﻿<%
If Trim(Request("BackUrl")) =" " Then
    BackUrl = Trim(Request.ServerVariables("HTTP_REFERER"))
Else
    BackUrl = Trim(Request("BackUrl"))
End If

Function Getfinddir(str)
	Getfinddir=left(str,instrRev(str,"/"))
End Function

'**************************************************
'函数名：db
'作  用：数据库操作
'**************************************************
function db(byval SQLstr,byval SQLtype)
	select case SQLtype
	case 0
		conn.Execute (SQLstr)
	case 1
		set db = conn.execute(SQLstr)
	case 2
		set db = server.createobject("Adodb.Recordset")
		db.open SQLstr, conn, 1, 1
	case 3:
		set db = server.createobject("Adodb.Recordset")
		db.open SQLstr, conn, 1, 3
	end select
End function

'关闭数据库
Sub ConnClose()
	If VarType(conn) = 8 Then Conn.close: Set Conn = Nothing
End Sub

'**************************************************
'函数名：IsValIDEmail
'作  者：王国强
'作  用：检查Email地址合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDEmail(strng) 
	IsValIDEmail = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDEmail= true 
End Function

'**************************************************
'函数名：IsValIDUserName
'作  者：王国强
'作  用：检查用户名的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDUserName(strng) 
	IsValIDUserName = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^[a-zA-Z][a-zA-Z0-9_]{3,15}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDUserName= true 
End Function

'**************************************************
'函数名：IsValIDPassword
'作  者：王国强
'作  用：检查密码的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDPassword(strng) 
	IsValIDPassword = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^[a-zA-Z0-9_]{4,15}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDPassword= true 
End Function

'**************************************************
'函数名：IsValIDPhone
'作  者：王国强
'作  用：检查电话的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDPhone(strng) 
	IsValIDPhone = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^((\(\d{2,3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}(\-\d{1,4})?$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDPhone= true 
End Function

'**************************************************
'函数名：IsValIDZip
'作  者：王国强
'作  用：检查邮政编码的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDZip(strng) 
	IsValIDZip = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^\d{6}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDZip= true 
End Function

'**************************************************
'函数名：IsValIDMobile
'作  者：王国强
'作  用：检查手机的合法性
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDMobile(strng) 
	IsValIDMobile = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^(13|15)[0-9]{9}$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDMobile= true 
End Function

'**************************************************
'函数名：IsValIDNum
'作  者：王国强
'作  用：检查是否为数字
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDNum(strng) 
	IsValIDNum = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^[0-9]*[1-9][0-9]*$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDNum= true 
End Function


'**************************************************
'函数名：IsValIdIP
'作  者：王国强
'作  用：检查是否为IP
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIdIP(strng) 
	IsValIdIP = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^((25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)\.){3}(25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIdIP= true 
End Function

'**************************************************
'函数名：IsValIDData
'作  者：王国强
'作  用：检查是否为日期0000-00-00
'返回值：True  ----合法
'        False ----不合法
'**************************************************
Function IsValIDData(strng) 
	IsValIDData = false 
	Dim regEx, Match 
	Set regEx = New RegExp 
	regEx.Pattern = "^((\d{2}(([02468][048])|([13579][26]))[\-\/\s]?((((0?[13578])|(1[02]))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\s]?((0?[1-9])|([1-2][0-9])))))|(\d{2}(([02468][1235679])|([13579][01345789]))[\-\/\s]?((((0?[13578])|(1[02]))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\s(((0?[1-9])|(1[0-2]))\:([0-5][0-9])((\s)|(\:([0-5][0-9])\s))([AM|PM|am|pm]{2,2})))?$" 
	regEx.IgnoreCase = True 
	Set Match = regEx.Execute(strng) 
	if match.count then IsValIDData= true 
End Function

'**************************************************
'函数名：IsObjInstalled
'作  用：检查组件是否已经安装
'参  数：strClassString ----组件名
'返回值：True  ----已经安装
'       False ----没有安装
'**************************************************
Function IsObjInstalled(strClassString)
	On Error Resume Next
	IsObjInstalled = False
	Err = 0
	Dim xTestObj
	Set xTestObj = Server.CreateObject(strClassString)
	If 0 = Err Then IsObjInstalled = True
	Set xTestObj = Nothing
	Err = 0
End Function

'********************************
'返回当前页的完整URL(带参数)
'********************************
Function getCurrentPageURL()
	dim strReturnPage,strQuery,thing
	strReturnPage="http://" & Request.ServerVariables("HTTP_HOST") & Request.ServerVariables("SCRIPT_NAME")
	strQuery=""
	for each thing in Request.QueryString
	    if  thing<>"Page" then
	   		if strQuery="" then
	   			strQuery=thing & "=" & Request.QueryString(thing) 
	   		else
	   			strQuery=strQuery & "&" & thing & "=" & Request.QueryString(thing) 
	   		end if
	    end if
	next
	if strQuery="" then
		getCurrentPageURL=strReturnPage
	else
		getCurrentPageURL=strReturnPage & "?" & strQuery
	end if
end Function

'**************************************************
'函数名：strCLng
'作  用：将字符转为整型数值 
'**************************************************
Function strCLng(ByVal str)
    If IsNumeric(str) Then
        strCLng = Fix(CDbl(str))
    Else
        strCLng = 0
    End If
End Function

'**************************************************
'函数名：strleach
'作  用：过滤非法字符函数 
'**************************************************
function strLeach(str)'
	dim tempstr 
	if str="" then exit function 
	tempstr=replace(str,chr(34),"")' " 
	tempstr=replace(tempstr,chr(39),"")' ' 
	tempstr=replace(tempstr,chr(60),"")' < 
	tempstr=replace(tempstr,chr(62),"")' > 
	tempstr=replace(tempstr,chr(37),"")' % 
	tempstr=replace(tempstr,chr(38),"")' & 
	tempstr=replace(tempstr,chr(40),"")' ( 
	tempstr=replace(tempstr,chr(41),"")' ) 
	tempstr=replace(tempstr,chr(59),"")' ; 
	tempstr=replace(tempstr,chr(43),"")' + 
	tempstr=replace(tempstr,chr(45),"")' - 
	tempstr=replace(tempstr,chr(91),"")' [ 
	tempstr=replace(tempstr,chr(93),"")' ] 
	tempstr=replace(tempstr,chr(123),"")' { 
	tempstr=replace(tempstr,chr(125),"")' } 
	strleach=tempstr 
end function 

'**************************************************
'函数名：strLength
'作  用：求字符串长度。汉字算两个字符，英文算一个字符。
'参  数：str  ----要求长度的字符串
'返回值：字符串长度
'**************************************************
function strLength(str)
	ON ERROR RESUME NEXT
	dim WINNT_CHINESE
	WINNT_CHINESE    = (len("中国")=2)
	if WINNT_CHINESE then
        dim l,t,c
        dim i
        l=len(str)
        t=l
        for i=1 to l
        	c=asc(mID(str,i,1))
            if c<0 then c=c+65536
            if c>255 then
                t=t+1
            end if
        next
        strLength=t
    else 
        strLength=len(str)
    end if
    if err.number<>0 then err.clear
end function

'****************************************************
'过程名：ErrMsg
'作  用：显示错误提示信息
'参  数：无
'****************************************************
sub ErrMsg(Message)
	dim strErr
	strErr=strErr & "<html><head><title>提示信息</title><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>" & vbcrlf
	strErr=strErr & "<style type='text/css'>" & vbcrlf
	strErr=strErr & "<!--" & vbcrlf
	strErr=strErr & "body {font:12.8px Arial, Helvetica, sans-serif;margin-top: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;COLOR: #6e6e6e;}td {font: 12px/1.6em Tahoma,Verdana;line-height: 18.8px;}A:link {COLOR: #000000; TEXT-DECORATION: none}A:active {COLOR: #000000;TEXT-DECORATION: underline}A:visited {COLOR: #000000; TEXT-DECORATION: none}A:hover {COLOR: #000000;TEXT-DECORATION: underline}" & vbcrlf
	strErr=strErr & "-->" & vbcrlf
	strErr=strErr & "</style>" & vbcrlf
	strErr=strErr & "</head><body><br><br>" & vbcrlf
	strErr=strErr & "<table width=""50%"" border=""0"" cellpadding=""5"" cellspacing=""1"" bgcolor=""cad9ea"" align=""center"">" & vbcrlf
	strErr=strErr & "<tr>" & vbcrlf
	strErr=strErr & "<td bgcolor=""e8f3fd"">提示信息</td>" & vbcrlf
	strErr=strErr & "</tr>" & vbcrlf
	strErr=strErr & "<tr>" & vbcrlf
	strErr=strErr & "<td bgcolor=""#FFFFFF"">" & Message &"" & vbcrlf
	strErr=strErr & "<br>" & vbcrlf
	strErr=strErr & "<a href=""javascript:history.back(1)"">点击这里返回</a>" & vbcrlf
	strErr=strErr & "</td>" & vbcrlf
	strErr=strErr & "</tr>" & vbcrlf
	strErr=strErr & "</table>" & vbcrlf
	strErr=strErr &  vbCrlf
	strErr=strErr & "</body></html>" & vbcrlf
	response.write strErr
end sub

'****************************************************
'过程名：performMsg
'作  用：显示成功提示信息
'参  数：无
'****************************************************
Sub performMsg(Perform, BackUrl)
    Dim strPerform
	strPerform=strPerform & "<html><head><title>提示信息</title><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>" & vbcrlf
	strPerform=strPerform & "<style type='text/css'>" & vbcrlf
	strPerform=strPerform & "<!--" & vbcrlf
	strPerform=strPerform & "body {font:12.8px Arial, Helvetica, sans-serif;margin-top: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px;COLOR: #6e6e6e;}td {font: 12px/1.6em Tahoma,Verdana;line-height: 18.8px;}A:link {COLOR: #000000; TEXT-DECORATION: none}A:active {COLOR: #000000;TEXT-DECORATION: underline}A:visited {COLOR: #000000; TEXT-DECORATION: none}A:hover {COLOR: #000000;TEXT-DECORATION: underline}" & vbcrlf
	strPerform=strPerform & "-->" & vbcrlf
	strPerform=strPerform & "</style>" & vbcrlf
	strPerform=strPerform & "</head><body><br><br>" & vbcrlf
	strPerform=strPerform & "<table width=""50%"" border=""0"" cellpadding=""5"" cellspacing=""1"" bgcolor=""cad9ea"" align=""center"">" & vbcrlf
	strPerform=strPerform & "<tr>" & vbcrlf
	strPerform=strPerform & "<td bgcolor=""e8f3fd"">提示信息</td>" & vbcrlf
	strPerform=strPerform & "</tr>" & vbcrlf
	strPerform=strPerform & "<tr>" & vbcrlf
	strPerform=strPerform & "<td bgcolor=""#FFFFFF"">" & Perform &"" & vbcrlf
	strPerform=strPerform & "<br>" & vbcrlf
    If BackUrl <> "" Then
	strPerform = strPerform & "<a href='" & BackUrl & "'>点击这里返回</a>"
    Else
	strPerform = strPerform & "<a href='" & Trim(Request.ServerVariables("HTTP_REFERER")) & "'>点击这里返回</a>"
    End If
	strPerform=strPerform & "</td>" & vbcrlf
	strPerform=strPerform & "</tr>" & vbcrlf
	strPerform=strPerform & "</table>" & vbcrlf
	strPerform=strPerform & "</body></html>" & vbcrlf
	response.write strPerform
end Sub

'****************************************************
'函数名：SendMail
'作  用：用Jmail组件发送邮件
'参  数：MailtoAddress  ----收信人地址
'        MailtoName    -----收信人姓名
'        Subject       -----主题
'        MailBody      -----信件内容
'        FromName      -----发信人姓名
'        MailFrom      -----发信人地址
'        Priority      -----信件优先级
'****************************************************
function SendMail(MailtoAddress,MailtoName,Subject,MailBody,FromName,MailFrom,Priority)
	on error resume next
	Dim JMail
	Set JMail=Server.CreateObject("JMail.Message")
	if err then
		SendMail= "<li>没有安装JMail组件</li>"
		err.clear
		exit function
	end if
	JMail.Charset=JMailCharset          '邮件编码
	JMail.silent=true
	JMail.ContentType = "text/html"     '邮件正文格式
	'JMail.ServerAddress=MailServer     '用来发送邮件的SMTP服务器
   	'如果服务器需要SMTP身份验证则还需指定以下参数
	JMail.MailServerUserName = MailServerUserName    '登录用户名
   	JMail.MailServerPassWord = MailServerPassword        '登录密码
  	JMail.MailDomain = MailDomain       '域名（如果用“name@domain.com”这样的用户名登录时，请指明domain.com
	JMail.AddRecipient MailtoAddress,MailtoName     '收信人
	JMail.Subject=Subject         '主题
	JMail.HMTLBody=MailBody       '邮件正文（HTML格式）
	JMail.Body=MailBody          '邮件正文（纯文本格式）
	JMail.FromName=FromName         '发信人姓名
	JMail.From = MailFrom         '发信人Email
	JMail.Priority=Priority              '邮件等级，1为加急，3为普通，5为低级
	JMail.Send(MailServer)
	SendMail =JMail.ErrorMessage
	JMail.Close
	Set JMail=nothing
end function

'****************************************************
'函数名：IsBlank
'作  用：验证为空
'****************************************************
Function IsBlank(ByRef fString)
	IsBlank = False
	Select Case VarType(fString)
	Case 0, 1
	IsBlank = True
	Case 8
	If Len(fString) = 0 Then
	IsBlank = True
	End If
	Case 9
	tmpType = TypeName(fString)
	If (tmpType = "Nothing") Or (tmpType = "Empty") Then
	IsBlank = True
	End If
	Case 8192, 8204, 8209
	If UBound(fString) = -1 Then
	IsBlank = True
	End If
	End Select
End Function

'****************************************************
'函数名：GetTextarea
'作  用：Textarea输入框
'****************************************************
sub GetTextarea(strForm,strDefine, strWidth, strHeight, strValue)
	Response.write("<div align=""left""><textarea name="""& strDefine &""" style=""width:"& strWidth & "%"" rows="""& strHeight &""" id="""& strDefine &""">"& strValue &"</textarea>")
	Response.write("<span onclick=""javascript:document."& strForm & "."& strDefine & ".rows+= " & strHeight & ";"" title=""点击向下拉长"" style=""cursor:hand"">")
	Response.write("<img src=""images/length.gif"" border=""0""></span>")
	Response.write("<span onclick=""javascript:if(document."& strForm & "."& strDefine & ".rows != "& strHeight & "){document."& strForm & "."& strDefine & ".rows-="& strHeight &";}else{document."& strForm & "."& strDefine & ".rows="& strHeight &";}"" title=""点击向上缩短"" style=""cursor:hand"">")
	Response.write("<img src=""images/short.gif"" border=""0""></span></div>")
End sub

'**************************
'目的：通用的实现<SELECT>内容的函数
'输入：idname <select的名字>
'liststr 以逗号分开的待显示内容
'valusestr 以逗号分开的待显示对应数值内容
'selectstr 选中的内容
'返回指：无
'例如：CommonSelect("provience","北京,天津,上海","bj,tj,sh","bj")
'**************************
Sub CommonSelect(idname,liststr,valuestr,selectstr)
	Dim arrlist
	Dim arrvalue
	Dim markstr
	arrlist=split(liststr,",")
	IF len(trim(valuestr))=0 Then valuestr=liststr
	IF selectstr="" Then selectstr=arrlist(0)
	arrvalue=split(valuestr,",")
	IF Ubound(arrlist)<>Ubound(arrvalue) Then
		Exit sub
	End IF
	Response.write "<select name=""" & idname & """ id=""" & idname & """>"
	For i=0 to Ubound(arrlist)
	    IF Cstr(arrvalue(i)) = Cstr(selectstr) Then
	       markstr=" selected "
	    Else   
	       markstr=""
	    End IF
	    Response.write "<option " &  markstr & "value='" & arrvalue(i) &"'>" &  arrlist(i) & "</option>"
	Next
	Response.write "</select>"
End Sub

'**************************
'目的：通用单选框
'输入：idname <select的名字>
'       liststr 以逗号分开的待显示内容
'       valusestr 以逗号分开的待显示对应数值内容
'       checkstr 选中的内容
'*************************
Sub CommonRadio(idname,liststr,valuestr,checkstr)
	Dim arrlist
	Dim arrvalue
	Dim markstr
	arrlist=split(liststr,",")
	IF len(trim(valuestr))=0 Then valuestr=liststr
	IF selectstr="" Then selectstr=arrlist(0)

	arrvalue=split(valuestr,",")
	IF Ubound(arrlist)<>Ubound(arrvalue) Then
		Exit sub
	End IF
	marked=false
	For i=0 to Ubound(arrlist)
	    if checkstr=""  and not marked then
		     markstr=" checked "
		     marked=true
		  else
		    IF Cstr(arrvalue(i)) = Cstr(checkstr)  Then
		       markstr=" checked "
		    Else   
		       markstr=""
		    End IF
		 end if
	    Response.write "<input type=radio " & markstr & " value='" & arrvalue(i) &"' name='" & idname & "' id='" & idname & "'>" & arrlist(i) & "&nbsp;"
	Next
End Sub

'********************************
'过程名：日期格式化
'参  数：无
'格式化时间，只对于时间格式的字段有效，如 $yyyy-mm-dd hh:nn:ss，yy表示二位年份，yyyy表示四位年份，mm dd hh nn ss 都以二位表示。
'timeVal - 时间， timeFormat - 格式化的格式
'********************************
Function FormatTime(timeVal, timeFormat)
	Dim tempVal
	If IsDate(timeVal) Then
		tempVal = timeVal: tempVal = LCase(timeFormat): tempVal = Replace(tempVal, "weeka", "WEEKA"): tempVal = Replace(tempVal, "montha", "MONTHA"): tempVal = Replace(tempVal, "week", "WEEK"): tempVal = Replace(tempVal, "month", "MONTH")
		If InStr(tempVal, "WEEKA") Then tempVal = Replace(tempVal, "WEEKA", Lang_Week_Abbr(Weekday(timeVal)))
		If InStr(tempVal, "WEEK") Then tempVal = Replace(tempVal, "WEEK", Lang_Week(Weekday(timeVal)))
		If InStr(tempVal, "MONTHA") Then tempVal = Replace(tempVal, "MONTHA", Lang_Month_Abbr(Month(timeVal)))
		If InStr(tempVal, "MONTH") Then tempVal = Replace(tempVal, "MONTH", Lang_Month(Month(timeVal)))
		If InStr(tempVal, "yyyy") > 0 Then tempVal = Replace(tempVal, "yyyy", Year(timeVal))
		If InStr(tempVal, "yy") > 0 Then tempVal = Replace(tempVal, "yy", Right(Year(timeVal), 2))
		If InStr(tempVal, "mm") > 0 Then tempVal = Replace(tempVal, "mm", Right("0" & Month(timeVal), 2))
		If InStr(tempVal, "m") > 0 Then tempVal = Replace(tempVal, "m", Month(timeVal))
		If InStr(tempVal, "dd") > 0 Then tempVal = Replace(tempVal, "dd", Right("0" & Day(timeVal), 2))
		If InStr(tempVal, "d") > 0 Then tempVal = Replace(tempVal, "d", Day(timeVal))
		If InStr(tempVal, "hh") > 0 Then tempVal = Replace(tempVal, "hh", Right("0" & Hour(timeVal), 2))
		If InStr(tempVal, "h") > 0 Then tempVal = Replace(tempVal, "h", Hour(timeVal))
		If InStr(tempVal, "nn") > 0 Then tempVal = Replace(tempVal, "nn", Right("0" & Minute(timeVal), 2))
		If InStr(tempVal, "n") > 0 Then tempVal = Replace(tempVal, "n", Minute(timeVal))
		If InStr(tempVal, "ss") > 0 Then tempVal = Replace(tempVal, "ss", Right("0" & Second(timeVal), 2))
		If InStr(tempVal, "s") > 0 Then tempVal = Replace(tempVal, "s", Second(timeVal))
	Else
		tempVal = timeVal
	End If
	FormatTime  =  tempVal
End Function

'**************************************************
'函数名：GetChkLoginAdmin
'作  用：检查后台用户是否登录
'返回值：True ----已经登录 False ---没有登录
'**************************************************
function GetChkLoginAdmin()
	ultraUserName=session("strUserName")
	ultraPassWord=session("strPassword")
	ultraUserName=Replace(Replace(Replace(Replace(Replace(Replace(ultraUserName,"'",""),")",""),">",""),"*",""),"?",""),"%","")
	ultraPassWord=Replace(Replace(Replace(Replace(Replace(Replace(ultraPassWord,"'",""),")",""),">",""),"*",""),"?",""),"%","")
	If Len(ultraUserName)>0 And Len(ultraPassWord)>0 Then
		Set UM_RS = DB("Select [UserName],[Password] From [tblSite] Where [UserName]='" & ultraUserName & "' and [Password]='" & md5(ultraPassWord,16) & "'",1)
		If Not UM_RS.Eof Then
			GetChkLoginAdmin=False
		Else
			GetChkLoginAdmin=True
		End If : UM_RS.Close
	End If
End function

'**************************************************
'函数名：referrerParsing
'作  用：取搜索引擎名称及关键字
'**************************************************
sub referrerParsing(referrer, searchEngine, searchKeywords)
	If instr(referrer,"google")<>0 then
		searchEngine	="谷歌"   
		pStartingPosition	=instr(referrer,"q=")
		if pStartingPosition>0 then  	
			pStartingPosition=pStartingPosition+2
			pEndingPosition=instr(pStartingPosition+1,referrer,"&")
			if pEndingPosition=0 then
				searchKeywords=decodeURI(mid(referrer,pStartingPosition))	  	  
			Else
				searchKeywords=decodeURI(mid(referrer,pStartingPosition,pEndingPosition-pStartingPosition))
			End if
		End if
	End if
	
	If instr(referrer,"baidu")<>0 then
		searchEngine	="百度"   
		pStartingPosition	=instr(referrer,"wd=")
		if pStartingPosition>0 then  	
			pStartingPosition=pStartingPosition+3
			pEndingPosition=instr(pStartingPosition+1,referrer,"&")
			if pEndingPosition=0 then
				searchKeywords=decodeURI(mid(referrer,pStartingPosition))  	  	  
			Else
				searchKeywords=decodeURI(mid(referrer,pStartingPosition,pEndingPosition-pStartingPosition))  	  	  
			End if
		End if
	End if
	
	If instr(referrer,"baidu")<>0 then
		searchEngine	="百度"   
		pStartingPosition	=instr(referrer,"word=")
		if pStartingPosition>0 then  	
			pStartingPosition=pStartingPosition+5
			pEndingPosition=instr(pStartingPosition+1,referrer,"&")
			if pEndingPosition=0 then
				searchKeywords=decodeURI(mid(referrer,pStartingPosition))  	  	  
			Else
				searchKeywords=decodeURI(mid(referrer,pStartingPosition,pEndingPosition-pStartingPosition))  	  	  
			End if
		End if
	End if
	
	If instr(referrer,"youdao")<>0 then
		searchEngine	="有道"   
		pStartingPosition	=instr(referrer,"q=")
		if pStartingPosition>0 then  	
			pStartingPosition=pStartingPosition+2
			pEndingPosition=instr(pStartingPosition+1,referrer,"&")
			if pEndingPosition=0 then
				searchKeywords=decodeURI(mid(referrer,pStartingPosition))	  	  
			Else
				searchKeywords=decodeURI(mid(referrer,pStartingPosition,pEndingPosition-pStartingPosition))
			End if
		End if
	End if
	
	If instr(referrer,"sogou")<>0 then
		searchEngine	="搜狗"   
		pStartingPosition	=instr(referrer,"query=")
		if pStartingPosition>0 then  	
			pStartingPosition=pStartingPosition+6
			pEndingPosition=instr(pStartingPosition+1,referrer,"&")
			if pEndingPosition=0 then
				searchKeywords=decodeURI(mid(referrer,pStartingPosition))	  	  
			Else
				searchKeywords=decodeURI(mid(referrer,pStartingPosition,pEndingPosition-pStartingPosition))
			End if
		End if
	End if
	
	If instr(referrer,"soso")<>0 then
		searchEngine	="搜搜"   
		pStartingPosition	=instr(referrer,"w=")
		if pStartingPosition>0 then  	
			pStartingPosition=pStartingPosition+2
			pEndingPosition=instr(pStartingPosition+1,referrer,"&")
			if pEndingPosition=0 then
				searchKeywords=decodeURI(mid(referrer,pStartingPosition))	  	  
			Else
				searchKeywords=decodeURI(mid(referrer,pStartingPosition,pEndingPosition-pStartingPosition))
			End if
		End if
	End if

	If instr(referrer,"bing")<>0 then
		searchEngine	="必应"   
		pStartingPosition	=instr(referrer,"q=")
		if pStartingPosition>0 then  	
			pStartingPosition=pStartingPosition+2
			pEndingPosition=instr(pStartingPosition+1,referrer,"&")
			if pEndingPosition=0 then
				searchKeywords=decodeURI(mid(referrer,pStartingPosition))	  	  
			Else
				searchKeywords=decodeURI(mid(referrer,pStartingPosition,pEndingPosition-pStartingPosition))
			End if
		End if
	End if
	
	If instr(referrer,"yahoo")<>0 then
		searchEngine	="雅虎"   
		pStartingPosition	=instr(referrer,"p=")
		if pStartingPosition>0 then  	
			pStartingPosition=pStartingPosition+2
			pEndingPosition=instr(pStartingPosition+1,referrer,"&")
			if pEndingPosition=0 then
				searchKeywords=decodeURI(mid(referrer,pStartingPosition))	  	  
			Else
				searchKeywords=decodeURI(mid(referrer,pStartingPosition,pEndingPosition-pStartingPosition))
			End if
		End if
	End If
	
	If instr(referrer,"goso")<>0 then
		searchEngine	="人民搜索"   
		pStartingPosition	=instr(referrer,"q=")
		if pStartingPosition>0 then  	
			pStartingPosition=pStartingPosition+2
			pEndingPosition=instr(pStartingPosition+1,referrer,"&")
			if pEndingPosition=0 then
				searchKeywords=decodeURI(mid(referrer,pStartingPosition))	  	  
			Else
				searchKeywords=decodeURI(mid(referrer,pStartingPosition,pEndingPosition-pStartingPosition))
			End if
		End if
	End if
End sub

'编码转换
Function DecodeURI(s) 
	s = UnEscape(s) 
	Dim reg, cs 
	cs = "GBK" 
	Set reg = New RegExp 
	reg.Pattern = "^(?:[\x00-\x7f]|[\xfc-\xff][\x80-\xbf]{5}|[\xf8-\xfb][\x80-\xbf]{4}|[\xf0-\xf7][\x80-\xbf]{3}|[\xe0-\xef][\x80-\xbf]{2}|[\xc0-\xdf][\x80-\xbf])+$" 
	If reg.Test(s) Then cs = "UTF-8" 
	Set reg = Nothing 
	Dim sm 
	Set sm = CreateObject("ADODB.Stream") 
	With sm 
	.Type = 2 
	.Mode = 3 
	.Open 
	.CharSet = "iso-8859-1" 
	.WriteText s 
	.Position = 0 
	.CharSet = cs 
	DecodeURI = .ReadText(-1) 
	.Close 
	End With 
	Set sm = Nothing 
End Function

'语言函数
function GetLangchs(strLang)
  select case strLang
  case "af"
    outstr="南非荷兰语"
  case "sq"
    outstr="阿尔巴尼亚语"
  case "ar-ae"
    outstr="阿拉伯语 - 阿拉伯联合酋长国"
  case "ar-bh"
    outstr="阿拉伯语 - 巴林"
  case "ar-dz"
    outstr="阿拉伯语 - 阿尔及利亚"
  case "ar-eg"
    outstr="阿拉伯语 - 埃及"
  case "ar-iq"
    outstr="阿拉伯语 - 伊拉克"
  case "ar-jo"
    outstr="阿拉伯语 - 约旦"
  case "ar-kw"
    outstr="阿拉伯语 - 科威特"
  case "ar-lb"
    outstr="阿拉伯语 - 黎巴嫩"
  case "ar-ly"
    outstr="阿拉伯语 - 利比亚"
  case "ar-ma"
    outstr="阿拉伯语 - 摩洛哥"
  case "ar-om"
    outstr="阿拉伯语 - 阿曼"
  case "ar-qa"
    outstr="阿拉伯语 - 卡塔尔"
  case "ar-sa"
    outstr="阿拉伯语 - 沙特阿拉伯"
  case "ar-sy"
    outstr="阿拉伯语 - 叙利亚"
  case "ar-tn"
    outstr="阿拉伯语 - 突尼斯"
  case "ar-ye"
    outstr="阿拉伯语 - 也门"
  case "hy"
    outstr="亚美尼亚语"
  case "az-az"
    outstr="阿泽里语 - 拉丁"
  case "az-az"
    outstr="阿泽里语 - 西里尔语"
  case "eu"
    outstr="巴斯克语"
  case "be"
    outstr="白俄罗斯语"
  case "bg"
    outstr="保加利亚语"
  case "ca"
    outstr="加泰罗尼亚语"
  case "zh"
    outstr="中文"
  case "zh-cn"
    outstr="中文 - 中华人民共和国"
  case "zh-hk"
    outstr="中文 - 中华人民共和国香港特别行政区"
  case "zh-mo"
    outstr="中文 - 中华人民共和国澳门特别行政区"
  case "zh-sg"
    outstr="中文 - 新加坡"
  case "zh-tw"
    outstr="中文 - 台湾地区"
  case "hr"
    outstr="克罗地亚语"
  case "cs"
    outstr="捷克语"
  case "da"
    outstr="丹麦语"
  case "nl"
    outstr="荷兰语"
  case "nl-nl"
    outstr="荷兰语"
  case "nl-be"
    outstr="荷兰语 - 比利时"
  case "en"
    outstr="英语"
  case "en-au"
    outstr="英语 - 澳大利亚"
  case "en-bz"
    outstr="英语 - 伯利兹"
  case "en-ca"
    outstr="英语 - 加拿大"
  case "en-cb"
    outstr="英语 - 加勒比地区"
  case "en-ie"
    outstr="英语 - 爱尔兰"
  case "en-jm"
    outstr="英语 - 牙买加"
  case "en-nz"
    outstr="英语 - 新西兰"
  case "en-ph"
    outstr="英语 - 菲律宾"
  case "en-za"
    outstr="英语 - 南非"
  case "en-tt"
    outstr="英语 - 特立尼达岛"
  case "en-gb"
    outstr="英语 - 英国"
  case "en-us"
    outstr="英语 - 美国"
  case "et"
    outstr="爱沙尼亚语"
  case "fa"
    outstr="波斯语"
  case "fi"
    outstr="芬兰语"
  case "fo"
    outstr="法罗语"
  case "fr"
    outstr="法语"
  case "fr-fr"
    outstr="法语 - 法国"
  case "fr-be"
    outstr="法语 - 比利时"
  case "fr-ca"
    outstr="法语 - 加拿大"
  case "fr-lu"
    outstr="法语 - 卢森堡"
  case "fr-ch"
    outstr="法语 - 瑞士"
  case "gd-ie"
    outstr="盖尔语 - 爱尔兰"
  case "gd"
    outstr="盖尔语 - 苏格兰"
  case "de"
    outstr="德语"
  case "de-de"
    outstr="德语 - 德国"
  case "de-at"
    outstr="德语 - 奥地利"
  case "de-li"
    outstr="德语 - 列支敦士登"
  case "de-lu"
    outstr="德语 - 卢森堡"
  case "de-ch"
    outstr="德语 - 瑞士"
  case "el"
    outstr="希腊语"
  case "he"
    outstr="希伯来语"
  case "hi"
    outstr="印地语"
  case "hu"
    outstr="匈牙利语"
  case "is"
    outstr="冰岛语"
  case "id"
    outstr="印度尼西亚语"
  case "it"
    outstr="意大利语"
  case "it-it"
    outstr="意大利语 - 意大利"
  case "it-ch"
    outstr="意大利语 - 瑞士"
  case "ja"
    outstr="日语"
  case "ko"
    outstr="朝鲜语"
  case "lv"
    outstr="拉脱维亚语"
  case "lt"
    outstr="立陶宛语"
  case "mk"
    outstr="FYRO 马其顿语"
  case "ms-my"
    outstr="马来语 - 马来西亚"
  case "ms-bn"
    outstr="马来语 - 文莱"
  case "mt"
    outstr="马耳他语"
  case "mr"
    outstr="马拉地语"
  case "no"
    outstr="挪威语"
  case "no-no"
    outstr="挪威语 - 博克马尔"
  case "no-no"
    outstr="挪威语 - 尼诺斯克"
  case "pl"
    outstr="波兰语"
  case "pt"
    outstr="葡萄牙语"
  case "pt-pt"
    outstr="葡萄牙语 - 葡萄牙"
  case "pt-br"
    outstr="葡萄牙语 - 巴西"
  case "rm"
    outstr="拉托-罗马语"
  case "ro"
    outstr="罗马尼亚语"
  case "ro-mo"
    outstr="罗马尼亚语 - 摩尔多瓦"
  case "ru"
    outstr="俄语"
  case "ru-mo"
    outstr="俄语 - 摩尔多瓦"
  case "sa"
    outstr="梵语"
  case "sr"
    outstr="塞尔维亚语"
  case "sr-sp"
    outstr="塞尔维亚语 - 西里尔语"
  case "sr-sp"
    outstr="塞尔维亚语 - 拉丁"
  case "tn"
    outstr="茨瓦纳语"
  case "sl"
    outstr="斯洛文尼亚语"
  case "sk"
    outstr="斯洛伐克语"
  case "sb"
    outstr="索布语"
  case "es"
    outstr="西班牙语"
  case "es-es"
    outstr="西班牙语 - 西班牙"
  case "es-ar"
    outstr="西班牙语 - 阿根廷"
  case "es-bo"
    outstr="西班牙语 - 玻利维亚"
  case "es-cl"
    outstr="西班牙语 - 智利"
  case "es-co"
    outstr="西班牙语 - 哥伦比亚"
  case "es-cr"
    outstr="西班牙语 - 哥斯达黎加"
  case "es-do"
    outstr="西班牙语 - 多米尼加共和国"
  case "es-ec"
    outstr="西班牙语 - 厄瓜多尔"
  case "es-gt"
    outstr="西班牙语 - 危地马拉"
  case "es-hn"
    outstr="西班牙语 - 洪都拉斯"
  case "es-mx"
    outstr="西班牙语 - 墨西哥"
  case "es-ni"
    outstr="西班牙语 - 尼加拉瓜"
  case "es-pa"
    outstr="西班牙语 - 巴拿马"
  case "es-pe"
    outstr="西班牙语 - 秘鲁"
  case "es-pr"
    outstr="西班牙语 - 波多黎各"
  case "es-py"
    outstr="西班牙语 - 巴拉圭"
  case "es-sv"
    outstr="西班牙语 - 萨尔瓦多"
  case "es-uy"
    outstr="西班牙语 - 乌拉圭"
  case "es-ve"
    outstr="西班牙语 - 委内瑞拉"
  case "sx"
    outstr="苏图语"
  case "sw"
    outstr="斯瓦希里语"
  case "sv"
    outstr="瑞典语"
  case "sv-se"
    outstr="瑞典语"
  case "sv-fi"
    outstr="瑞典语 - 芬兰"
  case "ta"
    outstr="泰米尔语"
  case "tt"
    outstr="鞑靼语"
  case "th"
    outstr="泰语"
  case "tr"
    outstr="土耳其语"
  case "ts"
    outstr="汤加语"
  case "uk"
    outstr="乌克兰语"
  case "ur"
    outstr="乌尔都语 - 巴基斯坦"
  case "uz-uz"
    outstr="乌兹别克语 - 西里尔"
  case "uz-uz"
    outstr="乌兹别克语 - 拉丁"
  case "vi"
    outstr="越南语"
  case "xh"
    outstr="科萨语"
  case "yi"
    outstr="意第绪语"
  case "zu"
    outstr="祖鲁语"
  case else
    outstr="未知"
  end select
  GetLangchs=outstr & " (" & strLang & ")"
End function

'**************************************************
'函数名：referrerOS
'作  用：取操作系统
'**************************************************
Function referrerOs(str)
	select case str
	case "Windows NT 5.0"
		referrerOs = "Windows 2000"
	case "Windows NT 5.1"
		referrerOs = "Windows XP"
	case "Windows NT 5.2"
		referrerOs = "Windows Server 2003"
	case "Windows NT 6.0"
		referrerOs = "Windows Vista|2008"
	case "Windows NT 6.1"
		referrerOs = "Windows 7|2008 R2"
	case else
		referrerOs = str
	End select
End Function

'********************************
'过程名：统计记录数
'参  数：无
'********************************
Function GetTotal(ByVal reference,ByVal table,ByVal strwhere)
	SQL="Select Count("&reference&") From "&table&" "&strwhere&""
	set UM_RS = db(SQL,1)
	strCount=UM_RS(0)
	If strCount>0 Then
		strCount=""&strCount&""
	Else
		strSum=0
	End if
	GetTotal=strCount
	UM_RS.Close
End Function

'********************************
'过程名：统计记录数
'参  数：无
'********************************
Function GetSumTotal(ByVal reference,ByVal table,ByVal strwhere)
	SQL="Select sum("&reference&") From "&table&" "&strwhere&""
	set UM_RS = db(SQL,1)
	strSum=UM_RS(0)
	If strSum>0 Then
		strSum=""&strSum&""
	Else
		strSum=0
	End if
	GetSumTotal=strSum
	UM_RS.Close
End Function

'********************************
'截取字符串去除所有HTML标记
'********************************
Function cutStr(str,strlen) 
	dim re 
	Set re=new RegExp 
	re.IgnoreCase =True 
	re.Global=True 
	re.Pattern="<(.[^>]*)>" 
	str=re.Replace(str,"") 
	set re=Nothing 
	Dim l,t,c,i 
	l=Len(str) 
	t=0 
	For i=1 to l 
	c=Abs(Asc(MID(str,i,1))) 
	If c>255 Then 
	t=t+2 
	Else 
	t=t+1 
	End If 
	If t>=strlen Then 
	cutStr=left(str,i)&"..." 
	Exit For 
	Else 
	cutStr=str 
	End If 
	Next 
	cutStr=Replace(cutStr,chr(10),"") 
	cutStr=Replace(cutStr,chr(13),"") 
End Function

'********************************
'更新要保存的IP
'********************************
function GetSaveIP(str)
	GetSaveIP=left(str,len(str)-1)
	GetSaveIP=right(GetSaveIP,len(GetSaveIP)-1)
	strIP=split(GetSaveIP,"#")
	if ubound(strIP) < strRefurbish Then
		GetSaveIP="#" & GetSaveIP & "#" & pUserIP & "#"
	Else
		GetSaveIP=replace("#" & GetSaveIP,"#" & strIP(0) & "#","#") & "#" & pUserIP & "#"
	End if
End Function

'********************************
'分秒格式化
'********************************
function CstrTime(Lsttime)
	CstrTime=""
	dminute=60*hour(Lsttime)+minute(Lsttime)
	dsecond=second(Lsttime)
	if dminute<>0 then CstrTime=dminute & "'"
	if dsecond<10 then CstrTime=CstrTime & "0"
	CstrTime=CstrTime & dsecond & """"
End function

'**************************************************
'函数名：GetProportional
'作  用：计算比例
'**************************************************
Function GetProportional(ByVal str,ByVal oStr)
    If IsNumeric(str) Then
        str = fix(cdbl(str))
    Else
        str = 0
    End If
    If IsNumeric(oStr) Then
        oStr = fix(cdbl(oStr))
    Else
        oStr = 0
    End If
	If str<=0 or oStr<=0 then
		GetProportional=0
	Else
		GetProportional=formatnumber(round(str*100/oStr,1),1,true) & "%"
	End if
End Function

'**************************************************
'函数名：GetNow
'作  用：取日期
'**************************************************
Function GetNow(ByVal str)
	U_Now = dateadd("h",UserZone-ServerZoneTime,now())
	strToday=datevalue(U_Now) '今日
	strTomorrow=dateadd("d",+1,strToday) '明天
	strYesterday=dateadd("d",-1,strToday) '昨日
	strday7=dateadd("d",-7,strToday) '最近7天
	strday30=dateadd("d",-30,strToday) '最近30天
	select case str
	case 0
		GetNow = strToday
	case 1
		GetNow = strYesterday
	case 2
		GetNow = strTomorrow
	case 7
		GetNow = strday7
	case 30
		GetNow = strday30
	end select
End Function

' 找到当前URL对应的站点
function Getfindhost(str)
	if str<> "" then
	strfindURL		= split(str,"/")
	Getfindhost	= strfindURL(2)
	if left(Getfindhost,8)="192.168." or left(Getfindhost,3)="10." or Getfindhost="127.0.0.1" or instr(Getfindhost,".")=0 then Getfindhost="LAN"
	else 
	Getfindhost	= ""
	end if
end Function

' Getxmlhttp
function Getxmlhttp(byval fString,byval pType)
	select case pType
		case "get","post"
		case else:pType="get"
	end select
	on error resume next
	dim xmlhttp
	set xmlhttp=server.createobject("microsoft.xmlhttp")
	xmlhttp.open pType,fString,false
	xmlhttp.setRequestHeader "If-Modified-Since","0"
	xmlhttp.send()
	Getxmlhttp=xmlhttp.responsetext
	set xmlhttp=nothing
	if err then 
		Getxmlhttp="0"&err.description
		Response.Write ""&err.description&""
		err.clear
		die
	End if
End function

' 获取IP地址
Function getIP()
    Dim sIPAddress, sHTTP_X_FORWARDED_FOR
	sHTTP_X_FORWARDED_FOR = Request.ServerVariables("HTTP_X_FORWARDED_FOR")
    If sHTTP_X_FORWARDED_FOR = "" Or InStr(sHTTP_X_FORWARDED_FOR, "unknown") > 0 Then
        sIPAddress = Request.ServerVariables("REMOTE_ADDR")
    ElseIf InStr(sHTTP_X_FORWARDED_FOR, ",") > 0 Then
        sIPAddress = Mid(sHTTP_X_FORWARDED_FOR, 1, InStr(sHTTP_X_FORWARDED_FOR, ",") -1)
    ElseIf InStr(sHTTP_X_FORWARDED_FOR, ";") > 0 Then
        sIPAddress = Mid(sHTTP_X_FORWARDED_FOR, 1, InStr(sHTTP_X_FORWARDED_FOR, ";") -1)
    Else
        sIPAddress = sHTTP_X_FORWARDED_FOR
    End If
    getIP = Trim(Mid(sIPAddress, 1, 15))
	if Not(IsValIdIP(getIP)) then getIP="unknow"
End Function

' 取IP所在地
function GetIPaddress(byval fString)
	dim pIP:pIP = getIP()
	if pIP="unknow" or pIP="127.0.0.1" or pIP="" then
		GetIPaddress = fString
		Exit function
	end if
	dim strIP:strIP=Getxmlhttp("http://whois.pconline.com.cn/ip.jsp?ip="&pIP&"","")
	dim strIPHTML
	If InStr(strIP,Chr(32))=1 Then
		strHTML = strIP
	Else
		if Len(strIP)>0 then
			dim jIP:jIP=split(strIP,Chr(32))
			strHTML = jIP(1)
		Else
			strHTML = fString
		End if
	End if
	GetIPaddress = strHTML
End Function

'根据地区分离省份
Function GetArea(str) '简单分离出省份
	If Len(trim(str)) = 0 Then
		GetArea = "(unknown)"
		Exit Function
	End If
	On Error Resume Next
	dim strProvince,i
	strProvince= strProvince & "北京市|上海市|天津市|重庆市|香港|澳门|广东省|河北省|山西省|内蒙古|辽宁省|吉林省|黑龙江省|江苏省|浙江省|安徽省|福建省|江西省|山东省|河南省|湖北省|湖南省|广西|海南省|四川省|贵州省|云南省|西藏|陕西省|甘肃省|青海省|宁夏|新疆|台湾省"
	strProvince=split(strProvince,"|")
	For i=0 to ubound(strProvince)
	if instr(str,strProvince(i))>0 then
	   GetArea=strProvince(i)
	   Exit function
	End if
	Next
	GetArea = "(unknown)"
End Function

'省转拼单
function GetChinaMap(strLang)
	select case strLang
	case "北京市"
		outstr="CN.BJ"
	case "上海市"
		outstr="CN.SH"
	case "天津市"
		outstr="CN.TJ"
	case "重庆市"
		outstr="CN.CQ"
	case "香港"
		outstr="CN.HK"
	case "澳门"
		outstr="CN.MA"
	case "广东省"
		outstr="CN.GD"
	case "河北省"
		outstr="CN.HB"
	case "山西省"
		outstr="CN.SX"
	case "内蒙古"
		outstr="CN.NM"
	case "辽宁省"
		outstr="CN.LN"
	case "吉林省"
		outstr="CN.JL"
	case "黑龙江省"
		outstr="CN.HL"
	case "浙江省"
		outstr="CN.ZJ"
	case "安徽省"
		outstr="CN.AH"
	case "福建省"
		outstr="CN.FJ"
	case "江西省"
		outstr="CN.JX"
	case "山东省"
		outstr="CN.SD"
	case "河南省"
		outstr="CN.HE"
	case "湖北省"
		outstr="CN.HB"
	case "湖南省"
		outstr="CN.HN"
	case "广西"
		outstr="CN.GX"
	case "海南省"
		outstr="CN.HA"
	case "四川省"
		outstr="CN.SC"
	case "贵州省"
		outstr="CN.GZ"
	case "云南省"
		outstr="CN.YN"
	case "西藏"
		outstr="CN.XZ"
	case "陕西省"
		outstr="CN.SA"
	case "甘肃省"
		outstr="CN.GS"
	case "青海省"
		outstr="CN.QH"
	case "宁夏"
		outstr="CN.NX"
	case "新疆"
		outstr="CN.XJ"
	case "台湾省"
		outstr="CN.TA"
	case else
		outstr="CN.BJ"
	end select
	GetChinaMap=outstr
End Function

'********************************
'函数名：getZone
'权限组
'********************************
Function getZone(text,i)
dim txt
txt = text
	if not isNull(txt) or txt <> "" then
	txt = mid(txt, i+(i-1), 1)
		if txt = "1" then
			getZone = False'表示通过验证
		else
			getZone = True '表示没通过
		end if
	else
		getZone = True '表示没通过
	end if
End Function

' 保存内容信息
sub GetClient(strStyle,strContent)
	set UM_RS=conn.Execute("select ID From tblClient where Style=" & strStyle & " and Client='"&strContent&"' and idSite=" & pidSite)
	if UM_RS.eof then
		conn.Execute ("insert into tblClient (idSite,Style,Client,Total,Yesterday,Today,LastTime) Values("&pidSite&","&strStyle&",'"&strContent&"',1,0,1,'"&TrueNow&"')")
	else
	    conn.Execute ("update tblClient set Total=Total+1,Today=Today+1,LastTime='"&TrueNow&"'  where Style=" & strStyle & " and Client='"&strContent&"' and idSite=" & pidSite)
	end if
	set UM_RS=nothing
End Sub

' 保存内容信息
sub GetLogs(strStyle,strContent,strSubContent)
	strContent=replace(strContent,"'","''")
	strSubContent=replace(strSubContent,"'","''")
	set UM_RS=conn.Execute("select ID From tblLogs where Style=" & strStyle & " and Logs='"&strContent&"' and idSite=" & pidSite)
	if UM_RS.eof then
		conn.Execute ("insert into tblLogs (idSite,Style,Logs,LastURL,Total,Yesterday,Today,LastTime) Values("&pidSite&","&strStyle&",'"&strContent&"','"&strSubContent&"',1,0,1,now()-"&ServerZoneTime&"/24)")
	else
	    conn.Execute ("update tblLogs set Total=Total+1,Today=Today+1,LastURL='"&strSubContent&"',LastTime=now()-"&ServerZoneTime&"/24 where Style=" & strStyle & " and Logs='"&strContent&"' and idSite=" & pidSite)
	end if
	set UM_RS=nothing
End sub
%>