/*****************************************************************

	wwwi.cn domain

	Copyright 2009 by Teddy <master@wwwi.cn> (http://wwwi.cn)

        С:QQ81900	

	Last Modified: 2009/01/11

*****************************************************************/



//---------------------------------------compat------------------------------------



if (!Array.prototype.push) {
  Array.prototype.push = function() {
		var startLength = this.length;
		for (var i = 0; i < arguments.length; i++)
      this[startLength + i] = arguments[i];
	  return this.length;
  }
}

if (!Function.prototype.apply) {
  // Based on code from http://www.youngpup.net/
  Function.prototype.apply = function(object, parameters) {
    var parameterStrings = new Array();
    if (!object)     object = window;
    if (!parameters) parameters = new Array();
    
    for (var i = 0; i < parameters.length; i++)
      parameterStrings[i] = 'x[' + i + ']';
    
    object.__apply__ = this;
    var result = eval('obj.__apply__(' + 
      parameterStrings[i].join(', ') + ')');
    object.__apply__ = null;
    
    return result;
  }
}


//---------------------------------------prototype------------------------------------



var Prototype = {
  Version: '@@VERSION@@'
}

var Class = {
  create: function() {
    return function() { 
      this.initialize.apply(this, arguments);
    }
  }
}

var Abstract = new Object();

Object.prototype.extend = function(object) {
  for (property in object) {
    this[property] = object[property];
  }
  return this;
}

Function.prototype.bind = function(object) {
  var method = this;
  return function() {
    method.apply(object, arguments);
  }
}

Function.prototype.bindAsEventListener = function(object) {
  var method = this;
  return function(event) {
    method.call(object, event || window.event);
  }
}

Number.prototype.toColorPart = function() {
  var digits = this.toString(16);
  if (this < 16) return '0' + digits;
  return digits;
}

var Try = {
  these: function() {
    var returnValue;
    
    for (var i = 0; i < arguments.length; i++) {
      var lambda = arguments[i];
      try {
        returnValue = lambda();
        break;
      } catch (e) {}
    }
    
    return returnValue;
  }
}

/*--------------------------------------------------------------------------*/

var PeriodicalExecuter = Class.create();
PeriodicalExecuter.prototype = {
  initialize: function(callback, frequency) {
    this.callback = callback;
    this.frequency = frequency;
    this.currentlyExecuting = false;
    
    this.registerCallback();
  },
  
  registerCallback: function() {
    setTimeout(this.onTimerEvent.bind(this), this.frequency * 1000);
  },
  
  onTimerEvent: function() {
    if (!this.currentlyExecuting) {
      try { 
        this.currentlyExecuting = true;
        this.callback(); 
      } finally { 
        this.currentlyExecuting = false;
      }
    }
    
    this.registerCallback();
  }
}

/*--------------------------------------------------------------------------*/

function $() {
  var elements = new Array();
  
  for (var i = 0; i < arguments.length; i++) {
    var element = arguments[i];
    try
    {
		if (typeof element == 'string')
		element = document.getElementById(element) || document.all(element) || document.forms(0).all(element);
    }
    catch(ex)
    {
		element = null;
    }

    if (arguments.length == 1) 
      return element;
      
    elements.push(element);
  }
  
  return elements;
}


function $$() {
  if (!parent)
  {
	return null;
  }
  
  var elements = new Array();
  
  for (var i = 0; i < arguments.length; i++) {
    var element = arguments[i];
    try
    {
		if (typeof element == 'string')
		element = parent.document.getElementById(element) || parent.document.all(element) || parent.document.forms(0).all(element);
    }
    catch(ex)
    {
		element = null;
    }

    if (arguments.length == 1) 
      return element;
      
    elements.push(element);
  }
  
  return elements;
}


//--------------------------------------string-----------------------------------------



String.prototype.lTrim = function () {return this.replace(/^\s*/, "");}

String.prototype.rTrim = function () {return this.replace(/\s*$/, "");}

String.prototype.trim = function () {return this.rTrim().lTrim();}

String.prototype.endsWith = function(sEnd) {return (this.substr(this.length-sEnd.length)==sEnd);}

String.prototype.startsWith = function(sStart) {return (this.substr(0,sStart.length)==sStart);}

String.prototype.format = function()

{ var s = this; for (var i=0; i < arguments.length; i++)

{ s = s.replace("{" + (i) + "}", arguments[i]);}

return(s);}

String.prototype.removeSpaces = function()

{ return this.replace(/ /gi,'');}

String.prototype.removeExtraSpaces = function()

{ return(this.replace(String.prototype.removeExtraSpaces.re, " "));}

String.prototype.removeExtraSpaces.re = new RegExp("\\s+", "g"); String.prototype.removeSpaceDelimitedString = function(r)

{ var s = " " + this.trim() + " "; return s.replace(" " + r,"").rTrim();}

String.prototype.isEmpty = function() {return this.length==0;}; String.prototype.validateURL = function()

{ var urlRegX = /[^a-zA-Z0-9-]/g; return sURL.match(urlRegX, "");}

String.prototype.isEmail = function()

{ var emailReg = /^\w+([-.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/; return emailReg.test(this);}

String.prototype.isAlphaNumeric = function()

{ var alphaReg = /[^a-zA-Z0-9]/g; return !alphaReg.test(this);}

String.prototype.encodeURI = function()

{ var returnString; returnString = escape( this )

returnString = returnString.replace(/\+/g,"%2B"); return returnString

}

String.prototype.decodeURI = function() {return unescape(this)}

//--------------------------------------Array-----------------------------------------

Array.prototype.indexOf = function(p_var)
{ 
	for (var i=0; i<this.length; i++)
	{ 
		if (this[i] == p_var)
		{ 
			return(i);
		}
	}
	return(-1);
}
Array.prototype.exists = function(p_var) {return(this.indexOf(p_var) != -1);}
Array.prototype.queue = function(p_var) {this.push(p_var)}
Array.prototype.dequeue = function() {return(this.shift());}
Array.prototype.removeAt = function(p_iIndex) {return this.splice(p_iIndex, 1);}
Array.prototype.remove = function(o)
{ 
	var i = this.indexOf(o); if (i>-1) this.splice(i,1); return (i>-1)
}
Array.prototype.clear = function()
{ 
	var iLength = this.length; 
	for (var i=0; i < iLength; i++)
	{ 
		this.shift();
	}
}
Array.prototype.addArray = function(p_a)
{ 
	if (p_a)
	{ 
		for (var i=0; i < p_a.length; i++)
		{ 
			this.push(p_a[i]);
		}
	}
}


//--------------------------------------ajax-------------------------------------------



var Ajax = {
  getTransport: function() {
    return Try.these(
      function() {return new ActiveXObject('Msxml2.XMLHTTP')},
      function() {return new ActiveXObject('Microsoft.XMLHTTP')},
      function() {return new XMLHttpRequest()}
    ) || false;
  },
  
  emptyFunction: function() {}
}

Ajax.Base = function() {};
Ajax.Base.prototype = {
  setOptions: function(options) {
    this.options = {
      method:       'post',
      asynchronous: true,
      parameters:   ''
    }.extend(options || {});
  }
}

Ajax.Request = Class.create();
Ajax.Request.Events = 
  ['Uninitialized', 'Loading', 'Loaded', 'Interactive', 'Complete'];

Ajax.Request.prototype = (new Ajax.Base()).extend({
  initialize: function(url, options) {
    this.transport = Ajax.getTransport();
    this.setOptions(options);
  
    try {
      if (this.options.method == 'get')
        url += '?' + this.options.parameters + '&_=';
    
      this.transport.open(this.options.method, url, true);
      
      if (this.options.asynchronous) {
        this.transport.onreadystatechange = this.onStateChange.bind(this);
        setTimeout((function() {this.respondToReadyState(1)}).bind(this), 10);
      }
              
      this.transport.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
      this.transport.setRequestHeader('X-Prototype-Version', Prototype.Version);

      if (this.options.method == 'post') {
        this.transport.setRequestHeader('Connection', 'close');
        this.transport.setRequestHeader('Content-type',
          'application/x-www-form-urlencoded');
      }
      
      this.transport.send(this.options.method == 'post' ? 
        this.options.parameters + '&_=' : null);
                      
    } catch (e) {
    }    
    return this.transport;
  },
      
  onStateChange: function() {
    var readyState = this.transport.readyState;
    if (readyState != 1)
      this.respondToReadyState(this.transport.readyState);
  },
  
  respondToReadyState: function(readyState) {
    var event = Ajax.Request.Events[readyState];
    (this.options['on' + event] || Ajax.emptyFunction)(this.transport);
  }
});


//----------------------------------form----------------------------------------



var Field = {
  clear: function() {
    for (var i = 0; i < arguments.length; i++)
      $(arguments[i]).value = '';
  },

  focus: function(element) {
    $(element).focus();
  },
  
  present: function() {
    for (var i = 0; i < arguments.length; i++)
      if ($(arguments[i]).value == '') return false;
    return true;
  },
  
  select: function(element) {
    $(element).select();
  },
   
  activate: function(element) {
    $(element).focus();
    $(element).select();
  }
}

/*--------------------------------------------------------------------------*/

var Form = {
  serialize: function(form) {
    var elements = Form.getElements($(form));
    var queryComponents = new Array();
    
    for (var i = 0; i < elements.length; i++) {
      var queryComponent = Form.Element.serialize(elements[i]);
      if (queryComponent)
        queryComponents.push(queryComponent);
    }
    
    return queryComponents.join('&');
  },
  
  getElements: function(form) {
	form = $(form);
    var elements = new Array();

    for (tagName in Form.Element.Serializers) {
      var tagElements = form.getElementsByTagName(tagName);
      for (var j = 0; j < tagElements.length; j++)
        elements.push(tagElements[j]);
    }
    return elements;
  },
  
  disable: function(form) {
    var elements = Form.getElements(form);
    for (var i = 0; i < elements.length; i++) {
      var element = elements[i];
      element.blur();
      element.disable = 'true';
    }
  },

  focusFirstElement: function(form) {
    form = $(form);
    var elements = Form.getElements(form);
    for (var i = 0; i < elements.length; i++) {
      var element = elements[i];
      if (element.type != 'hidden' && !element.disabled) {
        Field.activate(element);
        break;
      }
    }
  },

  reset: function(form) {
    $(form).reset();
  }
}

Form.Element = {
  serialize: function(element) {
    element = $(element);
    var method = element.tagName.toLowerCase();
    var parameter = Form.Element.Serializers[method](element);
    
    if (parameter)
      return encodeURIComponent(parameter[0]) + '=' + 
        encodeURIComponent(parameter[1]);                   
  },
  
  getValue: function(element) {
    element = $(element);
    var method = element.tagName.toLowerCase();
    var parameter = Form.Element.Serializers[method](element);
    
    if (parameter) 
      return parameter[1];
  }
}

Form.Element.Serializers = {
  input: function(element) {
    switch (element.type.toLowerCase()) {
      case 'hidden':
      case 'password':
      case 'text':
        return Form.Element.Serializers.textarea(element);
      case 'checkbox':  
      case 'radio':
        return Form.Element.Serializers.inputSelector(element);
    }
    return false;
  },

  inputSelector: function(element) {
    if (element.checked)
      return [element.name, element.value];
  },

  textarea: function(element) {
    return [element.name, element.value];
  },

  select: function(element) {
    var index = element.selectedIndex;
    var value = element.options[index].value || element.options[index].text;
    return [element.name, (index >= 0) ? value : ''];
  }
}

/*--------------------------------------------------------------------------*/

var $F = Form.Element.getValue;

/*--------------------------------------------------------------------------*/

Abstract.TimedObserver = function() {}
Abstract.TimedObserver.prototype = {
  initialize: function(element, frequency, callback) {
    this.frequency = frequency;
    this.element   = $(element);
    this.callback  = callback;
    
    this.lastValue = this.getValue();
    this.registerCallback();
  },
  
  registerCallback: function() {
    setTimeout(this.onTimerEvent.bind(this), this.frequency * 1000);
  },
  
  onTimerEvent: function() {
    var value = this.getValue();
    if (this.lastValue != value) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
    
    this.registerCallback();
  }
}

Form.Element.Observer = Class.create();
Form.Element.Observer.prototype = (new Abstract.TimedObserver()).extend({
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.Observer = Class.create();
Form.Observer.prototype = (new Abstract.TimedObserver()).extend({
  getValue: function() {
    return Form.serialize(this.element);
  }
});

//-----------------------------------AjaxHelper------------------------------------



var AjaxProxyUrl = new String('Ajax.aspx');



function Updater(ajaxTemplate, output, params, onComplete)

{

	var FormatContent = function(str)

	{

		var content = new String(str);

		var prefix = new String('<!--AjaxContent-->');

		content = content.substring(content.indexOf(prefix, 0) + prefix.length, content.length - 9);

		return content;

	}



	if (typeof output == 'string')

	{

		output = $(output);

	}

	

	if (params == null || (params != null && params.length == 0))

	{

		params = '_null=';

	}



	var xmlhttp = new Ajax.Request

	(

		AjaxProxyUrl, 

		{ 

			onComplete: 

				function(transport) 

				{ 

					if (output != null) 

					{ 

						output.innerHTML = FormatContent(transport.responseText); 

					} 

					if (onComplete != null) 

					{ 

						onComplete(FormatContent(transport.responseText)) 

					} 

				}, 

				parameters: params + '&AjaxTemplate=' + ajaxTemplate 

		}

	);

	

	return xmlhttp;

}



//The param "direction" 's value can be "beforeBegin", "afterBegin", "beforeEnd" ,"afterEnd"
function Inserter(element, direction, content, tagName)
{
	if (typeof element == 'string')
	{
		element = $(element);
	}

	if (element.insertAdjacentHTML)
	{
		element.insertAdjacentHTML(direction, content);
	}
	else
	{
		content = new String(content).trim();

		var fragment;

		if (tagName == null)
		{
			fragment = element.ownerDocument.createElement('span');
		}
		else
		{
			fragment = element.ownerDocument.createElement(tagName);
		}

		fragment.innerHTML = content;
		
		if (element != null)
		{
			if (direction == 'beforeBegin')
			{
				element.parentNode.insertBefore(fragment, element);
			}
			else if (direction == 'afterBegin')
			{
				element.insertBefore(fragment, element.firstChild);
			}
			else if (direction == 'beforeEnd')
			{
				element.appendChild(fragment);
			}
			else if (direction == 'afterEnd')
			{
				element.parentNode.insertBefore(fragment, element.nextSibling);
			}
		}
	}
}


//The param "direction" 's value can be "beforeBegin", "afterBegin", "beforeEnd" ,"afterEnd"

function Appender(ajaxTemplate, output, direction, params, onComplete)

{

	if (typeof output == 'string')

	{

		output = $(output);

	}

	

	if (output != null)

	{

		return Updater(ajaxTemplate, null, params, function(responseText){Inserter(output, direction, responseText); if (onComplete != null) onComplete(responseText);})

	}

}



function SerializeForm(form)

{

	return Form.serialize(form);

}

//-----------------------------------------------WebPartAjaxHelper---------------------------------------------------



var WebPartAjaxProxyUrl;

if (document.forms.length > 0)

{

	WebPartAjaxProxyUrl = document.forms(0).action

}



function WebPartUpdater(ajaxTemplate, output, params, onComplete)

{

	var FormatContent = function(str)

	{

		var content = new String(str);

		var prefix = new String('<!--AjaxContentBegin-->');

		content = content.substring(content.indexOf(prefix, 0) + prefix.length, content.indexOf('<!--AjaxContentEnd-->', 0));

		return content.trim();

	}



	if (typeof output == 'string')

	{

		output = $(output);

	}

	

	if (params == null || (params != null && params.length == 0))

	{

		params = '_null=';

	}



	var xmlhttp = new Ajax.Request

	(

		WebPartAjaxProxyUrl, 

		{ 

			onComplete: 

				function(transport) 

				{

					if (output != null) 

					{ 

						output.innerHTML = FormatContent(transport.responseText); 

					} 

					if (onComplete != null) 

					{ 

						onComplete(FormatContent(transport.responseText)) 

					} 

				}, 

				parameters: params + '&AjaxTemplate=' + ajaxTemplate ,

				method: 'get'

		}

	);

	

	return xmlhttp;

}



//The param "direction" 's value can be "beforeBegin", "afterBegin", "beforeEnd" ,"afterEnd"

function WebPartAppender(ajaxTemplate, output, direction, params, onComplete)

{

	if (typeof output == 'string')

	{

		output = $(output);

	}

	

	if (output != null)

	{

		WebPartUpdater(ajaxTemplate, null, params, function(responseText){Inserter(output, direction, responseText); if (onComplete != null) onComplete(responseText);})

	}

}


//-----------------------------------------------RemoteScripting---------------------------------------------------

var tempRSCallBack;

function RSCallback(scriptPath, output, params, callback)
{
	if (params == null || (params != null && params.length == 0))
	{
		params = '_null=';
	}

	if (output != null)
	{
		if (typeof output != 'string')
		{
			if (output.id != null && output.id.length > 0)
			{
				output = output.id;
			}
			else
			{
				//work out a random id
				output.id = 'id' + Math.floor((Math.random() * 10000));
				output = output.id;
			}
		}
	}
	else
	{
		output = '';
	}

	if (callback != null)
	{
		if (typeof callback != 'string')
		{
			tempRSCallBack = callback;
			callback = 'tempRSCallBack';
		}	
	}
	else
	{
		callback = '';
	}

	var script = document.createElement('script');
	script.type = 'text\/javascript';
	script.language = 'javascript';
	script.src = scriptPath + '?' + params + '&output=' + output + '&callback=' + callback;

	//you may write any custom code in return script to operate the output element and call back callback function
	document.body.appendChild(script);
}

function testinfo(returnkey)
{
	var info,i,myinfo;
	if(document.getElementById("vsearch").innerHTML.indexOf("ִ")>0)
	{
		info ="&nbsp;";
		myinfo="&nbsp;";
	}
	else
	{
	  info = document.getElementById("vsearch").innerHTML;	
	  myinfo = document.getElementById("vsearch").innerHTML;
	}
		
	var domainlist,domaininfo;
         myinfo =myinfo +"<br>"
	domainlist = returnkey.split('#');
	for (i =0; i< domainlist.length ; i++ )
	{
		domaininfo = domainlist[i].split('|');

		if (domainlist[i].indexOf("210") >= 0) //ע
		{
			//ȡ׺
			/*tld = domaininfo[1].split(".")[domaininfo[1].split(".").length-1];
		
			info = info + domaininfo[1] + "&nbsp;&nbsp;&nbsp;&nbsp;" +"<a href='"+GetUrl(tld,domaininfo[1])+"&domain="+domaininfo[1]+"'><font color=blue>ע</font></a><br>";	
				document.getElementById("vsearch").innerHTML = info;	*/
			myinfo = myinfo + "<input type=radio name=selectedDomainName value='"+domaininfo[1]+"'>"+ domaininfo[1] + "<br>";	

		}
		else if(domainlist[i].indexOf("211") >= 0) //ѱע
		{
			info = info + domaininfo[1] + "&nbsp;&nbsp;&nbsp;&nbsp;" +"<a href='whois.net?domain="+domaininfo[1]+"' target=_blank><font color=red>Ѿע</font></a><br>";	
			document.getElementById("vsearch").innerHTML = info;
		}
		else if(domainlist[i].indexOf("212") >= 0) //ֹע
		{	
			info = info + domaininfo[1] + "&nbsp;&nbsp;&nbsp;&nbsp;" +"עᣬ<br>";
			document.getElementById("vsearch").innerHTML = 	info;
		}
		else
		{
			info = info + domaininfo[1] + "&nbsp;&nbsp;&nbsp;&nbsp;" +"쳣<br>";	
			document.getElementById("vsearch").innerHTML = info;
		}
	}
    if(myinfo!="&nbsp;"){
	  myinfo="<br><br>Լע᣺<br>"+myinfo;
	  if(info!="&nbsp;"){
		  document.getElementById("vsearch").innerHTML += myinfo;
	  }else{
		  document.getElementById("vsearch").innerHTML = myinfo;
	  }
	  document.getElementById("XZ").style.display = "block";
	}
} 

function GetUrl(tld,returnkey)
{
	var vurl
	switch(tld)
	{
		case "cn":
			vurl = "domain_activate.asp?productid=cn";
			break;
		case "com":
		    vurl = "domain_activate.asp?productid=com";
		    if (IsChDomain(returnkey)==true)
			{
			vurl = "domain_activate.asp?productid=comch";
			}
			break;
		case "net":
			vurl = "domain_activate.asp?productid=net";
		    if (IsChDomain(returnkey)==true)
			{
			vurl = "domain_activate.asp?productid=netch";
			}
			break;
		case "org":
			vurl = "domain_activate.asp?productid=org";
			break;
		case "й":
			vurl = "domain_activate.asp?productid=cnch";
			break;	
		case "˾":
			vurl = "domain_activate.asp?productid=cnch";
			break;	
		case "":
			vurl = "domain_activate.asp?productid=cnch";
			break;	
		case "name":
			vurl = "domain_activate.asp?productid=name";
			break;
	}
	return vurl;

}

//жǷΪĺ
function IsChDomain(argString)
	{
		var flag=false;
		var compStr="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-1234567890";

		var length1=argString.length;
		for(var chrIndex=0;chrIndex<length1;chrIndex++)
			{
				var temp=argString.charCodeAt(chrIndex)
				if(temp>=10000) 
					flag=true;
				else
				{
					var temp1=compStr.indexOf(argString.charAt(chrIndex));
					if(temp1==-1)
					{
						flag=false;
						break;							
					}
				}
			}
		return flag;
}