﻿<%
Class Cls_FSO
	Public objFSO
	Private Sub Class_Initialize()
		Set objFSO = Server.CreateObject("Scripting.FileSystemObject")
	End Sub
	Private Sub class_terminate()
		Set objFSO = Nothing
	End Sub

	'=======文件操作========
	'取文件大小
	Public Function GetFileSize(FileName)
		Dim f
		If ReportFileStatus(FileName) = 1 Then
			Set f = objFSO.Getfile(FileName)
			GetFileSize = f.Size
			Set f = Nothing
		Else
			GetFileSize = -1
		End if
	End Function 

	'文件删除
	Public Function deleteAFile(FileSpec)
		If ReportFileStatus(FileSpec) = 1 Then
			objFSO.deleteFile(FileSpec)
			deleteAFile = 1
		Else
			deleteAFile = -1
		End if
	End Function

	'显示文件列表
	Public Function ShowFileList(FolderSpec)
		Dim f, f1, fc, s
		If ReportFolderStatus(FolderSpec) = 1 Then
			Set f = objFSO.GetFolder(FolderSpec)
			Set fc = f.Files
			For Each f1 in fc
				s = s & f1.name 
				s = s & "|"
			Next
			ShowFileList = s
			Set fc = Nothing
			Set f = Nothing
		Else
			ShowFileList = -1
		End if
	End Function

	'文件复制
	Public Function CopyAFile(SourceFile, DestinationFile)
		Dim MyFile
		If ReportFileStatus(SourceFile) = 1 Then
			Set MyFile = objFSO.GetFile(SourceFile)
			MyFile.Copy (DestinationFile)
			CopyAFile = 1
		Else
			CopyAFile = -1
		End if
	End Function

	'文件移动
	Public Function MoveAFile(SourceFile,DestinationFile)
		If ReportFileStatus(SourceFile) = 1 And ReportFileStatus(DestinationFileORPath) = -1 Then
			objFSO.MoveFile SourceFile,DestinationFileORPath
			MoveAFile = 1
		Else
			MoveAFile = -1
		End if
	End Function

	'文件是否存在？
	Public Function ReportFileStatus(FileName) 
		Dim msg
		msg = -1
		If (objFSO.FileExists(FileName)) Then
			msg = 1
		Else
			msg = -1
		End If
		ReportFileStatus = msg
	End Function

	'文件创建日期
	Public Function ShowDatecreated(FileSpec)
		Dim f
		If ReportFileStatus(FileSpec) = 1 Then
			Set f = objFSO.GetFile(FileSpec)
			ShowDatecreated = f.Datecreated
			Set f = Nothing
		Else
			ShowDatecreated = -1
		End if
	End Function

	'文件属性
	Public Function GetAttributes(FileName)
		Dim f
		Dim strFileAttributes
		If ReportFileStatus(FileName) = 1 Then
			Set f = objFSO.GetFile(FileName)
			select Case f.attributes 
			Case 0 strFileAttributes = "普通文件。没有设置任何属性。 "
			Case 1 strFileAttributes = "只读文件。可读写。 "
			Case 2 strFileAttributes = "隐藏文件。可读写。 "
			Case 4 strFileAttributes = "系统文件。可读写。 "
			Case 16 strFileAttributes = "文件夹或目录。只读。 "
			Case 32 strFileAttributes = "上次备份后已更改的文件。可读写。 " 
			Case 1024 strFileAttributes = "链接或快捷方式。只读。 "
			Case 2048 strFileAttributes = " 压缩文件。只读。"
			End select
			Set f = Nothing
			GetAttributes = strFileAttributes
		Else
			GetAttributes = -1
		End if
	End Function

	'最后一次访问/最后一次修改时间
	Public Function ShowFileAccessInfo(FileName,InfoType)
		'//功能：显示文件创建时信息
		'//形参：文件名,信息类别
		'// 1 -----创建时间
		'// 2 -----上次访问时间
		'// 3 -----上次修改时间
		'// 4 -----文件路径
		'// 5 -----文件名称
		'// 6 -----文件类型
		'// 7 -----文件大小
		'// 8 -----父目录
		'// 9 -----根目录
		Dim f, s
		If ReportFileStatus(FileName) = 1 then
			Set f = objFSO.GetFile(FileName)
			select Case InfoType
			Case 1 s = f.Datecreated
			Case 2 s = f.DateLastAccessed
			Case 3 s = f.DateLastModified
			Case 4 s = f.Path
			Case 5 s = f.Name
			Case 6 s = f.Type
			Case 7 s = f.Size
			Case 8 s = f.ParentFolder
			Case 9 s = f.RootFolder
			End select
			Set f = Nothing
			ShowFileAccessInfo = s 
		ELse
			ShowFileAccessInfo = -1 
		End if
	End Function

	'写文本文件
	Public Function WriteTxtFile(FileName,TextStr,WriteORAppendType)
		Const ForReading = 1, ForWriting = 2 , ForAppending = 8
		Dim f, m
		select Case WriteORAppendType
		Case 1: '文件进行写操作
			If ReportFileStatus(FileName) = 1 then
				Set f = objFSO.OpenTextFile(FileName, ForWriting, True)
			 
				f.Write TextStr
				f.Close
				Set f = Nothing
				WriteTxtFile = 1
			Else
				WriteTxtFile = -1
			End if
		Case 2: '文件末尾进行写操作
			If ReportFileStatus(FileName) = 1 then
				Set f = objFSO.OpenTextFile(FileName, ForAppending)
			 
				f.Write TextStr
				f.Close
				Set f = Nothing
				WriteTxtFile = 1
			Else
				WriteTxtFile = -1
			End if
		End select
	End Function

	'读文本文件
	Public Function ReadTxtFile(FileName)
		dim stm 
set stm=Server.CreateObject("adodb.stream") 
stm.Type=1 'adTypeBinary，按二进制数据读入 
stm.Mode=3 'adModeReadWrite ,这里只能用3用其他会出错 
stm.Open 
stm.LoadFromFile FileName 
stm.Position=0 '把指针移回起点 
stm.Type=2 '文本数据 
stm.Charset="utf-8" 
ReadTxtFile = stm.ReadText 
stm.Close 
set stm=nothing
	End Function

	'建立文本文件
	Public Function createTextFileDemo(FileName,IsCover)
		Dim f
		IsCover = CBool(IsCover)
		If IsCover then
			Set f = objFSO.createTextFile(FileName, True)
			f.Close
			Set f = Nothing
			createTextFileDemo = 1
		Else
			If ReportFileStatus(FileName) = 1 Then
				createTextFileDemo = -1
			Else
				Set f = objFSO.createTextFile(FileName, False)
				f.Close
				Set f = Nothing
				createTextFileDemo = 1
			End if
		End if
	End Function

	'=======目录操作========
	'取目录大小
	Public Function GetFolderSize(FolderName)
		Dim f
		If ReportFolderStatus(FolderName) = 1 Then
			Set f = objFSO.GetFolder(FolderName)
			GetFolderSize = f.Size
			Set f = Nothing
		Else
			GetFolderSize = -1
		End if
	End Function 

	'创建的文件夹
	Public Function createFolderDemo(FolderName)
		Dim f
		If ReportFolderStatus(Folderspec) = 1 Then
			createFolderDemo = -1
		Else
			Set f = objFSO.createFolder(FolderName)
			createFolderDemo = 1
			Set f = Nothing
		End if
	End Function

	'目录删除
	Public Function deleteAFolder(Folderspec)
		If ReportFolderStatus(Folderspec) = 1 Then
			objFSO.deleteFolder (Folderspec)
			deleteAFolder = 1
		Else
			deleteAFolder = -1
		End if
	End Function

	'显示目录列表
	Public Function ShowFolderList(FolderSpec) 
		Dim f, f1, fc, s
		If ReportFolderStatus(FolderSpec) = 1 Then
			Set f = objFSO.GetFolder(FolderSpec)
			Set fc = f.SubFolders
			For Each f1 in fc
				s = s & f1.name 
				s = s & "|"
			Next
			Set fc = Nothing
			Set f = Nothing
			ShowFolderList = s
		Else
			ShowFolderList = -1
		End if
	End Function

	'目录复制
	Public Function CopyAFolder(SourceFolder,DestinationFolder)
		objFSO.CopyFolder SourceFolder,DestinationFolder
		CopyAFolder = 1
		CopyAFolder = -1
	End Function


	'目录进行移动
	Public Function MoveAFolder(SourcePath,DestinationPath)
		If ReportFolderStatus(SourcePath)=1 And ReportFolderStatus(DestinationPath)=0 Then
			objFSO.MoveFolder SourcePath, DestinationPath
			MoveAFolder = 1
		Else
			MoveAFolder = -1
		End if
	End Function

	'判断目录是否存在
	Public Function ReportFolderStatus(fldr) 
		Dim msg
		msg = -1
		If (objFSO.FolderExists(fldr)) Then
			msg = 1
		Else
			msg = -1
		End If
		ReportFolderStatus = msg
	End Function

	'目录创建时信息
	Public Function ShowFolderAccessInfo(FolderName,InfoType)
		'//功能：显示目录创建时信息
		'//形参：目录名,信息类别
		'// 1 -----创建时间
		'// 2 -----上次访问时间
		'// 3 -----上次修改时间
		'// 4 -----目录路径
		'// 5 -----目录名称
		'// 6 -----目录类型
		'// 7 -----目录大小
		'// 8 -----父目录
		'// 9 -----根目录
		Dim f, s
		If ReportFolderStatus(FolderName) = 1 then
			Set f = objFSO.GetFolder(FolderName)
			select Case InfoType
			Case 1 s = f.Datecreated
			Case 2 s = f.DateLastAccessed
			Case 3 s = f.DateLastModified
			Case 4 s = f.Path
			Case 5 s = f.Name
			Case 6 s = f.Type
			Case 7 s = f.Size
			Case 8 s = f.ParentFolder
			Case 9 s = f.RootFolder
			End select
			Set f = Nothing
			ShowFolderAccessInfo = s 
		ELse
			ShowFolderAccessInfo = -1 
		End if
	End Function

	'遍历目录
	Public Function DisplayLevelDepth(pathspec)
		Dim f, n, Path
		Set f = objFSO.GetFolder(pathspec)
		If f.IsRootFolder Then
			DisplayLevelDepth = "指定的文件夹是根文件夹。" & RootFolder
		Else
			Do Until f.IsRootFolder
				Path = Path & f.Name & "<br>"
				Set f = f.ParentFolder
				n = n + 1
			Loop
			DisplayLevelDepth ="指定的文件夹是嵌套级为 " & n & " 的文件夹。<br>" & Path
		End If
		Set f = Nothing
	End Function

	'========磁盘操作========
	'驱动器是否存在？
	Public Function ReportDriveStatus(drv) 
		Dim msg
		msg = -1
		If objFSO.DriveExists(drv) Then
			msg = 1
		Else
			msg = -1
		End If
		ReportDriveStatus = msg
	End Function

	'可用的返回类型包括 FAT、NTFS 和 CDFS。
	Public Function ShowFileSystemType(drvspec)
		Dim d
		If ReportDriveStatus(drvspec) = 1 Then
			Set d = objFSO.GetDrive(drvspec)
			ShowFileSystemType = d.FileSystem
			set d = Nothing
		ELse
			ShowFileSystemType = -1
		End if
	End Function
End Class
%> 
