<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */
use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\AdminPublicDB;
use admin_application\AdvertisementDB;
use admin_application\ArticleMainDB;
use admin_application\ArticleTypeDB;
use modul_application\ESPCMS_AdvertisementDB;
use admin_application\link\AdvertisementLink;
use admin_application\link\SettingLink;
use admin_application\link\ArticleLink;
class Advertisement {
	private static $advert_list_cache_key;
	public function __construct() {
		global $module_array;
		$exclude_method = array('saveAdvertisement', 'setAdvertisement', 'celeritySaveAdvertisement');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		$app_config = ESPCMS_Core::get_app_config('advertisement', false);
		if (!$app_config['isetup']) {
			espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
		}
		self::$advert_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'advert_';
	}
	public static function listAdvertisement() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "advert";
		$out_type = $_REQUEST['out_type'];
		$lng = AdminPublicDB::get_lancode();
		$db_where = " AND lng='$lng'";
		$atid = $_REQUEST['atid'];
		if (espcms_ismatches($atid) && $atid) {
			$db_where .= " AND atid=$atid";
		}
		if ($out_type == 'list') {
			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$isclass = $_REQUEST['isclass'];
			if (espcms_ismatches($isclass)) {
				$db_where .= " AND isclass=$isclass";
			}
			$adtype = $_REQUEST['adtype'];
			if (espcms_ismatches($adtype)) {
				$db_where .= " AND adtype=$adtype";
			}
			$istime = $_REQUEST['istime'];
			if (espcms_ismatches($istime)) {
				$db_where .= " AND istime=$istime";
			}
			$islink = $_REQUEST['islink'];
			if (espcms_ismatches($islink)) {
				$db_where .= " AND islink=$islink";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('adid', 'pid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "adid";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['adtypename'] = ESPCMS_AdvertisementDB::get_advertisement_type_view($fetch_row['atid'], 'adtypename');
				$fetch_row['edit'] = AdvertisementLink::Advertisement_link_array('edit', $fetch_row);
				$fetch_row['copy'] = AdvertisementLink::Advertisement_link_array('copy', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'advertisement/advertisement_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', AdvertisementLink::Advertisement_link_array(false, $_REQUEST));
			$templates = 'advertisement/advertisement_index';
		}
		$espcms_admin_templates->output($templates);
	}
	public static function addAdvertisement() {
		global $espcms_admin_templates;
		$lng = AdminPublicDB::get_lancode();
		$atid = $_GET['atid'];
		$advertisement_type_list = ESPCMS_AdvertisementDB::get_advertisement_type_list($lng, $atid);
		$espcms_admin_templates->into('advertisement_type_list', $advertisement_type_list);
		$article_type_array = ArticleTypeDB::get_article_type_list(0, 0, 0, 1, $lng, true, false);
		$espcms_admin_templates->into('article_type_array', $article_type_array);
		$article_subjectlist_array = ArticleTypeDB::get_document_subjectlist_list($lng, 0, 0, 1);
		$espcms_admin_templates->into('article_subjectlist_array', $article_subjectlist_array);
		$espcms_admin_templates->into('link', AdvertisementLink::Advertisement_link_array());
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('articlelink', ArticleLink::Article_Main_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('advertisement/advertisement_add');
	}
	public static function editAdvertisement() {
		global $espcms_admin_templates;
		$adid = $_GET['adid'];
		if (!$adid || !espcms_ismatches($adid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($adid));
		}
		$lng = AdminPublicDB::get_lancode();
		$db_table = ESPCMS_DB_PREFIX . "advert";
		$db_where = " WHERE adid=$adid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$read['content'] = $read['content'] ? espcms_h2t($read['content']) : '';
		$espcms_admin_templates->into('read', $read);
		$article_type_array = $read['islink'] == 3 ? ArticleTypeDB::get_article_type_list($read['gotoid'], 0, 0, 1, $lng, true, false) : ArticleTypeDB::get_article_type_list(0, 0, 0, 1, $lng, true, false);
		$espcms_admin_templates->into('article_type_array', $article_type_array);
		$article_subjectlist_array = $read['islink'] == 4 ? ArticleTypeDB::get_document_subjectlist_list($lng, $read['gotoid'], 0, 1) : ArticleTypeDB::get_document_subjectlist_list($lng, 0, 0, 1);
		$espcms_admin_templates->into('article_subjectlist_array', $article_subjectlist_array);
		if ($read['islink'] == 2 && $read['gotoid'] && espcms_ismatches($read['gotoid'])) {
			$doc_list = ArticleMainDB::get_article_list($read['gotoid']);
			$title_array = is_array($doc_list) ? espcms_array_onedim($doc_list, 'title') : array();
			if (is_array($title_array)) {
				$title_list = implode(',', $title_array);
			}
			$espcms_admin_templates->into('doc_list', $doc_list);
			$espcms_admin_templates->into('title_list', $title_list);
		}
		$advertisement_type_list = ESPCMS_AdvertisementDB::get_advertisement_type_list($read['lng'], $read['atid']);
		$espcms_admin_templates->into('advertisement_type_list', $advertisement_type_list);
		$espcms_admin_templates->into('link', AdvertisementLink::Advertisement_link_array());
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('articlelink', ArticleLink::Article_Main_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->into('type', !$_GET['type'] ? 'edit' : 'copy');
		$espcms_admin_templates->output('advertisement/advertisement_edit');
	}
	public static function saveAdvertisement() {
		global $espcms_db_cache;
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "advert";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (!$_POST['title'] || !espcms_ismatches($_POST['atid']) || !$_POST['atid'] || !espcms_ismatches($_POST['adtype']) || !espcms_ismatches($_POST['islink']) || !espcms_ismatches($_POST['istime'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		$_POST['starttime'] = espcms_istime($_POST['starttime']) && $_POST['istime'] ? strtotime($_POST['starttime']) : 0;
		$_POST['endtime'] = espcms_istime($_POST['endtime']) && $_POST['istime'] ? strtotime($_POST['endtime']) : 0;
		$_POST['adtype'] = espcms_ismatches($_POST['adtype']) ? $_POST['adtype'] : 1;
		if ($_POST['islink'] == 2 && !espcms_ismatches($_POST['gotoid'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		} elseif ($_POST['islink'] == 3 && espcms_ismatches($_POST['tid'])) {
			$_POST['gotoid'] = $_POST['tid'];
		} elseif ($_POST['islink'] == 4 && espcms_ismatches($_POST['sid'])) {
			$_POST['gotoid'] = $_POST['sid'];
		} else {
			$_POST['gotoid'] = espcms_ismatches($_POST['gotoid']) ? $_POST['gotoid'] : 0;
		}
		$_POST['content'] = $_POST['content'] ? espcms_t2h($_POST['content']) : '';
		$_POST['filename'] = espcms_ismatches($_POST['adtype']) && $_POST['adtype'] == 2 ? $_POST['filename_file'] : $_POST['filename'];
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addAdvertisement')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['lng'] = AdminPublicDB::get_lancode();
			$pid = AdvertisementDB::lastPidAdvertisement($_POST['lng'], $_POST['atid'], 'pid');
			$_POST['pid'] = espcms_ismatches($pid) && $pid ? $pid + 1 : 1;
			$_POST['isclass'] = 1;
			$_POST['addtime'] = time();
			unset($_POST['isclass'], $_POST['click']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$advert_list_cache_key . $_POST['atid'], true);
			espcms_log_install('advert_pack-espcms_advertisemen_button_add', $_POST['title']);
			espcms_public_dialog('espcms_info_save_ok', 'advert_pack-espcms_advertisemen_add_save_ok_message', 'true', array($_POST['title']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editAdvertisement')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$adid = $_POST['adid'];
			if (empty($adid) || !espcms_ismatches($adid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($adid));
			}
			$db_where = "WHERE adid=$adid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($adid));
			}
			unset($_POST['isclass'], $_POST['click'], $_POST['addtime'], $_POST['lng'], $_POST['pid']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$advert_list_cache_key . $read['atid'], true);
			espcms_log_install('advert_pack-espcms_advertisemen_button_edit', $_POST['title']);
			espcms_public_dialog('espcms_info_save_ok', 'advert_pack-espcms_advertisemen_edit_save_ok_message', 'true', array($_POST['title']));
		}
	}
	public static function celeritySaveAdvertisement() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editAdvertisement')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$db_table = ESPCMS_DB_PREFIX . "advert";
		$talbe_field_array = espcms_field_out($db_table, true);
		$adid = $_POST['adid'];
		if (empty($adid) || !espcms_ismatches($adid)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($adid));
		}
		$db_where = "WHERE adid=$adid";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($adid));
		}
		unset($_POST['isclass'], $_POST['click'], $_POST['addtime'], $_POST['lng'], $_POST['islink']);
		$postvalue = espcms_post($_POST, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
		}
		$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
		if (!$update_id) {
			espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
		}
		$read['title'] = espcms_cutstr($read['title'], 10);
		$espcms_db_cache->cacheDEL(self::$advert_list_cache_key . $read['atid'], true);
		espcms_public_dialog('espcms_info_save_ok', 'advert_pack-espcms_advertisemen_sort_message', 'true', array($read['title']));
	}
	public static function setAdvertisement() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editAdvertisement')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$atid = $_POST['atid'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "advert";
		$talbe_field_array = array('isclass');
		if (!in_array($field, $talbe_field_array)) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE adid=$value", "$field='$field_value'");
			if ($update_key) {
				$update_count++;
			}
		}
		$espcms_db_cache->cacheDEL(self::$advert_list_cache_key . $atid, true);
		$set_info_id = implode(', ', $select_id);
		espcms_log_install('advert_pack-espcms_advertisemen_button_set', "$field=$field_value" . " adid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'advert_pack-espcms_advertisemen_set_message', 'true', array($field));
	}
	public static function delAdvertisement() {
		global $espcms_db_cache;
		$atid = $_POST['atid'];
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delAdvertisementDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		$espcms_db_cache->cacheDEL(self::$advert_list_cache_key . $atid, true);
		espcms_log_install('advert_pack-espcms_advertisemen_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'advert_pack-espcms_advertisemen_del_message', 'true', array(), 'json', $return);
	}
	public static function delAdvertisementDB($adid = 0) {
		if (!$adid || !espcms_ismatches($adid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $adid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "advert";
		$del_query = espcms_db_del($db_table, 'adid', $adid);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $adid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $adid);
			return $return_array;
		}
	}
}
