<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030

 */
use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use application\ESPCMS_FileTool;
use modul_application\ESPCMS_SKUDB;
use modul_application\ESPCMS_ArticleTypeDB;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_ArticleDB;
use admin_application\ArticleMainDB;
use admin_application\ArticleModelDB;
use admin_application\ArticleTypeDB;
use admin_application\AdminPublicDB;
use modul_application\ESPCMS_FormDB;
use admin_application\ArticleTool;
use modul_application\ESPCMS_ArticleCreateDB;
use modul_application\ESPCMS_QuestionnaireDB;
use inc_application\link\ArticleLink as ArticleLinkWeb;
use admin_application\link\ArticleLink;
use admin_application\link\SettingLink;
use admin_application\link\TemplatesLink;
use admin_application\link\SkuLink;
use admin_application\link\QuestionnaireLink;
class ArticleMain {
    public function __construct() {
        $exclude_method = array('selectArticle', 'saveArticle', 'celeritysave', 'listArticle', 'setArticle', 'creatArticle', 'ajaxArticle');
        ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
    }
    public static function listArticle() {
        global $espcms_admin_templates, $espcms_link_db, $espcms_command;
        $db_table = ESPCMS_DB_PREFIX . "document";
        $admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
        if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
        }
        $out_type = $_REQUEST['out_type'];
        $lng = AdminPublicDB::get_lancode();
        define("ESPCMS_CREAT", $lng);



        $db_where = " AND isbase=0";
        $mid = $_REQUEST['mid'];
        if (espcms_ismatches($mid) && $mid) {
            $db_where .= " AND mid=$mid";
        }
        $sid = $_REQUEST['sid'];
        if (espcms_ismatches($sid) && $sid) {
            $db_where .= " AND sid=$sid";
        }
        $tid = $_REQUEST['tid'];
        if (espcms_ismatches($tid) && $tid) {
            $tid_array = ArticleTypeDB::get_article_type_listDB($tid, $lng);
            $tid_list = implode(',', array_keys($tid_array));
            $db_where .= is_array($tid_array) && count($tid_array) > 1 ? " AND tid IN ($tid_list)" : " AND tid=$tid_list";
            if (!$mid || !espcms_ismatches($mid)) {
                $type_read = ESPCMS_ArticleTypeDB::get_article_type_view($tid);
                if (espcms_ismatches($type_read['mid']) && $type_read['mid']) {
                    $mid = $type_read['mid'];
                    $_REQUEST['mid'] = $type_read['mid'];
                }
            }
        } else {
            $db_where .= " AND lng='$lng'";
        }
        if ($out_type == 'list') {

            $limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;

            $per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
            $isclass = $_REQUEST['isclass'];
            if (espcms_ismatches($isclass)) {
                $db_where .= " AND isclass=$isclass";
            }
            $ismess = $_REQUEST['ismess'];
            if (espcms_ismatches($ismess)) {
                $db_where .= " AND ismess=$ismess";
            }
            $islink = $_REQUEST['islink'];
            if (espcms_ismatches($islink)) {
                $db_where .= " AND islink=$islink";
            }
            $ishtml = $_REQUEST['ishtml'];
            if (espcms_ismatches($ishtml)) {
                $db_where .= " AND ishtml=$ishtml";
            }
            $purview = $_REQUEST['purview'];
            if (espcms_ismatches($purview)) {
                $db_where .= " AND purview=$purview";
            }
            $istemplates = $_REQUEST['istemplates'];
            if (espcms_ismatches($istemplates)) {
                $db_where .= " AND istemplates=$istemplates";
            }
            $isorder = $_REQUEST['isorder'];
            if (espcms_ismatches($isorder)) {
                $db_where .= " AND isorder=$isorder";
            }
            $recommend = $_REQUEST['recommend'];
            if (espcms_ismatches($recommend) && $recommend) {
                $db_where .= " AND FIND_IN_SET('$recommend',recommend)";
            }

            $search_keyname_array = array('title', 'tsn', 'author', 'source', 'summary');
            $search_keyname = $_REQUEST['search_keyname'] && in_array($_REQUEST['search_keyname'], $search_keyname_array) ? $_REQUEST['search_keyname'] : 'title';
            $search_key = $_REQUEST['search_key'];
            if (isset($search_key) && !empty($search_key)) {

                $search_key = urldecode($search_key);

                $db_where .= espcms_ismatches($search_key) && $search_key ? " AND (did=$search_key OR $search_keyname LIKE '%$search_key%')" : " AND $search_keyname LIKE '%$search_key%'";
            }

            $searchlist = $_GET['searchlist'];
            if ($searchlist == 'true') {
                exit(espcms_page_db($db_table, $db_where, true));
            }

            $sort_key = $_REQUEST['sort_key'];
            $sort_key_array = array('did', 'pid', 'tid', 'mid', 'click');
            if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
                $order_key = $sort_key;
            } else {
                $order_key = "did";
            }

            $sort_rank = $_REQUEST['sort_rank'];
            $sort_rank_array = array('ASC', 'DESC');
            if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
                $order_rank = $sort_rank;
            } else {
                $order_rank = "DESC";
            }
            $db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
            while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
                $fetch_row['titlecode'] = urlencode($fetch_row['title']);
                $fetch_row['edit'] = ArticleLink::Article_Main_link_array('edit', $fetch_row);
                $fetch_row['copy'] = ArticleLink::Article_Main_link_array('copy', $fetch_row);
                $fetch_row['view'] = ArticleLinkWeb::doc_link($fetch_row, true, false, $fetch_row['lng']);
                $fetch_row['typename'] = ESPCMS_ArticleTypeDB::get_article_type_view($fetch_row['tid'], 'typename');
                $fetch_row['modelname'] = ArticleModelDB::get_mid_view($fetch_row['mid'], 'modelname');
                $array[] = $fetch_row;
            }
            $espcms_admin_templates->into('select_num', $_REQUEST['select_num']);
            $espcms_admin_templates->into('array', $array);
            $list_type = $_GET['list_type'];
            $templates = $list_type == 'select' ? 'article/article_list_select' : 'article/article_list';
        } elseif ($out_type == 'select') {

            $espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
            $_REQUEST['list_type'] = 'select';
            $espcms_admin_templates->into('link', ArticleLink::Article_Main_link_array(false, $_REQUEST));
            $espcms_admin_templates->into('select_num', $_GET['select_num']);
            $espcms_admin_templates->into('inputname', $_GET['inputname']);
            $espcms_admin_templates->into('inputname2', $_GET['inputname2']);
            $espcms_admin_templates->into('iframes_name', $_GET['iframeName']);
            $templates = 'article/article_index_select';
        } else {
            if (!espcms_ismatches($mid) || !$mid) {

                $model_list = ArticleModelDB::get_model_list(0, false, 0);
                if (is_array($model_list)) {
                    foreach ($model_list as $key => $value) {
                        $model_list[$key]['url'] = ArticleLink::Article_Main_link_array('add', $value);
                    }
                }
                $espcms_admin_templates->into('model_list', $model_list);
            }

            $article_label_array = ArticleTypeDB::get_document_label_list($lng, 0, $mid);
            $espcms_admin_templates->into('article_label_array', $article_label_array);
            $espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
            $espcms_admin_templates->into('ishtml', $espcms_command['IS_HTML']);
            $espcms_admin_templates->into('mid', $mid);
            $espcms_admin_templates->into('link', ArticleLink::Article_Main_link_array(false, $_REQUEST));
            $templates = 'article/article_index';
        }
        $espcms_admin_templates->output($templates);
    }

    public static function addArticle() {
        global $espcms_admin_templates, $espcms_command;
        $lng = AdminPublicDB::get_lancode();
        $mid = $_GET['mid'];
        if (!$mid || !espcms_ismatches($mid)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($mid));
        }
        $model_read = ArticleModelDB::get_mid_view($mid);
        if (!$model_read) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($mid));
        }

        $tid = $_GET['tid'] && espcms_ismatches($_GET['tid']) ? $_GET['tid'] : 0;
        $article_type_array = ArticleTypeDB::get_article_type_list($tid, 0, $mid, false, $lng, true, true);
        $espcms_admin_templates->into('article_type_array', $article_type_array);

        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if ($member_app_config['isetup'] && $model_read['ispurview']) {
            $member_class_list = ESPCMS_MemberDB::get_member_class_list();
            $espcms_admin_templates->into('member_class_list', $member_class_list);
        }
        $espcms_admin_templates->into('member_app_config', $member_app_config);

        $sku_app_config = ESPCMS_Core::get_app_config('sku', false);
        if ($sku_app_config['isetup']) {
            $espcms_admin_templates->into('sku_attr_link', SkuLink::SKUMain_link_array('skuattr', $_GET));
            $espcms_admin_templates->into('sku_app_config', $sku_app_config);
        }

        $article_subjectlist_array = $model_read['issid'] ? ArticleTypeDB::get_document_subjectlist_list($lng, 0, $mid) : array();
        $espcms_admin_templates->into('article_subjectlist_array', $article_subjectlist_array);

        $article_label_array = ArticleTypeDB::get_document_label_list($lng, 0, $mid);
        $espcms_admin_templates->into('article_label_array', $article_label_array);

        $forms_app_config = ESPCMS_Core::get_app_config('formsmanage', false);
        if ($forms_app_config['isetup'] && $forms_app_config['isopen'] && $model_read['isfgid']) {
            $form_group_array = ESPCMS_FormDB::get_form_group_list($lng);
            $espcms_admin_templates->into('form_group_array', $form_group_array);
        } else {
            $model_read['isfgid'] = 0;
        }

        $vote_app_config = ESPCMS_Core::get_app_config('questionnaire', false);
        if ($vote_app_config['isetup'] && $vote_app_config['isopen'] && $model_read['isques']) {
            $espcms_admin_templates->into('vote_link', QuestionnaireLink::Questionnaire_link_array('select'));
        } else {
            $model_read['isques'] = 0;
        }

        $model_att_array = ArticleModelDB::get_document_model_att_list($mid);
        $espcms_admin_templates->into('model_att_array', $model_att_array);

        $article_tsn = $model_read['istsn'] ? ArticleTool::tsn_creat($model_read['tsnstyle']) : '';
        $espcms_admin_templates->into('article_tsn', $article_tsn);
        $espcms_admin_templates->into('model_read', $model_read);

        $espcms_admin_templates->into('article_title_clolor', $espcms_command['INPUT_COLOR']);

        $espcms_admin_templates->into('article_iskeylink', $espcms_command['IS_KEYLINK']);

        $espcms_admin_templates->into('link', ArticleLink::Article_Main_link_array());

        $espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));

        $espcms_admin_templates->into('key_select_link', ArticleLink::KeywordsOptimization_link_array('select'));
        $espcms_admin_templates->into('keygroups_select_link', ArticleLink::KeywordsGroups_link_array('select'));

        $espcms_admin_templates->into('templates_select', TemplatesLink::TemplateFile_link_array('select'));

        $espcms_admin_templates->into('article_select_link', ArticleLink::Article_Main_link_array('select'));
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('article/article_add');
    }

    public static function editArticle() {
        global $espcms_admin_templates, $espcms_command;
        $lng = AdminPublicDB::get_lancode();
        $did = $_GET['did'];
        if (!$did || !espcms_ismatches($did)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($did));
        }
        $read = ESPCMS_ArticleDB::get_article_read($did);
        if (!$read) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($did));
        }
        $mid = $read['mid'];
        $read['content'] = ESPCMS_ArticleDB::get_article_content_read($did, 'content');

        $attr_read = ESPCMS_ArticleDB::get_article_attr_read($did);
        $read = is_array($attr_read) ? array_merge($read, $attr_read) : $read;

        $photo = ESPCMS_ArticleDB::get_document_album_list($did);
        $espcms_admin_templates->into('attr_read', $attr_read);
        $espcms_admin_templates->into('photo', $photo);
        $espcms_admin_templates->into('photo_sum', count($photo));
        if (!$mid || !espcms_ismatches($mid)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($mid));
        }
        $model_read = ArticleModelDB::get_mid_view($mid);
        if (!$model_read) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($mid));
        }

        $article_type_array = ArticleTypeDB::get_article_type_list($read['tid'], 0, $mid, false, $lng, true, true);
        $espcms_admin_templates->into('article_type_array', $article_type_array);

        $espcms_admin_templates->into('article_extid_array', $read['extid'] && preg_match("/^[\d]+[\d,]*$/i", $read['extid']) ? explode(',', $read['extid']) : array());
        $espcms_admin_templates->into('purview_array', $read['purview'] && preg_match("/^[\d]+[\d,]*$/i", $read['purview']) ? explode(',', $read['purview']) : array());

        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if ($member_app_config['isetup'] && $model_read['ispurview']) {
            $member_class_list = ESPCMS_MemberDB::get_member_class_list($read['purview']);
            $espcms_admin_templates->into('member_class_list', $member_class_list);
        }
        $espcms_admin_templates->into('member_app_config', $member_app_config);

        $sku_app_config = ESPCMS_Core::get_app_config('sku', false);
        if ($sku_app_config['isetup']) {
            $sku_list = ESPCMS_SKUDB::get_sku_key_did_list($did, $read['tid']);
            $espcms_admin_templates->into('sku_list', $sku_list);
            $espcms_admin_templates->into('sku_attr_link', SkuLink::SKUMain_link_array('skuattr', $_GET));
            $espcms_admin_templates->into('sku_app_config', $sku_app_config);
        }

        $article_subjectlist_array = $model_read['issid'] ? ArticleTypeDB::get_document_subjectlist_list($lng, $read['sid'], $mid) : array();
        $espcms_admin_templates->into('article_subjectlist_array', $article_subjectlist_array);

        $article_label_array = ArticleTypeDB::get_document_label_list($lng, $read['recommend'], $mid);
        $espcms_admin_templates->into('article_label_array', $article_label_array);

        $forms_app_config = ESPCMS_Core::get_app_config('formsmanage', false);
        if ($forms_app_config['isetup'] && $forms_app_config['isopen'] && $model_read['isfgid']) {
            $form_group_array = ESPCMS_FormDB::get_form_group_list($lng, $read['fgid']);
            $espcms_admin_templates->into('form_group_array', $form_group_array);
        } else {
            $model_read['isfgid'] = 0;
        }

        $model_att_array = ArticleModelDB::get_document_model_att_list($mid);
        if (is_array($model_att_array)) {
            foreach ($model_att_array as $key => $value) {
                if (($value['inputtype'] == 'select' || $value['inputtype'] == 'radio') && is_array($value['attrvalue'])) {
                    foreach ($value['attrvalue'] as $key2 => $value2) {
                        $model_att_array[$key]['attrvalue'][$key2]['selected'] = trim($read[$value['attrname']]) == trim($value2['name']) ? 'selected' : '';
                    }
                } elseif ($value['inputtype'] == 'checkbox') {
                    $expvale = explode(',', $read[$value['attrname']]);
                    foreach ($value['attrvalue'] as $key2 => $value2) {
                        $model_att_array[$key]['attrvalue'][$key2]['selected'] = in_array($value2['name'], $expvale) ? 'selected' : '';
                    }
                } elseif ($value['inputtype'] == 'date' || $value['inputtype'] == 'time' || $value['inputtype'] == 'datetime') {
                    if ($read[$value['attrname']] && espcms_ismatches($read[$value['attrname']]) && $value['inputtype'] == 'date') {
                        $model_att_array[$key]['attrvalue'] = date('Y-m-d', $read[$value['attrname']]);
                    }
                    if ($read[$value['attrname']] && espcms_ismatches($read[$value['attrname']]) && $value['inputtype'] == 'datetime') {
                        $model_att_array[$key]['attrvalue'] = date('Y-m-d H:i:s', $read[$value['attrname']]);
                    }
                    if ($read[$value['attrname']] && espcms_ismatches($read[$value['attrname']]) && $value['inputtype'] == 'time') {
                        $model_att_array[$key]['attrvalue'] = date('H:i', $read[$value['attrname']]);
                    }
                } elseif ($value['inputtype'] == 'int' || $value['inputtype'] == 'float' || $value['inputtype'] == 'decimal') {
                    $model_att_array[$key]['attrvalue'] = preg_match("/^[\d.]+/", $read[$value['attrname']]) ? $read[$value['attrname']] : 0;
                } elseif ($value['inputtype'] == 'editor') {

                    $model_att_array[$key]['attrvalue'] = $read[$value['attrname']];
                } else {
                    $model_att_array[$key]['attrvalue'] = $read[$value['attrname']];
                }
            }
        }
        $espcms_admin_templates->into('model_att_array', $model_att_array);
        if (espcms_islongfig($read['linkdid'])) {

            $doc_list = ArticleMainDB::get_article_list($read['linkdid']);
            $title_array = is_array($doc_list) ? espcms_array_onedim($doc_list, 'title') : array();
            $title_list = is_array($title_array) ? implode(',', $title_array) : '';
            $espcms_admin_templates->into('doc_list', $doc_list);
            $espcms_admin_templates->into('title_list', $title_list);
        }

        $vote_app_config = ESPCMS_Core::get_app_config('questionnaire', false);
        if ($vote_app_config['isetup'] && $vote_app_config['isopen'] && $model_read['isques']) {
            if (espcms_islongfig($read['votelink'])) {
                $vote_list = ESPCMS_QuestionnaireDB::get_vote_itemlong_list($read['votelink']);
                $vote_title_array = is_array($vote_list) ? espcms_array_onedim($vote_list, 'vote_title') : array();
                $vote_title_list = is_array($vote_title_array) ? implode(',', $vote_title_array) : '';
                $espcms_admin_templates->into('vote_list', $vote_list);
                $espcms_admin_templates->into('vote_title_list', $vote_title_list);
            }
            $espcms_admin_templates->into('vote_link', QuestionnaireLink::Questionnaire_link_array('select'));
        } else {
            $model_read['isques'] = 0;
        }

        $article_tsn = $model_read['istsn'] && !$read['tsn'] ? ArticleTool::tsn_creat($model_read['tsnstyle']) : $read['tsn'];
        $espcms_admin_templates->into('article_tsn', $article_tsn);
        $espcms_admin_templates->into('model_read', $model_read);

        $espcms_admin_templates->into('article_title_clolor', !$read['color'] ? $espcms_command['INPUT_COLOR'] : $read['color']);

        $espcms_admin_templates->into('link', ArticleLink::Article_Main_link_array());

        $espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));

        $espcms_admin_templates->into('key_select_link', ArticleLink::KeywordsOptimization_link_array('select'));
        $espcms_admin_templates->into('keygroups_select_link', ArticleLink::KeywordsGroups_link_array('select'));

        $espcms_admin_templates->into('templates_select', TemplatesLink::TemplateFile_link_array('select'));

        $espcms_admin_templates->into('article_select_link', ArticleLink::Article_Main_link_array('select'));
        $espcms_admin_templates->into('token', token('article_edit'));
        $espcms_admin_templates->into('read', $read);
        $espcms_admin_templates->into('type', $_GET['type'] ? 'copy' : 'edit');
        $espcms_admin_templates->output('article/article_edit');
    }

    public static function saveArticle() {
        global $espcms_command;




        define("ESPCMS_CREAT", AdminPublicDB::get_lancode());
        $saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';

        $db_table = ESPCMS_DB_PREFIX . "document";
        $talbe_field_array = espcms_field_out($db_table, true);
        if (!espcms_ismatches($_POST['tid']) || !espcms_ismatches($_POST['mid'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
        }
        $_POST['color'] = $_POST['color'] && $_POST['color'] == $espcms_command['INPUT_COLOR'] ? '' : $_POST['color'];
        $_POST['sid'] = !espcms_ismatches($_POST['sid']) || !$_POST['sid'] ? 0 : $_POST['sid'];
        $_POST['fgid'] = !espcms_ismatches($_POST['fgid']) || !$_POST['fgid'] ? 0 : $_POST['fgid'];
        $_POST['islink'] = !espcms_ismatches($_POST['islink']) ? 0 : $_POST['islink'];
        $_POST['ishtml'] = !espcms_ismatches($_POST['ishtml']) ? 0 : $_POST['ishtml'];
        $_POST['ismess'] = !espcms_ismatches($_POST['ismess']) ? 0 : $_POST['ismess'];
        $_POST['isorder'] = !espcms_ismatches($_POST['isorder']) ? 0 : $_POST['isorder'];
        $_POST['purview'] = !espcms_array_ismatches($_POST['purview']) ? 0 : implode(',', $_POST['purview']);
        $_POST['istemplates'] = !espcms_ismatches($_POST['istemplates']) ? 0 : $_POST['istemplates'];
        $_POST['isbase'] = !espcms_ismatches($_POST['isbase']) ? 0 : $_POST['isbase'];

        $_POST['extid'] = !espcms_array_ismatches($_POST['extid']) ? 0 : implode(',', $_POST['extid']);
        $_POST['recommend'] = !espcms_array_ismatches($_POST['recommend']) ? 0 : implode(',', $_POST['recommend']);
        $_POST['votelink'] = espcms_islongfig($_POST['votelink']) ? $_POST['votelink'] : '';
        $_POST['linkdid'] = espcms_islongfig($_POST['linkdid']) ? $_POST['linkdid'] : '';

        $_POST['oprice'] = !espcms_ismoney($_POST['oprice']) ? 0 : $_POST['oprice'];
        $_POST['bprice'] = !espcms_ismoney($_POST['bprice']) ? 0 : $_POST['bprice'];
        if ($_POST['content'] && $espcms_command['INPUT_ISDELLINK'] && $_POST['input_isdellink']) {

            $_POST['content'] = ArticleTool::article_link_clear($_POST['content']);
        }
        if ($_POST['content'] && $_POST['keywords'] && $espcms_command['IS_KEYLINK'] && $_POST['ceratkeylink_type'] > 0) {

            $_POST['content'] = ArticleTool::article_key_replace($_POST['content'], $_POST['keywords'], $_POST['ceratkeylink_type']);
        }
        if ($_POST['content'] && $_POST['donwloadpic']) {

            $_POST['content'] = ArticleTool::article_downloadpic($_POST['content']);
        }
        if ($_POST['content']) {
            $exCotnet = explode('<hr class=\"espcms_pagebreak\"/>', $_POST['content']);
            $_POST['filepage'] = count($exCotnet);
        }
        $_POST['content'] = $_POST['content'] ? htmlspecialchars($_POST['content']) : '';
        if ($saveType == 'add') {
            if (!ESPCMS_AdminAuthority::authorityVerify('addArticle')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            $_POST['lng'] = AdminPublicDB::get_lancode();



            $_POST['pid'] = 50;
            $_POST['addtime'] = !espcms_istime($_POST['addtime']) ? time() : strtotime($_POST['addtime']);
            $_POST['click'] = !espcms_ismatches($_POST['click']) ? 0 : $_POST['click'];
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }

            ArticleMainDB::article_install_content($install_id, $_POST);

            ArticleMainDB::article_install_document_album($install_id, $_POST);

            ArticleMainDB::article_install_document_attr($_POST['mid'], $install_id, $_POST);

            $sku_app_config = ESPCMS_Core::get_app_config('sku', false);
            if ($sku_app_config['isetup']) {
                ESPCMS_SKUDB::sku_key_value_save($_POST['tid'], $install_id, $_POST);
            }
            if ($_POST['ishtml'] <= 1 && !$espcms_command['IS_HTML']) {

                ESPCMS_ArticleCreateDB::creat_document_html($install_id, $_POST['lng']);
            }
            espcms_log_install('article_pack-espcms_article_main_button_add', $_POST['title']);
            $_POST['title'] = espcms_cutstr($_POST['title'], 10);
            $link_key['mid'] = $_POST['mid'];
            $link_key['tid'] = $_POST['tid'];
            $link_key['key_str'] = "mid=" . $_POST['mid'] . '&tid=' . $_POST['tid'];
            espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_main_add_save_ok_message', 'true', array($_POST['title']), 'json', $link_key);
        } elseif ($saveType == 'edit') {
            if (!ESPCMS_AdminAuthority::authorityVerify('editArticle')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            $_POST['datid'] = !espcms_ismatches($_POST['datid']) || !$_POST['datid'] ? 0 : $_POST['datid'];
            $did = $_POST['did'];
            if (empty($did) || !espcms_ismatches($did)) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($did));
            }
            $db_where = "WHERE did=$did";
            $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($did));
            }
            $mid = $read['mid'];
            $_POST['addtime'] = !espcms_istime($_POST['addtime']) ? $read['addtime'] : strtotime($_POST['addtime']);
            $_POST['click'] = !espcms_ismatches($_POST['click']) ? $read['click'] : $_POST['click'];
            $_POST['uptime'] = time();
            unset($_POST['lng']);
            unset($_POST['mid']);
            unset($_POST['pid']);
            unset($_POST['isclass']);
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
            if (!$update_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }

            ArticleMainDB::article_install_content($did, $_POST, true);

            if ($_POST['datid']) {
                ArticleMainDB::article_install_document_attr($mid, $did, $_POST, true);
            } else {
                ArticleMainDB::article_install_document_attr($mid, $did, $_POST, false);
            }

            ArticleMainDB::article_install_document_album($did, $_POST, true);

            $sku_app_config = ESPCMS_Core::get_app_config('sku', false);
            if ($sku_app_config['isetup']) {
                ESPCMS_SKUDB::sku_key_value_save($_POST['tid'], $did, $_POST, true);
            }
            if ($_POST['ishtml'] <= 1 && !$espcms_command['IS_HTML']) {

                ESPCMS_ArticleCreateDB::creat_document_html($did, $read['lng']);
            }
            espcms_log_install('article_pack-espcms_article_main_button_edit', $_POST['title']);
            $_POST['title'] = espcms_cutstr($_POST['title'], 10);
            espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_main_edit_save_ok_message', 'true', array($_POST['title']));
        }
    }

    public static function celeritySaveArticle() {
        if (!ESPCMS_AdminAuthority::authorityVerify('editArticle')) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
        }

        $db_table = ESPCMS_DB_PREFIX . "document";
        $talbe_field_array = espcms_field_out($db_table, true);
        $did = $_POST['did'];
        if (empty($did) || !espcms_ismatches($did)) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($did));
        }
        $db_where = "WHERE did=$did";
        $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($did));
        }
        unset($_POST['lng']);
        unset($_POST['mid']);
        unset($_POST['tid']);
        unset($_POST['isclass']);
        $postvalue = espcms_post($_POST, $talbe_field_array, true);
        if (!$postvalue || !is_array($postvalue)) {
            espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
        }
        $update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
        if (!$update_id) {
            espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
        }
        $read['title'] = espcms_cutstr($read['title'], 10);
        espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_main_edit_pid_ok', 'true', array($read['title']));
    }

    public static function creatArticle() {
        global $espcms_command;
        $lng = AdminPublicDB::get_lancode();
        $select_id = $_POST['select_id'];

        if (!is_array($select_id) || count($select_id) <= 0) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
        }
        if ($espcms_command['IS_HTML']) {
            espcms_public_dialog('info_set_err', 'article_pack-espcms_article_main_creat_err', 'false');
        }

        $update_count = 0;
        foreach ($select_id as $key => $value) {
            if (!espcms_ismatches($value)) {
                continue;
            }
            $update_key = ESPCMS_ArticleCreateDB::creat_document_html($value, $lng);
            if ($update_key) {
                $update_count++;
            }
        }
        $set_info_id = implode(', ', $select_id);
        espcms_log_install('article_pack-espcms_article_main_button_creat', "did=" . $set_info_id);
        espcms_public_dialog('info_set_ok', 'article_pack-espcms_article_main_creat_ok', 'true');
    }

    public static function setArticle() {
        if (!ESPCMS_AdminAuthority::authorityVerify('editArticle')) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
        }

        $select_id = $_POST['select_id'];
        $field = $_POST['field'];
        $field_value = $_POST['field_value'];

        if (!is_array($select_id) || count($select_id) <= 0) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
        }

        if (!$field || !espcms_ismatches($field_value)) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
        }

        $db_table = ESPCMS_DB_PREFIX . "document";
        $talbe_field_array = array('recommend_1', 'recommend_0', 'ismess', 'isorder', 'isclass');
        if (!in_array($field, $talbe_field_array)) {
            espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
        }

        $update_count = 0;
        foreach ($select_id as $value) {
            if (!espcms_ismatches($value)) {
                continue;
            }
            if ($field == 'recommend_1' || $field == 'recommend_0') {
                $update_key = self::setArticleDB($value, $field_value, $field);
            } else {
                $update_key = espcms_db_update_set_save($db_table, "WHERE did=$value", "$field='$field_value'");
            }
            if ($update_key) {
                $update_count++;
            }
        }
        $set_info_id = implode(', ', $select_id);
        espcms_log_install('article_pack-espcms_article_main_button_set', "$field=$field_value" . " did=" . $set_info_id);
        espcms_public_dialog('info_set_ok', 'article_pack-espcms_article_main_set_message', 'true', array($field));
    }

    protected static function setArticleDB($did = 0, $dlid = 0, $type = 'recommend_1') {
        if (!$did || !espcms_ismatches($did)) {
            return false;
        }
        if (!$dlid || !espcms_ismatches($dlid)) {
            return false;
        }
        $db_table = ESPCMS_DB_PREFIX . "document";
        $read = ESPCMS_ArticleDB::get_article_read($did);
        if (!$read) {
            return false;
        }
        if ($type == 'recommend_0' && !$read['recommend']) {
            return true;
        }
        if ($read['recommend']) {
            $recommend_array = explode(',', $read['recommend']);

            if (in_array($dlid, $recommend_array) && $type == 'recommend_1') {
                return true;
            }

            if (!in_array($dlid, $recommend_array) && $type == 'recommend_0') {
                return true;
            }
            if ($type == 'recommend_1') {
                $recommend_array[] = $dlid;
            } else {
                $recommend_array = unArrayValue($recommend_array, $dlid);
            }
            $dlid = is_array($recommend_array) && count($recommend_array) > 0 ? implode(',', $recommend_array) : '';
        }
        $update_key = espcms_db_update_set_save($db_table, "WHERE did=$did", "recommend='$dlid'");
        if ($update_key) {
            return true;
        } else {
            return false;
        }
    }

    public static function delArticle() {
        $select_id = $_POST['select_id'];

        if (!is_array($select_id) || count($select_id) <= 0) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
        }

        $delcount = 0;
        foreach ($select_id as $value) {
            $operate_result = self::delArticleDB($value);
            if ($operate_result['code'] == 'true') {
                $delcount++;
            }
        }
        $espcms_del_id = implode(', ', $select_id);
        espcms_log_install('article_pack-espcms_article_main_button_del', $espcms_del_id);

        $return['count'] = $delcount;
        espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_main_del_message', 'true', array(), 'json', $return);
    }

    private static function delArticleDB($did = 0) {
        global $espcms_command;
        if (!$did || !espcms_ismatches($did)) {
            $return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $did);
            return $return_array;
        }
        $db_table = ESPCMS_DB_PREFIX . "document";
        $db_table_document_album = ESPCMS_DB_PREFIX . "document_album";
        $db_table_document_attr = ESPCMS_DB_PREFIX . "document_attr";
        $db_table_document_content = ESPCMS_DB_PREFIX . "document_content";
        $db_where = "did=$did";
        $read = ESPCMS_ArticleDB::get_article_read($did);
        if (!$read) {
            $return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $did);
            return $return_array;
        }
        if ($read['filepath']) {
            $lng = $read['lng'];

            $html_dir = !$espcms_command['IS_HTMLDIR'] ? ESPCMS_FILE_ROOT : ESPCMS_FILE_ROOT . $espcms_command['FILE_HTMLDIR'];

            $html_creat_path = $espcms_command['HOME_LNG'] == $lng ? $html_dir : $html_dir . $lng . '/';

            $filepath = $html_creat_path . $read['filepath'];
            if (is_file($filepath)) {
                ESPCMS_FileTool::delFile($filepath);
            }
        }
        espcms_db_delall($db_table_document_album, $db_where);
        espcms_db_delall($db_table_document_attr, $db_where);
        espcms_db_delall($db_table_document_content, $db_where);
        if (espcms_db_delall($db_table, $db_where)) {
            $return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $did);
            return $return_array;
        } else {
            $return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $did);
            return $return_array;
        }
    }

    public static function ajaxArticle() {
        global $espcms_link_db;
        $did = $_POST['did'];
        if (!is_array($did) || !espcms_array_ismatches($did)) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($did));
        }
        $did_list = implode(',', $did);
        $db_table = ESPCMS_DB_PREFIX . "document";
        $db_where = espcms_ismatches($did_list) ? " AND did=$did_list" : " AND did IN($did_list)";
        $db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, 'did', 'DESC', false, false, 'did,title,tsn,pic,oprice,bprice'));
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $array[] = $fetch_row;
        }
        $array_json = json_encode($array);
        exit($array_json);
    }
}
