<?php
/*
  PHP version 5
  Copyright (c) 2002-2020 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/
use application\ESPCMS_AdminAuthority;
use application\ESPCMS_FileUpload;
use application\ESPCMS_FileTool;
use admin_application\FileDB;
use admin_application\link\SettingLink;
class FileManage {
    public function __construct() {
        $exclude_method = array('fileManageDialogbox', 'uploadFile', 'photoIndex', 'photoList', 'listFileManage', 'uploadFileSave', 'uploadFileConfig');
        ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
    }
    public static function listFileManage() {
        global $espcms_admin_templates, $espcms_link_db, $espcms_command;
        $db_table = ESPCMS_DB_PREFIX . "file";
        $db_table_filedir = ESPCMS_DB_PREFIX . "filedir";
        $viewtype = $_REQUEST['viewtype'] ? $_REQUEST['viewtype'] : 'web';
        $selectnum = $_REQUEST['selectnum'];
        $upfileType = $_REQUEST['upfileType'];
        $out_type = $_REQUEST['out_type'];
        if ($out_type == 'list') {
            $filedir_id = $_GET['filedir_id'];
            $db_where_file = $filedir_id && espcms_ismatches($filedir_id) ? " AND filedir_id=$filedir_id" : " AND filedir_id=0";
            if ($filedir_id && espcms_ismatches($filedir_id)) {
                $dir_read = espcms_db_read_field_array($db_table_filedir, 'WHERE filedir_id=' . $filedir_id, array('filedir_id', 'filedir_lastid', 'filedir_name'));
                $espcms_admin_templates->into('dir_read', $dir_read);
            }
            $db_where_file_dir = $filedir_id && espcms_ismatches($filedir_id) ? " AND filedir_lastid=$filedir_id" : " AND filedir_lastid=0";
            $db_sql_dir = "SELECT * FROM $db_table_filedir WHERE 1=1 $db_where_file_dir ORDER BY filedir_id DESC";
            $db_query_dir = $espcms_link_db->db_query($db_sql_dir);
            while ($fetch_row_dir = $espcms_link_db->db_array_list($db_query_dir)) {
                $array_dir[] = $fetch_row_dir;
            }
            $espcms_admin_templates->into('array_dir', $array_dir);
            if ($upfileType == 'image') {
                $db_where_file .= " AND file_type='image'";
            }
            $search_keyname_array = array('file_filename', 'file_title', 'file_type');
            $search_keyname = $_REQUEST['search_keyname'] && in_array($_REQUEST['search_keyname'], $search_keyname_array) ? $_REQUEST['search_keyname'] : 'file_filename';
            $search_key = $_REQUEST['search_key'];
            if (isset($search_key) && !empty($search_key)) {
                $search_key = urldecode($search_key);
                $db_where_file .= " AND $search_keyname LIKE '%$search_key%'";
            }
            $searchlist = $_GET['searchlist'];
            if ($searchlist == 'true') {
                exit(espcms_page_db($db_table, $db_where_file, true));
            }
            $order_key = "file_id";
            $sort_rank = $_REQUEST['sort_rank'];
            $sort_rank_array = array('ASC', 'DESC');
            if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
                $order_rank = $sort_rank;
            } else {
                $order_rank = "DESC";
            }
            $db_sql = "SELECT * FROM $db_table WHERE 1=1 $db_where_file ORDER BY $order_key $order_rank";
            $db_query = $espcms_link_db->db_query($db_sql);
            while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
                $fetch_row['file_name'] = $fetch_row['file_path'] . $fetch_row['file_filename'];
                $fetch_row['file_url'] = ESPCMS_URL_RT . $fetch_row['file_path'] . $fetch_row['file_filename'];
                $fetch_row['view'] = ESPCMS_URL . $fetch_row['file_path'] . $fetch_row['file_filename'];
                $array[] = $fetch_row;
            }
            $espcms_admin_templates->into('array', $array);
            $tempaltes_file = $_GET['fileListType'] == 'listfile' ? 'admin/filemanage_list_file' : 'admin/filemanage_list';
        } else {
            $upfileType = 'file';
            $espcms_admin_templates->into('upfileType', $upfileType);
            $upfile_ext = $espcms_command['UPFILE_FILE_OTHER_TYPE'];
            $espcms_admin_templates->into('upfile_ext', $upfile_ext);
            $php_upload_max_filesize = ini_get('file_uploads') ? intval(ini_get('upload_max_filesize')) : 2;
            $espcms_admin_templates->into('php_upload_max_filesize', $php_upload_max_filesize);
            $net_upload_max_filesize = intval($espcms_command['UPFILE_SIZE']);
            $espcms_admin_templates->into('net_upload_max_filesize', $net_upload_max_filesize);
            $chunksize = $php_upload_max_filesize > 5 ? 5 * 1024 * 1024 : $php_upload_max_filesize * 1024 * 1024;
            $espcms_admin_templates->into('chunksize', $chunksize);
            $upload_max_filesize_byte = $net_upload_max_filesize * 1024 * 1024;
            $espcms_admin_templates->into('upload_max_filesize_byte', $upload_max_filesize_byte);
            $espcms_admin_templates->into('selectnum', isset($selectnum) && espcms_ismatches($selectnum) ? intval($selectnum) : 30);
            $espcms_admin_templates->into('link', SettingLink::myfile_link_array(false, $_REQUEST));
            $espcms_admin_templates->into('upfileave', SettingLink::FileManage_link_array('save'));
            $tempaltes_file = $viewtype == 'dialog' ? 'filemanage/fileManage_dirlist_index' : 'admin/filemanage_index';
        }
        $espcms_admin_templates->output($tempaltes_file);
    }
    public static function addFileDir() {
        global $espcms_admin_templates;
        $filedir_id = $_GET['filedir_id'] && espcms_ismatches($_GET['filedir_id']) ? $_GET['filedir_id'] : 0;
        $espcms_admin_templates->into('link', SettingLink::myfile_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->into('filedir_id', $filedir_id);
        $espcms_admin_templates->output('admin/filemanage_filedir_add');
    }
    public static function editFileDir() {
        global $espcms_admin_templates;
        $filedir_id = $_GET['filedir_id'];
        if (!$filedir_id || !espcms_ismatches($filedir_id)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($filedir_id));
        }
        $db_table = ESPCMS_DB_PREFIX . "filedir";
        $db_where = " WHERE filedir_id=$filedir_id";
        $talbe_field_array = espcms_field_out($db_table, false);
        $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
        }
        $espcms_admin_templates->into('read', $read);
        $espcms_admin_templates->into('link', SettingLink::myfile_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->into('filedir_id', $filedir_id);
        $espcms_admin_templates->output('admin/filemanage_filedir_edit');
    }
    public static function importFile() {
        global $espcms_admin_templates, $espcms_command;
        $filedir_id = $_GET['filedir_id'] && espcms_ismatches($_GET['filedir_id']) ? $_GET['filedir_id'] : 0;
        if ($_GET['filedir_id'] && espcms_ismatches($_GET['filedir_id'])) {
            $dir_read = FileDB::getFileDir($_GET['filedir_id']);
            $espcms_admin_templates->into('dir_read', $dir_read);
        }
        $upfile_dir = $espcms_command['UPFILE_SAVAPATH'] ? $espcms_command['UPFILE_SAVAPATH'] : 'upfile/';
        $filePath = ESPCMS_FILE_ROOT . $upfile_dir;
        if ($dir_read['filedir_path']) {
            $filePath = ESPCMS_FILE_ROOT . $upfile_dir . $dir_read['filedir_path'];
        } else {
            $dir_array = ESPCMS_FileTool::list_dir($filePath);
            if ($dir_array && is_array($dir_array)) {
                $dir_select_array = array();
                foreach ($dir_array as $key => $value) {
                    $dir_select_array[$key]['title'] = str_replace($filePath, '', $value) . '/';
                }
                $espcms_admin_templates->into('dir_array', $dir_select_array);
            }
        }
        $espcms_admin_templates->into('link', SettingLink::myfile_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->into('filedir_id', $filedir_id);
        $espcms_admin_templates->output('admin/filemanage_filedir_import');
    }
    public static function checkFile() {
        global $espcms_command;
        $upfile_dir = $espcms_command['UPFILE_SAVAPATH'] ? $espcms_command['UPFILE_SAVAPATH'] : 'upfile/';
        $filePath = ESPCMS_FILE_ROOT . $upfile_dir;
        $db_where_dir = "AND filedir_isdir=1";
        $db_table_dir = ESPCMS_DB_PREFIX . 'filedir';
        $dir_array = espcms_db_list_array($db_table_dir, 'filedir_id,filedir_isdir,filedir_path,filedir_dirname', $db_where_dir, "filedir_id DESC");
        if (is_array($dir_array) && count($dir_array) > 0) {
            foreach ($dir_array as $key => $dir_read) {
                $dir_path = $filePath . $dir_read['filedir_path'];
                if (is_dir($dir_path) || !$dir_read['filedir_path']) {
                    continue;
                }
                espcms_db_del($db_table_dir, 'filedir_id', $dir_read['filedir_id']);
            }
        }
        $db_table_file = ESPCMS_DB_PREFIX . 'file';
        $file_array = espcms_db_list_array($db_table_file, 'file_id,file_filename,file_path,file_type', '', "file_id DESC");
        if (is_array($file_array) && count($file_array) > 0) {
            foreach ($file_array as $key => $file_read) {
                $file_path = ESPCMS_FILE_ROOT . $file_read['file_path'] . $file_read['file_filename'];
                if (is_file($file_path) || !$file_read['file_path']) {
                    continue;
                }
                espcms_db_del($db_table_file, 'file_id', $file_read['file_id']);
            }
        }
        espcms_log_install('filemanage_pack-espcms_filenamage_file_check_title');
        espcms_public_dialog('espcms_info_save_ok', 'filemanage_pack-espcms_filenamage_file_check_ok', 'true');
    }
    public static function saveFileDir() {
        global $espcms_command;
        if (!is_token($_POST['token_name'], $_POST['token_key'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
        }
        $saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
        $db_table = ESPCMS_DB_PREFIX . "filedir";
        $talbe_field_array = espcms_field_out($db_table, true);
        if ($saveType == 'add') {
            if (!ESPCMS_AdminAuthority::authorityVerify('addFileDir')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            if (!espcms_ismatches($_POST['filedir_lastid']) || !$_POST['filedir_name']) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            $_POST['filedir_addtime'] = time();
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            espcms_log_install('filemanage_pack-espcms_lable_myfiledir_addfieldir', $_POST['filedir_name']);
            espcms_public_dialog('espcms_info_save_ok', 'filemanage_pack-espcms_lable_myfiledir_add_save_ok', 'true', array($_POST['filedir_name']));
        } elseif ($saveType == 'edit') {
            if (!ESPCMS_AdminAuthority::authorityVerify('editFileDir')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            unset($_POST['filedir_lastid']);
            $filedir_id = $_POST['filedir_id'];
            if (empty($filedir_id) || !espcms_ismatches($filedir_id)) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($filedir_id));
            }
            $db_where = "WHERE filedir_id=$filedir_id";
            $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($filedir_id));
            }
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
            if (!$update_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            espcms_log_install('filemanage_pack-espcms_lable_myfiledir_editfieldir', $_POST['filedir_name']);
            espcms_public_dialog('espcms_info_save_ok', 'filemanage_pack-espcms_lable_myfiledir_edit_save_ok', 'true', array($_POST['filedir_name']));
        } elseif ($saveType == 'import') {
            if (!ESPCMS_AdminAuthority::authorityVerify('importFile')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            $assign_filedir_id = $_POST['filedir_id'];
            if (!espcms_ismatches($assign_filedir_id)) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($assign_filedir_id));
            }
            $list_path = $_POST['dirpath'] && espcms_isact($_POST['dirpath'], "/^[\w\/\-]+$/i") && $_POST['isdir'] && espcms_ismatches($_POST['isdir']) ? $_POST['dirpath'] : '';
            $upfile_dir = $espcms_command['UPFILE_SAVAPATH'] ? $espcms_command['UPFILE_SAVAPATH'] : 'upfile/';
            $filePath = ESPCMS_FILE_ROOT . $upfile_dir . $list_path;
            if (!is_dir($filePath)) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($upfile_dir . $list_path));
            }
            $path_reg = espcms_isact($_POST['dirpath'], "/^[\w\/\-]+$/i") && !$_POST['isdir'] && !$_POST['dirname'] ? '' : $_POST['dirpath'];
            $dir_array = ESPCMS_FileTool::list_dir($filePath);
            if (is_array($dir_array)) {
                $dir_level_array = array();
                foreach ($dir_array as $dir_key => $dir_path) {
                    $dir_name = str_replace($filePath, $path_reg, $dir_path);
                    $dir_level = explode('/', $dir_name);
                    $filedir_lastid = $assign_filedir_id;
                    if (is_array($dir_level)) {
                        foreach ($dir_level as $key => $value) {
                            if (!$value) {
                                continue;
                            }
                            if ($key == 0) {
                                $filedir_lastid = 0;
                            }
                            $filedir_id = FileDB::getSearchDir($value, $filedir_lastid, 'filedir_id');
                            if (!$filedir_id) {
                                $filedir_lastid = FileDB::import_fileDirDB($value, $filedir_lastid, $dir_name);
                            } else {
                                $filedir_lastid = $filedir_id;
                            }
                        }
                        $dir_level_array[$dir_key]['path'] = $dir_path;
                        $dir_level_array[$dir_key]['filedir_id'] = $filedir_lastid;
                    }
                }
            }
            $dir_level_array[] = array('filedir_id' => $assign_filedir_id, 'path' => $filePath);
            if (is_array($dir_level_array)) {
                foreach ($dir_level_array as $dir_read) {
                    FileDB::import_fileDB($dir_read['path'], $dir_read['filedir_id']);
                }
            }
            espcms_public_dialog('espcms_info_save_ok', 'filemanage_pack-espcms_lable_file_import_ok', 'true', array($upfile_dir . $list_path));
        }
    }
    public static function moverFile() {
        $file_id = $_POST['file_id'];
        $filedir_id = $_POST['filedir_id'];
        $file_id_array = explode(',', $file_id);
        if (!is_array($file_id_array) || count($file_id_array) <= 0 || !$filedir_id || !espcms_ismatches($filedir_id)) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false');
        }
        $file_id_list = implode(',', $file_id_array);
        $db_where = is_array($file_id_array) && count($file_id_array) > 1 ? " WHERE file_id IN ($file_id_list)" : " WHERE file_id=$file_id_list";
        $db_table = ESPCMS_DB_PREFIX . "file";
        espcms_db_update_set_save($db_table, $db_where, "filedir_id=$filedir_id");
        espcms_log_install('filemanage_pack-espcms_lable_myfiledir_mover2', $filedir_id);
        espcms_public_dialog('espcms_info_save_ok', 'filemanage_pack-espcms_lable_myfiledir_mover_ok', 'true', array($filedir_id));
    }
    public static function delFileDir() {
        $filedir_id = $_POST['filedir_id'];
        if (!$filedir_id || !espcms_ismatches($filedir_id)) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($filedir_id));
        }
        self::delFileDirDB($filedir_id);
        espcms_log_install('filemanage_pack-espcms_lable_myfiledir_delfieldir', $filedir_id);
        espcms_public_dialog('espcms_info_save_ok', 'filemanage_pack-espcms_lable_myfiledir_del_ok2', 'true', array($filedir_id));
    }
    private static function delFileDirDB($filedir_id = 0) {
        global $espcms_command;
        if (!$filedir_id || !espcms_ismatches($filedir_id)) {
            return false;
        }
        $filedir_id_array = FileDB::get_filedir_listDB($filedir_id);
        if (!is_array($filedir_id_array)) {
            return false;
        }
        $filedir_id_list = implode(',', array_keys($filedir_id_array));
        $db_where = is_array($filedir_id_array) && count($filedir_id_array) > 1 ? " filedir_id IN ($filedir_id_list)" : " filedir_id=$filedir_id_list";
        $db_table = ESPCMS_DB_PREFIX . "filedir";
        $db_table_file = ESPCMS_DB_PREFIX . "file";
        $talbe_field_array = espcms_field_out($db_table_file, false);
        $array = espcms_db_list_array($db_table_file, $talbe_field_array, " AND " . $db_where, "file_id DESC");
        if (is_array($array) || count($array) > 0) {
            foreach ($array as $value) {
                $filePathName = ESPCMS_FILE_ROOT . $value['file_path'] . $value['file_filename'];
                ESPCMS_FileTool::delfile($filePathName);
            }
            espcms_db_delall($db_table_file, $db_where);
        }
        $savePath = $espcms_command['UPFILE_SAVAPATH'] ? ESPCMS_FILE_ROOT . $espcms_command['UPFILE_SAVAPATH'] : ESPCMS_FILE_ROOT . 'upfile/';
        $dir_array = espcms_db_list_array($db_table, 'filedir_id,filedir_pid,filedir_lastid,filedir_name,filedir_isdir,filedir_path,filedir_dirname', " AND " . $db_where, "filedir_id DESC");
        if (is_array($dir_array) || count($dir_array) > 0) {
            foreach ($dir_array as $value) {
                $filePathName = $savePath . $value['file_path'] . $value['filedir_path'];
                ESPCMS_FileTool::delfile($filePathName);
            }
            espcms_db_delall($db_table, $db_where);
        }
        return true;
    }
    public static function delFile() {
        $file_id = $_POST['file_id'];
        $filelist = $_POST['filelist'];
        $file_id_array = explode(',', $file_id);
        $file_array = explode(',', $filelist);
        if (!is_array($file_id_array) || count($file_id_array) <= 0 || !is_array($file_array)) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false');
        }
        $db_table = ESPCMS_DB_PREFIX . "file";
        $delcount = 0;
        foreach ($file_id_array as $key => $value) {
            if (espcms_ismatches($value)) {
                $read = espcms_db_read_field_array($db_table, "WHERE file_id=$value", array('file_path', 'file_filename'));
                if ($read) {
                    $filePathName = ESPCMS_FILE_ROOT . $read['file_path'] . $read['file_filename'];
                    ESPCMS_FileTool::delfile($filePathName);
                    $del_query = espcms_db_del($db_table, 'file_id', $value);
                    $delcount++;
                }
            }
        }
        espcms_log_install('filemanage_pack-espcms_lable_myfiledir_delfieldir', $filelist);
        espcms_public_dialog('espcms_info_save_ok', 'filemanage_pack-espcms_lable_filemanage_del_message', 'true', array($_POST['filelist']));
    }
    public static function fileManageDialogbox() {
        global $espcms_admin_templates;
        $digheight = $_GET['digheight'];
        if ($digheight > 0) {
            $digheight = $digheight - 63;
        }
        $espcms_admin_templates->into('digheight', $digheight);
        $upfileType = $_GET['upfileType'];
        $espcms_admin_templates->into('upfileType', $upfileType);
        $selectnum = $_GET['selectnum'];
        $selectnum = isset($selectnum) && espcms_ismatches($selectnum) ? intval($selectnum) : 1;
        $espcms_admin_templates->into('selectnum', $selectnum);
        $inputname = $_GET['inputname'];
        $espcms_admin_templates->into('inputname', $inputname);
        $updatediv = $_GET['updatediv'];
        $espcms_admin_templates->into('updatediv', $updatediv);
        $displaytype = $_GET['displaytype'];
        $displaytype = empty($displaytype) ? 'pic' : $displaytype;
        $espcms_admin_templates->into('displaytype', $displaytype);
        $dialog_array = array('upfileType' => $upfileType, 'selectnum' => $selectnum, 'iframes_name' => $_GET['iframes_name']);
        $espcms_admin_templates->into('upfile', SettingLink::FileManage_link_array('upfile', $dialog_array));
        $espcms_admin_templates->into('batupfile', SettingLink::FileManage_link_array('batupfile', $dialog_array));
        $espcms_admin_templates->into('photoindex', SettingLink::FileManage_link_array('photoindex', $dialog_array));
        $espcms_admin_templates->into('dirindex', SettingLink::FileManage_link_array('dirindex', $dialog_array));
        $espcms_admin_templates->into('espcms_url', ESPCMS_URL);
        $espcms_admin_templates->into('iframes_name', $_GET['iframes_name']);
        $espcms_admin_templates->output('filemanage/fileManage_upfile_dialogbox');
    }
    public static function uploadFile() {
        global $espcms_admin_templates, $espcms_command;
        $upfileType = $_GET['upfileType'];
        $espcms_admin_templates->into('upfileType', $upfileType);
        switch ($upfileType) {
            case 'image':
                $upfile_ext = $espcms_command['UPFILE_FILE_PIC_TYPE'];
                break;
            case 'mover':
                $upfile_ext = $espcms_command['UPFILE_FILE_MOVER_TYPE'];
                break;
            case 'file':
                $upfile_ext = $espcms_command['UPFILE_FILE_OTHER_TYPE'];
                break;
            default:
                $upfile_ext = $espcms_command['UPFILE_FILE_OTHER_TYPE'];
                break;
        }
        $espcms_admin_templates->into('upfile_ext', $upfile_ext);
        $php_upload_max_filesize = ini_get('file_uploads') ? intval(ini_get('upload_max_filesize')) : 2;
        $espcms_admin_templates->into('php_upload_max_filesize', $php_upload_max_filesize);
        $net_upload_max_filesize = intval($espcms_command['UPFILE_SIZE']);
        $espcms_admin_templates->into('net_upload_max_filesize', $net_upload_max_filesize);
        $chunksize = $php_upload_max_filesize > 5 ? 5 * 1024 * 1024 : $php_upload_max_filesize * 1024 * 1024;
        $espcms_admin_templates->into('chunksize', $chunksize);
        $upload_max_filesize_byte = $net_upload_max_filesize * 1024 * 1024;
        $espcms_admin_templates->into('upload_max_filesize_byte', $upload_max_filesize_byte);
        $upload_content = espcms_lan_pack('filemanage_pack-espcms_filenamage_content_str', array($upfile_ext, $php_upload_max_filesize, $net_upload_max_filesize));
        $espcms_admin_templates->into('upload_content', $upload_content);
        $selectnum = isset($_GET['selectnum']) && espcms_ismatches($_GET['selectnum']) ? $_GET['selectnum'] : 1;
        $espcms_admin_templates->into('selectnum', $selectnum);
        $tokenkey = token();
        $espcms_admin_templates->into('token', $tokenkey);
        $espcms_admin_templates->into('upfileave', SettingLink::FileManage_link_array('save'));
        $espcms_admin_templates->into('UPFILE_PIC_ISZOOM', $espcms_command['UPFILE_PIC_ISZOOM']);
        $espcms_admin_templates->into('UPFILE_ISWATERMARK', $espcms_command['UPFILE_ISWATERMARK']);
        $fileDir = FileDB::get_filedir_listDB();
        $espcms_admin_templates->into('fileDir', $fileDir);
        $windowType = $_GET['windowType'];
        $tempaltes_file = $windowType == 'bat' ? 'filemanage/fileManage_batupfile' : 'filemanage/fileManage_upfile';
        $espcms_admin_templates->output($tempaltes_file);
    }
    public static function uploadFileSave() {
        global $espcms_command;
        $fileName = $_FILES['upfilename']['name'] ? $_FILES['upfilename']['name'] : uniqid("file_");
        $fileSize = $_FILES['upfilename']['size'];
        $upFileType = empty($_POST['upFileType']) ? 'image' : $_POST['upFileType'];
        $isZoom = $_POST['isZoom'] && $upFileType == 'image' ? true : false;
        $isWater = $_POST['isWater'] && $upFileType == 'image' ? true : false;
        $chunk = isset($_REQUEST["chunk"]) ? intval($_REQUEST["chunk"]) : 0;
        $chunks = isset($_REQUEST["chunks"]) ? intval($_REQUEST["chunks"]) : 1;
        $filedir_id = $_POST['filedir_id'];
        $window_mode = $_POST['window_mode'];
        if ($window_mode == 'list' || (espcms_ismatches($filedir_id) && $filedir_id)) {
            $file_dir_read = FileDB::getFileDir($filedir_id);
            $save_dirname = $file_dir_read['filedir_path'] ? $file_dir_read['filedir_path'] . '/' : true;
        }
        $uploadFileArray = ESPCMS_FileUpload::intoFile($_FILES['upfilename'], $espcms_command, $upFileType, $isZoom, $isWater, false, $chunk, $chunks, false, $save_dirname);
        if ($chunks > 1) {
            $isFinish = ($chunk + 1) == $chunks ? true : false;
        } else {
            $isFinish = true;
        }
        if ($uploadFileArray['returnVal'] && $isFinish) {
            $db_table = ESPCMS_DB_PREFIX . "file";
            $talbe_field_array = espcms_field_out($db_table, true);
            $talbe_value = array();
            $admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
            $talbe_value['admin_member_id'] = $admin_member_id && espcms_ismatches($admin_member_id) ? $admin_member_id : 0;
            if ($window_mode == 'window' && !$filedir_id) {
                $search_path = trim($uploadFileArray['search_path'], '/');
                $filedir_id = FileDB::getSearchPathDir($search_path, 'filedir_id');
                if (!espcms_ismatches($filedir_id)) {
                    $filedir_id = FileDB::saveImportDir($search_path);
                }
            }
            $talbe_value['filedir_id'] = isset($filedir_id) && espcms_ismatches($filedir_id) ? $filedir_id : 0;
            $talbe_value['file_title'] = isset($fileName) ? addslashes($fileName) : '';
            $talbe_value['file_filename'] = $uploadFileArray['upLoadFileName_nopath'];
            $talbe_value['file_ext'] = $uploadFileArray['extension'];
            $talbe_value['file_type'] = $uploadFileArray['file_screen'];
            $talbe_value['file_path'] = $uploadFileArray['path'];
            $talbe_value['file_size'] = isset($uploadFileArray['size']) && espcms_ismatches($uploadFileArray['size']) ? $uploadFileArray['size'] : 0;
            $talbe_value['file_iswidth'] = $uploadFileArray['iswidth'];
            $talbe_value['file_addtime'] = time();
            $talbe_value['file_isclass'] = 1;
            $postvalue = espcms_post($talbe_value, $talbe_field_array, true);
            if ($postvalue) {
                $install_id = espcms_db_install_save($db_table, $postvalue);
            }
            if ($install_id && $uploadFileArray['zoomFileName'] && $uploadFileArray['zoomFileName_nopath'] && $upFileType == 'image') {
                $talbe_value['file_filename'] = $uploadFileArray['zoomFileName_nopath'];
                $talbe_value['file_size'] = isset($uploadFileArray['zoomFileSize']) && espcms_ismatches($uploadFileArray['zoomFileSize']) ? $uploadFileArray['zoomFileSize'] : 0;
                $postvalue = espcms_post($talbe_value, $talbe_field_array, true);
                if ($postvalue) {
                    espcms_db_install_save($db_table, $postvalue);
                }
            }
            $outJOSN = json_encode($uploadFileArray);
            exit($outJOSN);
        } else {
            $outJOSN = json_encode($uploadFileArray);
            exit($outJOSN);
        }
    }
    public static function uploadFileConfig() {
        global $espcms_command;
        $action = $_GET['action'] ? $_GET['action'] : 'config';
        if ($action == 'config') {
            $config_array = array();
            $config_array['fileURL'] = ESPCMS_URL;
            $config_array['fileDialog'] = SettingLink::FileManage_link_array('dialog');
            $config_array['picDialog_title'] = espcms_lan_pack('filemanage_pack-espcms_filenamage_images_dialog_title');
            $config_array['videoDialog_title'] = espcms_lan_pack('filemanage_pack-espcms_filenamage_video_dialog_title');
            $config_array['fileDialog_title'] = espcms_lan_pack('filemanage_pack-espcms_filenamage_file_dialog_title');
            $config_array['imageActionName'] = 'uploadimage';
            $config_array['imageMaxSize'] = $espcms_command['UPFILE_SIZE'] * 1000 * 1000;
            $config_array['imageFieldName'] = 'upfilename';
            $config_array['imageCompressEnable'] = 'true';
            $config_array['imageCompressBorder'] = '1600';
            $config_array['imageisWater'] = $espcms_command['UPFILE_ISWATERMARK'];
            $config_array['imageAllowFiles'] = array(".png", ".jpg", ".jpeg", ".gif", ".bmp");
            $config_array['imageUrlPrefix'] = '';
            $config_array['scrawlActionName'] = 'uploadscrawl';
            $config_array['scrawlFieldName'] = 'upfilename';
            $config_array['scrawlUrlPrefix'] = '';
            $config_array['scrawlMaxSize'] = $espcms_command['UPFILE_SIZE'] * 1000 * 1000;
            $config_array['scrawlInsertAlign'] = 'none';
            $config_array['snapscreenActionName'] = 'uploadimage';
            $config_array['snapscreenUrlPrefix'] = '';
            $result = json_encode($config_array);
            exit($result);
        }
        if ($action == 'uploadimage' || $action == 'uploadvideo' || $action == 'uploadfile' || $action == 'uploadscrawl') {
            if ($action == 'uploadscrawl') {
                $base64Data = $_POST['upfilename'];
                $imageData = base64_decode($base64Data);
                $uploadFileArray = ESPCMS_FileUpload::intoFile($imageData, $espcms_command, 'image', false, false, true);
            } else {
                $fileName = $_FILES['upfilename']['name'] ? $_FILES['upfilename']['name'] : $_FILES['upfile']['name'];
                $upFileType = empty($_POST['upFileType']) ? 'image' : $_POST['upFileType'];
                $isZoom = $_POST['isZoom'] && $upFileType == 'image' ? true : false;
                $isWater = $_POST['isWater'] && $upFileType == 'image' ? true : false;
                $filedir_id = $_POST['filedir_id'];
                $fileArray = $_FILES['upfilename'] ? $_FILES['upfilename'] : $_FILES['upfile'];
                $uploadFileArray = ESPCMS_FileUpload::intoFile($fileArray, $espcms_command, $upFileType, $isZoom, $isWater, false, 0, 1, false, false);
            }
            if ($uploadFileArray['returnVal']) {
                $db_table = ESPCMS_DB_PREFIX . "file";
                $talbe_field_array = espcms_field_out($db_table, true);
                $talbe_value = array();
                $user_id = ESPCMS_AdminAuthority::getUserLoginInfo('user_id');
                $talbe_value['user_id'] = $user_id && espcms_ismatches($user_id) ? $user_id : 0;
                $search_path = trim($uploadFileArray['search_path'], '/');
                $filedir_id = FileDB::getSearchPathDir($search_path, 'filedir_id');
                if (!espcms_ismatches($filedir_id)) {
                    $filedir_id = FileDB::saveImportDir($search_path);
                }
                $talbe_value['filedir_id'] = isset($filedir_id) && espcms_ismatches($filedir_id) ? $filedir_id : 0;
                $talbe_value['file_title'] = isset($fileName) ? addslashes($fileName) : '';
                $talbe_value['file_filename'] = $uploadFileArray['upLoadFileName_nopath'];
                $talbe_value['file_ext'] = $uploadFileArray['extension'];
                $talbe_value['file_type'] = $uploadFileArray['upfiletype'];
                $talbe_value['file_path'] = $uploadFileArray['path'];
                $talbe_value['file_size'] = isset($uploadFileArray['size']) && espcms_ismatches($uploadFileArray['size']) ? $uploadFileArray['size'] : 0;
                $talbe_value['file_iswidth'] = $uploadFileArray['iswidth'];
                $talbe_value['file_addtime'] = time();
                $talbe_value['file_isclass'] = 1;
                $postvalue = espcms_post($talbe_value, $talbe_field_array, true);
                if ($postvalue) {
                    $install_id = espcms_db_install_save($db_table, $postvalue);
                }
                if ($install_id && $uploadFileArray['zoomFileName'] && $uploadFileArray['zoomFileName_nopath'] && $upFileType == 'image') {
                    $talbe_value['file_filename'] = $uploadFileArray['zoomFileName_nopath'];
                    $talbe_value['file_size'] = isset($uploadFileArray['zoomFileSize']) && espcms_ismatches($uploadFileArray['zoomFileSize']) ? $uploadFileArray['zoomFileSize'] : 0;
                    $postvalue = espcms_post($talbe_value, $talbe_field_array, true);
                    if ($postvalue) {
                        espcms_db_install_save($db_table, $postvalue);
                    }
                }
                $outJOSN = json_encode($uploadFileArray);
                exit($outJOSN);
            } else {
                $outJOSN = json_encode($uploadFileArray);
                exit($outJOSN);
            }
        }
    }
    public static function photoIndex() {
        global $espcms_admin_templates;
        $espcms_admin_templates->into('photolist', SettingLink::FileManage_link_array('photolist'));
        $selectnum = $_GET['selectnum'];
        $espcms_admin_templates->into('selectnum', isset($selectnum) && espcms_ismatches($selectnum) ? intval($selectnum) : 1);
        $page_db = array();
        $page_db['per_page_num'] = 21;
        $page_db['sum_db'] = 0;
        $page_db['sum_page'] = 1;
        $page_db['now_page'] = 0;
        $db_where = " AND file_type='image'";
        $user_id = ESPCMS_AdminAuthority::getUserLoginInfo('user_id');
        if ($user_id && espcms_ismatches($user_id)) {
            $db_where .= " AND user_id=$user_id";
        }
        $db_table = ESPCMS_DB_PREFIX . "file";
        $page_db['sum_db'] = espcms_db_num($db_table, $db_where);
        if ($page_db['sum_db'] > 0) {
            $page_db['sum_page'] = ceil($page_db['sum_db'] / $page_db['per_page_num']);
        }
        $espcms_admin_templates->into('page_db', $page_db);
        $espcms_admin_templates->output('filemanage/fileManage_photo_index');
    }
    public static function photoList() {
        global $espcms_admin_templates, $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . "file";
        $limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
        $per_page_num = 21;
        $db_where = " AND file_type='image'";
        $user_id = ESPCMS_AdminAuthority::getUserLoginInfo('user_id');
        if ($user_id && espcms_ismatches($user_id)) {
            $db_where .= " AND user_id=$user_id";
        }
        $searchlist = $_GET['searchlist'];
        if ($searchlist == 'true') {
            $page_db = array();
            $page_db['per_page_num'] = 21;
            $page_db['sum_db'] = 0;
            $page_db['sum_page'] = 1;
            $page_db['now_page'] = 0;
            $page_db['sum_db'] = espcms_db_num($db_table, $db_where);
            if ($page_db['sum_db'] > 0) {
                $page_db['sum_page'] = ceil($page_db['sum_db'] / $page_db['per_page_num']);
            }
            exit(json_encode($page_db));
        }
        $db_sql = "SELECT * FROM $db_table WHERE 1=1 $db_where ORDER BY file_id DESC LIMIT $limit,$per_page_num";
        $db_query = $espcms_link_db->db_query($db_sql);
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $fetch_row['file_url'] = ESPCMS_URL_RT . $fetch_row['file_path'] . $fetch_row['file_filename'];
            $fetch_row['file_name'] = $fetch_row['file_path'] . $fetch_row['file_filename'];
            $fetch_row['view'] = ESPCMS_URL . $fetch_row['file_path'] . $fetch_row['file_filename'];
            $array[] = $fetch_row;
        }
        $espcms_admin_templates->into('array', $array);
        $espcms_admin_templates->output('filemanage/fileManage_photo_list');
    }
}
