<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_AdminAuthority;
use admin_application\AdminPublicDB;
use application\ESPCMS_PublicDB;
use admin_application\link\TemplatesLink;

class MoblieTemplate {

	public function __construct() {
		$exclude_method = array('saveMoblieTemplate', 'keyMoblieTemplate', 'verifyMoblieTemplate', 'selectMoblieTemplates', 'setMoblieTemplate');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function listMoblieTemplate() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "templates";
		$out_type = $_REQUEST['out_type'];
		$lng = AdminPublicDB::get_lancode();
		$db_where = " AND styleclass='sms' AND lng='$lng'";
		if ($out_type == 'list') {
			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$typeclass = $_REQUEST['typeclass'];
			if (espcms_isact($typeclass, "/^[\w]+$/i") && $typeclass) {
				$db_where .= " AND typeclass='$typeclass'";
			}
			$isclass = $_REQUEST['isclass'];
			if (espcms_ismatches($isclass)) {
				$db_where .= " AND isclass=$isclass";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('tmid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "tmid";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = TemplatesLink::MoblieTemplate_link_array('edit', $fetch_row);
				$fetch_row['type'] = 'copy';
				$fetch_row['copy'] = TemplatesLink::MoblieTemplate_link_array('edit', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'templates/sms_templates_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', TemplatesLink::MoblieTemplate_link_array(false, $_REQUEST));
			$templates = 'templates/sms_templates_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function selectMoblieTemplates() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "templates";
		$lng = AdminPublicDB::get_lancode();
		$db_where = " AND lng='$lng' AND styleclass='sms'  AND isclass=1";
		$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, 'tmid', 'DESC'));
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$array[] = $fetch_row;
		}
		$espcms_admin_templates->into('array', $array);
		$espcms_admin_templates->into('inputname', $_GET['inputname']);
		$espcms_admin_templates->into('iframes_name', $_GET['iframeName']);
		$espcms_admin_templates->output('templates/mail_templates_select');
	}

	public static function addMoblieTemplate() {
		global $espcms_admin_templates;
		$mail_key_array = ESPCMS_PublicDB::get_templates_key();
		$typeclass = array();
		if (is_array($mail_key_array)) {
			$key_i = 0;
			foreach ($mail_key_array as $key => $value) {
				$lan_name = 'espcms_templates_' . $key;
				$typeclass[$key_i]['key'] = $key;
				$typeclass[$key_i]['name'] = espcms_lan_pack('templates_pack-' . $lan_name);
				$key_i++;
			}
			$espcms_admin_templates->into('typeclass', $typeclass);
		}
		$espcms_admin_templates->into('link', TemplatesLink::MoblieTemplate_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('templates/sms_templates_add');
	}

	public static function editMoblieTemplate() {
		global $espcms_admin_templates;
		$db_table = ESPCMS_DB_PREFIX . "templates";
		$tmid = $_GET['tmid'];
		if (!$tmid || !espcms_ismatches($tmid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($tmid));
		}
		$type = $_GET['type'] ? $_GET['type'] : 'edit';
		$db_where = " WHERE tmid=$tmid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$mail_key_array = ESPCMS_PublicDB::get_templates_key();
		$typeclass = array();
		if (is_array($mail_key_array)) {
			$key_i = 0;
			foreach ($mail_key_array as $key => $value) {
				$lan_name = 'espcms_templates_' . $key;
				$typeclass[$key_i]['key'] = $key;
				$typeclass[$key_i]['selected'] = $read['typeclass'] == $key ? 'selected' : '';
				$typeclass[$key_i]['name'] = espcms_lan_pack('templates_pack-' . $lan_name);
				$key_i++;
			}
			$espcms_admin_templates->into('typeclass', $typeclass);
		}
		$espcms_admin_templates->into('lable_list', $mail_key_array[$read['typeclass']]);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', TemplatesLink::MoblieTemplate_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->into('type', $type);
		$espcms_admin_templates->output('templates/sms_templates_edit');
	}

	public static function saveMoblieTemplate() {
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "templates";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (!$_POST['templatename'] || !$_POST['templatecontent'] || !preg_match('/^[\w]+$/', $_POST['templatecode'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		if ($saveType == 'add' || $saveType == 'copy') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addMoblieTemplate')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['lng'] = AdminPublicDB::get_lancode();
			$_POST['isclass'] = 1;
			$_POST['styleclass'] = 'sms';
			$_POST['lockin'] = 0;
			$_POST['addtime'] = time();
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			espcms_log_install('templates_pack-espcms_templates_sms_button_add', $_POST['templatename']);
			espcms_public_dialog('espcms_info_save_ok', 'templates_pack-espcms_templates_mail_add_save_ok_message', 'true', array($_POST['templatename']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editMoblieTemplate')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$tmid = $_POST['tmid'];
			if (empty($tmid) || !espcms_ismatches($tmid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($tmid));
			}
			$db_where = "WHERE tmid=$tmid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($tmid));
			}
			unset($_POST['isclass'], $_POST['lockin'], $_POST['styleclass'], $_POST['lng'], $_POST['addtime']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			espcms_log_install('templates_pack-espcms_templates_sms_button_edit', $_POST['templatename']);
			espcms_public_dialog('espcms_info_save_ok', 'templates_pack-espcms_templates_mail_edit_save_ok_message', 'true', array($_POST['templatename']));
		}
	}

	public static function setMoblieTemplate() {
		if (!ESPCMS_AdminAuthority::authorityVerify('editMoblieTemplate')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "templates";
		$talbe_field_array = array('isclass');
		if (!in_array($field, $talbe_field_array)) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE tmid=$value", "$field='$field_value'");
			if ($update_key) {
				$update_count++;
			}
		}
		$set_info_id = implode(', ', $select_id);
		espcms_log_install('templates_pack-espcms_templates_sms_button_set', "$field=$field_value" . " tmid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'templates_pack-espcms_templates_mail_set_message', 'true', array($field));
	}

	public static function delMoblieTemplate() {
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delMoblieTemplateDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('templates_pack-espcms_templates_sms_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'templates_pack-espcms_templates_mail_del_message', 'true', array(), 'json', $return);
	}

	private static function delMoblieTemplateDB($tmid = 0) {
		if (!$tmid || !espcms_ismatches($tmid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $tmid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "templates";
		$del_query = espcms_db_del($db_table, 'tmid', $tmid);
		if (!$del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $tmid);
			return $return_array;
		}
		$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $tmid);
		return $return_array;
	}

	public static function keyMoblieTemplate() {
		$label = $_GET['label'];
		if (!preg_match('/^[\w]+$/', $label)) {
			return false;
		}
		$mail_key_array = ESPCMS_PublicDB::get_templates_key($label);
		$lable_list = '';
		if (is_array($mail_key_array)) {
			$key_i = 0;
			foreach ($mail_key_array as $key => $value) {
				$lable_list .= '<li data-key="' . $value['title'] . '" class="lable_key_click" title="' . $value['name'] . '"><button type="button" class="btn btn-addblue min-w-150 btn-xs"><i class="espcms_icon_fa espcms_icon_fa-tag"></i>' . $value['name'] . '</button></li>';
			}
		}
		exit($lable_list);
	}

	public static function verifyMoblieTemplate() {
		$verifyKey = $_REQUEST['verify_key'];
		$verifyValue = $_REQUEST['verify_value'];
		$verifyType = $_REQUEST['verifyType'];
		$typeclass = $_REQUEST['typeclass'];
		$tmid = intval($_REQUEST['tmid']);
		$db_num = self::verifyMoblieTemplateDB($verifyKey, $verifyValue, $typeclass, $tmid, $verifyType) ? '1' : '0';
		exit($db_num);
	}

	private static function verifyMoblieTemplateDB($verifyKey, $verifyValue, $typeclass = false, $tmid = 0, $verifyType = false) {
		if (!espcms_ismatches($tmid) || !preg_match('/^[\w]+$/', $typeclass)) {
			return true;
		}
		$field_array = array('templatecode');
		if (!isset($verifyKey) && !in_array($verifyKey, $field_array)) {
			return true;
		}
		if (!$verifyValue) {
			return true;
		}
		$db_table = ESPCMS_DB_PREFIX . "templates";
		$lng = AdminPublicDB::get_lancode();
		$db_where .= " AND styleclass='sms' AND lng='$lng'";
		if (empty($tmid) || !espcms_ismatches($tmid)) {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue' AND typeclass='$typeclass'" : " AND $verifyKey='$verifyValue' AND typeclass='$typeclass'";
		} else {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue' AND typeclass='$typeclass' AND tmid!=$tmid" : " AND $verifyKey='$verifyValue' AND typeclass='$typeclass' AND tmid!=$tmid";
		}
		$db_num = espcms_db_num($db_table, $db_where);
		return $db_num > 0 ? true : false;
	}

}
