<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/




use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_OrderDB;
use admin_application\link\OrderLink;

class OrderFinance {

	public function __construct() {
		global $module_array;
		$exclude_method = array('saveOrderFinance', 'viewOrderFinance');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		if (!$order_app_config['isetup']) {
			espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
		}
	}
	public static function listOrderFinance() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "order_payreceipt";
		$out_type = $_REQUEST['out_type'];
		$oid = $_REQUEST['oid'];
		if (espcms_ismatches($oid) && $oid) {
			$db_where .= " AND oid=$oid";
		}
		if ($out_type == 'list') {
			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$paytype = $_REQUEST['paytype'];
			if (espcms_ismatches($paytype)) {
				$db_where .= " AND paytype=$paytype";
			}
			$payclass = $_REQUEST['payclass'];
			if (espcms_ismatches($payclass)) {
				$db_where .= " AND payclass=$payclass";
			}
			$search_keyname_array = array('paysn');
			$search_keyname = $_REQUEST['search_keyname'] && in_array($_REQUEST['search_keyname'], $search_keyname_array) ? $_REQUEST['search_keyname'] : 'paysn';
			$search_key = $_REQUEST['search_key'];
			if (isset($search_key) && !empty($search_key)) {
				$search_key = urldecode($search_key);
				$db_where .= " AND $search_keyname LIKE '%$search_key%'";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('oprid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "oprid";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$order_read = ESPCMS_OrderDB::get_order_view($fetch_row['oid']);
				$fetch_row['ordersn'] = $order_read['ordersn'];
				$fetch_row['islock'] = $order_read['islock'];
				$fetch_row['username'] = ESPCMS_MemberDB::get_member_noatt_view($fetch_row['userid'], 'username');
				$fetch_row['edit'] = OrderLink::OrderFinance_link_array('edit', $fetch_row);
				$fetch_row['view'] = OrderLink::OrderFinance_link_array('view', $fetch_row);
				$fetch_row['vieworder'] = OrderLink::Order_link_array('view', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'order/order_finance_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', OrderLink::OrderFinance_link_array(false, $_REQUEST));
			$templates = 'order/order_finance_index';
		}
		$espcms_admin_templates->output($templates);
	}
	public static function addOrderFinance() {
		global $espcms_admin_templates;
		$oid = $_GET['oid'];
		if (!$oid || !espcms_ismatches($oid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($oid));
		}
		$read = ESPCMS_OrderDB::get_order_view($oid);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($oid));
		}
		if ($read['userid'] && espcms_ismatches($read['userid'])) {
			$user_read = ESPCMS_MemberDB::get_member_noatt_view($read['userid']);
			if (!$user_read) {
				espcms_message_err('db_pack-espcms_db_read_fail', array($read['userid']));
			}
			$espcms_admin_templates->into('user_read', $user_read);
		}
		$pay_list = ESPCMS_OrderDB::get_pay_plug_list();
		$espcms_admin_templates->into('pay_list', $pay_list);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', OrderLink::OrderFinance_link_array());
		$espcms_admin_templates->into('token', token());
		$tempates = $read['ispay'] == 0 ? 'order/order_finance_add' : 'order/order_finance_refund_add';
		$espcms_admin_templates->output($tempates);
	}
	public static function editOrderFinance() {
		global $espcms_admin_templates;
		$oprid = $_GET['oprid'];
		if (!$oprid || !espcms_ismatches($oprid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($oprid));
		}
		$db_where = "WHERE oprid=$oprid";
		$db_table = ESPCMS_DB_PREFIX . 'order_payreceipt';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		$oid = $read_info['oid'];
		if (!$oid || !espcms_ismatches($oid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($oid));
		}
		$read = ESPCMS_OrderDB::get_order_view($oid);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($oid));
		}
		if ($read_info['userid'] && espcms_ismatches($read_info['userid'])) {
			$user_read = ESPCMS_MemberDB::get_member_noatt_view($read_info['userid']);
			if (!$user_read) {
				espcms_message_err('db_pack-espcms_db_read_fail', array($read_info['userid']));
			}
			$espcms_admin_templates->into('user_read', $user_read);
		}
		$pay_list = ESPCMS_OrderDB::get_pay_plug_list($read_info['opid']);
		$espcms_admin_templates->into('pay_list', $pay_list);
		$espcms_admin_templates->into('read_info', $read_info);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', OrderLink::OrderFinance_link_array());
		$espcms_admin_templates->into('token', token());
		$tempates = $read_info['payclass'] == 2 ? 'order/order_finance_refund_edit' : 'order/order_finance_edit';
		$espcms_admin_templates->output($tempates);
	}
	public static function viewOrderFinance() {
		global $espcms_admin_templates;
		$oprid = $_GET['oprid'];
		if (!$oprid || !espcms_ismatches($oprid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($oprid));
		}
		$db_where = "WHERE oprid=$oprid";
		$db_table = ESPCMS_DB_PREFIX . 'order_payreceipt';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		$oid = $read_info['oid'];
		if (!$oid || !espcms_ismatches($oid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($oid));
		}
		$read = ESPCMS_OrderDB::get_order_view($oid);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($oid));
		}
		if ($read_info['userid'] && espcms_ismatches($read_info['userid'])) {
			$user_read = ESPCMS_MemberDB::get_member_noatt_view($read_info['userid']);
			if (!$user_read) {
				espcms_message_err('db_pack-espcms_db_read_fail', array($read_info['userid']));
			}
			$espcms_admin_templates->into('user_read', $user_read);
		}
		$read_info['payname'] = ESPCMS_OrderDB::get_pay_plug_view($read_info['opid'], 'payname');
		$espcms_admin_templates->into('read_info', $read_info);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', OrderLink::OrderFinance_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('order/order_finance_view');
	}
	public static function saveOrderFinance() {
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "order_payreceipt";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (!espcms_ismatches($_POST['oid']) || !$_POST['oid']) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		$read = ESPCMS_OrderDB::get_order_view($_POST['oid']);
		if (!$read) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		$_POST['userid'] = $read['userid'];
		if (!espcms_ismatches($_POST['userid'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		if (!espcms_ismoney($_POST['payamount']) || espcms_ismoney($_POST['payamount']) > $read['orderamount']) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		$_POST['paytime'] = espcms_isdata($_POST['paytime']) ? strtotime($_POST['paytime']) : 0;
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addOrderFinance')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['payclass'] = $read['ispay'] == 0 ? 1 : 2;
			if ($_POST['payclass'] == 2) {
				$_POST['opid'] = 0;
				$_POST['paytype'] = 0;
			} else {
				$_POST['opid'] = $_POST['paytype'] ? $_POST['opid'] : 0;
				if (!espcms_ismatches($_POST['opid']) || !espcms_ismatches($_POST['paytype'])) {
					espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
				}
			}
			$_POST['addtime'] = time();
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			if ($_POST['payclass'] === 2) {
				$update_post['ordertype'] = 2;
				$update_post['ispay'] = 2;
				ESPCMS_OrderDB::order_update_type($_POST['oid'], $update_post);
				espcms_log_install('order_pack-espcms_order_button_add_payreceipt2', $read['ordersn']);
				espcms_public_dialog('espcms_info_save_ok', 'order_pack-espcms_order_payreceipt_add_save_ok_message2', 'true', array($read['ordersn']));
			}
			if ($_POST['payclass'] === 1) {
				$update_post['ordertype'] = 2;
				$update_post['ispay'] = 1;
				$update_post['opid'] = $_POST['opid'];
				$update_post['paysn'] = $_POST['paysn'];
				$update_post['paytime'] = $_POST['paytime'];
				ESPCMS_OrderDB::order_update_type($_POST['oid'], $update_post);
				espcms_log_install('order_pack-espcms_order_button_add_payreceipt', $read['ordersn']);
				espcms_public_dialog('espcms_info_save_ok', 'order_pack-espcms_order_payreceipt_add_save_ok_message', 'true', array($read['ordersn']));
			}
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editOrderFinance')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$oprid = $_POST['oprid'];
			if (empty($oprid) || !espcms_ismatches($oprid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($oprid));
			}
			$db_where = "WHERE oprid=$oprid";
			$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read_info) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($oprid));
			}
			if ($read_info['payclass'] == 2) {
				$_POST['opid'] = 0;
				$_POST['paytype'] = 0;
			} else {
				$_POST['opid'] = $_POST['paytype'] ? $_POST['opid'] : 0;
				if (!espcms_ismatches($_POST['opid']) || !espcms_ismatches($_POST['paytype'])) {
					espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
				}
			}
			unset($_POST['userid'], $_POST['oid'], $_POST['payclass'], $_POST['addtime']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			espcms_log_install('order_pack-espcms_order_button_edit_payreceipt', $read['ordersn']);
			espcms_public_dialog('espcms_info_save_ok', 'order_pack-espcms_order_payreceipt_edit_save_ok_message', 'true', array($read['ordersn']));
		}
	}
	public static function delOrderFinance() {
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delOrderFinanceDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('order_pack-espcms_order_payreceipt_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'order_pack-espcms_order_payreceipt_del_message', 'true', array(), 'json', $return);
	}
	private static function delOrderFinanceDB($oprid = 0) {
		if (!$oprid || !espcms_ismatches($oprid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $oprid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "order_payreceipt";
		$del_query = espcms_db_del($db_table, 'oprid', $oprid);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $oprid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $oprid);
			return $return_array;
		}
	}

}
