<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/
use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use application\ESPCMS_PY;
use modul_application\ESPCMS_MemberDB;
use admin_application\ArticleModelDB;
use admin_application\ArticleTypeDB;
use admin_application\AdminPublicDB;
use application\ESPCMS_PublicDB;
use admin_application\link\ArticleLink;
use admin_application\link\SettingLink;
use admin_application\link\TemplatesLink;
class SpecialCatalog {
    private static $document_subjectlist_list_cache_key;
    private static $document_subjectlist_read_cache_key;
    public function __construct() {
        $exclude_method = array('saveSpecialCatalog', 'setSpecialCatalog', 'sortSpecialCatalog', 'verifySpecialCatalog');
        ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
        self::$document_subjectlist_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'document_subjectlist_';
        self::$document_subjectlist_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'document_subjectlist_';
    }
    public static function listSpecialCatalog() {
        global $espcms_admin_templates, $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . "document_subjectlist";
        $admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
        if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
        }
        $out_type = $_REQUEST['out_type'];
        $lng = AdminPublicDB::get_lancode();
        $db_where = " AND lng='$lng'";
        if ($out_type == 'list') {
            $limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
            $per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
            $mid = $_REQUEST['mid'];
            if (espcms_ismatches($mid) && $mid) {
                $db_where .= " AND mid=$mid";
            }
            $isclass = $_REQUEST['isclass'];
            if (espcms_ismatches($isclass)) {
                $db_where .= " AND isclass=$isclass";
            }
            $isdir = $_REQUEST['isdir'];
            if (espcms_ismatches($isdir)) {
                $db_where .= " AND isdir=$isdir";
            }
            $styleid = $_REQUEST['styleid'];
            if (espcms_ismatches($styleid)) {
                $db_where .= " AND styleid=$styleid";
            }
            $ishtml = $_REQUEST['ishtml'];
            if (espcms_ismatches($ishtml)) {
                $db_where .= " AND ishtml=$ishtml";
            }
            $iswap = $_REQUEST['iswap'];
            if (espcms_ismatches($iswap)) {
                $db_where .= " AND iswap=$iswap";
            }
            $searchlist = $_GET['searchlist'];
            if ($searchlist == 'true') {
                exit(espcms_page_db($db_table, $db_where, true));
            }
            $sort_key = $_REQUEST['sort_key'];
            $sort_key_array = array('sid', 'pid', 'mid');
            if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
                $order_key = $sort_key;
            } else {
                $order_key = "sid";
            }
            $sort_rank = $_REQUEST['sort_rank'];
            $sort_rank_array = array('ASC', 'DESC');
            if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
                $order_rank = $sort_rank;
            } else {
                $order_rank = "DESC";
            }
            $db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
            while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
                $fetch_row['view'] = ArticleLink::Article_Main_link_array('index', $fetch_row);
                $fetch_row['edit'] = ArticleLink::SpecialCatalog_link_array('edit', $fetch_row);
                $fetch_row['modelname'] = ArticleModelDB::get_mid_view($fetch_row['mid'], 'modelname');
                $array[] = $fetch_row;
            }
            $espcms_admin_templates->into('array', $array);
            $templates = 'article/special_catalog_list';
        } else {
            $espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
            $espcms_admin_templates->into('link', ArticleLink::SpecialCatalog_link_array(false, $_REQUEST));
            $templates = 'article/special_catalog_index';
        }
        $espcms_admin_templates->output($templates);
    }
    public static function addSpecialCatalog() {
        global $espcms_admin_templates, $espcms_command;
        $admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
        if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
        }
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if ($member_app_config['isetup']) {
            $member_class_list = ESPCMS_MemberDB::get_member_class_list();
            $espcms_admin_templates->into('member_class_list', $member_class_list);
        }
        $espcms_admin_templates->into('is_html', $espcms_command['IS_HTML'] ? 1 : 0);
        $espcms_admin_templates->into('member_app_config', $member_app_config);
        $espcms_admin_templates->into('link', ArticleLink::SpecialCatalog_link_array());
        $espcms_admin_templates->into('read_mid', ArticleLink::ArticleModel_link_array('read'));
        $espcms_admin_templates->into('model_list', ArticleModelDB::get_model_list(0, false, 0));
        $espcms_admin_templates->into('page_style', ESPCMS_PublicDB::get_suburlist_style());
        $espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
        $espcms_admin_templates->into('key_select_link', ArticleLink::KeywordsOptimization_link_array('select'));
        $espcms_admin_templates->into('keygroups_select_link', ArticleLink::KeywordsGroups_link_array('select'));
        $espcms_admin_templates->into('templates_select', TemplatesLink::TemplateFile_link_array('select'));
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('article/special_catalog_add');
    }
    public static function editSpecialCatalog() {
        global $espcms_admin_templates;
        $sid = $_GET['sid'];
        if (!$sid || !espcms_ismatches($sid)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($sid));
        }
        $db_table = ESPCMS_DB_PREFIX . "document_subjectlist";
        $db_where = " WHERE sid=$sid";
        $talbe_field_array = espcms_field_out($db_table, false);
        $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
        }
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if ($member_app_config['isetup']) {
            $member_class_list = ESPCMS_MemberDB::get_member_class_list($read['purview']);
            $espcms_admin_templates->into('member_class_list', $member_class_list);
        }
        $espcms_admin_templates->into('read', $read);
        $espcms_admin_templates->into('member_app_config', $member_app_config);
        $espcms_admin_templates->into('link', ArticleLink::SpecialCatalog_link_array());
        $espcms_admin_templates->into('purview_array', $read['purview'] && preg_match("/^[\d]+[\d,]*$/i", $read['purview']) ? explode(',', $read['purview']) : array());
        $espcms_admin_templates->into('model_read', ArticleModelDB::get_mid_view($read['mid']));
        $espcms_admin_templates->into('read_mid', ArticleLink::ArticleModel_link_array('read'));
        $espcms_admin_templates->into('page_style', ESPCMS_PublicDB::get_suburlist_style($read['filenamestyle']));
        $espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
        $espcms_admin_templates->into('key_select_link', ArticleLink::KeywordsOptimization_link_array('select'));
        $espcms_admin_templates->into('keygroups_select_link', ArticleLink::KeywordsGroups_link_array('select'));
        $espcms_admin_templates->into('templates_select', TemplatesLink::TemplateFile_link_array('select'));
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('article/special_catalog_edit');
    }
    public static function saveSpecialCatalog() {
        global $espcms_db_cache;
        if (!is_token($_POST['token_name'], $_POST['token_key'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
        }
        $saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
        $db_table = ESPCMS_DB_PREFIX . "document_subjectlist";
        $talbe_field_array = espcms_field_out($db_table, true);
        if (!espcms_ismatches($_POST['isdir']) || !espcms_ismatches($_POST['styleid']) || !espcms_ismatches($_POST['ishtml']) || !espcms_ismatches($_POST['pagemax']) || !$_POST['subjectname']) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
        }
        $_POST['purview'] = !espcms_array_ismatches($_POST['purview']) ? 0 : implode(',', $_POST['purview']);
        if ($saveType == 'add') {
            if (!ESPCMS_AdminAuthority::authorityVerify('addSpecialCatalog')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            if (!espcms_ismatches($_POST['mid']) || empty($_POST['mid'])) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            if (espcms_ismatches($_POST['isdir']) && $_POST['isdir']) {
                $dirname = ESPCMS_PY::getFullSpell($_POST['subjectname'], '_');
                $_POST['dirname'] = !self::verifySpecialCatalogDB('dirname', $dirname) ? $dirname : $dirname . '_' . time();
            } elseif (!$_POST['isdir'] && !preg_match("/^[\w]+/", $_POST['dirname'])) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            } elseif (!$_POST['isdir'] && preg_match("/^[\w]+/", $_POST['dirname']) && self::verifySpecialCatalogDB('dirname', $_POST['dirname'])) {
                espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_dirname_warning_msg', 'false');
            }
            $_POST['lng'] = AdminPublicDB::get_lancode();
            $pid = ArticleTypeDB::lastPidSpecialCatalog($_POST['lng'], 'pid');
            $_POST['pid'] = $pid ? $pid + 1 : 1;
            $_POST['addtime'] = time();
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $espcms_db_cache->cacheDEL(self::$document_subjectlist_list_cache_key . $_POST['lng'], true);
            espcms_log_install('article_pack-espcms_special_catalog_button_add', $_POST['subjectname']);
            espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_special_catalog_add_save_ok_message', 'true', array($_POST['subjectname']));
        } elseif ($saveType == 'edit') {
            if (!ESPCMS_AdminAuthority::authorityVerify('editSpecialCatalog')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            $sid = $_POST['sid'];
            if (empty($sid) || !espcms_ismatches($sid)) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($sid));
            }
            $db_where = "WHERE sid=$sid";
            $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($sid));
            }
            unset($_POST['mid']);
            if (!$_POST['isdir'] && !preg_match("/^[\w]+/", $_POST['dirname'])) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            } elseif ($read['dirname'] != $_POST['dirname'] && !$_POST['isdir'] && preg_match("/^[\w]+/", $_POST['dirname']) && self::verifySpecialCatalogDB('dirname', $_POST['dirname'], $sid)) {
                espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_dirname_warning_msg', 'false');
            } elseif ((espcms_ismatches($_POST['isdir']) && $_POST['isdir'] && $read['subjectname'] != $_POST['subjectname']) || (!$read['isdir'] && $_POST['isdir'])) {
                $dirname = ESPCMS_PY::getFullSpell($_POST['subjectname'], '_');
                $_POST['dirname'] = !self::verifySpecialCatalogDB('dirname', $dirname, $sid) ? $dirname : $dirname . '_' . time();
            }
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
            if (!$update_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $espcms_db_cache->cacheDEL(self::$document_subjectlist_read_cache_key . $sid);
            $espcms_db_cache->cacheDEL(self::$document_subjectlist_list_cache_key . $read['lng'], true);
            espcms_log_install('article_pack-espcms_special_catalog_button_edit', $_POST['subjectname']);
            espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_special_catalog_edit_save_ok_message', 'true', array($_POST['subjectname']));
        }
    }
    public static function setSpecialCatalog() {
        global $espcms_db_cache;
        if (!ESPCMS_AdminAuthority::authorityVerify('editSpecialCatalog')) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
        }
        $lng = AdminPublicDB::get_lancode();
        $select_id = $_POST['select_id'];
        $field = $_POST['field'];
        $field_value = $_POST['field_value'];
        if (!is_array($select_id) || count($select_id) <= 0) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
        }
        if (!$field || !espcms_ismatches($field_value)) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
        }
        $db_table = ESPCMS_DB_PREFIX . "document_subjectlist";
        $talbe_field_array = espcms_field_out($db_table, true);
        $isavlue = false;
        foreach ($talbe_field_array as $key => $value) {
            if ($value['Field'] == $field) {
                $isavlue = true;
            }
        }
        if (!$isavlue) {
            espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
        }
        $update_count = 0;
        foreach ($select_id as $key => $value) {
            if (!espcms_ismatches($value)) {
                continue;
            }
            $update_key = espcms_db_update_set_save($db_table, "WHERE sid=$value", "$field='$field_value'");
            if ($update_key) {
                $update_count++;
                $espcms_db_cache->cacheDEL(self::$document_subjectlist_read_cache_key . $value);
            }
        }
        $set_info_id = implode(', ', $select_id);
        $espcms_db_cache->cacheDEL(self::$document_subjectlist_list_cache_key . $lng, true);
        espcms_log_install('article_pack-espcms_special_catalog_button_set', "$field=$field_value" . " sid=" . $set_info_id);
        espcms_public_dialog('info_set_ok', 'article_pack-espcms_special_catalog_set_message', 'true', array($field));
    }
    public static function delSpecialCatalog() {
        global $espcms_db_cache;
        $lng = AdminPublicDB::get_lancode();
        $select_id = $_POST['select_id'];
        if (!is_array($select_id) || count($select_id) <= 0) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
        }
        $delcount = 0;
        foreach ($select_id as $value) {
            $operate_result = self::delSpecialCatalogDB($value);
            if ($operate_result['code'] == 'true') {
                $delcount++;
            }
        }
        $espcms_del_id = implode(', ', $select_id);
        espcms_log_install('article_pack-espcms_special_catalog_button_del', $espcms_del_id);
        $return['count'] = $delcount;
        $espcms_db_cache->cacheDEL(self::$document_subjectlist_list_cache_key . $lng, true);
        espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_special_catalog_del_message', 'true', array(), 'json', $return);
    }
    private static function delSpecialCatalogDB($sid = 0) {
        global $espcms_db_cache;
        if (!$sid || !espcms_ismatches($sid)) {
            $return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $sid);
            return $return_array;
        }
        $db_table = ESPCMS_DB_PREFIX . "document_subjectlist";
        $del_query = espcms_db_del($db_table, 'sid', $sid);
        if ($del_query) {
            $espcms_db_cache->cacheDEL(self::$document_subjectlist_read_cache_key . $sid);
            $return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $sid);
            return $return_array;
        } else {
            $return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $sid);
            return $return_array;
        }
    }
    public static function sortSpecialCatalog() {
        global $espcms_db_cache;
        if (!ESPCMS_AdminAuthority::authorityVerify('editSpecialCatalog')) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
        }
        $lng = AdminPublicDB::get_lancode();
        $aid_array = $_POST['id_array'];
        if (!is_array($aid_array) || count($aid_array) <= 0) {
            exit('false');
        }
        $db_table = ESPCMS_DB_PREFIX . "document_subjectlist";
        foreach ($aid_array as $key => $value) {
            $pid = $key;
            if (espcms_ismatches($pid) && espcms_ismatches($value) && $value) {
                espcms_db_update_set_save($db_table, "WHERE sid=$value", "pid=$pid");
            }
        }
        $espcms_db_cache->cacheDEL(self::$document_subjectlist_list_cache_key . $lng, true);
        espcms_log_install('article_pack-espcms_special_catalog_button_sort', 'sid=' . $value);
        exit('true');
    }
    public static function verifySpecialCatalog() {
        $verifyKey = $_REQUEST['verify_key'];
        $verifyValue = $_REQUEST['verify_value'];
        $verifyType = $_REQUEST['verifyType'];
        $sid = $_REQUEST['sid'];
        $db_num = self::verifySpecialCatalogDB($verifyKey, $verifyValue, $sid, $verifyType) ? '1' : '0';
        exit($db_num);
    }
    private static function verifySpecialCatalogDB($verifyKey, $verifyValue, $sid = 0, $verifyType = false) {
        $field_array = array('dirname');
        if (!isset($verifyKey) && !in_array($verifyKey, $field_array)) {
            return true;
        }
        $lng = AdminPublicDB::get_lancode();
        $db_table = ESPCMS_DB_PREFIX . "document_subjectlist";
        $db_table_document_typelist = ESPCMS_DB_PREFIX . "document_typelist";
        $db_where = " AND lng='$lng'";
        $type_db_num = espcms_db_num($db_table_document_typelist, " AND lng='$lng' AND dirname='$verifyValue'");
        if ($type_db_num > 0) {
            return true;
        }
        if (empty($sid) || !espcms_ismatches($sid)) {
            $db_where .= $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
        } else {
            $db_where .= $verifyType ? " AND $verifyKey!='$verifyValue' AND sid!=$sid" : " AND $verifyKey='$verifyValue' AND sid!=$sid";
        }
        $db_num = espcms_db_num($db_table, $db_where);
        return $db_num > 0 ? true : false;
    }
}
