<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/
namespace admin_application;
class ApplyDB {
	public static function get_apply_list($typeclass = false, $isdb = 1) {
		$db_where = " AND isetup=1";
		if ($isdb && espcms_ismatches($isdb)) {
			$db_where .= " AND isdb=$isdb";
		}
		$db_table = ESPCMS_DB_PREFIX . 'apply';
		$talbe_field_array = espcms_field_out($db_table, false);
		$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "appid DESC");
		if (!is_array($array) || count($array) < 1) {
			return array();
		}
		foreach ($array as $key => $value) {
			if ($typeclass == $value['applycode']) {
				$array[$key]['selected'] = 'selected';
			}
		}
		return $array;
	}
	public static function save_apply($applycode = false, $postdb = array()) {
		global $espcms_db_cache;
		if (!$applycode || !preg_match('/^[\w]+$/', $applycode) || !is_array($postdb) || count($postdb) < 1) {
			return false;
		}
		$update_key = array();
		$db_table = ESPCMS_DB_PREFIX . "apply";
		$db_where = "WHERE applycode='$applycode'";
		$update_key['appconfig'] = serialize($postdb);
		$talbe_field_array = espcms_field_out($db_table, true);
		$postvalue = espcms_post($update_key, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			return false;
		}
		$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
		if (!$update_id) {
			return false;
		}
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $applycode;
		$espcms_db_cache->cacheDEL($cache_key, true);
		return $update_id;
	}
	public static function get_apply_read($applycode = false, $return_key = false) {
		if (!$applycode || !preg_match('/^[\w]+$/', $applycode)) {
			return false;
		}
		$db_where = "WHERE applycode='$applycode'";
		$db_table = ESPCMS_DB_PREFIX . 'apply';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}
	public static function install_save_apply($install_db = array()) {
		if (empty($install_db['app_market_id']) || !espcms_ismatches($install_db['app_market_id']) || !is_array($install_db)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "apply";
		$talbe_field_array = espcms_field_out($db_table, true);
		$install_db['volsn'] = espcms_ismatches($install_db['vol']) ? $install_db['vol'] : 0;
		$install_db['uservol'] = espcms_ismatches($install_db['uservol']) ? $install_db['uservol'] : 0;
		$install_db['addtime'] = time();
		$install_db['setuptime'] = time();
		$install_db['isdel'] = 0;
		$install_db['isetup'] = 1;
		$install_db['isopen'] = 1;
		$install_db['isdb'] = $install_db['issqlbak'] && espcms_ismatches($install_db['issqlbak']) ? $install_db['issqlbak'] : 0;
		$install_db['isset'] = $install_db['isset'] && espcms_ismatches($install_db['isset']) ? $install_db['isset'] : 0;
		$postvalue = espcms_post($install_db, $talbe_field_array, true);
		if ($postvalue) {
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				return false;
			}
		} else {
			return false;
		}
		return $install_id;
	}
}
