<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


namespace admin_application;

use application\ESPCMS_AdminAuthority;
use admin_application\ArticleModelDB;

class ArticleMainDB {

	public static function lastPidArticle($lng = false, $return_key = false) {
		$db_where = "WHERE lng='$lng' ORDER BY pid DESC LIMIT 0,1";
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_article_view($did = 0, $return_key = false) {
		if (!$did || !espcms_ismatches($did)) {
			return false;
		}
		$db_where = "WHERE did=$did";
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_article_list($did) {
		if (!espcms_islongfig($did)) {
			return false;
		}
		$db_where .= espcms_ismatches($did) ? " AND did=$did" : " AND did IN($did)";
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$talbe_field_array = espcms_field_out($db_table, false);
		$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "did DESC");
		if (!is_array($array) || count($array) < 1) {
			return array();
		}
		return $array;
	}

	public static function article_base_save($tid, $postdb = array()) {
		if (!espcms_ismatches($tid) || empty($tid) || !is_array($postdb) || count($postdb) < 1) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "document";
		$talbe_field_array = espcms_field_out($db_table, true);
		$postdb['title'] = $postdb['typename'];
		$postdb['tid'] = $tid;
		$postdb['pic'] = $postdb['typepic'];
		$postdb['isbase'] = 1;
		$postdb['summary'] = $postdb['content'];
		$postdb['aid'] = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		$postvalue = espcms_post($postdb, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			return false;
		}
		$install_id = espcms_db_install_save($db_table, $postvalue);
		if (!$install_id) {
			return false;
		}
		return $install_id;
	}

	public static function get_article_content_view($did = 0, $return_key = false) {
		if (!$did || !espcms_ismatches($did)) {
			return false;
		}
		$db_where = "WHERE did=$did";
		$db_table = ESPCMS_DB_PREFIX . 'document_content';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function article_install_content($did, $postdb = array(), $is_update = false) {
		if (!espcms_ismatches($did) || empty($did) || !is_array($postdb) || count($postdb) < 1) {
			return false;
		}
		if (!$is_update) {
			$postdb['did'] = $did;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_content";
		$talbe_field_array = espcms_field_out($db_table, true);
		$postvalue = espcms_post($postdb, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			return false;
		}
		if (!$is_update) {
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				return false;
			}
			return $install_id;
		}
		if ($is_update) {
			$dcid = self::get_article_content_view($did, 'dcid');
			if (!$dcid) {
				$install_id = espcms_db_install_save($db_table, $postvalue);
				if (!$install_id) {
					return false;
				}
				return $install_id;
			} else {
				$db_where = "WHERE did=$did";
				$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
				if (!$update_id) {
					return false;
				}
				return $update_id;
			}
		}
	}

	public static function article_install_document_album($did, $postdb = array(), $is_del = false) {
		if (!espcms_ismatches($did) || empty($did) || !is_array($postdb) || count($postdb) < 1) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_album";
		if ($is_del) {
			espcms_db_delall($db_table, "did=$did");
		}
		if (!is_array($postdb['picfile']) || count($postdb['picfile']) < 1) {
			return false;
		}
		$talbe_field_array = espcms_field_out($db_table, true);
		$album_install_array = array();
		foreach ($postdb['picfile'] as $key => $value) {
			$install_post['did'] = $did;
			$install_post['picname'] = $postdb['picname'][$key] ? $postdb['picname'][$key] : '';
			$install_post['filedes'] = $postdb['filedes'][$key] ? $postdb['filedes'][$key] : '';
			$install_post['picfile'] = $value;
			$install_post['addtime'] = time();
			$album_install_array[] = espcms_post($install_post, $talbe_field_array, true, true);
		}
		if (is_array($album_install_array)) {
			$install_id = espcms_db_install_array_save($db_table, $album_install_array);
		} else {
			$install_id = false;
		}
		return $install_id;
	}

	public static function article_install_document_attr($mid, $did, $postdb = array(), $is_update = false) {
		if (!espcms_ismatches($mid) || empty($mid) || !espcms_ismatches($did) || empty($did) || !is_array($postdb) || count($postdb) < 1) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_attr";
		$talbe_field_array = espcms_field_out($db_table, true);
		$model_att_array = ArticleModelDB::get_document_model_att_list($mid);
		$model_key_type = is_array($model_att_array) ? espcms_array_keytokey($model_att_array, 'attrname', 'inputtype') : array();
		if (is_array($model_key_type)) {
			foreach ($model_key_type as $key => $value) {
				if ($value == 'checkbox') {
					$postdb[$key] = $postdb[$key] ? $postdb[$key] : '';
				}
			}
		}
		foreach ($postdb as $key => $value) {
			if ($model_key_type[$key] == 'checkbox') {
				$postdb[$key] = is_array($value) ? implode(',', $value) : '';
			}
			if ($model_key_type[$key] == 'date' || $model_key_type[$key] == 'time' || $model_key_type[$key] == 'datetime') {
				$postdb[$key] = espcms_istime($value) || espcms_isdata($value) || preg_match("/^[\d]{1,2}:[\d]{1,2}$/i", $value) ? strtotime($value) : 0;
			}
			if ($model_key_type[$key] == 'int') {
				$postdb[$key] = espcms_ismatches($value) ? $value : 0;
			}
			if ($model_key_type[$key] == 'float' || $model_key_type[$key] == 'decimal') {
				$postdb[$key] = preg_match("/^[0-9.]+$/i", $value) ? $value : 0;
			}
			if ($model_key_type[$key] == 'editor') {
				$postdb[$key] = $value ? htmlspecialchars($value) : '';
			}
		}
		if (!$is_update) {
			$postdb['did'] = $did;
		}
		$postvalue = espcms_post($postdb, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			return false;
		}
		if (!$is_update) {
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				return false;
			}
			return $install_id;
		}
		if ($is_update) {
			$db_where = "WHERE did=$did";
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				return false;
			}
			return $update_id;
		}
	}

}
