<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

namespace admin_application;
class ArticleModelDB {
    public static function get_model_list($mid = 0, $isclass = false, $isbase = false) {
        global $espcms_db_cache;
        if (espcms_ismatches($isclass)) {
            $db_where = " AND isclass=$isclass";
        }
        if (espcms_ismatches($isbase)) {
            $db_where .= " AND isbase=$isbase";
        }
        $db_table = ESPCMS_DB_PREFIX . 'document_model';
        $cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $isclass . '_' . $isbase;
        $array = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!is_array($array) || !count($array) > 0) {
            $talbe_field_array = espcms_field_out($db_table, false);
            $array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "mid");
            if (!is_array($array) || count($array) < 1) {
                return array();
            }
            $espcms_db_cache->cacheSave($cache_key, $array);
        }
        foreach ($array as $key => $value) {
            if ($mid == $value['mid']) {
                $array[$key]['selected'] = 'selected';
            }
        }
        return $array;
    }

    public static function get_mid_view($mid = 0, $return_key = false) {
        global $espcms_db_cache;
        if (empty($mid) || !espcms_ismatches($mid)) {
            return false;
        }
        $db_where = "WHERE mid=$mid";
        $db_table = ESPCMS_DB_PREFIX . 'document_model';
        $cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $mid;
        $read_info = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!$read_info) {
            $talbe_field_array = espcms_field_out($db_table, false);
            $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read_info) {
                return false;
            }
            $espcms_db_cache->cacheSave($cache_key, $read_info);
        }
        return !$return_key ? $read_info : $read_info[$return_key];
    }

    public static function get_default_attr_list($mid = 0) {
        if (empty($mid) || !espcms_ismatches($mid)) {
            return false;
        }
        $db_where = " AND mid=$mid AND isdel=1";
        $db_table = ESPCMS_DB_PREFIX . 'document_model_att';
        $talbe_field_array = espcms_field_out($db_table, false);
        $array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "aid");
        if (!is_array($array) || count($array) < 1) {
            return array();
        }
        return $array;
    }

    public static function get_mid_attr_view($mid = 0, $attrname = false, $return_key = false) {
        if (empty($mid) || !espcms_ismatches($mid) || !$attrname) {
            return false;
        }
        $db_where = "WHERE mid=$mid AND attrname='$attrname'";
        $db_table = ESPCMS_DB_PREFIX . 'document_model_att';
        $talbe_field_array = espcms_field_out($db_table, false);
        $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read_info) {
            return false;
        }
        return !$return_key ? $read_info : $read_info[$return_key];
    }

    public static function install_attr($mid, $install_db = array(), $isdel = 1) {
        if (empty($mid) || !espcms_ismatches($mid) || !is_array($install_db)) {
            return false;
        }
        $db_table = ESPCMS_DB_PREFIX . "document_model_att";
        $talbe_field_array = espcms_field_out($db_table, true);
        $install_db['mid'] = $mid;
        $install_db['pid'] = espcms_ismatches($install_db['pid']) ? $install_db['pid'] : 0;
        $install_db['issys'] = $install_db['aid'];
        $install_db['iscover'] = 1;
        $install_db['isdel'] = $isdel;
        $postvalue = espcms_post($install_db, $talbe_field_array, true);
        if ($postvalue) {
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                return false;
            }
        } else {
            return false;
        }
        return $install_id;
    }

    public static function get_document_model_att_list($mid = 0, $selectedid = true) {
        global $espcms_link_db, $espcms_db_cache;
        if (empty($mid) || !espcms_ismatches($mid)) {
            return false;
        }
        $db_table = ESPCMS_DB_PREFIX . "document_model_att";
        $cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $mid;
        $array = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!$array) {
            $db_sql = "SELECT * FROM (SELECT * FROM $db_table HAVING mid IN(0,$mid) ORDER BY aid DESC) AS MODELATTR GROUP BY attrname ORDER BY pid,aid";
            $db_query = $espcms_link_db->db_query($db_sql);
            while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
                if ($fetch_row['isdel'] || !$fetch_row['isclass']) {
                    continue;
                }
                $array[] = $fetch_row;
            }
            if (!is_array($array) || count($array) < 1) {
                return array();
            }
            $espcms_db_cache->cacheSave($cache_key, $array);
        }
        if (is_array($array) && count($array) > 0) {
            foreach ($array as $att_id => $fetch_row) {
                if ($fetch_row['inputtype'] == 'editor') {
                    $array[$att_id]['attrrow'] = $fetch_row['attrrow'] < 300 ? 300 : $fetch_row['attrrow'];
                }
                if ($fetch_row['inputtype'] == 'select' || $fetch_row['inputtype'] == 'radio' || $fetch_row['inputtype'] == 'checkbox') {
                    $forvalue = preg_split("/\n/", $fetch_row['attrvalue']);
                    $newvalue = array();
                    foreach ($forvalue as $key => $value) {
                        if ($key == 0 && $selectedid) {
                            $newvalue[] = array('name' => trim($value), 'selected' => 'selected');
                        } else {
                            $newvalue[] = array('name' => trim($value), 'selected' => '');
                        }
                    }
                    $array[$att_id]['attrvalue'] = $newvalue;
                }
                if ($fetch_row['inputtype'] == 'selectinput') {
                    $forvalue = preg_split("/\n/", $fetch_row['attrvalue']);
                    $selectinputvalue = array();
                    foreach ($forvalue as $key => $value) {
                        $selectinputvalue[] = array('name' => trim($value));
                    }
                    $array[$att_id]['selectinputvalue'] = $selectinputvalue;
                }
            }
        }
        return $array;
    }
}
