<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/
namespace modul_application;
use application\ESPCMS_Core;
use modul_application\ESPCMS_ArticleTypeDB;
use modul_application\ESPCMS_ForumDB;
use modul_application\ESPCMS_FormDB;
use modul_application\ESPCMS_ArticleDB;
use inc_application\link\ArticleLink;
use inc_application\link\ForumLink;
use inc_application\link\FormsLink;
use inc_application\link\MemberLink;
use inc_application\link\OrderLink;
use inc_application\link\EnquiryLink;
use admin_application\link\NevigateLink;
class ESPCMS_NevigateDB {
	public static function get_nevigate_last_list($lng = false, $nevigate_uid = 0, $last_uid = 0, $is_editlink = true) {
		global $espcms_db_cache;
		if (!$lng || !preg_match("/^[a-z0-9]{2,50}$/i", $lng)) {
			return false;
		}
		$db_where .= " AND lng='$lng'";
		if (espcms_ismatches($nevigate_uid)) {
			$db_where .= " AND nevigate_uid=$nevigate_uid";
		}
		$db_table = ESPCMS_DB_PREFIX . 'nevigate';
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $lng . '_' . $nevigate_uid;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$array) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "nevigate_pid,nevigate_id DESC");
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		if (is_array($array) && count($array) > 0) {
			foreach ($array as $key => $nav_array) {
				$array[$key]['pathid'] = $last_uid ? $last_uid . '-' . $nav_array['nevigate_uid'] . '-' . $nav_array['nevigate_id'] : $nav_array['nevigate_uid'] . '-' . $nav_array['nevigate_id'];
				$array[$key]['parentpath'] = $last_uid ? $last_uid . '-' . $nav_array['nevigate_uid'] : $nav_array['nevigate_uid'];
				if ($is_editlink) {
					$array[$key]['edit'] = NevigateLink::Nevigate_link_array('edit', $nav_array);
					$array[$key]['add'] = NevigateLink::Nevigate_link_array('add', $nav_array);
					$array[$key]['addlink'] = NevigateLink::Nevigate_link_array('addlink', $nav_array);
					$array[$key]['import'] = NevigateLink::Nevigate_link_array('import', $nav_array);
				}
			}
		}
		return $array;
	}
	public static function get_nevigate_link_creat($nav_array = array()) {
		if (!is_array($nav_array) || count($nav_array) < 1) {
			return false;
		}
		$nav_array['title'] = $nav_array['nevigate_name'];
		if ($nav_array['nevigate_modul'] == 'link') {
			$nav_array['path'] = 'link';
			$nav_array['link'] = $nav_array['nevigate_url'];
		}
		if ($nav_array['nevigate_modul'] == 'type') {
			$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($nav_array['nevigate_linkid']);
			if (!$type_read || !$type_read['isclass']) {
				return false;
			}
			$type_goto_read = $type_read['gotoid'] && espcms_ismatches($type_read['gotoid']) ? ESPCMS_ArticleTypeDB::get_article_type_view($type_read['gotoid']) : $type_read;
			$nav_array['hover_id'] = $type_read['tid'];
			$nav_array['path'] = 'type';
			$nav_array['link'] = ArticleLink::type_link($type_goto_read);
		}
		if ($nav_array['nevigate_modul'] == 'article') {
			$doc_read = ESPCMS_ArticleDB::get_article_read($nav_array['nevigate_linkid']);
			if (!$doc_read || !$doc_read['isclass']) {
				return false;
			}
			$nav_array['path'] = 'article';
			$nav_array['link'] = ArticleLink::doc_link($doc_read);
		}
		if ($nav_array['nevigate_modul'] == 'sub') {
			$sub_read = ESPCMS_ArticleTypeDB::get_article_subjectlist_view($nav_array['nevigate_linkid']);
			if (!$sub_read || !$sub_read['isclass']) {
				return false;
			}
			$nav_array['path'] = 'sub';
			$nav_array['link'] = ArticleLink::subtype_link($sub_read);
		}
		if ($nav_array['nevigate_modul'] == 'bbs') {
			$bbs_app_config = ESPCMS_Core::get_app_config('bbsemanage', false);
			if ($bbs_app_config['isetup'] && $bbs_app_config['isopen']) {
				$bbs_type_read = ESPCMS_ForumDB::get_bbs_typelist_view($nav_array['nevigate_linkid']);
				$nav_array['hover_id'] = $bbs_type_read['btid'];
				$nav_array['path'] = 'bbs';
				$nav_array['link'] = ForumLink::type_link($bbs_type_read);
			} else {
				return false;
			}
		}
		if ($nav_array['nevigate_modul'] == 'forms') {
			$forms_app_config = ESPCMS_Core::get_app_config('formsmanage', false);
			if ($forms_app_config['isetup'] && $forms_app_config['isopen']) {
				$form_group_read = ESPCMS_FormDB::get_form_group_view($nav_array['nevigate_linkid']);
				$nav_array['hover_id'] = $form_group_read['fgid'];
				$nav_array['path'] = 'form';
				$nav_array['link'] = FormsLink::type_link($form_group_read);
			} else {
				return false;
			}
		}
		if ($nav_array['nevigate_modul'] == 'member') {
			$member_app_config = ESPCMS_Core::get_app_config('member', false);
			if ($member_app_config['isetup'] && $member_app_config['isopen']) {
				$nav_array['path'] = 'member';
				$nav_array['hover_id'] = 0;
				$nav_array['link'] = MemberLink::get_link('login');
			} else {
				return false;
			}
		}
		if ($nav_array['nevigate_modul'] == 'order') {
			$order_app_config = ESPCMS_Core::get_app_config('order', false);
			if ($order_app_config['isetup'] && $order_app_config['isopen']) {
				$nav_array['path'] = 'order';
				$nav_array['hover_id'] = 0;
				$nav_array['link'] = OrderLink::get_order_link('list');
			} else {
				return false;
			}
		}
		if ($nav_array['nevigate_modul'] == 'enquiry') {
			$enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
			if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
				$nav_array['path'] = 'enquiry';
				$nav_array['hover_id'] = 0;
				$nav_array['link'] = EnquiryLink::get_enquiry_link('putin');
			} else {
				return false;
			}
		}
		return $nav_array;
	}
	public static function get_menulink_hover($tid) {
		static $hover_tid = false;
		if (!$tid || !espcms_ismatches($tid)) {
			return false;
		}
		$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($tid);
		if (!$type_read) {
			return false;
		}
		if (self::get_nevigate_link_view($tid, 'type')) {
			$hover_tid = $type_read['tid'];
		} else {
			if ($type_read['upid']) {
				self::get_menulink_hover($type_read['upid']);
			}
		}
		return $hover_tid;
	}
	public static function get_nevigate_link_view($nevigate_linkid = 0, $nevigate_modul = false, $nevigate_uid = 0, $return_key = false) {
		if (!espcms_ismatches($nevigate_linkid) || !preg_match("/^[\w]{2,50}$/i", $nevigate_modul)) {
			return false;
		}
		$db_where = "WHERE nevigate_linkid=$nevigate_linkid AND nevigate_modul='$nevigate_modul' AND nevigate_uid=$nevigate_uid";
		$db_table = ESPCMS_DB_PREFIX . 'nevigate';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}
}
