<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn

 */
use application\ESPCMS_Core;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_FormDB;
use modul_application\ESPCMS_SendMessage;
use modul_application\ESPCMS_MemberAuthority;
use inc_application\link\FormsLink;
use inc_application\link\PublicLink;
class Form {
    public static function in_List() {
        global $espcms_web_templates;
        $forms_app_config = ESPCMS_Core::get_app_config('formsmanage', false);
        if (!$forms_app_config['isetup'] || !$forms_app_config['isopen']) {
            ESPCMS_Dialog::Message_Page('app_close');
        }
        $fgid = $_GET['fgid'];
        if (!$fgid || !espcms_ismatches($fgid)) {
            ESPCMS_Dialog::Message_Page('db_err');
        }
        $type_read = ESPCMS_FormDB::get_form_group_view($fgid);
        if (!$type_read || !$type_read['isclass']) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }
        $type_read['link'] = FormsLink::type_link($type_read);
        $template = $type_read['istemplates'] && $type_read['template'] && ESPCMS_WEB_TYPE != 'WAP' ? $type_read['template'] : 'form';
        $lanpack = $espcms_web_templates->geto('lngpack');
        $lanpack['sitename'] = $type_read['formgroupname'] . '-' . $lanpack['sitename'];
        $att_array = ESPCMS_FormDB::get_form_attr_list($fgid, 1, true, true);
        $espcms_web_templates->into('att_array', $att_array);
        $espcms_web_templates->into('type_read', $type_read);
        $espcms_web_templates->into('lngpack', $lanpack);
        $espcms_web_templates->into('tokenkey', token('form_send_' . $type_read['fgid']));
        $espcms_web_templates->into('seccodelink', PublicLink::get_verfication('seccodelink'));
        $espcms_web_templates->into('formlink', FormsLink::get_form_link(false));
        $espcms_web_templates->into('current', $fgid);
        $espcms_web_templates->into('path', 'forms');
        $espcms_web_templates->output('form/' . $template, 'form_send', false, false);
    }
    public static function in_Save() {
        global $espcms_command;
        if (!$_POST['fgid'] || !espcms_ismatches($_POST['fgid'])) {
            ESPCMS_Dialog::Message_Page('db_err');
        }
        $fgid = $_POST['fgid'];
        if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
            ESPCMS_Dialog::Message_Page('repeat_inut');
        }
        $forms_app_config = ESPCMS_Core::get_app_config('formsmanage', false);
        if (!$forms_app_config['isetup'] || !$forms_app_config['isopen']) {
            ESPCMS_Dialog::Message_Page('app_close');
        }
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if ($member_app_config['isetup'] && $member_app_config['isopen']) {
            $member_info = ESPCMS_MemberAuthority::getMemberInfo();
            $_POST['userid'] = $member_info['userid'] && espcms_ismatches($member_info['userid']) ? $member_info['userid'] : 0;
        }
        $_POST['addtime'] = time();
        $_POST['did'] = espcms_ismatches($_POST['did']) && $_POST['did'] ? $_POST['did'] : 0;
        $_POST['remail'] = 0;
        $_POST['isreply'] = 0;
        $_POST['ipadd'] = real_remote_ip();
        $type_read = ESPCMS_FormDB::get_form_group_view($fgid);
        if (!$type_read || !$type_read['isclass']) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }
        if ($type_read['isseccode'] && $espcms_command['SAFETY_ISVERIFICATION_CODE']) {
            require_once(ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_VerificationCode.php');
            $espcms_login_verification_code_cookie = $_COOKIE['espcms_web_login_verification_code'];
            if ($espcms_login_verification_code_cookie) {
                $espcms_login_verification_code = espcms_decrypt($espcms_login_verification_code_cookie, ESPCMS_ENCRYPT_CODE);
            } else {
                ESPCMS_Dialog::Message_Page('seescode_err');
            }
            $code = new ESPCMS_VerificationCode();
            $code->seccodeconvert($espcms_login_verification_code);
            $_POST['seccode'] = $_POST['seccode'] ? strtoupper($_POST['seccode']) : '';
            if ($espcms_login_verification_code != $_POST['seccode']) {
                ESPCMS_Dialog::Message_Page('seescode_err');
            }
        }
        if ((($type_read['purview'] && espcms_ismatches($type_read['purview'])) || ($type_read['purview'] && espcms_islongfig($type_read['purview']))) && $member_app_config['isopen'] && $member_app_config['isetup'] && !ESPCMS_MemberAuthority::authorityRandVerify($type_read['purview'], true)) {
            ESPCMS_Dialog::Message_Page('purview_err');
        }
        if ($type_read['inputtime'] && espcms_ismatches($type_read['inputtime'])) {
            $input_cookie_id = md5($_POST['ipadd'] + $_POST['fgid'] + 'forminput');
            $is_repeat = $_COOKIE[$input_cookie_id];
            if (!$is_repeat) {
                espcms_set_cookie($input_cookie_id, time(), $type_read['inputtime']);
            } else {
                ESPCMS_Dialog::Message_Page('operating_fast');
            }
        }
        $att_array = ESPCMS_FormDB::get_form_attr_list($fgid, 1);
        if (!is_array($att_array) || count($att_array) <= 0) {
            ESPCMS_Dialog::Message_Page('field_read_err');
        }
        $key_type = is_array($att_array) ? espcms_array_keytokey($att_array, 'attrname', 'inputtype') : array();
        if (is_array($key_type)) {
            foreach ($key_type as $key => $value) {
                if ($value == 'checkbox') {
                    $_POST[$key] = $_POST[$key] ? $_POST[$key] : '';
                }
            }
        }
        foreach ($_POST as $key => $value) {
            if ($key_type[$key] == 'checkbox') {
                $_POST[$key] = is_array($value) ? implode(',', $value) : '';
            } elseif ($key_type[$key] == 'date' || $key_type[$key] == 'time' || $key_type[$key] == 'datetime') {
                $_POST[$key] = espcms_istime($value) || espcms_isdata($value) || preg_match("/^[\d]{1,2}:[\d]{1,2}$/i", $value) ? strtotime($value) : 0;
            } elseif ($key_type[$key] == 'int') {
                $_POST[$key] = espcms_ismatches($value) ? $value : 0;
            } elseif ($key_type[$key] == 'float' || $key_type[$key] == 'decimal') {
                $_POST[$key] = preg_match("/^[0-9.]+$/i", $value) ? $value : 0;
            } elseif ($key_type[$key] == 'text') {
                $_POST[$key] = $value ? espcms_t2h($value) : '';
            } else {
                $_POST[$key] = $value ? htmlspecialchars($value) : '';
            }
        }
        $db_table = ESPCMS_DB_PREFIX . "form_value";
        $talbe_field_array = espcms_field_out($db_table, true);
        $postvalue = espcms_post($_POST, $talbe_field_array, true);
        if (!$postvalue || !is_array($postvalue)) {
            ESPCMS_Dialog::Message_Page('db_err');
        }
        $install_id = espcms_db_install_save($db_table, $postvalue);
        if (!$install_id) {
            ESPCMS_Dialog::Message_Page('save_err');
        }
        if ($espcms_command['EMAIL_ISOPEN'] && $type_read['ismail'] && $type_read['mailcode'] && espcms_isemail($type_read['putmail'])) {
            $_POST['fvid'] = $install_id;
            $_POST['formgroupname'] = $type_read['formgroupname'];
            $_POST['addtime'] = espcms_timeformat($_POST['addtime'], 3);
            ESPCMS_SendMessage::send_email_key_message($type_read['mailcode'], $type_read['putmail'], $_POST);
        }
        if ($espcms_command['SMS_ISOPEN'] && $type_read['issms'] && $type_read['smscode']) {
            $_POST['fvid'] = $install_id;
            $_POST['formgroupname'] = $type_read['formgroupname'];
            $_POST['addtime'] = espcms_timeformat($_POST['addtime'], 3);
            ESPCMS_SendMessage::send_moblie_sms_message($type_read['smscode'], $espcms_command['SMS_MOBLIE_NB'], $_POST);
        }
        ESPCMS_Dialog::Message_len_Page($type_read['successtext']);
    }
    public static function in_Token() {
        if (!$_GET['fgid'] || !espcms_ismatches($_GET['fgid'])) {
            return false;
        }
        $tokenkey = token('form_send_' . $_GET['fgid']);
        $out_json = json_encode($tokenkey);
        exit($out_json);
    }
}
