<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_Core;
use application\ESPCMS_PageButton;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_MemberAuthority;
use modul_application\ESPCMS_SendMessage;
use application\ESPCMS_FileUpload;
use inc_application\link\MemberLink;
use inc_application\link\PublicLink;

class MemberMain {

	private static $member_cookie_read;
	private static $member_con;

	public function __construct() {
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		ESPCMS_MemberAuthority::authorityWebVerify(false, $member_app_config['appconfig']);
		static::$member_con = unserialize($member_app_config['appconfig']);

		$member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
		static::$member_cookie_read = ESPCMS_MemberDB::get_member_view($member_cookie_info['userid']);
		if (!static::$member_cookie_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('quit'));
		}
	}

	public static function in_Center() {
		global $espcms_web_templates;
		$member_read = static::$member_cookie_read;
		$member_read['rankname'] = ESPCMS_MemberDB::get_member_class_view(static::$member_cookie_read['mcid'], 'rankname');

		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('member', $member_read);
		$espcms_web_templates->into('out', 'center');
		$espcms_web_templates->output('member/member_center', 'member_center', false, false);
	}

	public static function in_EditInfo() {
		global $espcms_web_templates;
		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
		}
		$member_read = ESPCMS_MemberDB::get_member_view($userid);
		if (!$member_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('quit'));
		}
		$lng = espcms_lancode();

		$att_array = ESPCMS_MemberDB::get_member_attr($lng);
		if (is_array($att_array)) {
			foreach ($att_array as $key => $value) {
				if (($value['inputtype'] == 'select' || $value['inputtype'] == 'radio') && is_array($value['attrvalue'])) {
					foreach ($value['attrvalue'] as $key2 => $value2) {
						$att_array[$key]['attrvalue'][$key2]['selected'] = trim($member_read[$value['attrname']]) == trim($value2['name']) ? 'selected' : '';
					}
				} elseif ($value['inputtype'] == 'checkbox') {
					$expvale = explode(',', $member_read[$value['attrname']]);
					foreach ($value['attrvalue'] as $key2 => $value2) {
						$att_array[$key]['attrvalue'][$key2]['selected'] = in_array($value2['name'], $expvale) ? 'selected' : '';
					}
				} elseif ($value['inputtype'] == 'date' || $value['inputtype'] == 'time' || $value['inputtype'] == 'datetime') {
					if ($member_read[$value['attrname']] && espcms_ismatches($member_read[$value['attrname']]) && $value['inputtype'] == 'date') {
						$att_array[$key]['attrvalue'] = date('Y-m-d', $member_read[$value['attrname']]);
					}
					if ($member_read[$value['attrname']] && espcms_ismatches($member_read[$value['attrname']]) && $value['inputtype'] == 'datetime') {
						$att_array[$key]['attrvalue'] = date('Y-m-d H:i:s', $member_read[$value['attrname']]);
					}
					if ($member_read[$value['attrname']] && espcms_ismatches($member_read[$value['attrname']]) && $value['inputtype'] == 'time') {
						$att_array[$key]['attrvalue'] = date('H:i', $member_read[$value['attrname']]);
					}
				} elseif ($value['inputtype'] == 'int' || $value['inputtype'] == 'float' || $value['inputtype'] == 'decimal') {
					$att_array[$key]['attrvalue'] = preg_match("/^[\d.]+/", $member_read[$value['attrname']]) ? $member_read[$value['attrname']] : 0;
				} else {
					$att_array[$key]['attrvalue'] = $member_read[$value['attrname']];
				}
			}
		}
		$espcms_web_templates->into('att_array', $att_array);

		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('member_con', static::$member_con);
		$espcms_web_templates->into('tokenkey', token('member_editinfo'));
		$espcms_web_templates->into('member', $member_read);
		$espcms_web_templates->into('out', 'editinfo');
		$espcms_web_templates->output('member/member_center', 'member_center', false, false);
	}

	public static function in_EditPassword() {
		global $espcms_web_templates;
		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
		}
		$member_read = ESPCMS_MemberDB::get_member_view($userid);
		if (!$member_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('quit'));
		}

		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('tokenkey', token('member_editpassword'));
		$espcms_web_templates->into('member_con', static::$member_con);
		$espcms_web_templates->into('member', $member_read);
		$espcms_web_templates->into('out', 'editpassword');
		$espcms_web_templates->output('member/member_center', 'member_center', false, false);
	}

	public static function in_EditEmail() {
		global $espcms_web_templates;
		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
		}
		$member_read = ESPCMS_MemberDB::get_member_view($userid);
		if (!$member_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('quit'));
		}

		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('tokenkey', token('member_editmail'));
		$espcms_web_templates->into('member_con', static::$member_con);
		$espcms_web_templates->into('member', $member_read);
		$espcms_web_templates->into('out', 'editemail');
		$espcms_web_templates->output('member/member_center', 'member_center', false, false);
	}

	public static function in_EditSave() {
		global $espcms_command;

		$inputclass = $_POST['inputclass'] ? $_POST['inputclass'] : 'editinfo';
		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
		}
		if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
			ESPCMS_Dialog::Message_Page('repeat_inut', MemberLink::get_link('center'));
		}
		$lng = espcms_lancode();
		$db_where = "WHERE userid=$userid";

		$db_table = ESPCMS_DB_PREFIX . "member";
		$talbe_field_array = espcms_field_out($db_table, true);

		if ($inputclass == 'editinfo') {
			$_POST['sex'] = espcms_ismatches($_POST['sex']) && $_POST['sex'] ? $_POST['sex'] : 1;
			$_POST['birthday'] = espcms_isdata($_POST['birthday']) ? strtotime($_POST['birthday']) : 0;
			$_POST['qq'] = espcms_ismatches($_POST['qq']) ? $_POST['qq'] : 0;
			$_POST['updatetime'] = time();
			$_POST['address'] = $_POST['address'] ? htmlspecialchars($_POST['address']) : '';
			$_POST['alias'] = $_POST['alias'] ? htmlspecialchars($_POST['alias']) : '';
			$_POST['tel'] = $_POST['tel'] ? htmlspecialchars($_POST['tel']) : '';
			$_POST['weixin'] = $_POST['weixin'] ? htmlspecialchars($_POST['weixin']) : '';
			$_POST['country'] = $_POST['country'] ? htmlspecialchars($_POST['country']) : '';
			$_POST['province'] = $_POST['province'] ? htmlspecialchars($_POST['province']) : '';
			$_POST['city'] = $_POST['city'] ? htmlspecialchars($_POST['city']) : '';
			$_POST['district'] = $_POST['district'] ? htmlspecialchars($_POST['district']) : '';
			unset($_POST['lng'], $_POST['username'], $_POST['addtime'], $_POST['lastip'], $_POST['lasttime'], $_POST['ismoblietime'], $_POST['ismoblie'], $_POST['isemailtime'], $_POST['isemail'], $_POST['isqq'], $_POST['mobliesntime']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				ESPCMS_Dialog::Message_Page('dba_read_err', MemberLink::get_link('edit_info'));
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				ESPCMS_Dialog::Message_Page('save_err', MemberLink::get_link('edit_info'));
			}
			ESPCMS_MemberDB::member_install_attr($lng, $userid, $_POST, true);
			ESPCMS_Dialog::Message_Page('member_edit_ok', MemberLink::get_link('center'));
		} elseif ($inputclass == 'editpassword') {

			$password_len = strlen($_POST['oldpassword']);
			if ($password_len < 6 || $password_len > 30) {
				ESPCMS_Dialog::Message_Page('password_input_err', MemberLink::get_link('edit_password'));
			}
			$old_password = md5($_POST['oldpassword']);

			if ($_POST['password'] && $_POST['password'] == $_POST['validation_password']) {
				$new_password = md5($_POST['password']);
			} else {
				ESPCMS_Dialog::Message_Page('password_equal', MemberLink::get_link('edit_password'));
			}
			$member_read = ESPCMS_MemberDB::get_member_view($userid);
			if (!$member_read) {
				ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('edit_password'));
			}
			if ($old_password !== $member_read['password']) {
				ESPCMS_Dialog::Message_Page('password_verify_no', MemberLink::get_link('edit_password'));
			}
			$update_key = espcms_db_update_set_save($db_table, $db_where, "password='$new_password'");
			if (!$update_key) {
				ESPCMS_Dialog::Message_Page('save_err', MemberLink::get_link('edit_info'));
			}
			$member_read['newpassword'] = $_POST['password'];

			if ($espcms_command['EMAIL_ISOPEN'] && $member_read['isemail'] && espcms_isemail($member_read['email'])) {
				$member_read['addtime'] = espcms_timeformat($member_read['addtime'], 3);
				ESPCMS_SendMessage::send_email_key_message('member_edit_password', $member_read['email'], $member_read);
			}

			if ($espcms_command['SMS_ISOPEN'] && $member_read['ismoblie'] && espcms_ismoblie($member_read['mobile'])) {
				$member_read['addtime'] = espcms_timeformat($member_read['addtime'], 3);
				ESPCMS_SendMessage::send_moblie_sms_message('member_edit_password', $member_read['mobile'], $member_read);
			}
			ESPCMS_Dialog::Message_Page('edit_password_ok', MemberLink::get_link('quit'));
		} elseif ($inputclass == 'editmail') {
			$password_len = strlen($_POST['password']);
			if ($password_len < 6 || $password_len > 30) {
				ESPCMS_Dialog::Message_Page('password_input_err', MemberLink::get_link('edit_mail'));
			}
			$password = md5($_POST['password']);
			$member_read = ESPCMS_MemberDB::get_member_view($userid);
			if (!$member_read) {
				ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('edit_mail'));
			}
			if ($password !== $member_read['password']) {
				ESPCMS_Dialog::Message_Page('password_verify_no', MemberLink::get_link('edit_mail'));
			}
			if (!espcms_isemail($_POST['email'])) {
				ESPCMS_Dialog::Message_Page('input_err', MemberLink::get_link('edit_mail'));
			}
			$email = $_POST['email'];
			$db_db_where = " AND userid!=$userid AND email='$email'";
			$db_num = espcms_db_num($db_table, $db_db_where);
			if ($db_num > 0) {
				ESPCMS_Dialog::Message_Page('email_repetition', MemberLink::get_link('edit_mail'));
			}
			$update_key = espcms_db_update_set_save($db_table, $db_where, "email='$email',isemail=0");
			if (!$update_key) {
				ESPCMS_Dialog::Message_Page('save_err', MemberLink::get_link('edit_info'));
			}
			if ($espcms_command['EMAIL_ISOPEN'] && static::$member_con['MEMBER_EMAIL_VERIFY']) {

				$member_read['user_key'] = urlencode(espcms_encrypt($member_read['username'], ESPCMS_ENCRYPT_CODE));
				$member_read['pass_key'] = urlencode(espcms_encrypt($member_read['password'], ESPCMS_ENCRYPT_CODE));
				$member_read['checklink'] = MemberLink::get_mailcheck($member_read);
				ESPCMS_SendMessage::send_email_message('member_mail_check', $member_read, $member_read['userid']);

				ESPCMS_Dialog::Message_Page('edit_email_check_ok', MemberLink::get_link('quit'), 'member_login_botton');
			} else {
				ESPCMS_Dialog::Message_Page('edit_email_ok', MemberLink::get_link('edit_info'));
			}
		} elseif ($inputclass == 'creatsns') {
			$type = $_POST['type'];
			if (!$type) {
				ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('bindsns'));
			}

			$password_len = strlen($_POST['password']);
			if ($password_len < 6 || $password_len > 30) {
				ESPCMS_Dialog::Message_Page('password_input_err', MemberLink::get_link('bindsns'));
			}
			$password = md5($_POST['password']);
			$member_read = ESPCMS_MemberDB::get_member_view($userid);
			if (!$member_read) {
				ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('bindsns'));
			}
			if ($password !== $member_read['password']) {
				ESPCMS_Dialog::Message_Page('password_verify_no', MemberLink::get_link('bindsns'));
			}
			if ($type == 'weibo') {
				$weibo_app_config = ESPCMS_Core::get_app_config('weibologin', false);
				if (!$weibo_app_config['isetup'] || !$weibo_app_config['isopen'] || !$member_read['weibo_openid']) {
					ESPCMS_Dialog::Message_Page('member_reg_binsns_err', MemberLink::get_link('bindsns'));
				}
				$update_key = espcms_db_update_set_save($db_table, $db_where, "weibo_openid=''");
			}
			if ($type == 'weixin') {
				$weixin_app_config = ESPCMS_Core::get_app_config('weixinlogin', false);
				if (!$weixin_app_config['isetup'] || !$weixin_app_config['isopen'] || !$member_read['weixin_openid']) {
					ESPCMS_Dialog::Message_Page('member_reg_binsns_err', MemberLink::get_link('bindsns'));
				}
				$update_key = espcms_db_update_set_save($db_table, $db_where, "weixin_openid='',isweixin=0");
			}
			if ($type == 'qq') {
				$qq_app_config = ESPCMS_Core::get_app_config('qqlogin', false);
				if (!$qq_app_config['isetup'] || !$qq_app_config['isopen'] || !$member_read['qq_openid']) {
					ESPCMS_Dialog::Message_Page('member_reg_binsns_err', MemberLink::get_link('bindsns'));
				}
				$update_key = espcms_db_update_set_save($db_table, $db_where, "qq_openid='',isqq=0");
			}
			if (!$update_key) {
				ESPCMS_Dialog::Message_Page('save_err', MemberLink::get_link('bindsns'));
			}
			ESPCMS_Dialog::Message_Page('member_reg_binsns_clear_ok', MemberLink::get_link('bindsns'));
		}
	}

	public static function in_IntegralList() {
		global $espcms_web_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . 'member_integral';

		$pageid = $_GET['pageid'] && espcms_ismatches($_GET['pageid']) ? $_GET['pageid'] : 1;
		$per_page_num = 20;

		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
		}

		$db_where = " AND userid=$userid";

		$db_num = espcms_db_num($db_table, $db_where);

		$db_sql = espcms_db_list_out($db_table, $db_where);

		$lanpack = $espcms_web_templates->geto('lngpack');

		$espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $pageid, 1, $lanpack['pagebotton'], 'inc_application\link\MemberLink', 'get_member_Integral_link', array());

		$sql = $espcms_page_button->sql_creat('member_integral_id', 'DESC');
		$db_query = $espcms_link_db->db_query($sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$array[] = $fetch_row;
		}
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('array', $array);
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
		$espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
		$espcms_web_templates->output('member/member_integral', 'member_integral', false, false);
	}

	public static function in_EditPhoto() {
		global $espcms_web_templates, $espcms_command;
		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
		}
		$member_read = ESPCMS_MemberDB::get_member_view($userid);
		if (!$member_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('quit'));
		}
		$link_array = array('attrname' => 'pic', 'inputtype' => 'img');
		$espcms_web_templates->into('file_save_link', PublicLink::get_fileupload('upfiesave', $link_array));

		$php_upload_max_filesize = ini_get('file_uploads') ? intval(ini_get('upload_max_filesize')) : 2;
		$espcms_web_templates->into('php_upload_max_filesize', $php_upload_max_filesize);

		$net_upload_max_filesize = intval($espcms_command['WEB_UPFILE_SIZE']);
		$espcms_web_templates->into('net_upload_max_filesize', $net_upload_max_filesize);

		$chunksize = $php_upload_max_filesize > 5 ? 5 * 1024 * 1024 : $php_upload_max_filesize * 1024 * 1024;
		$espcms_web_templates->into('chunksize', $chunksize);

		$upload_max_filesize_byte = $net_upload_max_filesize * 1024 * 1024;
		$espcms_web_templates->into('upload_max_filesize_byte', $upload_max_filesize_byte);
		$espcms_web_templates->into('inputtype', 'img');
		$espcms_web_templates->into('upfile_ext', $espcms_command['UPFILE_FILE_PIC_TYPE']);

		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('tokenkey', token('member_editphoto'));
		$espcms_web_templates->into('member_con', static::$member_con);
		$espcms_web_templates->into('member', $member_read);
		$espcms_web_templates->output('member/member_photo', 'member_photo', false, false);
	}

	public static function in_PhotoSave() {
		global $espcms_command;

		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			$uploadFileArray['returnVal'] = 0;
			$outJOSN = json_encode($uploadFileArray);
			exit($outJOSN);
		}
		if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
			$uploadFileArray['returnVal'] = 0;
			$outJOSN = json_encode($uploadFileArray);
			exit($outJOSN);
		}

		$espcms_command['UPFILE_SIZE'] = $espcms_command['WEB_UPFILE_SIZE'];
		$espcms_command['UPFILE_FORMATFILE_TYPE'] = 4;

		$espcms_command['UPFILE_SAVAPATH'] = 'upload/';
		$filename = 'userphoto_' . md5($userid);

		$uploadFileArray = ESPCMS_FileUpload::intoFile($_FILES['espcms_webupfilename'], $espcms_command, 'image', false, false, false, 0, 1, $filename, 'photo/');
		if (!$uploadFileArray['upLoadFileName']) {
			$uploadFileArray['returnVal'] = 0;
			$outJOSN = json_encode($uploadFileArray);
			exit($outJOSN);
		}
		$db_where = "WHERE userid=$userid";
		$pic = $uploadFileArray['upLoadFileName'];

		$db_table = ESPCMS_DB_PREFIX . "member";
		$update_key = espcms_db_update_set_save($db_table, $db_where, "pic='$pic'");
		if (!$update_key) {
			$uploadFileArray['returnVal'] = 0;
			$outJOSN = json_encode($uploadFileArray);
			exit($outJOSN);
		}
		$uploadFileArray['returnVal'] = 1;
		$outJOSN = json_encode($uploadFileArray);
		exit($outJOSN);
	}

	public static function in_Bindsns() {
		global $espcms_web_templates;
		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
		}
		$member_read = ESPCMS_MemberDB::get_member_view($userid);
		if (!$member_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('center'));
		}

		$weibo_app_config = ESPCMS_Core::get_app_config('weibologin', false);
		$qq_app_config = ESPCMS_Core::get_app_config('qqlogin', false);
		$weixin_app_config = ESPCMS_Core::get_app_config('weixinlogin', false);
		if ($weibo_app_config['isetup'] && $weibo_app_config['isopen'] && $member_read['weibo_openid']) {
			$weibo_creat_link = MemberLink::member_bingsns_link('weibo');
			$espcms_web_templates->into('weibo_creat_link', $weibo_creat_link);
		}
		if ($qq_app_config['isetup'] && $qq_app_config['isopen'] && $member_read['qq_openid']) {
			$qq_creat_link = MemberLink::member_bingsns_link('qq');
			$espcms_web_templates->into('qq_creat_link', $qq_creat_link);
		}
		if ($weixin_app_config['isetup'] && $weixin_app_config['isopen'] && $member_read['weixin_openid']) {
			$weixin_creat_link = MemberLink::member_bingsns_link('weixin');
			$espcms_web_templates->into('weixin_creat_link', $weixin_creat_link);
		}

		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('member_con', static::$member_con);
		$espcms_web_templates->into('member', $member_read);
		$espcms_web_templates->into('out', 'home');
		$espcms_web_templates->output('member/member_bingsns', 'member_bingsns', false, false);
	}

	public static function in_BindsnsClear() {
		global $espcms_web_templates;
		$type = $_GET['type'];
		if (!$type) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('bindsns'));
		}
		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('bindsns'));
		}
		$member_read = ESPCMS_MemberDB::get_member_view($userid);
		if (!$member_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('bindsns'));
		}
		if ($type == 'weibo') {
			$weibo_app_config = ESPCMS_Core::get_app_config('weibologin', false);
			if ($weibo_app_config['isetup'] && $weibo_app_config['isopen'] && $member_read['weibo_openid']) {
				$weibo_creat_link = MemberLink::member_bingsns_link('weibo');
				$espcms_web_templates->into('weibo_creat_link', $weibo_creat_link);
			} else {
				ESPCMS_Dialog::Message_Page('member_reg_binsns_err', MemberLink::get_link('bindsns'));
			}
		}
		if ($type == 'weixin') {
			$weixin_app_config = ESPCMS_Core::get_app_config('weixinlogin', false);
			if ($weixin_app_config['isetup'] && $weixin_app_config['isopen'] && $member_read['weixin_openid']) {
				$weixin_creat_link = MemberLink::member_bingsns_link('weixin');
				$espcms_web_templates->into('weixin_creat_link', $weixin_creat_link);
			} else {
				ESPCMS_Dialog::Message_Page('member_reg_binsns_err', MemberLink::get_link('bindsns'));
			}
		}
		if ($type == 'qq') {
			$qq_app_config = ESPCMS_Core::get_app_config('qqlogin', false);
			if ($qq_app_config['isetup'] && $qq_app_config['isopen'] && $member_read['qq_openid']) {
				$qq_creat_link = MemberLink::member_bingsns_link('qq');
				$espcms_web_templates->into('qq_creat_link', $qq_creat_link);
			} else {
				ESPCMS_Dialog::Message_Page('member_reg_binsns_err', MemberLink::get_link('bindsns'));
			}
		}
		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('type', $type);
		$espcms_web_templates->into('member_con', static::$member_con);
		$espcms_web_templates->into('member', $member_read);
		$espcms_web_templates->into('tokenkey', token('member_editsns'));
		$espcms_web_templates->into('out', 'password');
		$espcms_web_templates->output('member/member_bingsns', 'member_bingsns', false, false);
	}

}
