<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn

 */

use application\ESPCMS_Core;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_ArticleDB;
use modul_application\ESPCMS_MemberAuthority;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_CouponDB;
use modul_application\ESPCMS_OrderDB;
use modul_application\ESPCMS_SendMessage;
use inc_application\link\ArticleLink;
use inc_application\link\OrderLink;
use inc_application\link\MemberLink;
use inc_application\link\CouponLink;

class Order {

	private static $order_con;
	private static $member_con;

	public function __construct() {
		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		if (!$order_app_config['isetup'] || !$order_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		static::$order_con = unserialize($order_app_config['appconfig']);

		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		static::$member_con = unserialize($member_app_config['appconfig']);
	}


	public static function in_Buy() {
		$did = $_GET['did'];
		if (!$did || !espcms_ismatches($did)) {
			ESPCMS_Dialog::Message_Page('db_err');
		}
		$doc_read = ESPCMS_ArticleDB::get_article_read($did);
		if (!$doc_read || !$doc_read['isclass']) {
			ESPCMS_Dialog::Message_Page('doc_read_err');
		}
		if (!$doc_read['isorder']) {
			ESPCMS_Dialog::Message_Page('doc_order_close');
		}

		$espcms_buy_order_info = $_COOKIE['espcms_buy_order_info'];
		if ($espcms_buy_order_info) {
			$order_cookie_read = espcms_decrypt($espcms_buy_order_info, ESPCMS_ENCRYPT_CODE);
			$order_cookie_array = $order_cookie_read ? unserialize($order_cookie_read) : array();
		}
		if (!$order_cookie_read || !is_array($order_cookie_array) || count($order_cookie_array) < 1) {

			$order_array = array($did => array('did' => $did, 'num' => 1));
			$save_cookie = serialize($order_array);
		} else {
			if (array_key_exists($did, $order_cookie_array)) {

				$order_cookie_array[$did]['num'] = $order_cookie_array[$did]['num'] && espcms_ismatches($order_cookie_array[$did]['num']) ? $order_cookie_array[$did]['num'] + 1 : 1;
			} else {

				$order_cookie_array[$did] = array('did' => $did, 'num' => 1);
			}
			$save_cookie = serialize($order_cookie_array);
		}

		$session_id = espcms_set_cookie('espcms_buy_order_info', espcms_encrypt($save_cookie, ESPCMS_ENCRYPT_CODE), 108000);
		if ($session_id) {
			header('location:' . OrderLink::get_order_link('list'));
		} else {
			ESPCMS_Dialog::Message_Page('order_save_cookie');
		}
	}

	public static function in_List() {
		global $espcms_web_templates;
		$db_table = ESPCMS_DB_PREFIX . 'document';

		$espcms_buy_order_info = $_COOKIE['espcms_buy_order_info'];
		if ($espcms_buy_order_info) {
			$order_cookie_read = espcms_decrypt($espcms_buy_order_info, ESPCMS_ENCRYPT_CODE);
			$order_cookie_array = $order_cookie_read ? unserialize($order_cookie_read) : array();
		}
		if (is_array($order_cookie_array) && count($order_cookie_array) > 0) {
			$did_array = espcms_array_findkey($order_cookie_array, 'did');
			$did_list = is_array($did_array) && espcms_array_ismatches($did_array) ? implode(',', $did_array) : false;
			if (!$did_list) {
				ESPCMS_Dialog::Message_Page('order_cart_empty');
			}
			$db_where = espcms_ismatches($did_list) ? " AND isclass=1 AND isorder=1 AND did=$did_list" : " AND isclass=1 AND isorder=1 AND did IN ($did_list)";

			$product_total = 0;
			$talbe_field_array = espcms_field_out($db_table);
			$list_array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, 'pid,did DESC');
			if (!is_array($list_array)) {
				ESPCMS_Dialog::Message_Page('order_cart_empty');
			}
			foreach ($list_array as $key => $value) {
				$list_array[$key]['ctitle'] = empty($value['color']) ? $value['title'] : "<font color='" . $value['color'] . "'>" . $value['title'] . "</font>";
				$list_array[$key]['link'] = ArticleLink::doc_link($value);
				$num = $order_cookie_array[$value['did']]['num'];
				$countprice = espcms_ismoney($value['bprice']) && espcms_ismatches($num) ? $value['bprice'] * $num : 0;
				$list_array[$key]['countprice'] = $countprice;
				$list_array[$key]['amount'] = $num;
				$product_total = $product_total + $countprice;
			}

			$espcms_web_templates->into('array', $list_array);
			$espcms_web_templates->into('product_total', $product_total);
			$espcms_web_templates->into('order_link', OrderLink::get_order_link());

			$order_integral = static::$order_con['ORDER_INTEGRAL'] && espcms_ismatches(static::$order_con['ORDER_INTEGRAL']) ? static::$order_con['ORDER_INTEGRAL'] * $product_total : 0;
			$espcms_web_templates->into('order_integral', $order_integral);
		}
		$espcms_web_templates->into('path', 'order');
		$espcms_web_templates->into('out', 'order_list');
		$espcms_web_templates->output('member/order', 'order', false, false);
	}

	public static function in_Settlement() {
		global $espcms_web_templates;
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if ($member_app_config['isetup'] && $member_app_config['isopen']) {
			if (static::$order_con['ORDER_ISMEMBER']) {
				ESPCMS_MemberAuthority::authorityWebVerify(false, $member_app_config['appconfig'], OrderLink::get_order_link('list'));
			}

			$member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
			$member_read = ESPCMS_MemberDB::get_member_view($member_cookie_info['userid']);
			if (!$member_read && static::$order_con['ORDER_ISMEMBER']) {
				ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('quit'));
			}
			$espcms_web_templates->into('member', $member_read);
		}
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$did_array = $_POST['did'];
		$amount = $_POST['amount'];
		if (!is_array($did_array) || !is_array($amount) || count($did_array) < 1 || count($amount) < 1) {
			ESPCMS_Dialog::Message_Page('order_cart_empty', OrderLink::get_order_link('list'));
		}

		$order_cookie_array = array();
		foreach ($did_array as $key => $value) {
			$num = $amount[$key];
			if (!$num || !espcms_ismatches($num) || !$value || !espcms_ismatches($value)) {
				continue;
			}
			$order_cookie_array[$value] = array('did' => $value, 'num' => $num);
		}
		if (!is_array($order_cookie_array) || count($order_cookie_array) < 1) {
			ESPCMS_Dialog::Message_Page('order_cart_empty', OrderLink::get_order_link('list'));
		}
		$save_cookie = serialize($order_cookie_array);
		$session_id = espcms_set_cookie('espcms_buy_order_info', espcms_encrypt($save_cookie, ESPCMS_ENCRYPT_CODE), 108000);
		if (!$session_id) {
			ESPCMS_Dialog::Message_Page('order_save_cookie', OrderLink::get_order_link('list'));
		}

		$did_list = is_array($did_array) && espcms_array_ismatches($did_array) ? implode(',', $did_array) : false;
		if (!$did_list) {
			ESPCMS_Dialog::Message_Page('order_cart_empty', OrderLink::get_order_link('list'));
		}
		$db_where = espcms_ismatches($did_list) ? " AND isclass=1 AND isorder=1 AND did=$did_list" : " AND isclass=1 AND isorder=1 AND did IN ($did_list)";

		$product_total = 0;
		$talbe_field_array = espcms_field_out($db_table);
		$list_array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, 'pid,did DESC');
		if (!is_array($list_array)) {
			ESPCMS_Dialog::Message_Page('order_cart_empty', OrderLink::get_order_link('list'));
		}
		foreach ($list_array as $key => $value) {
			$list_array[$key]['ctitle'] = empty($value['color']) ? $value['title'] : "<font color='" . $value['color'] . "'>" . $value['title'] . "</font>";
			$list_array[$key]['link'] = ArticleLink::doc_link($value);
			$num = $order_cookie_array[$value['did']]['num'];
			$countprice = espcms_ismoney($value['bprice']) && espcms_ismatches($num) ? $value['bprice'] * $num : 0;
			$list_array[$key]['countprice'] = $countprice;
			$list_array[$key]['amount'] = $num;
			$product_total = $product_total + $countprice;
		}
		$espcms_web_templates->into('path', 'order');
		$espcms_web_templates->into('array', $list_array);
		$espcms_web_templates->into('product_total', $product_total);
		$espcms_web_templates->into('tokenkey', token('order_settlement'));
		$espcms_web_templates->into('order_link', OrderLink::get_order_link());

		$shipplug = ESPCMS_OrderDB::get_express_list(false, 1);
		$espcms_web_templates->into('shipplug', $shipplug);

		$order_integral = static::$order_con['ORDER_INTEGRAL'] && espcms_ismatches(static::$order_con['ORDER_INTEGRAL']) ? static::$order_con['ORDER_INTEGRAL'] * $product_total : 0;
		$espcms_web_templates->into('order_integral', $order_integral);

		$coupon_app_config = ESPCMS_Core::get_app_config('coupon', false);
		if ($coupon_app_config['isetup'] && $coupon_app_config['isopen']) {
			$espcms_web_templates->into('coupon_app', $coupon_app_config);
			$espcms_web_templates->into('uncoupon_link', CouponLink::get_uncoupon_link());
			$espcms_web_templates->into('check_coupon_link', CouponLink::get_check_coupon_link());
		}
		$espcms_web_templates->into('out', 'order_edit');
		$espcms_web_templates->into('member_con', static::$member_con);
		$espcms_web_templates->into('order_con', static::$order_con);
		$espcms_web_templates->output('member/order', 'order', false, false);
	}

	public static function in_Save() {
		global $espcms_web_templates, $espcms_command;
		$member_app_config = ESPCMS_Core::get_app_config('member', false);

		if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
			ESPCMS_Dialog::Message_Page('repeat_inut', OrderLink::get_order_link('list'));
		}
		if ($member_app_config['isetup'] && $member_app_config['isopen']) {
			if (static::$order_con['ORDER_ISMEMBER']) {
				ESPCMS_MemberAuthority::authorityWebVerify(false, $member_app_config['appconfig'], OrderLink::get_order_link('list'));
			}
			$member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
			$member_read = ESPCMS_MemberDB::get_member_view($member_cookie_info['userid']);
		}

		if (!is_array($_POST['products_id']) || !is_array($_POST['product_item_qty']) || count($_POST['products_id']) < 1 || count($_POST['product_item_qty']) < 1 || count($_POST['products_id']) != count($_POST['product_item_qty'])) {
			ESPCMS_Dialog::Message_Page('order_cart_empty', OrderLink::get_order_link('list'));
		}

		$product_total = 0;
		foreach ($_POST['products_id'] as $key => $did) {
			if (!$did || !espcms_ismatches($did)) {
				continue;
			}
			$bprice = ESPCMS_ArticleDB::get_article_read($did, 'bprice');

			$num = $_POST['product_item_qty'][$key] && espcms_ismatches($_POST['product_item_qty'][$key]) ? $_POST['product_item_qty'][$key] : 0;

			$countprice = espcms_ismoney($bprice) && $num ? $bprice * $num : 0;

			$product_total = $product_total + $countprice;
		}
		if ($product_total != $_POST['productmoney']) {
			ESPCMS_Dialog::Message_Page('db_err', OrderLink::get_order_link('list'));
		}
		$_POST['addtime'] = time();
		$_POST['updatetime'] = 0;
		$_POST['islock'] = 0;
		if (static::$order_con['ORDER_SN']) {
			$_POST['ordersn'] = espcms_random(static::$order_con['ORDER_SN']);
		}
		$_POST['order_source'] = 'web';
		$_POST['ordertype'] = 1;
		$_POST['ispay'] = 0;
		$_POST['isshipping'] = 0;
		$_POST['userid'] = espcms_ismatches($_POST['userid']) && $_POST['userid'] ? $_POST['userid'] : 0;
		$_POST['isinvoice'] = espcms_ismatches($_POST['isinvoice']) ? $_POST['isinvoice'] : 0;
		$_POST['paytype'] = espcms_ismatches($_POST['paytype']) && $_POST['paytype'] ? $_POST['paytype'] : 1;
		if (static::$order_con['ORDER_ISOPID'] && espcms_ismatches($_POST['osid'])) {
			$_POST['osid'] = $_POST['osid'];
			$_POST['shiptype'] = 1;
		} else {
			$_POST['shiptype'] = 2;
			$_POST['osid'] = espcms_ismatches($_POST['osid']) && $_POST['osid'] ? $_POST['osid'] : 0;
		}
		if (!espcms_ismoney($_POST['productmoney']) || !espcms_isemail($_POST['email'])) {
			ESPCMS_Dialog::Message_Page('input_err', OrderLink::get_order_link('list'));
		}
		unset($_POST['opid'], $_POST['paytime'], $_POST['updatetime'], $_POST['shippingtime'], $_POST['shippingsn'], $_POST['paysn'], $_POST['country'], $_POST['treatnote']);

		$shippingmoney = ESPCMS_OrderDB::get_express_view($_POST['osid'], 'price');
		$_POST['shippingmoney'] = $shippingmoney && espcms_ismoney($shippingmoney) ? $shippingmoney : 0;

		$_POST['paymoney'] = 0;

		$coupon_app_config = ESPCMS_Core::get_app_config('coupon', false);
		if (static::$order_con['ORDER_ISMEMBER'] && $member_app_config['isetup'] && $member_app_config['isopen'] && $coupon_app_config['isetup'] && $coupon_app_config['isopen'] && $_POST['ocdsn']) {

			$discount = ESPCMS_CouponDB::CheckCoupon($_POST['userid'], $_POST['products_id'], $_POST['products_tid'], $_POST['ocdsn'], $_POST['productmoney']);
			$_POST['discount'] = espcms_ismoney($discount) ? $discount : 0;
			$coupon_isuser = $discount > 0 ? true : false;
		} else {
			$coupon_isuser = false;

			$_POST['discount'] = 0;
		}
		$orderamount = $_POST['shippingmoney'] + $_POST['productmoney'];

		$_POST['invoicefeemoney'] = $_POST['isinvoice'] && static::$order_con['ORDER_INVOICE_FEE'] && espcms_ismatches(static::$order_con['ORDER_INVOICE_FEE']) ? (static::$order_con['ORDER_INVOICE_FEE'] / 100) * $orderamount : 0;
		$_POST['invoicefeemoney'] = round($_POST['invoicefeemoney'], 2);
		$_POST['orderamount'] = $_POST['shippingmoney'] + $_POST['productmoney'] + $_POST['invoicefeemoney'] - $_POST['discount'];
		$_POST['orderamount'] = round($_POST['orderamount'], 2);

		$integral_price = $_POST['productmoney'] - $_POST['discount'];
		$_POST['integral'] = static::$order_con['ORDER_INTEGRAL'] && espcms_ismatches(static::$order_con['ORDER_INTEGRAL']) ? intval(static::$order_con['ORDER_INTEGRAL'] * $integral_price) : 0;
		$_POST['consignee'] = $_POST['consignee'] ? htmlspecialchars($_POST['consignee']) : '';
		$_POST['country'] = $_POST['country'] ? htmlspecialchars($_POST['country']) : '';
		$_POST['province'] = $_POST['province'] ? htmlspecialchars($_POST['province']) : '';
		$_POST['city'] = $_POST['city'] ? htmlspecialchars($_POST['city']) : '';
		$_POST['address'] = $_POST['address'] ? htmlspecialchars($_POST['address']) : '';
		$_POST['zipcode'] = $_POST['zipcode'] ? htmlspecialchars($_POST['zipcode']) : '';
		$_POST['tel'] = $_POST['tel'] ? htmlspecialchars($_POST['tel']) : '';
		$_POST['content'] = $_POST['content'] ? htmlspecialchars($_POST['content']) : '';
		$_POST['invcontent'] = $_POST['invcontent'] ? htmlspecialchars($_POST['invcontent']) : '';
		$_POST['companysn'] = $_POST['companysn'] ? htmlspecialchars($_POST['companysn']) : '';
		$_POST['invpayee'] = $_POST['invpayee'] ? htmlspecialchars($_POST['invpayee']) : '';
		$_POST['treatnote'] = $_POST['treatnote'] ? htmlspecialchars($_POST['treatnote']) : '';

		$db_table = ESPCMS_DB_PREFIX . "order";
		$talbe_field_array = espcms_field_out($db_table, true);
		$postvalue = espcms_post($_POST, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			ESPCMS_Dialog::Message_Page('dba_read_err', OrderLink::get_order_link('list'));
		}
		$install_id = espcms_db_install_save($db_table, $postvalue);
		if (!$install_id) {
			ESPCMS_Dialog::Message_Page('save_err', OrderLink::get_order_link('list'));
		}

		if ($coupon_isuser) {
			ESPCMS_CouponDB::update_coupon_list_isuser($install_id, $_POST['userid'], false, $_POST['ocdsn']);
		}

		if ($_POST['paytype'] == 2) {
			$pay_plug_list = defined('ESPCMS_WEB_TYPE')  && ESPCMS_WEB_TYPE == 'WAP'? ESPCMS_OrderDB::get_pay_plug_list(false, 1, 1) : ESPCMS_OrderDB::get_pay_plug_list(false, 1, 0);
			foreach ($pay_plug_list as $key => $value) {
				$value['oid'] = $install_id;
				$pay_plug_list[$key]['pay_link'] = OrderLink::get_order_payweb_link('pay_link', $value);
			}
			$espcms_web_templates->into('pay_plug_list', $pay_plug_list);
		}

		ESPCMS_OrderDB::order_install_goods($install_id, $_POST);

		espcms_set_cookie('espcms_buy_order_info', false);
		if ($member_app_config['isetup'] && $member_app_config['isopen']) {
			$member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
			$espcms_web_templates->into('member', $member_cookie_info);
		}

		if ($espcms_command['EMAIL_ISOPEN'] && static::$order_con['ORDER_ISEMAIL']) {
			$_POST['oid'] = $install_id;
			$_POST['addtime'] = espcms_timeformat($_POST['addtime'], 3);
			if ($member_read['isemail'] && espcms_isemail($member_read['email'])) {
				ESPCMS_SendMessage::send_email_key_message('order_new_verify', $member_read['email'], $_POST);
			}
			ESPCMS_SendMessage::send_email_key_message('order_system_new_verify', $espcms_command['ADMINE_MAIL'], $_POST);
		}

		if ($espcms_command['SMS_ISOPEN'] && static::$order_con['ORDER_ISMOBLIE']) {
			$_POST['oid'] = $install_id;
			$_POST['addtime'] = espcms_timeformat($_POST['addtime'], 3);
			if ($member_read['ismoblie'] && espcms_ismoblie($member_read['mobile'])) {
				ESPCMS_SendMessage::send_moblie_sms_message('order_new_verify', $member_read['mobile'], $_POST);
			}
			ESPCMS_SendMessage::send_moblie_sms_message('order_system_new_verify', $espcms_command['SMS_MOBLIE_NB'], $_POST);
		}
		$espcms_web_templates->into('member_app', $member_app_config);
		$order_read['oid'] = $install_id;
		$espcms_web_templates->into('order_link', OrderLink::get_order_link(false, $order_read));
		$espcms_web_templates->into('member_order_link', OrderLink::order_member_link());
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('read', $_POST);
		$espcms_web_templates->into('out', 'edit_buyok');
		$espcms_web_templates->into('path', 'order');
		$espcms_web_templates->into('order_con', static::$order_con);
		$espcms_web_templates->output('member/order', 'order', false, false);
	}

	public static function in_DelOrder() {
		$did = $_POST['did'];
		$deltype = $_POST['deltype'];
		if ((!$did || !espcms_ismatches($did)) && $deltype == 'd') {
			exit('false');
		}
		if ($deltype == 'a') {
			$session_id = espcms_set_cookie('espcms_buy_order_info', '');
			if ($session_id) {
				exit('true');
			} else {
				exit('false');
			}
		} else {

			$espcms_buy_order_info = $_COOKIE['espcms_buy_order_info'];
			if ($espcms_buy_order_info) {
				$order_cookie_read = espcms_decrypt($espcms_buy_order_info, ESPCMS_ENCRYPT_CODE);
				$order_cookie_array = $order_cookie_read ? unserialize($order_cookie_read) : array();
			}
			unset($order_cookie_array[$did]);
			$save_cookie = serialize($order_cookie_array);

			$session_id = espcms_set_cookie('espcms_buy_order_info', espcms_encrypt($save_cookie, ESPCMS_ENCRYPT_CODE), 108000);
			if ($session_id) {
				exit('true');
			} else {
				exit('false');
			}
		}
	}

	public static function in_Pay() {
		global $espcms_web_templates;
		$oid = $_GET['oid'];
		$paycode = $_GET['paycode'];
		if (!$oid || !espcms_ismatches($oid) || !$paycode || !espcms_isact($paycode, "/^[\w]+$/i")) {
			ESPCMS_Dialog::Message_Page('db_err');
		}
		$pay_file = ESPCMS_FILE_ROOT . 'espcms_includes/payment/' . $paycode . '.php';
		if (!is_file($pay_file)) {
			ESPCMS_Dialog::Message_Page('order_paplug_err', OrderLink::get_order_link('list'));
		}
		$pay_plug_read = ESPCMS_OrderDB::get_pay_plug_code_view($paycode);
		$pay_argument = $pay_plug_read['pluglist'] ? unserialize($pay_plug_read['pluglist']) : false;
		if (!$pay_argument || !is_array($pay_argument)) {
			ESPCMS_Dialog::Message_Page('order_paycode_err', OrderLink::get_order_link('list'));
		}
		$order_read = ESPCMS_OrderDB::get_order_view($oid);
		if (!$order_read || !is_array($order_read)) {
			ESPCMS_Dialog::Message_Page('order_read_err', OrderLink::get_order_link('list'));
		}
		if ($order_read['ordertype'] == 0) {
			ESPCMS_Dialog::Message_Page('order_type_cancellation', OrderLink::get_order_link('list'));
		}
		if ($order_read['ispay'] > 0) {
			ESPCMS_Dialog::Message_Page('order_type_havepay', OrderLink::get_order_link('list'));
		}

		$order_read['return_url'] = OrderLink::get_order_pay_link('return_url', $_GET);

		$order_read['notify_url'] = OrderLink::get_order_pay_link('notify_url', $_GET);

		$notify_key[] = 'AsyncUpdate';
		$notify_key[] = $paycode;
		$notify_key[] = $order_read['oid'];

		$pay_link = ESPCMS_OrderDB::get_paylink($paycode, $order_read, $pay_argument, $notify_key);

		if (!$pay_link) {
			ESPCMS_Dialog::Message_Page('order_paycode_err', OrderLink::get_order_link('list'));
		}
	
		if ($pay_plug_read['isqrcode']) {

			$pay_pic = ESPCMS_Core::connect_url('GetQRCode', array('code' => urlencode($pay_link), 'w' => 300, 'h' => 300));
		} else {

			header("location:" . $pay_link);
			exit;
		}
		
		$espcms_web_templates->into('order_link', OrderLink::get_order_link(false, $order_read));
		$espcms_web_templates->into('member_order_link', OrderLink::order_member_link());
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('pay_pic', $pay_pic);
		$espcms_web_templates->into('read', $order_read);
		$espcms_web_templates->into('path', 'order');
		$espcms_web_templates->output('member/pay_weixin', 'order', false, false);
	}

	public static function in_PayOk() {
		global $espcms_web_templates;
		$oid = $_GET['oid'];
		if (!$oid || !espcms_ismatches($oid)) {
			ESPCMS_Dialog::Message_Page('db_err');
		}
		$order_read = ESPCMS_OrderDB::get_order_view($oid);
		if (!$order_read || !is_array($order_read)) {
			ESPCMS_Dialog::Message_Page('order_read_err', OrderLink::get_order_link('list'));
		}
		if ($order_read['ordertype'] == 0) {
			ESPCMS_Dialog::Message_Page('order_type_cancellation', OrderLink::get_order_link('list'));
		}
		if (!$order_read['ispay']) {
			$pay_plug_list = defined('ESPCMS_WEB_TYPE') && ESPCMS_WEB_TYPE == 'WAP' ? ESPCMS_OrderDB::get_pay_plug_list(false, 1, 1) : ESPCMS_OrderDB::get_pay_plug_list(false, 1, 0);
			foreach ($pay_plug_list as $key => $value) {
				$value['oid'] = $oid;
				$pay_plug_list[$key]['pay_link'] = OrderLink::get_order_payweb_link('pay_link', $value);
			}
			$espcms_web_templates->into('pay_plug_list', $pay_plug_list);
		}
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if ($member_app_config['isetup'] && $member_app_config['isopen']) {
			$member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
			$espcms_web_templates->into('member', $member_cookie_info);
		}
		$espcms_web_templates->into('member_app', $member_app_config);
		$espcms_web_templates->into('order_link', OrderLink::get_order_link(false, $order_read));
		$espcms_web_templates->into('member_order_link', OrderLink::order_member_link());
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('read', $order_read);
		$espcms_web_templates->into('out', $order_read['ispay'] ? 'pay_ok' : 'pay_no');
		$espcms_web_templates->into('path', 'order');
		$espcms_web_templates->into('order_con', static::$order_con);
		$espcms_web_templates->output('member/order', 'order', false, false);
	}

	public static function in_PayTypeRead() {
		$oid = $_GET['oid'];
		$order_read = ESPCMS_OrderDB::get_order_view($oid);
		if (!$order_read || !is_array($order_read)) {
			exit('false');
		}
		if ($order_read['ispay'] == 1) {
			exit('true');
		} else {
			exit('false');
		}
	}

	public static function in_JsOrder() {
		global $espcms_web_templates, $espcms_command;
		$espcms_web_templates->libfile = true;

		$db_table = ESPCMS_DB_PREFIX . 'document';

		$espcms_buy_order_info = $_COOKIE['espcms_buy_order_info'];
		if ($espcms_buy_order_info) {
			$order_cookie_read = espcms_decrypt($espcms_buy_order_info, ESPCMS_ENCRYPT_CODE);
			$order_cookie_array = $order_cookie_read ? unserialize($order_cookie_read) : array();
		}
		if (is_array($order_cookie_array) && count($order_cookie_array) > 0) {
			$did_array = espcms_array_findkey($order_cookie_array, 'did');
			$did_list = is_array($did_array) && espcms_array_ismatches($did_array) ? implode(',', $did_array) : false;
			if (!$did_list) {
				ESPCMS_Dialog::Message_Page('order_cart_empty');
			}
			$db_where = espcms_ismatches($did_list) ? " AND isclass=1 AND isorder=1 AND did=$did_list" : " AND isclass=1 AND isorder=1 AND did IN ($did_list)";

			$product_total = 0;
			$talbe_field_array = espcms_field_out($db_table);
			$list_array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, 'pid,did DESC');
			if (!is_array($list_array)) {
				ESPCMS_Dialog::Message_Page('order_cart_empty');
			}
			foreach ($list_array as $key => $value) {
				$list_array[$key]['ctitle'] = empty($value['color']) ? $value['title'] : "<font color='" . $value['color'] . "'>" . $value['title'] . "</font>";
				$list_array[$key]['link'] = ArticleLink::doc_link($value);
				$num = $order_cookie_array[$value['did']]['num'];
				$countprice = espcms_ismoney($value['bprice']) && espcms_ismatches($num) ? $value['bprice'] * $num : 0;
				$list_array[$key]['countprice'] = $countprice;
				$list_array[$key]['amount'] = $num;
				$product_total = $product_total + $countprice;
			}
			$espcms_web_templates->into('array', $list_array);
			$espcms_web_templates->into('count', count($list_array));
			$espcms_web_templates->into('product_total', $product_total);
			$espcms_web_templates->into('order_link', OrderLink::get_order_link());

			$order_integral = static::$order_con['ORDER_INTEGRAL'] && espcms_ismatches(static::$order_con['ORDER_INTEGRAL']) ? static::$order_con['ORDER_INTEGRAL'] * $product_total : 0;
			$espcms_web_templates->into('order_integral', $order_integral);
		}

		$filename = $_GET['file'] ? $_GET['file'] : 'order';
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('order_link', OrderLink::get_order_link());
		$output = $espcms_web_templates->fetch('lib/' . $filename);
		$outHTML = addslashes($output);
		$textArray = preg_split('/[\r\n]/i', $outHTML);
		if (is_array($textArray)) {
			$outHTML = null;
			foreach ($textArray as $key => $value) {
				$outHTML .= 'document.write("' . $value . '");';
			}
			exit($outHTML);
		} else {
			exit('document.writeln("' . $outHTML . '")');
		}
	}

}
