<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

use application\ESPCMS_Core;
use modul_application\ESPCMS_ArticleDB;
use modul_application\ESPCMS_ArticleTypeDB;
use modul_application\ESPCMS_AdvertisementDB;
use inc_application\link\ArticleLink;

class lib_bann {

	public static function call_bann($parameter, $filename = 'bann', $outHTML = null) {
		global $espcms_db_cache;
		$espcms_lib_template = espcms_web_template();
		$espcms_lib_template->libfile = true;
		$para = espcms_array_getvalue($parameter);
		if (!espcms_ismatches($para['atid']) || !$para['atid']) {
			return false;
		}
		if (!espcms_ismatches($para['adtype']) && $para['adtype']) {
			return false;
		}
		$app_config = ESPCMS_Core::get_app_config('advertisement', false);
		if (!$app_config['isetup'] || !$app_config['isopen']) {
			return false;
		}
		$atid = $para['atid'];
		$limit = espcms_ismatches($para['max']) && $para['max'] ? $para['max'] : 10;
		$db_table = ESPCMS_DB_PREFIX . 'advert';
		$talbe_field_array = espcms_field_out($db_table);
		$db_where = " AND isclass=1 AND atid=$atid";
		if (espcms_ismatches($para['adtype']) && $para['adtype']) {
			$db_where .= " AND adtype=" . $para['adtype'];
		}
		$type_read = ESPCMS_AdvertisementDB::get_advertisement_type_view($atid);
		if (!$type_read) {
			return false;
		}
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $atid . '_' . $para['adtype'] . '_' . $para['max'];
		$bann_array = false;
		if (!$bann_array) {
			$time = time();
			$list_array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, 'pid,adid DESC', '0,' . $limit);
			if (is_array($list_array)) {
				foreach ($list_array as $value) {
					if ($value['istime'] && ($value['starttime'] > $time || $value['endtime'] < $time)) {
						continue;
					}
					if (espcms_ismatches($value['gotoid']) && $value['gotoid'] && $value['islink'] == 2) {
						$doc_read = ESPCMS_ArticleDB::get_article_read($value['gotoid']);
						$value['link'] = ArticleLink::doc_link($doc_read);
						$value['url'] = $value['link'];
					} elseif (espcms_ismatches($value['gotoid']) && $value['gotoid'] && $value['islink'] == 3) {
						$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($value['gotoid']);
						if (!$type_read || !$type_read['isclass']) {
							continue;
						}
						$type_goto_read = $type_read['gotoid'] && espcms_ismatches($type_read['gotoid']) ? ESPCMS_ArticleTypeDB::get_article_type_view($type_read['gotoid']) : $type_read;
						$value['link'] = ArticleLink::type_link($type_goto_read);
						$value['url'] = $value['link'];
					} elseif (espcms_ismatches($value['gotoid']) && $value['gotoid'] && $value['islink'] == 4) {
						$sub_read = ESPCMS_ArticleTypeDB::get_article_subjectlist_view($value['gotoid']);
						if (!$sub_read || !$sub_read['isclass']) {
							continue;
						}
						$value['link'] = ArticleLink::subtype_link($sub_read);
						$value['url'] = $value['link'];
					} else {
						$value['link'] = $value['url'];
					}
					$bann_array[] = $value;
				}
			}
			$espcms_db_cache->cacheSave($cache_key, $bann_array);
		}
		$espcms_lib_template->into('array', $bann_array);
		$espcms_lib_template->into('type', $type_read);
		$espcms_lib_template->into('para', $para);
		if (!empty($outHTML)) {
			$output = $espcms_lib_template->fetch(null, null, $outHTML);
		} else {
			$output = $espcms_lib_template->fetch('lib/' . $filename);
		}
		return $output;
	}

}
