<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_Core;
use modul_application\ESPCMS_ArticleDB;
use modul_application\ESPCMS_ArticleTypeDB;
use inc_application\link\ArticleLink;
use inc_application\link\OrderLink;
use inc_application\link\EnquiryLink;

class lib_bread {

	public static function call_bread($parameter, $filename = 'bread', $outHTML = null) {
		$espcms_lib_template = espcms_web_template();
		$espcms_lib_template->libfile = true;
		$para = espcms_array_getvalue($parameter);
		if (!espcms_ismatches($para['tid']) || !$para['tid']) {
			return false;
		}
		$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($para['tid']);
		if (!$type_read) {
			return false;
		}

		if (espcms_ismatches($type_read['gotoid']) && $type_read['gotoid']) {
			$did = ESPCMS_ArticleTypeDB::get_article_type_view($type_read['gotoid'], 'linkid');
		} else {
			$did = $type_read['linkid'];
		}
		if (!espcms_ismatches($did) || !$did) {
			return false;
		}
		$doc_read = ESPCMS_ArticleDB::get_article_read($did);
		if (!$doc_read) {
			return false;
		}

		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		$enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
		$doc_read['ctitle'] = empty($doc_read['color']) ? $doc_read['title'] : "<span style='color:" . $doc_read['color'] . "'>" . $doc_read['title'] . "</span>";
		$doc_read['ishtml'] = $type_read['pageclass'] == 2 ? 2 : $doc_read['ishtml'];
		$doc_read['typename'] = $type_read['typename'];
		$doc_read['typelink'] = ArticleLink::type_link($type_read);
		$doc_read['pageclass'] = $type_read['pageclass'];
		$doc_read['link'] = ArticleLink::doc_link($doc_read);
		if ($order_app_config['isetup'] && $order_app_config['isopen']) {
			$doc_read['buylink'] = OrderLink::get_order_link('buy', $doc_read);
		}
		if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
			$doc_read['enqlink'] = EnquiryLink::get_enquiry_link('into', $doc_read);
		}
		$doc_content = ESPCMS_ArticleDB::get_article_content_read($did, 'content');
		if ($doc_content) {
			$doc_read['content'] = htmlspecialchars_decode($doc_content);
		}
		$attr_read = ESPCMS_ArticleDB::get_article_attr_read($did);
		$read = is_array($attr_read) ? array_merge($doc_read, $attr_read) : $doc_read;
		$espcms_lib_template->into('read', $read);
		$espcms_lib_template->into('para', $para);
		if (!empty($outHTML)) {
			$output = $espcms_lib_template->fetch(null, null, $outHTML);
		} else {
			$output = $espcms_lib_template->fetch('lib/' . $filename);
		}
		return $output;
	}

}
