jQuery.fn.float = function(settings) {
	if (typeof settings == "object") {
		settings = jQuery.extend({
			delay: 1000,
			offset: {
				left: 5,
				right: 5,
				top: 0,
				bottom: 0
			},
			style: null, //样式
			width: 200, //宽度
			height: 200, //高度
			position: "rm" //位置
		}, settings || {});
		var winW = $(window).width();
		var winH = $(window).height();
		function getPosition($applyTo, position) {
			var _pos = null;
			switch (position) {
				case "rm" :
					$applyTo.data("offset", "right");
					$applyTo.data("offsetPostion", settings.offset.right);
					_pos = {
						right: settings.offset.right,
						top: winH / 2 - $applyTo.innerHeight() / 2
					};
					break;
				case "lm" :
					$applyTo.data("offset", "left");
					$applyTo.data("offsetPostion", settings.offset.left);
					_pos = {
						left: settings.offset.left,
						top: winH / 2 - $applyTo.innerHeight() / 2
					};
					break;
				case "rb" :
					_pos = {
						right: settings.offset.right,
						top: winH - $applyTo.innerHeight()
					};
					break;
				case "lb" :
					_pos = {
						left: settings.offset.left,
						top: winH - $applyTo.innerHeight()
					};
					break;
				case "l" :
					_pos = {
						left: settings.offset.left,
						top: settings.offset.top
					};
					break;
				case "r" :
					_pos = {
						right: settings.offset.right,
						top: settings.offset.top
					};
					break;
				case "t" :
					$applyTo.data("offset", "top");
					$applyTo.data("offsetPostion", settings.offset.top);
					_pos = {
						left: settings.offset.left,
						top: settings.offset.top
					};
					break;
				case "b" :
					$applyTo.data("offset", "bottom");
					$applyTo.data("offsetPostion", settings.offset.bottom);
					_pos = {
						left: settings.offset.left,
						top: winH - $applyTo.innerHeight()
					};
					break;
			}
			return _pos;
		}
		function setPosition($applyTo, position, isUseAnimate) {
			var scrollTop = $(window).scrollTop();
			var scrollLeft = $(window).scrollLeft();
			var _pos = getPosition($applyTo, position);
			_pos.top += scrollTop;
			isUseAnimate && $applyTo.stop().animate(_pos, settings.delay) || $applyTo.css(_pos);
		}
		return this.each(function() {
			var $this = $(this);
			$this.css("position", "absolute");
			settings.style && $this.css(settings.style);
			setPosition($this, settings.position);
			$(this).data("isAllowScroll", true);
			$(window).scroll(function() {
				$this.data("isAllowScroll") && setPosition($this, settings.position, true);
			});
		})
	} else {
		var speed = arguments.length > 1 && arguments[1] || "fast";
		this.each(function() {
			if (settings == "clearOffset") {
				var _c = {};
				if ($(this).data("offset")) {
					_c[$(this).data("offset")] = 0;
					$(this).data("isAllowScroll", false);
					$(this).stop().animate(_c, speed);
				}
			} else if (settings == "addOffset") {
				var _c = {};
				if ($(this).data("offset") && $(this).data("offsetPostion")) {
					_c[$(this).data("offset")] = $(this).data("offsetPostion");
					$(this).stop().animate(_c, speed);
					$(this).data("isAllowScroll", true);
				}
			} else if (settings == "setScrollDisable") {
				$(this).data("isAllowScroll", false);
			} else if (settings == "setScrollUsable") {
				$(this).data("isAllowScroll", true);
			}
		})
	}
}
function closeim() {
	addCookie('ImisCloseType', 1, 0)
	$('#right-float-box').removeClass().addClass('displaynone');
	$('#float-bottom').removeClass().addClass('displaynone');
}
function cookie(name) {
	var cookieArray = document.cookie.split("; ");
	var cookie = new Object();
	for (var i = 0; i < cookieArray.length; i++) {
		var arr = cookieArray[i].split("=");
		if (arr[0] == name) {
			return unescape(arr[1]);
		}
	}
	return null;
}
function addCookie(objName, objValue, objHours) {
	var str = objName + "=" + escape(objValue);
	if (objHours > 0) {
		var date = new Date();
		var ms = objHours * 3600 * 1000;
		date.setTime(date.getTime() + ms);
		str += "; expires=" + date.toGMTString();
	}
	document.cookie = str;
}
function SetCookie(name, value) {
	var Days = 30;
	var exp = new Date();
	exp.setTime(exp.getTime() + Days * 24 * 60 * 60 * 1000);
	document.cookie = name + "=" + escape(value) + ";expires=" + exp.toGMTString();
}
function delCookie(name) {
	var exp = new Date();
	exp.setTime(exp.getTime() - 1);
	var cval = getCookie(name);
	if (cval != null) {
		document.cookie = name + "=" + cval + ";expires=" + exp.toGMTString();
	}
}
