<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

use application\ESPCMS_AdminAuthority;
use admin_application\AdminPublicDB;
use admin_application\link\SettingLink;

class AdminUser {

	public function __construct() {
		$exclude_method = array('saveAdminUser', 'editPassword', 'selectMember', 'verifyAdminUser');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function listAdminUser() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {

			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;

			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;

			$admin_isclass = $_REQUEST['admin_isclass'];
			if (espcms_ismatches($admin_isclass)) {
				$db_where .= " AND admin_isclass=$admin_isclass";
			}
			$admin_isremote = $_REQUEST['admin_isremote'];
			if (espcms_ismatches($admin_isremote)) {
				$db_where .= " AND admin_isremote=$admin_isremote";
			}

			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}

			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('admin_member_id');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "admin_member_id";
			}

			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['isdel'] = $admin_member_id == $fetch_row['admin_member_id'] ? 0 : 1;
				$fetch_row['log'] = SettingLink::AdminLog_link_array('index', $fetch_row);
				$fetch_row['edit'] = SettingLink::AdminUser_link_array('edit', $fetch_row);
				$fetch_row['power_groups_name'] = AdminPublicDB::get_power_groups_view($fetch_row['power_groups_id'], 'power_groups_name');
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'admin/admin_member_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', SettingLink::AdminUser_link_array(false, $_REQUEST));
			$templates = 'admin/admin_member_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addAdminUser() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$get_power_groups_list = AdminPublicDB::get_power_groups_list(0, 'ASC');
		$espcms_admin_templates->into('power_groups_list', $get_power_groups_list);
		$espcms_admin_templates->into('link', SettingLink::AdminUser_link_array());

		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/admin_member_add');
	}

	public static function editAdminUser() {
		global $espcms_admin_templates;
		$admin_member_id = $_GET['admin_member_id'];
		if (!$admin_member_id || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$db_where = " WHERE admin_member_id=$admin_member_id";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$get_power_groups_list = AdminPublicDB::get_power_groups_list($read['power_groups_id'], 'ASC');
		$espcms_admin_templates->into('power_groups_list', $get_power_groups_list);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', SettingLink::AdminUser_link_array());

		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/admin_member_edit');
	}

	public static function selectAdminUser() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$search_key = rtrim($_GET['search_key']);
		if (!isset($search_key) || empty($search_key) || strlen($search_key) < 2) {
			exit(espcms_lan_pack('public_pack-espcms_input_parameter_fail'));
		}

		$search_keyname_array = array('admin_username', 'admin_email', 'admin_name');
		$search_keyname = $_REQUEST['search_keyname'] && in_array($_REQUEST['search_keyname'], $search_keyname_array) ? $_REQUEST['search_keyname'] : 'admin_username';
		if (isset($search_key) && !empty($search_key)) {
			$db_where .= "admin_username LIKE '%$search_key%' OR admin_email LIKE '%$search_key%' OR admin_name LIKE '%$search_key%'";
		}
		$db_sql = "SELECT admin_username,admin_email,admin_member_id,admin_name FROM $db_table WHERE $db_where ORDER BY admin_member_id DESC LIMIT 0,10";
		$db_query = $espcms_link_db->db_query($db_sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$array[] = $fetch_row;
		}
		$espcms_admin_templates->into('array', $array);
		$espcms_admin_templates->output('admin/admin_member_dropdown');
	}

	public static function editPassword() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$db_where = " WHERE admin_member_id=$admin_member_id";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', SettingLink::AdminUser_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/admin_password_edit');
	}

	public static function saveAdminUser() {

		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';

		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$talbe_field_array = espcms_field_out($db_table, true);
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addAdminUser')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			if (!espcms_ismatches($_POST['power_groups_id']) || !espcms_ismatches($_POST['admin_isremote']) || !espcms_ismatches($_POST['admin_sex'])) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['power_groups_id']));
			}
			if ($_POST['admin_password'] && $_POST['admin_password'] == $_POST['validation_password']) {
				$_POST['admin_password'] = md5($_POST['admin_password']);
			} else {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['admin_password']));
			}

			$_POST['admin_intotime'] = time();

			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue) {
				$install_id = espcms_db_install_save($db_table, $postvalue);
				if (!$install_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			espcms_log_install('setting_pack-espcms_admin_member_button_add', $_POST['admin_username']);
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_admin_member_add_save_ok_message', 'true', array($_POST['admin_username']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editAdminUser')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			if (!espcms_ismatches($_POST['power_groups_id']) || !espcms_ismatches($_POST['admin_isremote']) || !espcms_ismatches($_POST['admin_sex'])) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['power_groups_id']));
			}
			$admin_member_id = $_POST['admin_member_id'];
			if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($admin_member_id));
			}
			if (empty($_POST['admin_password'])) {
				unset($_POST['admin_password']);
			} else {
				if ($_POST['admin_password'] != $_POST['validation_password']) {
					espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_admin_member_validation_password_validation_msg', 'false');
				}
				$_POST['admin_password'] = md5($_POST['admin_password']);
			}

			$db_where = "WHERE admin_member_id=$admin_member_id";
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue && is_array($postvalue)) {
				$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);

				if (!$update_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {

				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			espcms_log_install('setting_pack-espcms_admin_member_button_edit', $_POST['admin_username']);

			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_admin_member_edit_save_ok_message', 'true', array($_POST['admin_username']));
		} elseif ($saveType == 'editpassword') {

			$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
			if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($admin_member_id));
			}
			$db_where = "WHERE admin_member_id=$admin_member_id";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($admin_member_id));
			}
			if ($_POST['admin_old_password']) {
				$_POST['admin_old_password'] = md5($_POST['admin_old_password']);
			} else {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['admin_old_password']));
			}
			if ($_POST['admin_old_password'] != $read['admin_password']) {
				espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_admin_member_edit_password_err1', 'false');
			}
			if ($_POST['admin_password'] && $_POST['admin_password'] == $_POST['validation_password']) {
				$_POST['admin_password'] = md5($_POST['admin_password']);
			} else {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['admin_password']));
			}
			$update_id = espcms_db_update_set_save($db_table, $db_where, "admin_password='$_POST[admin_password]'");
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			espcms_log_install('setting_pack-espcms_admin_member_edit_password', $read['admin_username']);
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_admin_member_edit_password_ok_message', 'true', array($read['admin_username']));
		}
	}

	public static function setAdminUser() {
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];

		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}

		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}

		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$talbe_field_array = espcms_field_out($db_table, true);
		$isavlue = false;
		foreach ($talbe_field_array as $key => $value) {
			if ($value['Field'] == $field) {
				$isavlue = true;
			}
		}
		if (!$isavlue) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}

		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE admin_member_id=$value", "$field='$field_value'");
			if ($update_key) {
				$update_count++;
			}
		}
		$admin_member_id = implode(', ', $select_id);
		espcms_log_install('setting_pack-espcms_admin_member_button_set', "$field=$field_value" . " admin_member_id=" . $admin_member_id);

		espcms_public_dialog('info_set_ok', 'setting_pack-espcms_admin_member_set_message', 'true', array($field));
	}

	public static function delAdminUser() {
		$select_id = $_POST['select_id'];

		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}

		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delAdminUserDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$admin_member_id = implode(', ', $select_id);
		espcms_log_install('setting_pack-espcms_admin_member_button_del', $admin_member_id);

		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_admin_member_del_message', 'true', array(), 'json', $return);
	}

	public static function delAdminUserDB($admin_member_id = 0) {
		if (!$admin_member_id || !espcms_ismatches($admin_member_id)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $admin_member_id);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$talbe_field_array = espcms_field_out($db_table, true);
		$db_where = " WHERE admin_member_id=$admin_member_id";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $admin_member_id);
			return $return_array;
		}
		$del_query = espcms_db_del($db_table, 'admin_member_id', $admin_member_id);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $admin_member_id);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $admin_member_id);
			return $return_array;
		}
	}

	public static function verifyAdminUser() {

		$verifyKey = $_REQUEST['verify_key'];

		$verifyValue = $_REQUEST['verify_value'];

		$verifyType = $_REQUEST['verifyType'];

		$field_array = array('admin_username', 'admin_email');
		if (!isset($verifyKey) && !in_array($verifyKey, $field_array)) {
			$renturn_value = 'false';
		}
		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$admin_member_id = intval($_REQUEST['admin_member_id']);
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			$db_where = $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
		} else {
			$db_where = $verifyType ? " AND $verifyKey!='$verifyValue' AND admin_member_id!=$admin_member_id" : " AND $verifyKey='$verifyValue' AND admin_member_id!=$admin_member_id";
		}
		$db_num = espcms_db_num($db_table, $db_where);
		exit($db_num);
	}

}
