<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use modul_application\ESPCMS_ArticleCreateDB;
use admin_application\ArticleModelDB;
use admin_application\ArticleTypeDB;
use admin_application\AdminPublicDB;
use admin_application\link\CreateMainLink;

class CreateHtmlArticleType {

	public function __construct() {
		$exclude_method = array('saveCreateHtmlArticleType', 'loadCreateWindow', 'countCreateHtmlArticleType', 'ajaxArticleType');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function indexBase() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$lng = AdminPublicDB::get_lancode();
		$lng_array = ESPCMS_Core::get_lan_list($lng, false);
		$espcms_admin_templates->into('lng_array', $lng_array);

		$model_list = ArticleModelDB::get_model_list();
		$espcms_admin_templates->into('model_list', $model_list);
		$espcms_admin_templates->into('link', CreateMainLink::CreateType_link_array());
		$espcms_admin_templates->output('create/create_type');
	}

	public static function loadCreateWindow() {
		global $espcms_admin_templates;
		if (!$_GET['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_GET['lng'])) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($_GET['lng']));
		}
		if (!$_GET['mid'] || !espcms_ismatches($_GET['mid'])) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($_GET['mid']));
		}
		if ($_GET['tid'] && !espcms_ismatches($_GET['tid'])) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($_GET['tid']));
		}
		if (!espcms_ismatches($_GET['createtype'])) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($_GET['createtype']));
		}
		$espcms_admin_templates->into('lng', $_GET['lng']);
		$espcms_admin_templates->into('mid', $_GET['mid']);
		$espcms_admin_templates->into('tid', $_GET['tid']);
		$espcms_admin_templates->into('createtype', $_GET['createtype']);
		$espcms_admin_templates->into('link', CreateMainLink::CreateType_link_array());
		$espcms_admin_templates->output('create/create_type_load');
	}

	public static function saveCreateHtmlArticleType() {



		if (!$_POST['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_POST['lng'])) {
			espcms_public_dialog('espcms_public_dialog', 'create_pack-espcms_create_lng_validation_msg', 'false');
		}
		if (!$_POST['tid'] || !espcms_ismatches($_POST['tid'])) {
			espcms_public_dialog('espcms_public_dialog', 'create_pack-espcms_create_tid_validation_msg', 'false');
		}
		$creat_result = ESPCMS_ArticleCreateDB::create_type_html($_POST['tid'], $_POST['lng']);
		if (!$creat_result) {
			espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_type_save_no_message', 'false');
		} else {
			espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_type_save_ok_message', 'true');
		}
	}

	public static function countCreateHtmlArticleType() {
		if (!$_POST['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_POST['lng'])) {
			return false;
		}
		$lng = $_POST['lng'] == 'big5' ? 'cn' : $_POST['lng'];
		$mid = $_POST['mid'] && espcms_ismatches($_POST['mid']) ? $_POST['mid'] : 0;
		$tid = $_POST['tid'];
		$createtype = $_POST['createtype'];
		if ($createtype) {
			if (espcms_ismatches($tid) && $tid) {
				$tid_array = ArticleTypeDB::get_article_type_listDB($tid, $lng, $mid);
				if (is_array($tid_array)) {
					$tid_list = implode('_', array_keys($tid_array));
				}
			} else {
				$tid_array = ArticleTypeDB::get_article_type_listDB(0, $lng, $mid);
				if (is_array($tid_array)) {
					$tid_list = implode('_', espcms_array_findkey($tid_array, 'tid'));
				}
			}
			$create_num = count($tid_array);
		} elseif (!$createtype && espcms_ismatches($tid) && $tid) {
			$create_num = 1;
			$tid_list = $tid;
		} elseif (!$createtype && !$tid) {
			$create_num = 0;
			$tid_list = '';
		}
		espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_type_num', 'true', array($create_num), 'json', array('num' => $create_num, 'tid' => $tid_list));
	}

	public static function ajaxArticleType() {
		if (!$_GET['mid'] || !espcms_ismatches($_GET['mid'])) {
			return false;
		}
		if (!$_GET['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_GET['lng'])) {
			return false;
		}
		$_GET['lng'] = $_GET['lng'] == 'big5' ? 'cn' : $_GET['lng'];
		$article_type_array = ArticleTypeDB::get_article_type_list(0, 0, $_GET['mid'], false, $_GET['lng']);
		$title = espcms_lan_pack('create_pack-espcms_create_tid_title');
		$data_validation_msg = espcms_lan_pack('create_pack-espcms_create_tid_validation_msg');
		if (is_array($article_type_array)) {
			$option_str = '<select class="selectpicker form-control" name="tid" id="tid" data-size="8" data-isvalidation="true" title="' . $title . '" data-validation="^[1-9]{1}[0-9]*$" data-validation-msg="' . $data_validation_msg . '">';
			foreach ($article_type_array as $key => $value) {
				$option_str .= '<option value="' . $value['tid'] . '" class="' . $value['classname'] . '" data-icon="' . $value['icon'] . '">' . $value['typename'] . '</option>';
			}
			$option_str .= '</select>';
		}
		exit($option_str);
	}

}
