<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030

 */
use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use modul_application\ESPCMS_ArticleCreateDB;
use admin_application\AdminPublicDB;
use admin_application\link\CreateMainLink;
class CreateHtmlIndex {
	public function __construct() {
		$exclude_method = array('saveCreateHtmlIndex', 'getCreateHtmlIndex');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}
	public static function indexBase() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$lng = AdminPublicDB::get_lancode();
		$lng_array = ESPCMS_Core::get_lan_list($lng, false);
		$espcms_admin_templates->into('lng_array', $lng_array);
		$espcms_admin_templates->into('link', CreateMainLink::CreateIndex_link_array());
		$espcms_admin_templates->output('create/create_index');
	}
	public static function saveCreateHtmlIndex() {
		if (!$_POST['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_POST['lng'])) {
			espcms_public_dialog('espcms_public_dialog', 'create_pack-espcms_create_lng_validation_msg', 'false', array($_POST['lng']));
		}
		define("ESPCMS_WEB_LAN", $_POST['lng']);
		$creat_result = ESPCMS_ArticleCreateDB::creat_index_html($_POST['lng']);
		if (!$creat_result) {
			espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_index_save_no_message', 'false', array($_POST['lng']));
		} else {
			espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_index_save_ok_message', 'true', array($_POST['lng']));
		}
	}
	public static function getCreateHtmlIndex() {
		global $espcms_command;
		if (!$_POST['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_POST['lng'])) {
			return false;
		}
		$lng = $_POST['lng'];
		$lan_read = ESPCMS_Core::get_lan_view($lng);
		$lan_dirname = $lan_read['ispack'] && $lan_read['packname'] ? $lan_read['packname'] : $lan_read['lng'];
		$html_dir = !$espcms_command['IS_HTMLDIR'] ? '/' : '/' . $espcms_command['FILE_HTMLDIR'];
		if (!$espcms_command['IS_ALONELNG']) {
			$html_creat_path = $espcms_command['HOME_LNG'] == $lng ? $html_dir : $html_dir . $lan_dirname . '/';
		} else {
			$html_creat_path = $html_dir . $lan_dirname . '/';
		}
		$creat_file = $html_creat_path . $espcms_command['ENTRANCE_FILE'] . '.html';
		echo $creat_file;
	}
}
