<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\AdminPublicDB;
use admin_application\link\TemplatesLink;
use admin_application\link\ErrPageLink;

class ErrPageCreat {

    public function __construct() {
        $exclude_method = array('indexErrPageCreat', 'saveErrPageCreat');
        ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
        if (!ESPCMS_AdminAuthority::authorityVerify('editSetting')) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
        }
    }

    public static function indexErrPageCreat() {
        global $espcms_admin_templates;
        $db_table = ESPCMS_DB_PREFIX . "config";
        $db_where_404 = " WHERE config_name='ERRPAGE_404'";
        $read_404 = espcms_db_read($db_table, $db_where_404, 'config_value', true);
        if (!$read_404) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($db_where_404));
        }
        $db_where_500 = " WHERE config_name='ERRPAGE_500'";
        $read_500 = espcms_db_read($db_table, $db_where_500, 'config_value', true);
        if (!$read_500) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($db_where_500));
        }
        $espcms_admin_templates->into('ERRPAGE_404', $read_404['config_value']);
        $espcms_admin_templates->into('ERRPAGE_500', $read_500['config_value']);
        $espcms_admin_templates->into('link', ErrPageLink::ErrPage_link_array());
        $espcms_admin_templates->into('templates_select', TemplatesLink::TemplateFile_link_array('select'));
        $espcms_admin_templates->output('admin/errpage_creat');
    }

    public static function saveErrPageCreat() {
        global $espcms_link_db, $espcms_command;
        $db_table = ESPCMS_DB_PREFIX . "config";
        $file_404 = $_POST['ERRPAGE_404'];
        $file_500 = $_POST['ERRPAGE_500'];
        if (espcms_isact($file_404, "/^[\w]+$/i")) {
            $update_sql_404 = "UPDATE $db_table SET config_value='$file_404' WHERE config_name='ERRPAGE_404'";
        } else {
            $update_sql_404 = "UPDATE $db_table SET config_value='' WHERE config_name='ERRPAGE_404'";
        }
        $espcms_link_db->db_query($update_sql_404);
        if (espcms_isact($file_500, "/^[\w]+$/i")) {
            $update_sql_500 = "UPDATE $db_table SET config_value='$file_500' WHERE config_name='ERRPAGE_500'";
        } else {
            $update_sql_500 = "UPDATE $db_table SET config_value='' WHERE config_name='ERRPAGE_500'";
        }
        $espcms_link_db->db_query($update_sql_500);
        $lan = AdminPublicDB::get_lancode();
        define("ESPCMS_WEB_LAN", $lan);
        define("ESPCMS_CREAT", $lan);
        $html_dir = ESPCMS_FILE_ROOT;
        $espcms_web_templates = espcms_web_template($lan);
        if (espcms_isact($file_404, "/^[\w]+$/i")) {
            $file_html_403 = $html_dir . '403.html';
            $template_file_403 = 'public/' . $file_404;
            $html_start = $espcms_web_templates->output($template_file_403, '403_file', true, $file_html_403);
            if (!$html_start) {
                espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_errpage_no_message_404', 'false', array($template_file_403));
            }
        }
        if (espcms_isact($file_500, "/^[\w]+$/i")) {
            $file_html_500 = $html_dir . '500.html';
            $template_file_500 = 'public/' . $file_500;
            $html_start = $espcms_web_templates->output($template_file_500, '500_file', true, $file_html_500);
            if (!$html_start) {
                espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_errpage_no_message_500', 'false', array($template_file_500));
            }
        }
        espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_errpage_ok_message', 'true');
    }

}
