<?php
/*
  PHP version 5
  Copyright (c) 2002-2020 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\link\MemberLink;

class MemberType {
    private static $member_class_list_cache_key;
    private static $member_class_read_cache_key;

    public function __construct() {
        global $module_array;
        $exclude_method = array('saveMemberType', 'setMemberType', 'celeritySaveMemberType');
        ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if (!$member_app_config['isetup']) {
            espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
        }
        self::$member_class_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'member_class_';
        self::$member_class_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'member_class_';
    }

    public static function listMemberType() {
        global $espcms_admin_templates, $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . "member_class";
        $out_type = $_REQUEST['out_type'];
        if ($out_type == 'list') {
            $limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
            $per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
            $lockin = $_REQUEST['lockin'];
            if (espcms_ismatches($lockin) && $lockin) {
                $db_where .= " AND lockin=$lockin";
            }
            $isinter = $_REQUEST['isinter'];
            if (espcms_ismatches($isinter)) {
                $db_where .= " AND isinter=$isinter";
            }
            $isclass = $_REQUEST['isclass'];
            if (espcms_ismatches($isclass)) {
                $db_where .= " AND isclass=$isclass";
            }
            $searchlist = $_GET['searchlist'];
            if ($searchlist == 'true') {
                exit(espcms_page_db($db_table, $db_where, true));
            }
            $sort_key = $_REQUEST['sort_key'];
            $sort_key_array = array('mcid');
            if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
                $order_key = $sort_key;
            } else {
                $order_key = "mcid";
            }
            $sort_rank = $_REQUEST['sort_rank'];
            $sort_rank_array = array('ASC', 'DESC');
            if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
                $order_rank = $sort_rank;
            } else {
                $order_rank = "DESC";
            }
            $db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
            while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
                $fetch_row['view'] = MemberLink::Member_link_array('index', $fetch_row);
                $fetch_row['edit'] = MemberLink::MemberType_link_array('edit', $fetch_row);
                $array[] = $fetch_row;
            }
            $espcms_admin_templates->into('array', $array);
            $templates = 'member/member_type_list';
        } else {
            $espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
            $espcms_admin_templates->into('link', MemberLink::MemberType_link_array(false, $_REQUEST));
            $templates = 'member/member_type_index';
        }
        $espcms_admin_templates->output($templates);
    }

    public static function addMemberType() {
        global $espcms_admin_templates;
        $espcms_admin_templates->into('link', MemberLink::MemberType_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('member/member_type_add');
    }

    public static function editMemberType() {
        global $espcms_admin_templates;
        $mcid = $_GET['mcid'];
        if (!$mcid || !espcms_ismatches($mcid)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($mcid));
        }
        $db_table = ESPCMS_DB_PREFIX . "member_class";
        $db_where = " WHERE mcid=$mcid";
        $talbe_field_array = espcms_field_out($db_table, false);
        $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
        }
        $espcms_admin_templates->into('read', $read);
        $espcms_admin_templates->into('link', MemberLink::MemberType_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('member/member_type_edit');
    }

    public static function saveMemberType() {
        global $espcms_db_cache;
        if (!is_token($_POST['token_name'], $_POST['token_key'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
        }
        $saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
        $db_table = ESPCMS_DB_PREFIX . "member_class";
        $talbe_field_array = espcms_field_out($db_table, true);
        if (!espcms_ismatches($_POST['isinter']) || !$_POST['rankname']) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
        }
        if ($_POST['isinter'] && !espcms_ismatches($_POST['integra'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
        }
        if ($saveType == 'add') {
            if (!ESPCMS_AdminAuthority::authorityVerify('addMemberType')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            unset($_POST['isclass']);
            $_POST['lockin'] = 0;
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $espcms_db_cache->cacheDEL(self::$member_class_list_cache_key, true);
            espcms_log_install('member_pack-espcms_member_class_button_add', $_POST['rankname']);
            espcms_public_dialog('espcms_info_save_ok', 'member_pack-espcms_member_class_add_save_ok_message', 'true', array($_POST['rankname']));
        } elseif ($saveType == 'edit') {
            if (!ESPCMS_AdminAuthority::authorityVerify('editMemberType')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            $mcid = $_POST['mcid'];
            if (empty($mcid) || !espcms_ismatches($mcid)) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($mcid));
            }
            $db_where = "WHERE mcid=$mcid";
            $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($mcid));
            }
            unset($_POST['isclass'], $_POST['lockin']);
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
            if (!$update_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $espcms_db_cache->cacheDEL(self::$member_class_read_cache_key . $mcid);
            $espcms_db_cache->cacheDEL(self::$member_class_list_cache_key, true);
            espcms_log_install('member_pack-espcms_member_class_button_edit', $_POST['rankname']);
            espcms_public_dialog('espcms_info_save_ok', 'member_pack-espcms_member_class_edit_save_ok_message', 'true', array($_POST['rankname']));
        }
    }

    public static function celeritySaveMemberType() {
        global $espcms_db_cache;
        if (!ESPCMS_AdminAuthority::authorityVerify('editMemberType')) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
        }
        $db_table = ESPCMS_DB_PREFIX . "member_class";
        $talbe_field_array = espcms_field_out($db_table, true);
        $mcid = $_POST['mcid'];
        if (empty($mcid) || !espcms_ismatches($mcid)) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($mcid));
        }
        $db_where = "WHERE mcid=$mcid";
        $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($mcid));
        }
        unset($_POST['lockin']);
        unset($_POST['isclass']);
        unset($_POST['isinter']);
        unset($_POST['integra']);
        $postvalue = espcms_post($_POST, $talbe_field_array, true);
        if (!$postvalue || !is_array($postvalue)) {
            espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
        }
        $update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
        if (!$update_id) {
            espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
        }
        $espcms_db_cache->cacheDEL(self::$member_class_read_cache_key . $mcid);
        $espcms_db_cache->cacheDEL(self::$member_class_list_cache_key, true);
        espcms_public_dialog('espcms_info_save_ok', 'member_pack-espcms_member_class_edit_save_ok_message', 'true', array($read['rankname']));
    }

    public static function setMemberType() {
        global $espcms_db_cache;
        if (!ESPCMS_AdminAuthority::authorityVerify('editMemberType')) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
        }
        $select_id = $_POST['select_id'];
        $field = $_POST['field'];
        $field_value = $_POST['field_value'];
        if (!is_array($select_id) || count($select_id) <= 0) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
        }
        if (!$field || !espcms_ismatches($field_value)) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
        }
        $db_table = ESPCMS_DB_PREFIX . "member_class";
        $talbe_field_array = espcms_field_out($db_table, true);
        $isavlue = false;
        foreach ($talbe_field_array as $key => $value) {
            if ($value['Field'] == $field) {
                $isavlue = true;
            }
        }
        if (!$isavlue) {
            espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
        }
        $update_count = 0;
        foreach ($select_id as $key => $value) {
            if (!espcms_ismatches($value)) {
                continue;
            }
            $update_key = espcms_db_update_set_save($db_table, "WHERE mcid=$value", "$field='$field_value'");
            if ($update_key) {
                $update_count++;
                $espcms_db_cache->cacheDEL(self::$member_class_read_cache_key . $value);
            }
        }
        $set_info_id = implode(', ', $select_id);
        $espcms_db_cache->cacheDEL(self::$member_class_list_cache_key, true);
        espcms_log_install('member_pack-espcms_member_class_button_set', "$field=$field_value" . " mcid=" . $set_info_id);
        espcms_public_dialog('info_set_ok', 'member_pack-espcms_member_class_set_message', 'true', array($field));
    }

    public static function delMemberType() {
        global $espcms_db_cache;
        $select_id = $_POST['select_id'];
        if (!is_array($select_id) || count($select_id) <= 0) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
        }
        $delcount = 0;
        foreach ($select_id as $value) {
            $operate_result = self::delMemberTypeDB($value);
            if ($operate_result['code'] == 'true') {
                $delcount++;
            }
        }
        $espcms_del_id = implode(', ', $select_id);
        $espcms_db_cache->cacheDEL(self::$member_class_list_cache_key, true);
        espcms_log_install('member_pack-espcms_member_class_button_del', $espcms_del_id);
        $return['count'] = $delcount;
        espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_class_del_message', 'true', array(), 'json', $return);
    }

    public static function delMemberTypeDB($mcid = 0) {
        if (!$mcid || !espcms_ismatches($mcid)) {
            $return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $mcid);
            return $return_array;
        }
        $db_table = ESPCMS_DB_PREFIX . "member_class";
        $del_query = espcms_db_del($db_table, 'mcid', $mcid);
        if ($del_query) {
            $return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $mcid);
            return $return_array;
        } else {
            $return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $mcid);
            return $return_array;
        }
    }
}
