<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_AdminAuthority;
use admin_application\link\WebSkinLink;

class WebSkin {

    private static $skin_list_cache_key;
    private static $skin_read_cache_key;

    public function __construct() {
        $exclude_method = array('saveWebSkin', 'verifyWebSkin');
        ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);

        self::$skin_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'skin_';
        self::$skin_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'skin_';
    }

    public static function listWebSkin() {
        global $espcms_admin_templates, $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . "skin";
        $out_type = $_REQUEST['out_type'];
        if ($out_type == 'list') {

            $limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;

            $per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
            $islockin = $_REQUEST['islockin'];
            if (espcms_ismatches($islockin)) {
                $db_where .= " AND islockin=$islockin";
            }
            $isclass = $_REQUEST['isclass'];
            if (espcms_ismatches($isclass)) {
                $db_where .= " AND isclass=$isclass";
            }

            $searchlist = $_GET['searchlist'];
            if ($searchlist == 'true') {
                exit(espcms_page_db($db_table, $db_where, true));
            }

            $sort_key = $_REQUEST['sort_key'];
            $sort_key_array = array('skid');
            if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
                $order_key = $sort_key;
            } else {
                $order_key = "skid";
            }

            $sort_rank = $_REQUEST['sort_rank'];
            $sort_rank_array = array('ASC', 'DESC');
            if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
                $order_rank = $sort_rank;
            } else {
                $order_rank = "DESC";
            }
            $db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
            while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
                $fetch_row['edit'] = WebSkinLink::WebSkin_link_array('edit', $fetch_row);
                $array[] = $fetch_row;
            }
            $espcms_admin_templates->into('array', $array);
            $templates = 'skin/skin_list';
        } else {
            $espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
            $espcms_admin_templates->into('link', WebSkinLink::WebSkin_link_array(false, $_REQUEST));
            $templates = 'skin/skin_index';
        }
        $espcms_admin_templates->output($templates);
    }

    public static function addWebSkin() {
        global $espcms_admin_templates;
        $espcms_admin_templates->into('link', WebSkinLink::WebSkin_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('skin/skin_add');
    }

    public static function saveWebSkin() {

        if (!is_token($_POST['token_name'], $_POST['token_key'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
        }
        $saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';

        $db_table = ESPCMS_DB_PREFIX . "skin";
        $talbe_field_array = espcms_field_out($db_table, true);
        if (!$_POST['skin_name']) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
        }
        $_POST['iswap'] = espcms_ismatches($_POST['iswap']) ? $_POST['iswap'] : 0;
        if (!preg_match('/^[\w]{2,50}$/i', $_POST['skin_code'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
        }
        if ($saveType == 'add') {
            if (!ESPCMS_AdminAuthority::authorityVerify('addWebSkin')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }

            if (self::verifyWebSkinDB('skin_code', $_POST['skin_code'])) {
                espcms_public_dialog('espcms_public_dialog', 'skin_pack-espcms_skin_formcode_warning_msg', 'false', array($_POST['skin_code']));
            }
            $_POST['islockin'] = 0;
            $_POST['isclass'] = 0;
            $_POST['addtime'] = time();
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            espcms_log_install('skin_pack-espcms_webskin_button_add', $_POST['skin_name']);
            espcms_public_dialog('espcms_info_save_ok', 'skin_pack-espcms_webskin_add_save_ok_message', 'true', array($_POST['skin_name']));
        }
    }

    public static function openWebSkin() {
        global $espcms_db_cache;
        $skid = $_POST['skid'];
        if (!$skid || !espcms_ismatches($skid)) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($skid));
        }
        $db_where = "WHERE skid=$skid";
        $db_table = ESPCMS_DB_PREFIX . 'skin';
        $talbe_field_array = espcms_field_out($db_table, false);
        $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read_info) {
            espcms_public_dialog('info_set_err', 'skin_pack-espcms_webskin_set_message_err1', 'false', array($skid));
        }
        $template_dir = ESPCMS_FILE_ROOT . 'templates/' . $read_info['skin_code'];
        if (!is_dir($template_dir)) {
            espcms_public_dialog('info_set_err', 'skin_pack-espcms_webskin_set_message_err1', 'false', array($skid));
        }

        $iswap = $read_info['iswap'];
        $update_key = espcms_db_update_set_save($db_table, "WHERE iswap=$iswap", "isclass=0");
        if ($update_key) {
            espcms_db_update_set_save($db_table, "WHERE skid=$skid", "isclass=1");
        }
        espcms_log_install('skin_pack-espcms_webskin_button_set', $skid);
        $cache_id = $iswap ? 'wap' : 'web';
        $espcms_db_cache->cacheDEL(self::$skin_read_cache_key . $cache_id);
        $espcms_db_cache->cacheDEL(self::$skin_list_cache_key, true);
        espcms_public_dialog('espcms_public_dialog', 'skin_pack-espcms_webskin_set_message', 'true', array(), 'json');
    }

    public static function delWebSkin() {
        $skid = $_POST['skid'];
        if (!$skid || !espcms_ismatches($skid)) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($skid));
        }
        self::delWebSkinDB($skid);
        espcms_log_install('skin_pack-espcms_webskin_button_del', $skid);
        espcms_public_dialog('espcms_public_dialog', 'skin_pack-espcms_webskin_del_message', 'true', array(), 'json');
    }

    private static function delWebSkinDB($skid = 0) {
        if (!$skid || !espcms_ismatches($skid)) {
            $return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $skid);
            return $return_array;
        }
        $db_table = ESPCMS_DB_PREFIX . "skin";
        $del_query = espcms_db_delall($db_table, "skid=$skid AND isclass=0");
        if (!$del_query) {
            $return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $skid);
            return $return_array;
        }
        $return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $skid);
        return $return_array;
    }

    public static function verifyWebSkin() {

        $verifyKey = $_REQUEST['verify_key'];

        $verifyValue = $_REQUEST['verify_value'];

        $verifyType = $_REQUEST['verifyType'];

        $skid = $_REQUEST['skid'];
        $db_num = self::verifyWebSkinDB($verifyKey, $verifyValue, $skid, $verifyType) ? '1' : '0';
        exit($db_num);
    }

    private static function verifyWebSkinDB($verifyKey, $verifyValue, $skid = 0, $verifyType = false) {

        $field_array = array('skin_code');
        if (!isset($verifyKey) && !in_array($verifyKey, $field_array)) {
            return true;
        }
        if (!$verifyValue) {
            return true;
        }
        $db_table = ESPCMS_DB_PREFIX . "skin";
        if (empty($skid) || !espcms_ismatches($skid)) {
            $db_where .= $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
        } else {
            $db_where .= $verifyType ? " AND $verifyKey!='$verifyValue' AND skid!=$skid" : " AND $verifyKey='$verifyValue' AND skid!=$skid";
        }
        $db_num = espcms_db_num($db_table, $db_where);
        return $db_num > 0 ? true : false;
    }

}
