<?php
/*
  PHP version 5
  Copyright (c) 2002-2020 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/
namespace admin_application;
use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Change;
use application\ESPCMS_FileTool;
class FileDB {
    public static function get_filedir_listDB($in_filedir_id = 0, $filedir_id = 0, $level = 0) {
        global $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . 'filedir';
        $db_sql = "SELECT c.filedir_id,c.filedir_lastid,c.filedir_pid,c.filedir_name,COUNT(a.filedir_id) AS has_c FROM $db_table AS c LEFT JOIN $db_table AS a ON a.filedir_lastid = c.filedir_id  GROUP BY c.filedir_id ORDER BY c.filedir_lastid,c.filedir_pid,c.filedir_id";
        $db_query = $espcms_link_db->db_query($db_sql);
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $array[] = $fetch_row;
        }
        if ($filedir_id > 0) {
            foreach ($array as $key => $value) {
                $array[$key]['selected'] = ($filedir_id == $value['filedir_id']) ? 'selected' : '';
            }
        }
        $out_category_array = ESPCMS_Change::has_category($in_filedir_id, $array, 'filedir_id', 'filedir_lastid');
        if (is_array($out_category_array)) {
            foreach ($out_category_array as $key => $value) {
                $out_category_array[$key]['classname'] = 'opt_three_' . $value['level'];
                $out_category_array[$key]['icon'] = $value['has_c'] > 0 ? 'espcms_icon_fa espcms_icon_fa-chevron-circle-down text-orange' : 'espcms_icon_fa espcms_icon_fa-chevron-circle-right text-danfei';
            }
        }
        if ($level > 0) {
            if ($in_filedir_id == 0) {
                $end_level = $level;
            } else {
                $first_item = reset($out_category_array);
                $end_level = $first_item['level'] + $level;
            }
            foreach ($out_category_array AS $key => $val) {
                if ($val['level'] >= $end_level) {
                    unset($out_category_array[$key]);
                }
            }
        }
        return $out_category_array;
    }
    public static function saveFile($saveFile = array(), $filedir_id = 0) {
        if (!is_array($saveFile) || !$saveFile['size']) {
            return false;
        }
        $db_table = ESPCMS_DB_PREFIX . "file";
        $talbe_field_array = espcms_field_out($db_table, true);
        $talbe_value = array();
        $admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
        $talbe_value['admin_member_id'] = $admin_member_id && espcms_ismatches($admin_member_id) ? $admin_member_id : 0;
        $talbe_value['filedir_id'] = espcms_ismatches($filedir_id) ? $filedir_id : 0;
        $talbe_value['file_title'] = $saveFile['filename'];
        $talbe_value['file_filename'] = $saveFile['upLoadFileName_nopath'];
        $talbe_value['file_ext'] = $saveFile['extension'];
        $talbe_value['file_type'] = $saveFile['upfiletype'];
        $talbe_value['file_path'] = $saveFile['path'];
        $talbe_value['file_size'] = $saveFile['size'] && espcms_ismatches($saveFile['size']) ? $saveFile['size'] : 0;
        $talbe_value['file_iswidth'] = $saveFile['iswidth'];
        $talbe_value['file_addtime'] = $saveFile['ctime'] && espcms_ismatches($saveFile['ctime']) ? $saveFile['ctime'] : time();
        $talbe_value['file_isclass'] = 1;
        $postvalue = espcms_post($talbe_value, $talbe_field_array, true);
        if ($postvalue) {
            $install_id = espcms_db_install_save($db_table, $postvalue);
        }
        return $install_id;
    }
    public static function getFileDir($filedir_id = false, $return_key = false) {
        if (!$filedir_id || !espcms_ismatches($filedir_id)) {
            return false;
        }
        $db_where = "WHERE filedir_id=$filedir_id";
        $db_table = ESPCMS_DB_PREFIX . "filedir";
        $talbe_field_array = espcms_field_out($db_table, false);
        $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read_info) {
            return false;
        }
        return !$return_key ? $read_info : $read_info[$return_key];
    }
    public static function getSearchFile($file_filename = false, $file_path = false, $return_key = false) {
        if (!$file_filename || !$file_path) {
            return false;
        }
        $db_where = "WHERE file_filename='$file_filename' AND file_path='$file_path'";
        $db_table = ESPCMS_DB_PREFIX . "file";
        $talbe_field_array = espcms_field_out($db_table, false);
        $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read_info) {
            return false;
        }
        return !$return_key ? $read_info : $read_info[$return_key];
    }
    public static function getSearchDir($filedir_name = false, $filedir_lastid = 0, $return_key = false) {
        if (!$filedir_name || !espcms_ismatches($filedir_lastid)) {
            return false;
        }
        $db_where = "WHERE filedir_lastid=$filedir_lastid AND filedir_dirname='$filedir_name'";
        $db_table = ESPCMS_DB_PREFIX . "filedir";
        $talbe_field_array = espcms_field_out($db_table, false);
        $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read_info) {
            return false;
        }
        return !$return_key ? $read_info : $read_info[$return_key];
    }
    public static function getSearchPathDir($filedir_path = false, $return_key = false) {
        if (!$filedir_path || !preg_match("/^[\w\-\/]{2,}$/i", $filedir_path)) {
            return false;
        }
        $db_where = "WHERE filedir_path='$filedir_path'";
        $db_table = ESPCMS_DB_PREFIX . "filedir";
        $talbe_field_array = espcms_field_out($db_table, false);
        $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read_info) {
            return false;
        }
        return !$return_key ? $read_info : $read_info[$return_key];
    }
    public static function import_fileDirDB($filedir_name, $filedir_lastid = 0, $filedir_path = false) {
        if (!$filedir_name || !$filedir_path) {
            return false;
        }
        $db_table = ESPCMS_DB_PREFIX . "filedir";
        $talbe_field_array = espcms_field_out($db_table, true);
        $install_post['filedir_lastid'] = espcms_ismatches($filedir_lastid) ? $filedir_lastid : 0;
        $install_post['filedir_name'] = $filedir_name;
        $install_post['filedir_path'] = $filedir_path;
        $install_post['filedir_dirname'] = $filedir_name;
        $install_post['filedir_addtime'] = time();
        $install_post['filedir_isdir'] = 1;
        $postvalue = espcms_post($install_post, $talbe_field_array, true);
        $install_id = espcms_db_install_save($db_table, $postvalue);
        if (!$install_id) {
            return false;
        }
        return $install_id;
    }
    public static function saveImportDir($dir_name = false) {
        if (!$dir_name || !preg_match("/^[\w\-\/]{2,}$/i", $dir_name)) {
            return false;
        }
        $dir_level = explode('/', $dir_name);
        $filedir_lastid = 0;
        if (!is_array($dir_level)) {
            return false;
        }
        $filedir_path = '';
        foreach ($dir_level as $key => $value) {
            if (!$value) {
                continue;
            }
            if ($key == 0) {
                $filedir_path = $value;
            } else {
                $filedir_path = $filedir_path . '/' . $value;
            }
            $filedir_id = self::getSearchDir($value, $filedir_lastid, 'filedir_id');
            if (!$filedir_id) {
                $filedir_lastid = FileDB::import_fileDirDB($value, $filedir_lastid, $filedir_path);
            } else {
                $filedir_lastid = $filedir_id;
            }
        }
        return $filedir_lastid;
    }
    public static function import_fileDB($dir_path = false, $filedir_id = 0) {
        global $espcms_command;
        if (!$dir_path || !is_dir($dir_path) || !espcms_ismatches($filedir_id)) {
            return false;
        }
        $upfile_dir = $espcms_command['UPFILE_SAVAPATH'] ? $espcms_command['UPFILE_SAVAPATH'] : 'upfile/';
        $filePath = ESPCMS_FILE_ROOT . $upfile_dir;
        $dir_name = $filePath == $dir_path ? $upfile_dir . str_replace($filePath, '', $dir_path) : $upfile_dir . str_replace($filePath, '', $dir_path) . '/';
        $file_array = ESPCMS_FileTool::list_dir($dir_path, array(), 'allfile', false);
        if (!is_array($file_array) || !count($file_array)) {
            return false;
        }
        $save_key = 0;
        foreach ($file_array as $file_read) {
            if (!is_array($file_read) || !$file_read['basename'] || !$file_read['extension']) {
                continue;
            }
            if (!preg_match("/^[\w\-]+$/i", $file_read['filename'])) {
                $file_old = $file_read['filepath'];
                $file_new_name = md5($file_read['filename']);
                $file_read['basename'] = $file_new_name . '.' . $file_read['extension'];
                $file_read['filename'] = $file_new_name;
                $file_read['filepath'] = $file_read['dirname'] . '/' . $file_read['basename'];
                $file_rename_key = rename($file_old, $file_read['filepath']);
                if (!$file_rename_key) {
                    continue;
                }
            }
            $file_search_read = self::getSearchFile($file_read['basename'], $dir_name);
            if ($file_search_read['file_id'] && $file_search_read['filedir_id'] == $filedir_id) {
                continue;
            } elseif ($file_search_read['file_id'] && $file_search_read['filedir_id'] != $filedir_id) {
                $db_table = ESPCMS_DB_PREFIX . "file";
                $db_where = "WHERE file_id=" . $file_search_read['file_id'];
                espcms_db_update_set_save($db_table, $db_where, "filedir_id=$filedir_id");
            } else {
                $saveFile = array();
                $saveFile['filename'] = $file_read['basename'];
                $saveFile['upLoadFileName_nopath'] = $file_read['basename'];
                $saveFile['extension'] = $file_read['extension'];
                $saveFile['upfiletype'] = ESPCMS_FileTool::file_type_screen($file_read['extension']);
                $saveFile['path'] = $dir_name;
                $saveFile['size'] = filesize($file_read['filepath']);
                $saveFile['ctime'] = filectime($file_read['filepath']);
                if (self::saveFile($saveFile, $filedir_id)) {
                    $save_key++;
                }
            }
        }
        return $save_key;
    }
}
