<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

namespace modul_application;

class ESPCMS_AdvertisementDB {

	public static function get_advertisement_type_view($atid = 0, $return_key = false) {
		global $espcms_db_cache;
		if (!$atid || !espcms_ismatches($atid)) {
			return false;
		}
		$db_where = "WHERE atid=$atid";
		$db_table = ESPCMS_DB_PREFIX . 'advert_type';
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $atid;
		$read_info = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$read_info) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read_info) {
				return false;
			}
			$espcms_db_cache->cacheSave($cache_key, $read_info);
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_advertisement_type_list($lng = false, $atid = 0, $isclass = false) {
		global $espcms_db_cache;
		if (!$lng || !preg_match("/^[a-z0-9]{2,50}$/i", $lng)) {
			return false;
		}
		$db_where .= " AND lng='$lng'";
		if (espcms_ismatches($isclass)) {
			$db_where .= " AND isclass=$isclass";
		}
		$db_table = ESPCMS_DB_PREFIX . 'advert_type';
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $lng . '_' . $isclass;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$array) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "atid DESC");
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		if (is_array($array) && count($array) > 0 && $atid && espcms_ismatches($atid)) {
			foreach ($array as $key => $value) {
				$array[$key]['selected'] = ($atid == $value['atid']) ? 'selected' : '';
			}
		}
		return $array;
	}

}
