<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


namespace modul_application;

use application\ESPCMS_Core;
use inc_application\link\PublicLink;

class ESPCMS_MemberDB {

	public static function get_member_noatt_view($userid = 0, $return_key = false) {
		if (!$userid || !espcms_ismatches($userid)) {
			return false;
		}
		$db_where = "WHERE userid=$userid";
		$db_table = ESPCMS_DB_PREFIX . 'member';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_member_view($userid = 0, $return_key = false) {
		if (!$userid || !espcms_ismatches($userid)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'member';
		$db_table_member_value = ESPCMS_DB_PREFIX . 'member_value';
		$db_where = "WHERE " . $db_table . ".userid=$userid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$talbe_field_array_member_value = espcms_field_out($db_table_member_value, false, false, 'userid');
		$read_info = espcms_db_left_join_read($db_table, $db_table_member_value, $db_where, $talbe_field_array, $talbe_field_array_member_value, 'userid');
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_member_atrr_view($userid = 0, $return_key = false) {
		if (!$userid || !espcms_ismatches($userid)) {
			return false;
		}
		$db_where = "WHERE userid=$userid";
		$db_table = ESPCMS_DB_PREFIX . 'member_value';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_member_class_list($mcid = 0, $isclass = false) {
		global $espcms_db_cache;
		if (espcms_ismatches($isclass)) {
			$db_where = " AND isclass=$isclass";
		}
		$db_table = ESPCMS_DB_PREFIX . 'member_class';
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $isclass;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!is_array($array) || !count($array) > 0) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where);
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		foreach ($array as $key => $value) {
			if ($mcid == $value['mcid']) {
				$array[$key]['selected'] = 'selected';
			}
		}
		return $array;
	}

	public static function get_member_class_view($mcid = 0, $return_key = false) {
		global $espcms_db_cache;
		if (!$mcid || !espcms_ismatches($mcid)) {
			return false;
		}
		$db_where = "WHERE mcid=$mcid";
		$db_table = ESPCMS_DB_PREFIX . 'member_class';
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $mcid;
		$read_info = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$read_info) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read_info) {
				return false;
			}
			$espcms_db_cache->cacheSave($cache_key, $read_info);
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_member_class_array($mcid) {
		if (!preg_match("/^[\d]+[\d,]*$/i", $mcid) || !$mcid) {
			return false;
		}
		$db_where .= espcms_ismatches($mcid) ? " AND mcid=$mcid" : " AND mcid IN($mcid)";
		$db_table = ESPCMS_DB_PREFIX . 'member_class';
		$talbe_field_array = espcms_field_out($db_table, false);
		$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "mcid DESC");
		if (!is_array($array) || count($array) < 1) {
			return array();
		}
		return $array;
	}

	public static function get_member_attr($lng = false, $selectedid = true, $is_reg = false) {
		global $espcms_link_db, $espcms_db_cache;
		if (!$lng || !preg_match('/^[\w]+$/', $lng)) {
			return false;
		}
		$db_where = " AND isclass=1 AND isline=0 AND lng='$lng'";
		if ($is_reg) {
			$db_where .= ' AND isreg=1';
		}
		$db_table = ESPCMS_DB_PREFIX . "member_attr";
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $lng . '_' . $is_reg;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$array) {
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, 'pid,maid', 'ASC'));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$array[] = $fetch_row;
			}
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		if (is_array($array) && count($array) > 0) {
			foreach ($array as $att_id => $fetch_row) {
				if ($fetch_row['inputtype'] == 'select' || $fetch_row['inputtype'] == 'radio' || $fetch_row['inputtype'] == 'checkbox') {
					$forvalue = preg_split("/\n/", $fetch_row['attrvalue']);
					$newvalue = array();
					foreach ($forvalue as $key => $value) {
						if ($key == 0 && $selectedid) {
							$newvalue[] = array('name' => trim($value), 'selected' => 'selected');
						} else {
							$newvalue[] = array('name' => trim($value), 'selected' => '');
						}
					}
					$array[$att_id]['attrvalue'] = $newvalue;
				} elseif ($fetch_row['inputtype'] == 'addon' || $fetch_row['inputtype'] == 'img') {
					$array[$att_id]['uploadlink'] = PublicLink::get_fileupload('uploadlink', $fetch_row);
				}
			}
		}
		return $array;
	}

	public static function member_install_attr($lng, $userid, $postdb = array(), $is_update = false) {
		if (!$lng || !preg_match('/^[\w]+$/', $lng) || !espcms_ismatches($userid) || empty($userid) || !is_array($postdb) || count($postdb) < 1) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "member_value";
		$talbe_field_array = espcms_field_out($db_table, true);
		$att_array = self::get_member_attr($lng);
		if (!is_array($att_array) || count($att_array) <= 0) {
			return false;
		}
		$key_type = is_array($att_array) ? espcms_array_keytokey($att_array, 'attrname', 'inputtype') : array();
		if (is_array($key_type)) {
			foreach ($key_type as $key => $value) {
				if ($value == 'checkbox') {
					$postdb[$key] = $postdb[$key] ? $postdb[$key] : '';
				}
			}
		}
		foreach ($postdb as $key => $value) {
			if ($key_type[$key] == 'checkbox') {
				$postdb[$key] = is_array($value) ? implode(',', $value) : '';
			} elseif ($key_type[$key] == 'date' || $key_type[$key] == 'time' || $key_type[$key] == 'datetime') {
				$postdb[$key] = espcms_istime($value) || espcms_isdata($value) || preg_match("/^[\d]{1,2}:[\d]{1,2}$/i", $value) ? strtotime($value) : 0;
			} elseif ($key_type[$key] == 'int') {
				$postdb[$key] = espcms_ismatches($value) ? $value : 0;
			} elseif ($key_type[$key] == 'float' || $key_type[$key] == 'decimal') {
				$postdb[$key] = preg_match("/^[0-9.]+$/i", $value) ? $value : 0;
			} else {
				$postdb[$key] = $value ? htmlspecialchars($value) : '';
			}
		}
		$postdb['userid'] = $userid;
		$postvalue = espcms_post($postdb, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			return false;
		}
		if ($is_update) {
			$attr_read = self::get_member_atrr_view($userid);
			if ($attr_read || $attr_read['mvid']) {
				$db_where = "WHERE userid=$userid";
				$update_id = espcms_db_update_save($db_table, $db_where, $postvalue, array('userid'));
				if (!$update_id) {
					return false;
				}
				return $update_id;
			} else {
				$is_update = false;
			}
		}
		if (!$is_update) {
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				return false;
			}
			return $install_id;
		}
	}

	public static function member_login_save($userid = 0, $login_log_type = 1) {
		if (empty($userid) || !espcms_ismatches($userid)) {
			return false;
		}
		$db_table_user = ESPCMS_DB_PREFIX . "member";
		$db_where = "WHERE userid=$userid";
		$ip = real_remote_ip();
		$time = time();
		if ($login_log_type == 1) {
			$updateid = espcms_db_update_set_save($db_table_user, $db_where, "visitcount=visitcount+1,lasttime=$time,lastip='$ip'");
		} elseif ($login_log_type == 2) {
			$updateid = espcms_db_update_set_save($db_table_user, $db_where, "outtime=$time");
		}
		if (!$updateid) {
			return false;
		}
		return true;
	}

	public static function member_login_log_save($userid = 0) {
		if (empty($userid) || !espcms_ismatches($userid)) {
			return false;
		}
		$remoteip = real_remote_ip();
		$onlineip = ip_shift($remoteip);
		$onlineip = empty($onlineip) ? 0 : $onlineip;
		$db_table = ESPCMS_DB_PREFIX . "member_login";
		$talbe_field_array = espcms_field_out($db_table, true);
		$install_value_array = array();
		$install_value_array['userid'] = $userid;
		$install_value_array['login_time'] = time();
		$install_value_array['login_ip'] = $onlineip;
		$install_value_array['login_type'] = ESPCMS_WEB_TYPE;
		$install_value_array['login_content'] = $_SERVER['HTTP_USER_AGENT'];
		$install_value = espcms_post($install_value_array, $talbe_field_array, true);
		if (!espcms_db_install_save($db_table, $install_value)) {
			return false;
		}
		return true;
	}

	public static function member_integral_DB($userid, $member_integral = 0, $member_integral_type = 1) {
		if (!espcms_ismatches($userid) || !$userid || !espcms_ismatches($member_integral) || !$member_integral || !espcms_ismatches($member_integral_type)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "member";
		$db_where = "WHERE userid=$userid";
		$db_set = $member_integral_type == 2 ? "integral=integral-$member_integral" : "integral=integral+$member_integral";
		$update_id = espcms_db_update_set_save($db_table, $db_where, $db_set);
		if (!$update_id) {
			return false;
		}
		return $update_id;
	}

	public static function install_member_integral($userid, $member_integral = 0, $member_integral_type = 1, $member_integral_name = false) {
		if (!espcms_ismatches($userid) || !$userid || !espcms_ismatches($member_integral) || !$member_integral || !espcms_ismatches($member_integral_type)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "member_integral";
		$talbe_field_array = espcms_field_out($db_table, true);
		$app_read = ESPCMS_Core::get_app_config('member', true, 'appconfig');
		$install_value_array = array();
		$install_value_array['userid'] = $userid;
		if ($app_read['MEMBER_INTERGRALSN']) {
			$install_value_array['member_integral_sn'] = espcms_random($app_read['MEMBER_INTERGRALSN']);
		}
		$install_value_array['member_integral_addtime'] = time();
		$install_value_array['member_integral_ip'] = real_remote_ip();
		$install_value_array['member_integral_name'] = $member_integral_name;
		$install_value_array['member_integral'] = $member_integral;
		$install_value_array['member_integral_type'] = $member_integral_type;
		$install_value = espcms_post($install_value_array, $talbe_field_array, true);
		$install_id = espcms_db_install_save($db_table, $install_value);
		if (!$install_id) {
			return false;
		}
		return $install_id;
	}

	public static function update_member_info($userid, $postdb = array()) {
		if (!espcms_ismatches($userid) || !$userid || !is_array($postdb) || count($postdb) < 1) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "member";
		$talbe_field_array = espcms_field_out($db_table, true);
		$db_where = "WHERE userid=$userid";
		$postvalue = espcms_post($postdb, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			return false;
		}
		$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
		if (!$update_id) {
			return false;
		}
		return $update_id;
	}

}
