<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
 */

class ESPCMS_Mysql {
    var $dbcharset = 'utf8';
    var $sql_show_errors_info;
    var $php_current_version;
    private $dblink;
    private $dbname;
    private $dbhost;
    private $dbuser;
    private $dbpassword;
    private $return_type;

    function __construct($dbhost, $dbname, $dbuser, $dbpassword, $dbcharset, $return_type = true) {
        register_shutdown_function(array($this, '__destruct'));
        if (ESPCMS_DEBUG && ESPCMS_DISPLAY_EER) {
            $this->show_errors();
        }
        $this->php_current_version = phpversion();
        $this->dbhost = $dbhost;
        $this->dbname = $dbname;
        $this->dbuser = $dbuser;
        $this->dbpassword = $dbpassword;
        $this->dbcharset = $dbcharset;
        $this->return_type = $return_type;
        $this->db_connect();
    }

    public function show_errors($isshow = true) {
        $errors = $this->sql_show_errors_info;
        $this->sql_show_errors_info = $isshow;
        return $errors;
    }

    public function __destruct() {
        return true;
    }

    public function db_connect($pconnect = false) {
        $this->is_mysql = true;
        $new_link = defined('MYSQL_NEW_LINK') ? MYSQL_NEW_LINK : true;
        $client_flags = defined('MYSQL_CLIENT_FLAGS') ? MYSQL_CLIENT_FLAGS : 0;
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            if (ESPCMS_DEBUG) {
                $error_reporting = false;
                if (defined('E_DEPRECATED')) {
                    $error_reporting = error_reporting();
                    error_reporting($error_reporting ^ E_DEPRECATED);
                }
                $this->dblink = mysqli_connect($this->dbhost, $this->dbuser, $this->dbpassword);
                if (false !== $error_reporting) {
                    error_reporting($error_reporting);
                }
            } else {
                $this->dblink = mysqli_connect($this->dbhost, $this->dbuser, $this->dbpassword);
            }
            if (!$this->dblink) {
                if ($this->return_type) {
                    espcms_message_err('db_pack-espcms_db_connect_fail', array(htmlspecialchars($this->dbhost, ENT_QUOTES), htmlspecialchars($this->dbuser, ENT_QUOTES)));
                } else {
                    return false;
                }
            }
            mysqli_query($this->dblink, "SET sql_mode=''");
            mysqli_query($this->dblink, "SET character set 'utf8'");
            mysqli_query($this->dblink, "SET NAMES 'utf8'");
        } else {
            if (ESPCMS_DEBUG) {
                $error_reporting = false;
                if (defined('E_DEPRECATED')) {
                    $error_reporting = error_reporting();
                    error_reporting($error_reporting ^ E_DEPRECATED);
                }
                if ($pconnect) {
                    $this->dblink = mysql_pconnect($this->dbhost, $this->dbuser, $this->dbpassword);
                } else {
                    $this->dblink = mysql_connect($this->dbhost, $this->dbuser, $this->dbpassword, $new_link, $client_flags);
                }
                if (false !== $error_reporting) {
                    error_reporting($error_reporting);
                }
            } else {
                if ($pconnect) {
                    $this->dblink = mysql_pconnect($this->dbhost, $this->dbuser, $this->dbpassword);
                } else {
                    $this->dblink = mysql_connect($this->dbhost, $this->dbuser, $this->dbpassword, $new_link, $client_flags);
                }
            }
            if (!$this->dblink) {
                if ($this->return_type) {
                    espcms_message_err('db_pack-espcms_db_connect_fail', array(htmlspecialchars($this->dbhost, ENT_QUOTES), htmlspecialchars($this->dbuser, ENT_QUOTES)));
                } else {
                    return false;
                }
            }
            if ($this->db_version() > '4.1') {
                if ($this->dbcharset) {
                    mysql_query("SET character_set_connection=" . $this->dbcharset . ", character_set_results=" . $this->dbcharset . ",character_set_client=binary", $this->dblink);
                }
                if ($this->db_version() > '5.0.1') {
                    mysql_query("SET sql_mode=''", $this->dblink);
                }
            }
        }
        $this->ready = true;
        $this->db_select($this->dbname, $this->dblink);
    }

    public function db_select($dbname, $dblink = null) {
        if (is_null($dblink)) {
            $dblink = $this->dblink;
        }
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            if (!mysqli_select_db($dblink, $dbname)) {
                $this->ready = false;
                if ($this->return_type) {
                    espcms_message_err('db_pack-espcms_db_select_fail', array(htmlspecialchars($this->dbname, ENT_QUOTES), htmlspecialchars($this->dbuser, ENT_QUOTES)));
                } else {
                    return false;
                }
            }
        } else {
            if (!mysql_select_db($dbname, $dblink)) {
                $this->ready = false;
                if ($this->return_type) {
                    espcms_message_err('db_pack-espcms_db_select_fail', array(htmlspecialchars($this->dbname, ENT_QUOTES), htmlspecialchars($this->dbuser, ENT_QUOTES)));
                } else {
                    return false;
                }
            }
        }
    }

    public function db_version() {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return preg_replace('/[^0-9.].*/', '', mysqli_get_server_info($this->dblink));
        } else {
            return preg_replace('/[^0-9.].*/', '', mysql_get_server_info($this->dblink));
        }
    }

    public function db_query($sql, $type = 'qe', $is_requery = false) {
        if (!$sql) {
            return false;
        }
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            if (!($query = mysqli_query($this->dblink, $sql))) {
                if ($is_requery) {
                    return false;
                } else {
                    espcms_message_err('db_pack-espcms_db_query_fail', array(htmlspecialchars($sql, ENT_QUOTES)));
                }
            }
        } else {
            $func = ($type == 'un' && function_exists('mysql_unbuffered_query')) ? 'mysql_unbuffered_query' : 'mysql_query';
            if (!($query = $func($sql, $this->dblink))) {
                if ($is_requery) {
                    return false;
                } else {
                    espcms_message_err('db_pack-espcms_db_query_fail', array(htmlspecialchars($sql, ENT_QUOTES)));
                }
            }
        }
        return $query;
    }

    public function db_array_read($sql) {
        $query = $this->db_query($sql);
        return $this->db_array_list($query);
    }

    public function db_array_list($query) {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return mysqli_fetch_assoc($query);
        } else {
            return mysql_fetch_assoc($query);
        }
    }

    public function db_array($query, $array_type = null) {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return empty($array_type) ? mysqli_fetch_array($query) : mysqli_fetch_array($query, $array_type);
        } else {
            return empty($array_type) ? mysql_fetch_array($query) : mysql_fetch_array($query, $array_type);
        }
    }

    public function db_array_row($query) {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return mysqli_fetch_row($query);
        } else {
            return mysql_fetch_row($query);
        }
    }

    public function db_affected_rows() {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return mysqli_affected_rows($this->dblink);
        } else {
            return mysql_affected_rows($this->dblink);
        }
    }

    public function db_num_rows($query) {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return mysqli_num_rows($query);
        } else {
            return mysql_num_rows($query);
        }
    }

    public function db_num_fields($query) {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return mysqli_num_fields($query);
        } else {
            return mysql_num_fields($query);
        }
    }

    public function db_free_result($query) {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return mysqli_free_result($query);
        } else {
            return mysql_free_result($query);
        }
    }

    public function db_insert_id() {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return ($id = mysqli_insert_id($this->dblink)) >= 0 ? $id : $this->db_result($this->db_query("SELECT last_insert_id()"), 0);
        } else {
            return ($id = mysql_insert_id($this->dblink)) >= 0 ? $id : $this->db_result($this->db_query("SELECT last_insert_id()"), 0);
        }
    }

    public function db_result($query, $row) {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            mysqli_data_seek($query, $row);
            $row = mysqli_fetch_array($query);
            $query_now = $row[$field];
        } else {
            $query_now = mysql_result($query, $row);
        }
        return $query_now;
    }

    public function error() {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return mysqli_error($this->dblink);
        } else {
            return (($this->dblink) ? mysql_error($this->dblink) : mysql_error());
        }
    }

    public function errno() {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return mysqli_error($this->dblink);
        } else {
            return intval(($this->dblink) ? mysql_errno($this->dblink) : mysql_errno());
        }
    }

    public function db_fetch_fields($query) {
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return mysqli_fetch_field($query);
        } else {
            return mysql_fetch_field($query);
        }
    }

    public function db_close() {
        return version_compare('5.5.0', $this->php_current_version, '<') ? mysqli_close($this->dblink) : mysql_close($this->dblink);
    }

    public function db_real_escape_string($str) {
        if (!$str) {
            return false;
        }
        if (version_compare('5.5.0', $this->php_current_version, '<')) {
            return mysqli_real_escape_string($this->dblink, $str);
        } else {
            return mysql_real_escape_string($str);
        }
    }
}
