<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/



use application\ESPCMS_Core;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_MemberAuthority;
use modul_application\ESPCMS_SendMessage;
use inc_application\link\MemberLink;

class MemberMoblie {

	private static $member_read;
	private static $member_con;

	public function __construct() {
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		static::$member_con = unserialize($member_app_config['appconfig']);
		ESPCMS_MemberAuthority::authorityWebVerify();
		$member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
		static::$member_read = ESPCMS_MemberDB::get_member_view($member_cookie_info['userid']);
		if (!static::$member_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('quit'));
		}
	}
	public static function in_BindingMoblie() {
		global $espcms_web_templates, $espcms_command;
		if (!$espcms_command['SMS_ISOPEN'] || !static::$member_con['MEMBER_MOBLIE_VERIFY']) {
			ESPCMS_Dialog::Message_Page('sms_send_no', MemberLink::get_link('quit'), 'member_login_botton');
		}
		static::$member_read['rankname'] = ESPCMS_MemberDB::get_member_class_view(static::$member_read['mcid'], 'rankname');
		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('tokenkey', token('member_binding_moblie'));
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('member_con', static::$member_con);
		$espcms_web_templates->into('curCount', $espcms_command['SMS_VERIFICATION_INTERVAL_TIME'] && espcms_ismatches($espcms_command['SMS_VERIFICATION_INTERVAL_TIME']) ? $espcms_command['SMS_VERIFICATION_INTERVAL_TIME'] : 60);
		$espcms_web_templates->into('member', static::$member_read);
		$espcms_web_templates->into('path', 'member');
		$templates_file = static::$member_read['ismoblie'] ? 'member/member_binding_moblie_cancel' : 'member/member_binding_moblie';
		$espcms_web_templates->output($templates_file, 'member_binding_moblie', false, false);
	}
	public static function in_BindingMoblieSave() {
		global $espcms_command;
		$userid = static::$member_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('input_err', MemberLink::get_link('binding'));
		}
		if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
			ESPCMS_Dialog::Message_Page('repeat_inut', MemberLink::get_link('binding'));
		}
		if (!preg_match("/^[\d]{6}$/i", $_POST['mobliesn'])) {
			ESPCMS_Dialog::Message_Page('input_err', MemberLink::get_link('binding'));
		}
		$member_read = ESPCMS_MemberDB::get_member_noatt_view($userid);
		if (!$member_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('bangtin_moblie'));
		}
		$time = time();
		$verification_time = $member_read['mobliesntime'] + $espcms_command['SMS_VERIFICATION_TIME'];
		if ($verification_time < $time) {
			ESPCMS_Dialog::Message_Page('moblie_timeerr', MemberLink::get_link('binding'), 'bangtin_moblie');
		}
		if ($member_read['ismoblie']) {
			if ($_POST['mobliesn'] != $member_read['mobliesn'] || !$member_read['ismoblie']) {
				ESPCMS_Dialog::Message_Page('moblie_validate_err', MemberLink::get_link('binding'));
			}
			$db_table = ESPCMS_DB_PREFIX . 'member';
			$db_where = " WHERE userid=$userid AND ismoblie=1";
			$update_key = espcms_db_update_set_save($db_table, $db_where, "mobliesn='',mobliesntime=0,ismoblie=0,ismoblietime=0");
			if ($update_key) {
				$SAFETY_PASSWORD_TIME = espcms_ismatches(static::$member_con['MEMBER_SAFETY_PASSWORD_TIME']) && static::$member_con['MEMBER_SAFETY_PASSWORD_TIME'] > 0 ? static::$member_con['MEMBER_SAFETY_PASSWORD_TIME'] * 60 * 60 : 3600 * 24 * 30;
				$member_read['ismoblie'] = 0;
				$member_read['ismoblietime'] = 0;
				$session_id = espcms_set_cookie('espcms_web_user_info', espcms_encrypt($member_read, ESPCMS_ENCRYPT_CODE), $SAFETY_PASSWORD_TIME);
				if (!$session_id) {
					ESPCMS_Dialog::Message_Page('cookie_save_err', MemberLink::get_link('quit'), 'member_login_botton');
				}
				ESPCMS_Dialog::Message_Page('moblie_del_binding_ok', MemberLink::get_link('center'), 'member_center_botton');
			} else {
				ESPCMS_Dialog::Message_Page('moblie_del_binding_no', MemberLink::get_link('binding'));
			}
		} else {
			if ($_POST['mobliesn'] != $member_read['mobliesn'] || $member_read['ismoblie']) {
				ESPCMS_Dialog::Message_Page('moblie_validate_err', MemberLink::get_link('binding'));
			}
			$db_table = ESPCMS_DB_PREFIX . 'member';
			$db_where = " WHERE userid=$userid AND ismoblie=0";
			$update_key = espcms_db_update_set_save($db_table, $db_where, "mobliesn='',mobliesntime=0,ismoblie=1,ismoblietime=$time");
			if ($update_key) {
				$SAFETY_PASSWORD_TIME = espcms_ismatches(static::$member_con['MEMBER_SAFETY_PASSWORD_TIME']) && static::$member_con['MEMBER_SAFETY_PASSWORD_TIME'] > 0 ? static::$member_con['MEMBER_SAFETY_PASSWORD_TIME'] * 60 * 60 : 3600 * 24 * 30;
				$member_read['ismoblie'] = 1;
				$member_read['ismoblietime'] = $time;
				$session_id = espcms_set_cookie('espcms_web_user_info', espcms_encrypt($member_read, ESPCMS_ENCRYPT_CODE), $SAFETY_PASSWORD_TIME);
				if (!$session_id) {
					ESPCMS_Dialog::Message_Page('cookie_save_err', MemberLink::get_link('quit'), 'member_login_botton');
				}
				ESPCMS_Dialog::Message_Page('moblie_binding_ok', MemberLink::get_link('center'), 'member_center_botton');
			} else {
				ESPCMS_Dialog::Message_Page('moblie_binding_no', MemberLink::get_link('binding'));
			}
		}
	}
	public static function in_VerMoblieCode() {
		global $espcms_command;
		$userid = static::$member_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($userid));
		}
		$member_read = ESPCMS_MemberDB::get_member_noatt_view($userid);
		if (!$member_read) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($userid));
		}
		if ($member_read['mobliesntime'] > 0) {
			$verification_time = $member_read['mobliesntime'] + $espcms_command['SMS_VERIFICATION_INTERVAL_TIME'];
			if ($verification_time > time()) {
				espcms_public_dialog('espcms_public_dialog', 'smssend_pack-espcms_send_toomoney_message', 'false');
			}
		}
		$mobliesn = random(6, true);
		$mobliesntime = time();
		if ($member_read['ismoblie']) {
			$update_set = "mobliesn='$mobliesn',mobliesntime=$mobliesntime";
		} else {
			$mobile = $_POST['mobile'];
			if (!espcms_ismoblie($mobile)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($mobile));
			}
			$update_set = "mobile='$mobile',mobliesn='$mobliesn',mobliesntime=$mobliesntime";
		}
		if (!$espcms_command['SMS_ISOPEN'] || !static::$member_con['MEMBER_MOBLIE_VERIFY']) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_module_close', 'false');
		}
		$db_where = " WHERE userid=$userid";
		$db_table = ESPCMS_DB_PREFIX . 'member';
		$update_key = espcms_db_update_set_save($db_table, $db_where, $update_set);
		if ($update_key) {
			static::$member_read['idcode'] = $mobliesn;
			ESPCMS_SendMessage::send_sms_message('member_moblie_code', static::$member_read, static::$member_read['userid'], false);
			espcms_public_dialog('espcms_public_dialog', 'smssend_pack-espcms_send_ok_message', 'true');
		} else {
			espcms_public_dialog('espcms_public_dialog', 'smssend_pack-espcms_send_no_message', 'false');
		}
	}

}
