<?php
/**
 * 后台管理_检测PHPOK系统是否安全
 * @作者 phpok.com <admin@phpok.com>
 * @版权 深圳市锟铻科技有限公司
 * @主页 http://www.phpok.com
 * @版本 5.x
 * @许可 http://www.phpok.com/lgpl.html PHPOK开源授权协议：GNU Lesser General Public License
 * @时间 2018年12月08日 10时01分
**/
namespace phpok\app\control\safecheck;
/**
 * 安全限制，防止直接访问
**/
if(!defined("PHPOK_SET")){
	exit("<h1>Access Denied</h1>");
}
class admin_control extends \phpok_control
{
	private $popedom;
	public function __construct()
	{
		parent::control();
		$this->popedom = appfile_popedom('safecheck');
		$this->assign("popedom",$this->popedom);
	}

	private function _folders()
	{
		$data = array('_root'=>P_Lang('根目录'));
		$data['_app'] = P_Lang('应用');
		$data['_cache'] = P_Lang('缓存');
		$data['_config'] = P_Lang('配置');
		$data['_data'] = P_Lang('数据');
		$data['css'] = P_Lang('后台样式');
		$data['extension'] = P_Lang('扩展类');
		$data['framework'] = P_Lang('核心');
		$data['gateway'] = P_Lang('网关');
		$data['images'] = P_Lang('图片');
		$data['install'] = P_Lang('安装');
		$data['js'] = P_Lang('JS库');
		$data['langs'] = P_Lang('语言包');
		$data['phpinc'] = P_Lang('模板执行PHP');
		$data['plugins'] = P_Lang('插件');
		$data['res'] = P_Lang('附件');
		$data['static'] = P_Lang('静态资源');
		$data['task'] = P_Lang('计划任务');
		$data['tpl'] = P_Lang('模板');
		$data['wxapp'] = P_Lang('微信小程序');
		return $data;
	}

	public function index_f()
	{
		if(!$this->popedom['list']){
			$this->error(P_Lang('您没有检查执行安全检测'));
		}
		$rs = $this->model('safecheck')->get_one();
		$check_action = true;
		if(!$rs){
			$check_action = false;
		}
		$this->assign('check_action',$check_action);
		$this->display('admin_index');
	}

	public function setting_f()
	{
		$rs = $this->model('safecheck')->get_one();
		if($rs){
			$this->assign('rs',$rs);
		}
		$this->display('admin_setting');
	}

	public function save_f()
	{
		$data = array();
		$data['server'] = $this->get('server');
		if(!$data['server']){
			$this->error(P_Lang('码表地址不能为空'));
		}
		$data['ip'] = $this->get('ip');
		$this->model('safecheck')->save($data);
		$this->success();
	}

	public function checking_f()
	{
		$id = $this->get('id');
		if(!$id){
			$this->error(P_Lang('未指定检测类型'));
		}
		if($id == 'local'){
			$this->_check_script(false);
		}
		if($id == 'yun'){
			$this->_check_script(true);
		}
		if($id == 'res'){
			$this->_check_res();
		}
		$this->success();
	}

	private function _check_res()
	{
		$script_ext = array('php','asp','aspx','jsp','py');
		$list = array();
		$this->lib('file')->deep_ls($this->dir_root.'res/',$list);
		if(!$list || count($list)<1){
			$this->success();
		}
		$filelist = array();
		foreach($list as $key=>$value){
			$ext = $this->file_ext($value);
			if($ext && in_array($ext,$script_ext)){
				$tmp = $this->file2array($value);
				$filelist[] = $tmp;
				continue;
			}
		}
		if(!$filelist || count($filelist)<1){
			$this->success();
		}
		$this->assign('rslist',$filelist);
		$content = $this->display('ajax_rslist',true);
		$this->success($content);
	}

	/**
	 * 本地文件检测
	**/
	private function _check_script($remote=false)
	{
		//脚本文件类型
		$script_ext = array('php','asp','aspx','jsp','py');
		$list = $this->lib('file')->ls($this->dir_root);
		$filelist = array();
		$chklist = $this->model('safecheck')->get_table($remote);
		if(!$chklist){
			$this->error(P_Lang('没有找到匹配码表数据，不能进行验证'));
		}
		$not_include = array('res','_cache','tpl_admin','tpl_www');
		foreach($list as $key=>$value){
			$tmpname = basename($value);
			$t1 = substr($tmpname,0,1);
			if($t1 == '.' || in_array($tmpname,$not_include)){
				continue;
			}
			if(is_dir($value)){
				$tmplist = array();
				$this->lib('file')->deep_ls($value,$tmplist);
				foreach($tmplist as $k=>$v){
					$tmp = $this->file2array($v);
					if($tmp && $tmp['ext'] && in_array($tmp['ext'],$script_ext) && !$chklist[$tmp['md5']]){
						$filelist[] = $tmp;
					}
				}
			}else{
				$tmp = $this->file2array($value);
				if($tmp && $tmp['ext'] && in_array($tmp['ext'],$script_ext) && !$chklist[$tmp['md5']]){
					$filelist[] = $tmp;
				}
			}
		}
		foreach($filelist as $key=>$value){
			if($chklist[$value['md5']]){
				if($value['mdate'] != $chklist[$value['md5']]['mdate']){
					$value['is_mdate'] = true;
				}
				if($value['cdate'] != $chklist[$value['md5']]['cdate']){
					$value['is_cdate'] = true;
				}
				if($value['adate'] != $chklist[$value['md5']]['adate']){
					$value['is_adate'] = true;
				}
				if($value['filesize'] != $chklist[$value['md5']]['filesize']){
					$value['is_filesize'] = true;
				}
			}else{
				$value['is_notice'] = true;
			}
			$filelist[$key] = $value;
		}
		if(!$filelist || count($filelist)<1){
			$this->success();
		}
		$this->assign('rslist',$filelist);
		$content = $this->display('ajax_rslist',true);
		$this->success($content);
	}

	public function tables_f()
	{
		//脚本文件类型
		$script_ext = array('php','asp','aspx','jsp','py');
		$list = $this->lib('file')->ls($this->dir_root);
		//删除临时表
		$tmpfile = $this->dir_data."tmptable.txt";
		$this->lib('file')->rm($tmpfile);
		$info = array();
		$info['md5'] = 'MD5';
		$info['hash'] = 'Hash';
		$info['mdate'] = 'Modify Datetime';
		$info['cdate'] = 'Create Datetime';
		$info['adate'] = 'Read Datetime';
		$info['filesize'] = 'Filesize';
		$info['ext'] = 'Ext';
		$info['filename'] = '文件路径';
		$str = $this->array2str($info);
		$this->lib('file')->vi($str."\n",$tmpfile);
		$handle = fopen($tmpfile,'ab');
		$not_include = array('res','_cache','tpl_admin','tpl_www');
		foreach($list as $key=>$value){
			$tmpname = basename($value);
			$t1 = substr($tmpname,0,1);
			if($t1 == '.' || in_array($tmpname,$not_include)){
				continue;
			}
			if(is_dir($value)){
				$tmplist = array();
				$this->lib('file')->deep_ls($value,$tmplist);
				foreach($tmplist as $k=>$v){
					$tmp = $this->f2array($v);
					if($tmp && $tmp['ext'] && in_array($tmp['ext'],$script_ext)){
						$str = $this->array2str($tmp);
						fwrite($handle,$str."\n");
					}
				}
			}else{
				$tmp = $this->f2array($value);
				if($tmp && $tmp['ext'] && in_array($tmp['ext'],$script_ext)){
					$str = $this->array2str($tmp);
					fwrite($handle,$str."\n");
				}
			}
		}
		fclose($handle);
		$this->lib('file')->mv($tmpfile,$this->dir_data."table.php");
		$this->success();
	}

	private function array2str($rs)
	{
		$tlist = array();
		foreach($rs as $key=>$value){
			if($key == 'filename'){
				$tmpname = $value;
			}else{
				$len = $key == 'ext' ? 5 : 32;
				if($key == 'mdate' || $key == 'cdate' || $key == 'adate'){
					$len = 16;
				}
				if($key == 'filesize'){
					$len = 10;
				}
				$tmpname = str_pad($value,$len);
			}
			$tlist[$key] = $tmpname;
		}
		return implode(" | ",$tlist);
	}

	private function f2array($file)
	{
		$f2 = substr($file,strlen($this->dir_root));
		$filesize = filesize($file);
		$mdate = filemtime($file);
		$rs = array();
		$rs['md5'] = md5($f2); //文件路径MD5
		$rs['hash'] = ($filesize >= 1024*300) ? md5($f2.'-'.$mdate.'-'.$filesize) : md5_file($file);
		$rs['mdate'] = $mdate;
		$rs['cdate'] = filectime($file);
		$rs['adate'] = fileatime($file);
		$rs['filesize'] = $filesize;
		$rs['ext'] = $this->file_ext($file);
		$rs['filename'] = $f2;
		return $rs;
	}

	private function file2array($file)
	{
		$f2 = substr($file,strlen($this->dir_root));
		$filesize = filesize($file);
		$mdate = filemtime($file);
		$rs = array();
		$rs['name'] = basename($file);
		$rs['filesize'] = $filesize;
		$rs['filename'] = $f2;
		$rs['filesize'].$rs['mdate'];
		$rs['hash'] = ($filesize >= 1024*300) ? md5($f2.'-'.$mdate.'-'.$filesize) : md5_file($file);
		$rs['md5'] = md5($f2); //文件路径MD5
		$rs['cdate'] = filectime($file);
		$rs['mdate'] = $mdate;
		$rs['adate'] = fileatime($file);
		$rs['size'] = $this->lib('common')->num_format($rs['filesize'],2,false);
		$rs['ext'] = $this->file_ext($file);
		$rs['folder'] = $f2 ? substr($f2,0,-(strlen($rs['name']))) : '';
		return $rs;
	}

	/**
	 * 取得文件类型
	 * @参数 $file 文件（含路径）
	**/
	private function file_ext($file)
	{
		if(function_exists('pathinfo')){
			$t = pathinfo($file,PATHINFO_EXTENSION);
			if($t){
				return $t;
			}
		}
		$file = basename($file);
		$e = explode(".",$file);
		if(!$e[1]){
			return '未知';
		}
		$len = count($e);
		$ext = $e[($len-1)];
		return $ext;
	}
}
