/**
 * 后面页面脚本_检测PHPOK系统是否安全
 * @作者 phpok.com <admin@phpok.com>
 * @版权 深圳市锟铻科技有限公司
 * @主页 http://www.phpok.com
 * @版本 5.x
 * @许可 http://www.phpok.com/lgpl.html PHPOK开源授权协议：GNU Lesser General Public License
 * @时间 2018年12月08日 10时01分
**/
;(function($){
	$.admin_safecheck = {
		setting:function()
		{
			$.dialog.open(get_url('safecheck','setting'),{
				'title':p_lang('安全检测配置'),
				'lock':true,
				'width':'500px',
				'height':'217px',
				'ok':function(){
					var iframe = this.iframe.contentWindow;
					if (!iframe.document.body) {
						alert('iframe还没加载完毕呢');
						return false;
					};
					iframe.save();
					return false;
				},
				'okVal':p_lang('保存配置'),
				'cancel':true
			})
		},
		start:function()
		{
			var id = $("#checktype").val();
			if(!id){
				$.dialog.alert('请选择测检类型');
				return false;
			}
			var obj = $.dialog.tips('正在检测中，请稍候……',100).lock();
			var url = get_url('safecheck','checking','id='+id);
			$.phpok.json(url,function(rs){
				obj.close();
				if(!rs.status){
					$.dialog.alert(rs.info,true,'error');
					return false;
				}
				if(!rs.info){
					$.dialog.alert('恭喜您，系统没有检测到异常文件',true,'succeed');
					return true;
				}
				$("#checkreport").html(rs.info);
				return true;
			});
			return false;
		},
		tables:function(vpass)
		{
			if(!vpass || vpass == 'undefined'){
				$.dialog.alert('您还未设置二次密码，不支持生成码表功能');
				return false;
			}
			$.dialog.prompt("确定要生成新的码表吗？系统会默认当前新的码表文件是安全！<br/>请填写二次密码以验证",function(val){
				if(!val || val == 'undefined'){
					$.dialog.alert('密码不能为空',true,'error');
					return false;
				}
				var t = $.md5($.md5(val));
				if(t != vpass){
					$.dialog.alert("密码不正确",true,'error');
					return false;
				}
				var url = get_url('safecheck','tables');
				var obj = $.dialog.tips('码表生成中，请稍候…',100).lock();
				$.phpok.json(url,function(rs){
					obj.close();
					if(!rs.status){
						$.dialog.alert(rs.info,true,'error');
						return false;
					}
					$.dialog.alert('码表更新成功',true,'succeed');
					return false;
				})
			});
		},
		to_report:function()
		{
			$("#checkstatus").append('<p>正在生成报告…</p>');
		},
		sleep:function(delay)
		{
			 var start = (new Date()).getTime();
			while ((new Date()).getTime() - start < (delay*1000)) {
				continue;
			}
		},
		check:function()
		{
			var self = this;
			var info = $("#safe-report").attr('data-list');
			if(!info){
				$.dialog.alert()
			}
			var index = $("#safe-report").attr('data-index');
		},
		_tpl:function(info)
		{
			var html = '<tr>';
			html += '<td>'+info.name+'</td>';
			html += '<td>'+info.file+'</td>';
			html += '<td>'+info.status+'</td>';
			html += '<td>'+info.info+'</td>';
			html += '</tr>';
			return html;
		}
	}
})(jQuery);
