-- 安装数据库文件，直接在这里写SQL
DROP TABLE IF EXISTS `qinggan_world_location`;
CREATE TABLE IF NOT EXISTS `qinggan_world_location` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `pid` int(11) unsigned DEFAULT '0' COMMENT '父ID',
  `name` varchar(255) DEFAULT NULL COMMENT '中文名称',
  `name_en` varchar(255) DEFAULT NULL COMMENT '英文名称',
  `code` varchar(50) DEFAULT NULL COMMENT '代码',
  `code2` varchar(10) NOT NULL COMMENT '2位国际编码',
  `status` tinyint(1) unsigned DEFAULT '0' COMMENT '默认是否显示1，隐藏0',
  `excise_rate` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '消费税税率，值都是小于1的',
  `tariff_rate` decimal(10,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '关税税率，无关税请留0值',
  `lang_code` varchar(10) NOT NULL COMMENT '执行的语言包',
  `site_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '锁定站点ID，为0表示默认',
  `tpl_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '模板风格文件，为0读取默认板风格',
  `taxis` int(10) unsigned NOT NULL DEFAULT '255' COMMENT '值越小越往前排',
  `currency_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '货币ID，为0使用站点默认',
  `freight_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '运费计算方式',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='全球地区库' AUTO_INCREMENT=1 ;

INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(1, 0, '亚洲', 'Asia Pacific', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2, 0, '欧洲', 'Europe', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3, 0, '非洲', 'Africa', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4, 0, '美洲', 'Americas', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(5, 0, '南美', 'South America', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(6, 0, '大洋洲', 'Oceania', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(7, 1, '中国', 'China', 'CN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(8, 2, '阿尔巴尼亚', 'Albania', 'ALB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(9, 3, '阿尔及利亚', 'Algeria', 'DZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(10, 1, '阿富汗', 'Afghanistan', 'AFG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(11, 4, '阿根廷', 'Argentina', 'ARG', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(12, 1, '阿拉伯联合酋长国', 'United Arab Emirates', 'ARE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(13, 4, '阿鲁巴', 'Aruba', 'ABW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(14, 1, '阿曼', 'Oman', 'OMN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(15, 1, '阿塞拜疆', 'Azerbaijan', 'AZE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(16, 3, '阿森松岛', 'Ascension Island', 'ASC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(17, 3, '埃及', 'Egypt', 'EGY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(18, 3, '埃塞俄比亚', 'Ethiopia', 'ETH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(19, 2, '爱尔兰', 'Ireland', 'IRL', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(20, 2, '爱沙尼亚', 'Estonia', 'EST', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(21, 2, '安道尔', 'Andorra', 'AND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(22, 3, '安哥拉', 'Angola', 'AGO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(23, 4, '安圭拉', 'Anguilla', 'AIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(25, 1, '澳大利亚', 'Australia', 'AUS', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(26, 2, '奥地利', 'Austria', 'AUT', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(27, 2, '奥兰群岛', 'Aland lslands', 'ALA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(28, 4, '巴巴多斯岛', 'Barbados', 'BRB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(29, 6, '巴布亚新几内亚', 'Papua New Guinea', 'PNG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(30, 4, '巴哈马', 'Bahamas', 'BHS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(31, 1, '巴基斯坦', 'Pakistan', 'PAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(32, 4, '巴拉圭', 'Paraguay', 'PRY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(33, 1, '巴勒斯坦', 'Palestinian Authority', 'PSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(34, 1, '巴林', 'Bahrain', 'BHR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(35, 4, '巴拿马', 'Panama', 'PAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(36, 4, '巴西', 'Brazil', 'BRA', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(37, 2, '白俄罗斯', 'White Russia', 'BLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(38, 4, '百慕大', 'Bermuda', 'BMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(39, 2, '保加利亚', 'Bulgaria', 'BGR', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(40, 4, '北马里亚纳群岛', 'Northern Mariana Islands', 'MNP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(41, 3, '贝宁', 'Benin', 'BEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(42, 2, '比利时', 'Belgium', 'BEL', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(43, 2, '冰岛', 'Iceland', 'ISL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(44, 4, '波多黎各', 'Puerto Rico', 'PRI', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(45, 2, '波兰', 'Poland', 'POL', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(46, 4, '玻利维亚', 'Bolivia', 'BOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(47, 2, '波斯尼亚和黑塞哥维那', 'Bosnia and Herzegovina', 'BIH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(48, 3, '博茨瓦纳', 'Botswana', 'BWA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(49, 4, '伯利兹', 'Belize', 'BLZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(50, 1, '不丹', 'Bhutan', 'BTN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(51, 3, '布基纳法索', 'Burkina Faso', 'BFA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(52, 3, '布隆迪', 'Burundi', 'BDI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(53, 2, '布韦岛', 'Bouvet Island', 'BVT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(54, 1, '朝鲜', 'North Korea', 'PRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(55, 2, '丹麦', 'Denmark', 'DNK', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(56, 2, '德国', 'Deutschland', 'DEU', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(57, 1, '东帝汶', 'Timor-Leste', 'TLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(58, 3, '多哥', 'Togo', 'TGO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(59, 4, '多米尼加', 'Dominica', 'DMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(60, 4, '多米尼加共和国', 'Dominican Republic', 'DOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(61, 2, '俄罗斯', 'Russia', 'RUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(62, 4, '厄瓜多尔', 'Ecuador', 'ECU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(63, 3, '厄立特里亚', 'Eritrea', 'ERI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(64, 2, '法国', 'France', 'FRA', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(65, 2, '法罗群岛', 'Faroe Islands', 'FRO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(66, 6, '法属波利尼西亚', 'Frech Polynesia', 'PYF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(67, 4, '法属圭亚那', 'French Guiana', 'GUF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(68, 2, '法属南部领地', 'French Southern and Antarctic Lands', 'ATF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(69, 2, '梵蒂冈', 'Vatican City', 'VAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(70, 1, '菲律宾', 'Philippines', 'PHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(71, 6, '斐济', 'Fiji Islands', 'FJI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(72, 2, '芬兰', 'Finland', 'FIN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(73, 3, '佛得角', 'Cape Verde', 'CPV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(74, 2, '弗兰克群岛', 'Falkland Islands', 'FLK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(75, 3, '冈比亚', 'Gambia', 'GMB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(76, 3, '刚果', 'Congo', 'COG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(77, 3, '刚果民主共和国', 'Congo(DRC)', 'COD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(78, 4, '哥伦比亚', 'Colombia', 'COL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(79, 4, '哥斯达黎加', 'Costa Rica', 'CRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(80, 2, '格恩西岛', 'Guernsey', 'GGY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(81, 4, '格林纳达', 'Grenada', 'GRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(82, 4, '格陵兰', 'Greenland', 'GRL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(83, 4, '古巴', 'Cuba', 'CUB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(84, 4, '瓜德罗普', 'Guadeloupe', 'GLP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(85, 6, '关岛', 'Guam', 'GUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(86, 4, '圭亚那', 'Guyana', 'GUY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(87, 1, '哈萨克斯坦', 'Kazakhstan', 'KAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(88, 4, '海地', 'Haiti', 'HTI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(89, 1, '韩国', 'Korea', 'KOR', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(90, 2, '荷兰', 'Netherlands', 'NLD', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(91, 4, '荷属安地列斯', 'Netherlands Antilles', 'ANT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(92, 6, '赫德和麦克唐纳群岛', 'Heard Island and McDonald Islands', 'HMD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(93, 4, '洪都拉斯', 'Honduras', 'HND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(94, 6, '基里巴斯', 'Kiribati', 'KIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(95, 3, '吉布提', 'Djibouti', 'DJI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(96, 1, '吉尔吉斯斯坦', 'Kyrgyzstan', 'KGZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(97, 3, '几内亚', 'Guinea', 'GIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(98, 3, '几内亚比绍', 'Guinea-Bissau', 'GNB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(99, 4, '加拿大', 'Canada', 'CAN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(100, 3, '加纳', 'Ghana', 'GHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(101, 3, '加蓬', 'Gabon', 'GAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(102, 1, '柬埔寨', 'Cambodia', 'KHM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(103, 2, '捷克共和国', 'Czech Republic', 'CZE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(104, 3, '津巴布韦', 'Zimbabwe', 'ZWE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(105, 3, '喀麦隆', 'Cameroon', 'CMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(106, 1, '卡塔尔', 'Qatar', 'QAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(107, 4, '开曼群岛', 'Cayman Islands', 'CYM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(108, 6, '科科斯群岛', 'Cocos(Keeling)Islands', 'CCK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(109, 3, '科摩罗', 'Comoros', 'COM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(110, 3, '科特迪瓦', 'Cote d''Ivoire', 'CIV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(111, 1, '科威特', 'Kuwait', 'KWT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(112, 2, '克罗地亚', 'Croatia', 'HRV', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(113, 3, '肯尼亚', 'Kenya', 'KEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(114, 6, '库克群岛', 'Cook Islands', 'COK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(115, 2, '拉脱维亚', 'Latvia', 'LVA', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(116, 3, '莱索托', 'Lesotho', 'LSO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(117, 1, '老挝', 'Laos', 'LAO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(118, 1, '黎巴嫩', 'Lebanon', 'LBN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(119, 3, '利比里亚', 'Liberia', 'LBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(120, 3, '利比亚', 'Libya', 'LBY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(121, 2, '立陶宛', 'Lithuania', 'LTU', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(122, 2, '列支敦士登', 'Liechtenstein', 'LIE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(123, 2, '留尼旺岛', 'Reunion', 'REU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(124, 2, '卢森堡', 'Luxembourg', 'LUX', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(125, 3, '卢旺达', 'Rwanda', 'RWA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(126, 2, '罗马尼亚', 'Romania', 'ROU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(127, 3, '马达加斯加', 'Madagascar', 'MDG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(128, 1, '马尔代夫', 'Maldives', 'MDV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(129, 2, '马耳他', 'Malta', 'MLT', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(130, 3, '马拉维', 'Malawi', 'MWI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(131, 1, '马来西亚', 'Malaysia', 'MYS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(132, 3, '马里', 'Mali', 'MLI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(133, 2, '马其顿', 'Macedonia,Former Yugoslav Republic of', 'MKD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(134, 6, '马绍尔群岛', 'Marshall Islands', 'MHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(135, 4, '马提尼克', 'Martinique', 'MTQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(136, 3, '马约特岛', 'Mayotte', 'MYT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(137, 2, '曼岛', 'Isle of Man', 'IMN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(138, 3, '毛里求斯', 'Mauritius', 'MUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(139, 3, '毛里塔尼亚', 'Mauritania', 'MRT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(140, 4, '美国', 'United States', 'USA', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(141, 6, '美属萨摩亚', 'American Samoa', 'ASM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(142, 4, '美属外岛', 'United States Minor Outlying Islands', 'UMI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(143, 1, '蒙古', 'Mongolia', 'MNG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(144, 4, '蒙特塞拉特', 'Montserrat', 'MSR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(145, 1, '孟加拉', 'Bangladesh', 'BGD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(146, 6, '密克罗尼西亚', 'Micronesia', 'FSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(147, 4, '秘鲁', 'Peru', 'PER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(148, 1, '缅甸', 'Myanmar', 'MMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(149, 2, '摩尔多瓦', 'Moldova', 'MDA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(150, 3, '摩洛哥', 'Morocco', 'MAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(151, 2, '摩纳哥', 'Monaco', 'MCO', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(152, 3, '莫桑比克', 'Mozambique', 'MOZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(153, 4, '墨西哥', 'Mexico', 'MEX', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(154, 3, '纳米比亚', 'Namibia', 'NAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(155, 3, '南非', 'South Africa', 'ZAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(156, 0, '南极洲', 'Antarctica', 'ATA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(158, 6, '瑙鲁', 'Nauru', 'NRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(159, 1, '尼泊尔', 'Nepal', 'NPL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(160, 4, '尼加拉瓜', 'Nicaragua', 'NIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(161, 3, '尼日尔', 'Niger', 'NER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(162, 3, '尼日利亚', 'Nigeria', 'NGA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(163, 6, '纽埃', 'Niue', 'NIU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(164, 2, '挪威', 'Norway', 'NOR', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(165, 4, '诺福克', 'Norfolk Island', 'NFK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(166, 6, '帕劳群岛', 'Palau', 'PLW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(167, 6, '皮特凯恩', 'Pitcairn Islands', 'PCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(168, 2, '葡萄牙', 'Portugal', 'PRT', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(170, 1, '日本', 'Japan', 'JPN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(171, 2, '瑞典', 'Sweden', 'SWE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(172, 2, '瑞士', 'Switzerland', 'CHE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(173, 4, '萨尔瓦多', 'El Salvador', 'SLV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(174, 6, '萨摩亚', 'Samoa', 'WSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(175, 2, '塞尔维亚,黑山', 'Serbia,Montenegro', 'SCG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(176, 3, '塞拉利昂', 'Sierra Leone', 'SLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(177, 3, '塞内加尔', 'Senegal', 'SEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(178, 1, '塞浦路斯', 'Cyprus', 'CYP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(179, 3, '塞舌尔', 'Seychelles', 'SYC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(180, 1, '沙特阿拉伯', 'Saudi Arabia', 'SAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(181, 6, '圣诞岛', 'Christmas Island', 'CXR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(182, 3, '圣多美和普林西比', 'Sao Tome and Principe', 'STP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(183, 3, '圣赫勒拿', 'St.Helena', 'SHN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(184, 4, '圣基茨和尼维斯', 'St.Kitts and Nevis', 'KNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(185, 4, '圣卢西亚', 'St.Lucia', 'LCA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(186, 2, '圣马力诺', 'San Marino', 'SMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(187, 4, '圣皮埃尔和米克隆群岛', 'St.Pierre and Miquelon', 'SPM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(188, 4, '圣文森特和格林纳丁斯', 'St.Vincent and the Grenadines', 'VCT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(189, 1, '斯里兰卡', 'Sri Lanka', 'LKA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(190, 2, '斯洛伐克', 'Slovakia', 'SVK', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(191, 2, '斯洛文尼亚', 'Slovenia', 'SVN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(192, 2, '斯瓦尔巴和扬马廷', 'Svalbard and Jan Mayen', 'SJM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(193, 3, '斯威士兰', 'Swaziland', 'SWZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(194, 3, '苏丹', 'Sudan', 'SDN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(195, 4, '苏里南', 'Suriname', 'SUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(196, 6, '所罗门群岛', 'Solomon Islands', 'SLB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(197, 3, '索马里', 'Somalia', 'SOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(198, 1, '塔吉克斯坦', 'Tajikistan', 'TJK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(199, 1, '泰国', 'Thailand', 'THA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(200, 3, '坦桑尼亚', 'Tanzania', 'TZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(201, 6, '汤加', 'Tonga', 'TON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(202, 4, '特克斯和凯克特斯群岛', 'Turks and Caicos Islands', 'TCA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(203, 4, '特里斯坦达昆哈', 'Tristan da Cunha', 'TAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(204, 4, '特立尼达和多巴哥', 'Trinidad and Tobago', 'TTO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(205, 3, '突尼斯', 'Tunisia', 'TUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(206, 6, '图瓦卢', 'Tuvalu', 'TUV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(207, 1, '土耳其', 'Turkey', 'TUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(208, 1, '土库曼斯坦', 'Turkmenistan', 'TKM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(209, 6, '托克劳', 'Tokelau', 'TKL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(210, 6, '瓦利斯和福图纳', 'Wallis and Futuna', 'WLF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(211, 6, '瓦努阿图', 'Vanuatu', 'VUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(212, 4, '危地马拉', 'Guatemala', 'GTM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(213, 4, '维尔京群岛，美属', 'Virgin Islands', 'VIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(214, 4, '维尔京群岛，英属', 'Virgin Islands,British', 'VGB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(215, 4, '委内瑞拉', 'Venezuela', 'VEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(216, 1, '文莱', 'Brunei', 'BRN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(217, 3, '乌干达', 'Uganda', 'UGA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(218, 2, '乌克兰', 'Ukraine', 'UKR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(219, 4, '乌拉圭', 'Uruguay', 'URY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(220, 1, '乌兹别克斯坦', 'Uzbekistan', 'UZB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(221, 2, '西班牙', 'Spain', 'ESP', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(222, 2, '希腊', 'Greece', 'GRC', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(223, 1, '新加坡', 'Singapore', 'SGP', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(224, 6, '新喀里多尼亚', 'New Caledonia', 'NCL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(225, 1, '新西兰', 'New Zealand', 'NZL', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(226, 2, '匈牙利', 'Hungary', 'HUN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(227, 1, '叙利亚', 'Syria', 'SYR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(228, 4, '牙买加', 'Jamaica', 'JAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(229, 1, '亚美尼亚', 'Armenia', 'ARM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(230, 1, '也门', 'Yemen', 'YEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(231, 1, '伊拉克', 'Iraq', 'IRQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(232, 1, '伊朗', 'Iran', 'IRN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(233, 1, '以色列', 'Israel', 'ISR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(234, 2, '意大利', 'Italy', 'ITA', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(235, 1, '印度', 'India', 'IND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(236, 1, '印度尼西亚', 'Indonesia', 'IDN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(237, 2, '英国', 'United Kingdom', 'GBR', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(238, 3, '英属印度洋领地', 'British Indian Ocean Territory', 'IOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(239, 1, '约旦', 'Jordan', 'JOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(240, 1, '越南', 'Vietnam', 'VNM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(241, 3, '赞比亚', 'Zambia', 'ZMB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(242, 2, '泽西岛', 'Jersey', 'JEY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(243, 3, '乍得', 'Chad', 'TCD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(244, 3, '直布罗陀', 'Gibraltar', 'GIB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(245, 4, '智利', 'Chile', 'CHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(246, 3, '中非共和国', 'Central African Republic', 'CAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(247, 7, '北京', 'Beijing', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(248, 7, '天津', 'Tianjin', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(249, 7, '河北', 'Hebei', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(250, 7, '山西', 'Shanxi', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(251, 7, '内蒙古', 'Inner Mongolia', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(252, 7, '辽宁', 'Liaoning', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(253, 7, '吉林', 'Jilin', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(254, 7, '黑龙江', 'Heilongjiang', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(255, 7, '上海', 'Shanghai', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(256, 7, '江苏', 'Jiangsu', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(257, 7, '浙江', 'Zhejiang', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(258, 7, '安徽', 'Anhui', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(259, 7, '福建', 'Fujian', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(260, 7, '江西', 'Jiangxi', '36', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(261, 7, '山东', 'Shandong', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(262, 7, '河南', 'Henan', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(263, 7, '湖北', 'Hubei', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(264, 7, '湖南', 'Hunan', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(265, 7, '广东', 'Guangdong', '44', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(266, 7, '广西', 'Guangxi', '45', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(267, 7, '海南', 'Hainan', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(268, 7, '重庆', 'Chongqing', '50', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(269, 7, '四川', 'Sichuan', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(270, 7, '贵州', 'Guizhou', '52', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(271, 7, '云南', 'Yunnan', '53', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(272, 7, '西藏', 'Tibet', '54', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(273, 7, '陕西', 'Shaanxi', '61', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(274, 7, '甘肃', 'Gansu', '62', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(275, 7, '青海', 'Qinghai', '63', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(276, 7, '宁夏', 'Ningxia', '64', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(277, 7, '新疆', 'Xinjiang', '65', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(278, 1, '台湾（中国）', 'Taiwan(China)', '71', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(279, 1, '香港（中国）', 'HongKong(China)', '81', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(280, 1, '澳门（中国）', 'Macao(China)', '82', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(281, 25, '北部地区', 'Northern Territory', 'NT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(282, 25, '堪培拉', 'Canberra', 'ACT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(283, 25, '昆士兰', 'Queensland', 'QLD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(284, 25, '南澳大利亚', 'South Australia', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(285, 25, '塔斯马尼亚', 'Tasmania', 'TAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(286, 25, '维多利亚', 'Victoria', 'VIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(287, 25, '西澳大利亚', 'Western Australia', 'WA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(288, 25, '新南威尔士', 'New South Wales', 'NSW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(289, 89, '大邱', 'Daegu', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(290, 89, '大田', 'Daejeon', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(291, 89, '釜山', 'Busan', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(292, 89, '光州', 'Gwangju', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(293, 89, '济州特别自治道', 'Jeju-do', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(294, 89, '江原道', 'Gangwon-do', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(295, 89, '京畿道', 'Gyeonggi-do', '49', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(296, 89, '庆尚北道', 'Chungcheongbuk-do', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(297, 89, '庆尚南道', 'Chungcheongnam-do', '44', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(298, 89, '全罗北道', 'Gyeongsangbuk-do', '47', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(299, 89, '全罗南道', 'Gyeongsangnam-do', '48', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(300, 89, '仁川', 'Incheon', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(301, 89, '首尔', 'Seoul', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(302, 89, '蔚山', 'Ulsan', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(303, 89, '忠清北道', 'Jeollabuk-do', '45', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(304, 89, '忠清南道', 'Jeollanam-do', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(305, 131, '槟榔屿', 'Pulau Pinang', 'PH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(306, 131, '玻璃市', 'Perlis', 'PS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(307, 131, '丁加奴', 'Terengganu', 'TR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(308, 131, '吉打', 'Kedah', 'KD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(309, 131, '吉兰丹', 'Kelantan', 'KN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(310, 131, '吉隆坡', 'Kuala Lumpur', 'KL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(311, 131, '马六甲', 'Malacca', 'ML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(312, 131, '纳闽', 'Labuan', 'LB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(313, 131, '彭亨', 'Pahang', 'PG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(314, 131, '霹雳', 'Perak', 'PK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(315, 131, '柔佛', 'Johor', 'JH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(316, 131, '森美兰', 'Negeri Sembilan', 'NS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(317, 131, '沙巴', 'Sabah', 'SB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(318, 131, '沙捞越', 'Sarawak', 'SR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(319, 131, '雪兰莪', 'Selangor', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(320, 140, '阿肯色', 'Arkansas', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(321, 140, '阿拉巴马', 'Alabama', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(322, 140, '阿拉斯加', 'Alaska', 'AK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(323, 140, '爱达荷', 'Idaho', 'ID', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(324, 140, '爱荷华', 'Iowa', 'IA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(325, 140, '北达科他', 'North Dakota', 'ND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(326, 140, '北卡罗来纳', 'North Carolina', 'NC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(327, 140, '宾夕法尼亚', 'Pennsylvania', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(328, 140, '德克萨斯', 'Texas', 'TX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(329, 140, '俄亥俄', 'Ohio', 'OH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(330, 140, '俄克拉荷马', 'Oklahoma', 'OK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(331, 140, '俄勒冈', 'Oregon', 'OR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(332, 140, '佛罗里达', 'Florida', 'FL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(333, 140, '佛蒙特', 'Vermont', 'VT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(334, 140, '哥伦比亚特区', 'District of Columbia', 'DC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(335, 140, '华盛顿', 'Washington', 'WA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(336, 140, '怀俄明', 'Wyoming', 'WY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(337, 140, '加利福尼亚', 'California', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(338, 140, '堪萨斯', 'Kansas', 'KS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(339, 140, '康涅狄格', 'Connecticut', 'CT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(340, 140, '科罗拉多', 'Colorado', 'CO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(341, 140, '肯塔基', 'Kentucky', 'KY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(342, 140, '路易斯安那', 'Louisiana', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(343, 140, '罗德岛', 'Rhode Island', 'RI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(344, 140, '马里兰', 'Maryland', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(345, 140, '马萨诸塞', 'Massachusetts', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(346, 140, '蒙大拿', 'Montana', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(347, 140, '密苏里', 'Missouri', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(348, 140, '密西西比', 'Mississippi', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(349, 140, '密歇根', 'Michigan', 'MI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(350, 140, '缅因', 'Maine', 'ME', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(351, 140, '明尼苏达', 'Minnesota', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(352, 140, '南达科他', 'South Dakota', 'SD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(353, 140, '南卡罗来纳', 'South Carolina', 'SC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(354, 140, '内布拉斯加', 'Nebraska', 'NE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(355, 140, '内华达', 'Nevada', 'NV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(356, 140, '纽约', 'New York', 'NY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(357, 140, '特拉华', 'Delaware', 'DE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(358, 140, '田纳西', 'Tennessee', 'TN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(359, 140, '威斯康星', 'Wisconsin', 'WI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(360, 140, '维吉尼亚', 'Virginia', 'VA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(361, 140, '西佛吉尼亚', 'West Virginia', 'WV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(362, 140, '夏威夷', 'Hawaii', 'HI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(363, 140, '新罕布什尔', 'New Hampshire', 'NH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(364, 140, '新墨西哥', 'New Mexico', 'NM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(365, 140, '新泽西', 'New Jersey', 'NJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(366, 140, '亚利桑那', 'Arizona', 'AZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(367, 140, '伊利诺斯', 'Illinois', 'IL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(368, 140, '印第安那', 'Indiana', 'IN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(369, 140, '犹他', 'Utah', 'UT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(370, 140, '佐治亚', 'Georgia', 'GA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(371, 237, '北爱尔兰', 'Northern Ireland', 'NIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(372, 237, '苏格兰', 'Scotland', 'SCT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(373, 237, '威尔士', 'Wales', 'WLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(374, 237, '英格兰', 'England', 'ENG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(375, 8, '爱尔巴桑', 'Elbasan', 'EL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(376, 8, '迪勃拉', 'Diber', 'DI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(377, 8, '地拉那', 'Tirane', 'TR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(378, 8, '都拉斯', 'Durres', 'DR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(379, 8, '发罗拉', 'Vlore', 'VL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(380, 8, '费里', 'Fier', 'FR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(381, 8, '吉诺卡斯特', 'Gjirokaster', 'GJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(382, 8, '科尔察', 'Korce', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(383, 8, '库克斯', 'Kukes', 'KU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(384, 8, '莱什', 'Lezhe', 'LE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(385, 8, '培拉特', 'Berat', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(386, 8, '斯库台', 'Shkoder', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(387, 9, '阿德拉尔', 'Adrar', 'ADR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(388, 9, '阿尔及尔', 'Alger', 'ALG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(389, 9, '艾因·德夫拉', 'Ain Defla', 'ADE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(390, 9, '艾因·蒂姆尚特', 'Ain Temouchent', 'ATE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(391, 9, '安纳巴', 'Annaba', 'AAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(392, 9, '奥兰', 'Oran', 'ORA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(393, 9, '巴特纳', 'Batna', 'BAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(394, 9, '贝贾亚', 'Bejaia', 'BJA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(395, 9, '贝沙尔', 'Bechar', 'BEC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(396, 9, '贝伊德', 'El Bayadh', 'EBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(397, 9, '比斯克拉', 'Biskra', 'BIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(398, 9, '布尔吉·布阿雷里吉', 'Bordj Bou Arreridj', 'BOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(399, 9, '布利达', 'Blida', 'BLI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(400, 9, '布迈德斯', 'Boumerdes', 'BOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(401, 9, '布依拉', 'Bouira', 'BOA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(402, 9, '蒂巴扎', 'Tipaza', 'TIP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(403, 9, '蒂斯姆西勒特', 'Tissemsilt', 'TIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(404, 9, '盖尔达耶', 'Ghardaia', 'GHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(405, 9, '盖尔马', 'Guelma', 'GUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(406, 9, '罕西拉', 'Khenchela', 'KHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(407, 9, '赫利赞', 'Relizane', 'REL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(408, 9, '吉杰尔', 'Jijel', 'JIJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(409, 9, '杰勒法', 'Djelfa', 'DJE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(410, 9, '君士坦丁', 'Constantine', 'CZL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(411, 9, '拉格瓦特', 'Laghouat', 'LAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(412, 9, '马斯卡拉', 'Mascara', 'MUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(413, 9, '麦迪亚', 'Medea', 'MED', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(414, 9, '密拉', 'Mila', 'MIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(415, 9, '莫斯塔加纳姆', 'Mostaganem', 'MOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(416, 9, '姆西拉', 'Msila', 'MSI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(417, 9, '纳阿马', 'Naama', 'NAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(418, 9, '塞蒂夫', 'Setif', 'SET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(419, 9, '赛伊达', 'Saida', 'SAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(420, 9, '斯基克达', 'Skikda', 'SKI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(421, 9, '苏克·阿赫拉斯', 'Souk Ahras', 'SAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(422, 9, '塔里夫', 'El Tarf', 'ETA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(423, 9, '塔曼拉塞特', 'Tamanghasset', 'TAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(424, 9, '特贝萨', 'Tebessa', 'TEB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(425, 9, '特莱姆森', 'Tlemcen', 'TLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(426, 9, '提济乌祖', 'Tizi Ouzou', 'IOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(427, 9, '提亚雷特', 'Tiaret', 'TIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(428, 9, '廷杜夫', 'Tindouf', 'TIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(429, 9, '瓦德', 'El Oued', 'EOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(430, 9, '瓦尔格拉', 'Ouargla', 'OUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(431, 9, '乌姆布阿基', 'Oum el Bouaghi', 'OEB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(432, 9, '西迪贝勒阿贝斯', 'Sidi Bel Abbes', 'SBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(433, 9, '谢里夫', 'Chlef', 'CHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(434, 9, '伊利齐', 'Illizi', 'ILL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(435, 10, '赫拉特', 'Herat', 'HEA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(436, 10, '喀布尔', 'Kabul', 'KBL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(437, 10, '坎大哈', 'Kandahar', 'KDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(438, 10, '马扎里沙里夫', 'Mazar-i Sharif', 'MZR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(439, 11, '巴拉那', 'Parana', 'PRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(440, 11, '别德马', 'Viedma', 'VDM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(441, 11, '波萨达斯', 'Posadas', 'PSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(442, 11, '布兰卡港', 'Bahia Blanca', 'BHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(443, 11, '布宜诺斯艾利斯', 'Buenos Aires', 'BUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(444, 11, '福莫萨', 'Formosa', 'FMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(445, 11, '胡胡伊', 'Jujuy', 'JUJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(446, 11, '卡塔马卡', 'Catamarca', 'CTC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(447, 11, '科尔多瓦', 'Cordoba', 'COR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(448, 11, '科连特斯', 'Corrientes', 'CNQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(449, 11, '克劳斯城', 'Villa Krause', 'VLK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(450, 11, '肯考迪娅', 'Concordia', 'COC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(451, 11, '拉里奥哈', 'La Rioja', 'IRJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(452, 11, '拉普拉塔', 'La Plata', 'LPG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(453, 11, '雷西斯滕匹亚', 'Resistencia', 'RES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(454, 11, '里奥加耶戈斯', 'Rio Gallegos', 'RGL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(455, 11, '里奥夸尔托', 'Rio Cuarto', 'RCU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(456, 11, '里瓦达维亚海军准将城', 'Comodoro Rivadavia', 'CRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(457, 11, '罗萨里奥', 'Rosario', 'ROS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(458, 11, '罗森', 'Rawson', 'RWO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(459, 11, '马德普拉塔', 'Mar del Plata', 'MDQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(460, 11, '门多萨', 'Mendoza', 'MDZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(461, 11, '内乌肯', 'Neuquen', 'NQN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(462, 11, '萨尔塔', 'Salta', 'SLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(463, 11, '圣地亚哥-德尔埃斯特罗', 'Santiago del Estero', 'SDE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(464, 11, '圣菲', 'Santa Fe', 'SFN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(465, 11, '圣胡安', 'San Juan', 'UAQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(466, 11, '圣拉斐尔', 'San Rafael', 'AFA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(467, 11, '圣路易斯', 'San Luis', 'LUQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(468, 11, '圣罗莎', 'Santa Rosa', 'RSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(469, 11, '圣米格尔-德图库曼', 'San Miguel de Tucuman', 'SMC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(470, 11, '圣尼古拉斯', 'San Nicolas', 'SNS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(471, 11, '特雷利乌', 'Trelew', 'REL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(472, 11, '乌斯怀亚', 'Ushuaia', 'USH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(473, 12, '阿布扎比', 'Abu Dhabi', 'AZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(474, 12, '艾因', 'Al l''Ayn', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(475, 12, '迪拜', 'Dubai', 'DU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(476, 12, '沙迦', 'Ash Shariqah', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(477, 14, '巴提奈地区', 'Al-Batinah', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(478, 14, '达希莱地区', 'Az-Zahirah', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(479, 14, '东部地区', 'Ash-Sharqiyah', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(480, 14, '马斯喀特省', 'Masqat', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(481, 14, '穆桑达姆省', 'Musandam', 'MU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(482, 14, '内地地区', 'Ad-Dakhiliyah', 'DA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(483, 14, '中部地区', 'Al-Wusta', 'WU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(484, 14, '佐法尔省', 'Zufar', 'ZU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(485, 15, '阿布歇隆', 'Abseron', 'ABS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(486, 15, '哈奇马斯', 'Xacmaz', 'XAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(487, 15, '卡尔巴卡尔', 'Kalbacar', 'KAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(488, 15, '卡扎赫', 'Qazax', 'QAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(489, 15, '连科兰', 'Lankaran', 'LAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(490, 15, '密尔-卡拉巴赫', 'Mil-Qarabax', 'MQA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(491, 15, '穆甘-萨连', 'Mugan-Salyan', 'MSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(492, 15, '纳戈尔诺－卡拉巴赫', 'Nagorni-Qarabax', 'NQA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(493, 15, '纳希切万', 'Naxcivan', 'NX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(494, 15, '普利亚拉克斯', 'Priaraks', 'PRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(495, 15, '舍基', 'Saki', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(496, 15, '苏姆盖特', 'Sumqayit', 'SMC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(497, 15, '锡尔万', 'Sirvan', 'SIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(498, 15, '占贾', 'Ganca', 'GA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(499, 17, '阿斯旺', 'Aswan', 'ASW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(500, 17, '古尔代盖', 'Al Ghurdaqah', 'GBY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(501, 17, '开罗', 'Cairo', 'CAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(502, 17, '苏布拉开马', 'Shubra al Khaymah', 'SKH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(503, 17, '亚历山大', 'Alexandria', 'ALY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(504, 18, '阿法尔', 'Afar', 'AF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(505, 18, '阿姆哈拉', 'Amara', 'AH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(506, 18, '奥罗米亚', 'Oromiya', 'OR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(507, 18, '宾香古尔', 'Binshangul Gumuz', 'BG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(508, 18, '德雷达瓦', 'Dire Dawa', 'DD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(509, 18, '甘贝拉各族', 'Gambela Hizboch', 'GB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(510, 18, '哈勒里民族', 'Hareri  Hizb', 'HR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(511, 18, '南方各族', 'YeDebub Biheroch', 'SN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(512, 18, '索马里', 'Sumale', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(513, 18, '提格雷', 'Tigray', 'TG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(514, 18, '亚的斯亚贝巴', 'Adis abeba', 'AA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(515, 19, '奥法利', 'Offaly', 'OF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(516, 19, '蒂珀雷里', 'Tipperary', 'TP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(517, 19, '都柏林', 'Dublin', 'DB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(518, 19, '多内加尔', 'Donegal', 'DG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(519, 19, '戈尔韦', 'Galway', 'GW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(520, 19, '基尔代尔', 'Kildare', 'KD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(521, 19, '基尔肯尼', 'Kilkenny', 'KK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(522, 19, '卡范', 'Cavan', 'CV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(523, 19, '卡洛', 'Carlow', 'CW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(524, 19, '凯里', 'Kerry', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(525, 19, '科克', 'Cork', 'CK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(526, 19, '克莱尔', 'Clare', 'CL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(527, 19, '朗福德', 'Longford', 'LF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(528, 19, '劳斯', 'Louth', 'LT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(529, 19, '崂斯', 'Laois', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(530, 19, '利默里克', 'Limerick', 'LM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(531, 19, '利特里姆', 'Leitrim', 'LR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(532, 19, '罗斯康芒', 'Roscommon', 'RC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(533, 19, '梅奥', 'Mayo', 'MY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(534, 19, '米斯', 'Meath', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(535, 19, '莫内根', 'Monaghan', 'MG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(536, 19, '斯莱戈', 'Sligo', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(537, 19, '威克洛', 'Wicklow', 'WK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(538, 19, '韦克斯福德', 'Wexford', 'WX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(539, 19, '沃特福德', 'Waterford', 'WF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(540, 19, '西米斯', 'Westmeath', 'WM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(541, 20, '贝尔瓦', 'Polva', '65', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(542, 20, '哈留', 'Harju', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(543, 20, '拉普拉', 'Rapla', '70', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(544, 20, '里亚内', 'Laane', '57', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(545, 20, '帕尔努', 'Parnu', '67', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(546, 20, '萨雷', 'Saare', '74', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(547, 20, '塔尔图', 'Tartu', '78', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(548, 20, '瓦尔加', 'Valga', '82', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(549, 20, '维良地', 'Viljandi', '84', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(550, 20, '维鲁', 'Laane-Viru', '59', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(551, 20, '沃鲁', 'Voru', '86', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(552, 20, '希尤', 'Hiiu', '39', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(553, 20, '耶尔韦', 'Jarva', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(554, 20, '耶盖瓦', 'Jogeva', '49', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(555, 20, '依达－维鲁', 'Ida-Viru', '44', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(556, 21, '安道尔城', 'Andorra la Vella', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(557, 21, '奥尔迪诺', 'Ordino', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(558, 21, '恩坎普', 'Encamp', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(559, 21, '卡尼略', 'Canillo', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(560, 21, '莱塞斯卡尔德－恩戈尔达', 'Escaldes-Engordany', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(561, 21, '马萨纳', 'La Massana', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(562, 21, '圣胡利娅－德洛里亚', 'Sant Julia de Laria', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(563, 22, '北宽扎', 'Cuanza Norte', 'CNO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(564, 22, '北隆达', 'Lunda Norte', 'LNO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(565, 22, '本戈', 'Bengo', 'BGO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(566, 22, '本格拉', 'Benguela', 'BGU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(567, 22, '比耶', 'Bie', 'BIE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(568, 22, '卡宾达', 'Cabinda', 'CAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(569, 22, '库内内', 'Cunene', 'CNN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(570, 22, '宽多库邦戈', 'Cuando Cubango', 'CCU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(571, 22, '罗安达', 'Luanda', 'LUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(572, 22, '马兰热', 'Malanje', 'MAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(573, 22, '莫希科', 'Moxico', 'MOX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(574, 22, '纳米贝', 'Namibe', 'NAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(575, 22, '南宽扎', 'Cuanza Sul', 'CUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(576, 22, '南隆达', 'Lunda Sul', 'LSU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(577, 22, '万博', 'Huambo', 'HUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(578, 22, '威拉', 'Huila', 'HUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(579, 22, '威热', 'Uige', 'UIG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(580, 22, '扎伊尔', 'Zaire', 'ZAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(581, 26, '布尔根兰', 'Burgenland', 'BUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(582, 26, '蒂罗尔', 'Tyrol', 'TYR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(583, 26, '福拉尔贝格', 'Vorarlberg', 'VOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(584, 26, '克恩顿', 'Carinthia', 'CAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(585, 26, '萨尔茨堡', 'Salzburg', 'SZG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(586, 26, '上奥地利', 'Upper Austria', 'UAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(587, 26, '施蒂利亚', 'Styria', 'STY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(588, 26, '维也纳', 'Vienna', 'VDD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(589, 26, '下奥地利', 'Lower Austria', 'LAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(590, 29, '北部', 'Northern', 'NO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(591, 29, '布干维尔', 'Bougainville', 'BV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(592, 29, '东部高地', 'Eastern Highlands', 'EH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(593, 29, '东塞皮克', 'East Sepik', 'ES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(594, 29, '东新不列颠', 'East New Britain', 'EB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(595, 29, '恩加', 'Enga', 'EN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(596, 29, '海湾', 'Gulf', 'GU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(597, 29, '马当', 'Madang', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(598, 29, '马努斯', 'Manus', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(599, 29, '米尔恩湾', 'Milne Bay', 'MB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(600, 29, '莫尔兹比港', 'Port Moresby', 'NC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(601, 29, '莫罗贝', 'Morobe', 'MR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(602, 29, '南部高地', 'Southern Highlands', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(603, 29, '钦布', 'Simbu', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(604, 29, '桑道恩', 'Sandaun', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(605, 29, '西部', 'Western', 'WE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(606, 29, '西部高地', 'Western Highlands', 'WH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(607, 29, '西新不列颠', 'West New Britain', 'WB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(608, 29, '新爱尔兰', 'New Ireland', 'NI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(609, 31, '白沙瓦', 'Peshawar', 'PEW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(610, 31, '费萨拉巴德', 'Faisalabad', 'LYP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(611, 31, '故吉软瓦拉', 'Gujranwala', 'GUJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(612, 31, '海德拉巴', 'Hyderabad', 'HDD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(613, 31, '卡拉奇', 'Karachi', 'KCT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(614, 31, '拉合尔', 'Lahore', 'LHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(615, 31, '拉瓦尔品第', 'Rawalpindi', 'RWP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(616, 31, '木尔坦', 'Multan', 'MUX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(617, 31, '伊斯兰堡', 'Islamabad', 'ISB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(618, 32, '阿曼拜', 'Amambay', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(619, 32, '阿耶斯总统省', 'Presidente Hayes', 'PH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(620, 32, '巴拉瓜里', 'Paraguari', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(621, 32, '博克龙', 'Boqueron', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(622, 32, '瓜伊拉', 'Guaira', 'GU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(623, 32, '卡瓜苏', 'Caaguazu', 'CG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(624, 32, '卡嫩迪尤', 'Canindeyu', 'CN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(625, 32, '卡萨帕', 'Caazapa', 'CZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(626, 32, '康塞普西翁', 'Concepcion', 'CC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(627, 32, '科迪勒拉', 'Cordillera', 'CD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(628, 32, '米西奥内斯', 'Misiones', 'MI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(629, 32, '涅恩布库', 'Neembucu', 'NE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(630, 32, '上巴拉圭', 'Alto Paraguay', 'AG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(631, 32, '上巴拉那', 'Alto Parana', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(632, 32, '圣佩德罗', 'San Pedro', 'SP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(633, 32, '亚松森特别区', 'Asuncion', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(634, 32, '伊塔普亚', 'Itapua', 'IT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(635, 32, '中央', 'Central', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(636, 33, '加沙地带', 'Gaza Strip', 'GZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(637, 33, '西岸', 'West Bank', 'WE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(638, 34, '北部', 'Ash-Shamaliyah', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(639, 34, '哈德', 'Al-Hadd', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(640, 34, '哈马德', 'Hammad', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(641, 34, '里法', 'Ar-Rifa', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(642, 34, '麦纳麦', 'Al-Manamah', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(643, 34, '穆哈拉格', 'Al-Muharraq', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(644, 34, '西部', 'Al-Gharbiyah', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(645, 34, '伊萨城', 'Isa', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(646, 34, '中部', 'Al-Wusta', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(647, 36, '阿克里', 'Acre', 'AC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(648, 36, '阿拉戈斯', 'Alagoas', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(649, 36, '阿马帕', 'Amapa', 'AP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(650, 36, '巴拉那', 'Parana', 'PR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(651, 36, '巴西利亚', 'Brasilia', 'BSB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(652, 36, '巴伊亚', 'Bahia', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(653, 36, '北里奥格兰德', 'Rio Grande do Norte', 'RN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(654, 36, '伯南布哥', 'Pernambuco', 'PE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(655, 36, '戈亚斯', 'Goias', 'GO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(656, 36, '朗多尼亚', 'Rondonia', 'RO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(657, 36, '里约热内卢', 'Rio de Janeiro', 'RJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(658, 36, '罗赖马', 'Roraima', 'RR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(659, 36, '马拉尼昂', 'Maranhao', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(660, 36, '马托格罗索', 'Mato Grosso', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(661, 36, '米纳斯吉拉斯', 'Minas Gerais', 'MG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(662, 36, '南里奥格兰德', 'Rio Grande do Sul', 'RS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(663, 36, '南马托格罗索', 'Mato Grosso do Sul', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(664, 36, '帕拉', 'Para', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(665, 36, '帕拉伊巴', 'Paraiba', 'PB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(666, 36, '皮奥伊', 'Piaui', 'PI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(667, 36, '塞阿拉', 'Ceara', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(668, 36, '塞尔希培', 'Sergipe', 'SE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(669, 36, '圣埃斯皮里图', 'Espirito Santo', 'ES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(670, 36, '圣保罗', 'Sao Paulo', 'SP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(671, 36, '圣卡塔琳娜', 'Santa Catarina', 'SC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(672, 36, '托坎廷斯', 'Tocantins', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(673, 36, '亚马孙', 'Amazonas', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(674, 37, '布列斯特', 'Bresckaja', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(675, 37, '戈梅利', 'Homelskaja', 'HO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(676, 37, '格罗德诺', 'Hrodzenskaja', 'HR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(677, 37, '明斯克市', 'Minsk', 'MI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(678, 37, '莫吉廖夫', 'Mahileuskaja', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(679, 37, '维捷布斯克', 'Vicebskaja', 'VI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(680, 39, '布尔加斯', 'Burgas', 'BOJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(681, 39, '卡斯科伏', 'Khaskovo', 'KHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(682, 39, '鲁塞', 'Ruse', 'ROU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(683, 39, '洛维奇', 'Lovech', 'LVP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(684, 39, '蒙塔纳', 'Montana', 'OZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(685, 39, '普罗夫迪夫', 'Plovdiv', 'PDV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(686, 39, '索非亚', 'Sofiya', 'SOF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(687, 39, '索非亚市', 'Grad Sofiya', 'GSO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(688, 39, '瓦尔纳', 'Varna', 'VAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(689, 41, '阿黎博里', 'Alibori', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(690, 41, '阿塔科拉', 'Atakora', 'AK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(691, 41, '滨海', 'Littoral', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(692, 41, '波希康市', 'Bohicon', 'BOH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(693, 41, '博尔古', 'Borgou', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(694, 41, '大西洋', 'Atlantique', 'AQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(695, 41, '高原', 'Plateau', 'PL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(696, 41, '库福', 'Kouffo', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(697, 41, '莫诺', 'Mono', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(698, 41, '丘陵', 'Collines', 'CO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(699, 41, '韦梅', 'Oueme', 'OU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(700, 41, '峡谷', 'Donga', 'DO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(701, 41, '祖', 'Zou', 'ZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(702, 42, '埃诺', 'Hainaut', 'WHT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(703, 42, '安特卫普', 'Antwerpen', 'VAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(704, 42, '布拉班特-瓦隆', 'Brabant-Wallone', 'WBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(705, 42, '布鲁塞尔', 'Brussels', 'BRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(706, 42, '东佛兰德', 'Oost-Vlaanderen', 'VOV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(707, 42, '佛兰芒-布拉班特', 'Vlaams-Brabant', 'VBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(708, 42, '列日', 'Liege', 'WLG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(709, 42, '林堡', 'Limburg', 'VLI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(710, 42, '卢森堡', 'Luxembourg', 'WLX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(711, 42, '那慕尔', 'Namur', 'WNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(712, 42, '西佛兰德', 'West-Vlaanderen', 'VWV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(713, 45, '埃尔布隆格', 'Elbląg', 'ELB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(714, 45, '奥尔什丁', 'Olsztyn', 'OLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(715, 45, '奥斯特罗文卡', 'Ostrołeka', 'OSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(716, 45, '比得哥什', 'Bydgoszcz', 'BZG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(717, 45, '彼得库夫', 'Piotrkow', 'PIO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(718, 45, '比托姆', 'Bytom', 'BYT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(719, 45, '比亚瓦波德拉斯卡', 'Biała Podlaska', 'BAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(720, 45, '比亚维斯托克', 'Białystok', 'BIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(721, 45, '波莱', 'Opole', 'OPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(722, 45, '波兹南', 'Poznan', 'POZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(723, 45, '达布罗瓦戈尼察', 'Dabrowa Gornicza', 'DAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(724, 45, '大波兰地区戈茹夫', 'Gorzow Wlkp', 'GOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(725, 45, '弗罗茨瓦夫', 'Wroclaw', 'WRO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(726, 45, '弗沃茨瓦韦克', 'Wlocławek', 'WLO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(727, 45, '格但斯克', 'Gdansk', 'GDN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(728, 45, '格丁尼亚', 'Gdynia', 'GDY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(729, 45, '格利维采', 'Gliwice', 'GWC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(730, 45, '格鲁琼兹', 'Grudziadz', 'GRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(731, 45, '海乌姆', 'Chełm', 'CHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(732, 45, '华沙', 'Warszawa', 'WAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(733, 45, '霍茹夫', 'Chorzow', 'CHZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(734, 45, '卡利什', 'Kalisz', 'KAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(735, 45, '卡托维兹', 'Katowice', 'KTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(736, 45, '凯尔采', 'Kielce', 'KLC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(737, 45, '科宁', 'Konin', 'KON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(738, 45, '科沙林', 'Koszalin', 'OSZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(739, 45, '克拉科夫', 'Krakow', 'KRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(740, 45, '克罗斯诺', 'Krosno', 'KRO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(741, 45, '拉多姆', 'Radom', 'RDM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(742, 45, '莱格尼察', 'Legnica', 'LEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(743, 45, '莱什诺', 'Leszno', 'LEZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(744, 45, '卢布林', 'Lublin', 'LUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(745, 45, '鲁达', 'Ruda Sl', 'RDS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(746, 45, '罗兹', 'Lodz', 'LOD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(747, 45, '绿山城', 'Zielona Gora', 'IEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(748, 45, '米什洛维采', 'Mysłowice', 'MYL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(749, 45, '皮瓦', 'Piła', 'PIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(750, 45, '普热梅希尔', 'Przemysl', 'PRZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(751, 45, '普沃茨克', 'Plock', 'PLO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(752, 45, '切哈努夫', 'Ciechanow', 'CIE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(753, 45, '热舒夫', 'Rzeszow', 'RZE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(754, 45, '什切青', 'Szczecin', 'SZZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(755, 45, '斯凯尔涅维采', 'Skierniewice', 'SKI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(756, 45, '斯武普斯克', 'Slupsk', 'SLP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(757, 45, '苏瓦乌基', 'Suwałki', 'SWL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(758, 45, '索波特', 'Sopot', 'SOP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(759, 45, '索斯诺维茨', 'Sosnowiec', 'SWC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(760, 45, '塔尔努夫', 'Tarnow', 'TAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(761, 45, '塔尔诺布热格', 'Tarnobrzeg', 'QEP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(762, 45, '特切', 'Tychy', 'TYY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(763, 45, '托伦', 'Torun', 'TOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(764, 45, '瓦乌布日赫', 'Walbrzych', 'WZH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(765, 45, '沃姆扎', 'Lomza', 'QOY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(766, 45, '希米亚诺维采', 'Siemianowice Sl', 'SOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(767, 45, '希维诺乌伊希切', 'Swinoujscie', 'SWI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(768, 45, '希维托赫洛维采', 'Swietochłowice', 'SWT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(769, 45, '谢德尔采', 'Siedlce', 'SDC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(770, 45, '谢拉兹', 'Sieradz', 'SIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(771, 45, '新松奇', 'Nowy Sacz', 'NOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(772, 45, '雅沃兹诺', 'Jaworzno', 'JAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(773, 45, '耶莱尼亚古拉', 'Jelenia Gora', 'JEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(774, 45, '扎布热', 'Zabrze', 'ZAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(775, 45, '扎莫希奇', 'Zamosc', 'ZAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(776, 46, '奥尔托', 'El Alto', 'ALT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(777, 46, '奥鲁罗', 'Oruro', 'ORU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(778, 46, '贝尼', 'El Beni', 'BEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(779, 46, '波多西', 'Potosi', 'POI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(780, 46, '基拉科洛', 'Quillacollo', 'QUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(781, 46, '科恰班巴', 'Cochabamba', 'CBB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(782, 46, '拉巴斯', 'La Paz', 'LPB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(783, 46, '潘多', 'Pando', 'PAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(784, 46, '丘基萨卡', 'Chuquisaca', 'CHU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(785, 46, '萨卡巴', 'Sacaba', 'SAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(786, 46, '圣克鲁斯', 'Santa Cruz', 'SRZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(787, 46, '塔里哈', 'Tarija', 'TJA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(788, 47, '波萨维纳', 'Posavski', 'FPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(789, 47, '波斯尼亚－波德里涅', 'Bosansko-Podrinjski', 'FBP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(790, 47, '多米斯拉夫格勒', 'Tomislavgrad', 'FTO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(791, 47, '黑塞哥维那－涅雷特瓦', 'Hercegovacko-Neretvanski', 'FHN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(792, 47, '萨拉热窝', 'Sarajevo', 'FSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(793, 47, '图兹拉－波德里涅', 'Tuzlanski-Podrinjski', 'FTU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(794, 47, '乌纳－萨纳', 'Unsko-Sanski', 'FUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(795, 47, '西波斯尼亚', 'Hercegovacko-Bosanski', 'FHB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(796, 47, '西黑塞哥维那', 'Zapadno-Hercegovaki', 'FZH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(797, 47, '泽尼察－多博伊', 'Zenicko-Dobojski', 'FZE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(798, 47, '中波斯尼亚', 'Srednjo-Bosanski', 'FSB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(799, 49, '伯利兹', 'Belize', 'BZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(800, 49, '橘园', 'Orange Walk', 'OW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(801, 49, '卡约', 'Cayo', 'CY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(802, 49, '科罗萨尔', 'Corozal', 'CR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(803, 49, '斯坦港', 'Stann Creek', 'SC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(804, 49, '托莱多', 'Toledo', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(805, 51, '巴雷', 'Bale', 'BAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(806, 51, '巴姆', 'Bam', 'BAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(807, 51, '巴瓦', 'Banwa', 'BAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(808, 51, '巴泽加', 'Bazega', 'BAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(809, 51, '波尼', 'Poni', 'PON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(810, 51, '布尔古', 'Boulgou', 'BLG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(811, 51, '布尔基恩德', 'Boulkiemde', 'BOK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(812, 51, '布古里巴', 'Bougouriba', 'BOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(813, 51, '冈祖尔古', 'Ganzourgou', 'GAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(814, 51, '古尔马', 'Gourma', 'GOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(815, 51, '济罗', 'Ziro', 'ZIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(816, 51, '卡焦戈', 'Kadiogo', 'KAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(817, 51, '凯内杜古', 'Kenedougou', 'KEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(818, 51, '科蒙加里', 'Komondjari', 'KOO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(819, 51, '科莫埃', 'Comoe', 'COM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(820, 51, '孔皮恩加', 'Kompienga', 'KOP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(821, 51, '孔西', 'Kossi', 'KOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(822, 51, '库尔佩罗戈', 'Koulpelogo', 'KOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(823, 51, '库尔维奥戈', 'Kourweogo', 'KOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(824, 51, '库里滕加', 'Kouritenga', 'KOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(825, 51, '雷拉巴', 'Leraba', 'LER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(826, 51, '罗卢姆', 'Loroum', 'LOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(827, 51, '穆翁', 'Mouhoun', 'MOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(828, 51, '纳门滕加', 'Namentenga', 'NAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(829, 51, '纳乌里', 'Nahouri', 'NAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(830, 51, '纳亚拉', 'Nayala', 'NAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(831, 51, '尼亚尼亚', 'Gnagna', 'GNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(832, 51, '努姆比埃尔', 'Noumbiel', 'NOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(833, 51, '帕索雷', 'Passore', 'PAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(834, 51, '塞诺', 'Seno', 'SEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(835, 51, '桑吉', 'Sanguie', 'SAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(836, 51, '桑马滕加', 'Sanmatenga', 'SAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(837, 51, '苏鲁', 'Sourou', 'SOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(838, 51, '苏姆', 'Soum', 'SOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(839, 51, '塔波阿', 'Tapoa', 'TAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(840, 51, '图伊', 'Tuy', 'TUY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(841, 51, '乌埃', 'Houet', 'HOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(842, 51, '乌布里滕加', 'Oubritenga', 'OUB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(843, 51, '乌达兰', 'Oudalan', 'OUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(844, 51, '锡西里', 'Sissili', 'SIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(845, 51, '亚加', 'Yagha', 'YAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(846, 51, '亚滕加', 'Yatenga', 'YAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(847, 51, '伊奥巴', 'Ioba', 'IOA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(848, 51, '宗德韦奥戈', 'Zoundweogo', 'ZOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(849, 51, '宗多马', 'Zondoma', 'ZOD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(850, 52, '布班扎', 'Bubanza', 'BB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(851, 52, '布鲁里', 'Bururi', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(852, 52, '布琼布拉城市', 'Bujumbura Mairie', 'BM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(853, 52, '布琼布拉乡村', 'Bujumbura Rural', 'BU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(854, 52, '恩戈齐', 'Ngozi', 'NG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(855, 52, '基龙多', 'Kirundo', 'KI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(856, 52, '基特加', 'Gitega', 'GI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(857, 52, '卡鲁济', 'Karuzi', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(858, 52, '卡扬扎', 'Kayanza', 'KY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(859, 52, '坎库佐', 'Cankuzo', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(860, 52, '鲁塔纳', 'Rutana', 'RT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(861, 52, '鲁伊吉', 'Ruyigi', 'RY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(862, 52, '马坎巴', 'Makamba', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(863, 52, '穆拉姆维亚', 'Muramvya', 'MU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(864, 52, '穆瓦洛', 'Mwaro', 'MW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(865, 52, '穆因加', 'Muyinga', 'MY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(866, 52, '锡比托凯', 'Cibitoke', 'CI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(867, 54, '海州', 'Haeju', 'HAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(868, 54, '惠山', 'Hyesan', 'HYE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(869, 54, '江界', 'Kanggye', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(870, 54, '开城', 'Kaesong', 'KSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(871, 54, '罗先', 'Naseon', 'NAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(872, 54, '南浦', 'Namp''o', 'NAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(873, 54, '平壤', 'Pyongyang', 'FNJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(874, 54, '清津', 'Ch''ongjin', 'CHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(875, 54, '沙里院', 'Sariwon', 'SAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(876, 54, '咸兴', 'Hamhung', 'HAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(877, 54, '新义州', 'Sinuiju', 'SII', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(878, 54, '元山', 'Wonsan', 'WON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(879, 55, '奥胡斯', 'Aarhus', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(880, 55, '北日德兰', 'Nordjylland', 'VSV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(881, 55, '博恩霍尔姆', 'Bornholm', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(882, 55, '菲特烈堡', 'Frederiksborg', 'FRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(883, 55, '菲茵', 'Fyn', 'FY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(884, 55, '哥本哈根', 'Copenhagen', 'CPH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(885, 55, '里伯', 'Ribe', 'RIB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(886, 55, '灵克宾', 'Ringkoebing', 'RKG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(887, 55, '罗斯基勒', 'Roskilde', 'RKE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(888, 55, '南日德兰', 'Soenderjylland', 'VBI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(889, 55, '斯多斯特姆', 'Storstroem', 'ST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(890, 55, '维堡', 'Viborg', 'VIB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(891, 55, '维厄勒', 'Vejle', 'VEJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(892, 55, '西希兰', 'Vestsjaelland', 'VS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(893, 56, '阿恩斯贝格', 'Arnsberg', 'ARN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(894, 56, '爱尔福特', 'Erfurt', 'ERF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(895, 56, '安斯巴格', 'Ansbach', 'ANS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(896, 56, '奥格斯堡', 'Augsburg', 'AGB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(897, 56, '柏林', 'Berlin', 'BE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(898, 56, '拜伊罗特', 'Bayreuth', 'BYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(899, 56, '比勒费尔德', 'Bielefeld', 'BFE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(900, 56, '波茨坦', 'Potsdam', 'POT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(901, 56, '波鸿', 'Bochum', 'BOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(902, 56, '不来梅', 'Bremen', 'HB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(903, 56, '不伦瑞克', 'Brunswick', 'BRW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(904, 56, '达姆施塔特', 'Darmstadt', 'DAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(905, 56, '代特莫尔特', 'Detmold', 'DET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(906, 56, '德累斯顿', 'Dresden', 'DRS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(907, 56, '德绍', 'Dessau', 'DES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(908, 56, '杜塞尔多夫', 'Dusseldorf', 'DUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(909, 56, '法兰克福', 'Frankfurt', 'FFO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(910, 56, '弗赖堡', 'Freiburg', 'FBG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(911, 56, '哈雷', 'Halle', 'HAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(912, 56, '汉堡', 'Hamburg', 'HH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(913, 56, '汉诺威', 'Hannover', 'HAJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(914, 56, '基尔', 'Kiel', 'KEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(915, 56, '吉森', 'GieBen', 'GBN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(916, 56, '卡尔斯鲁厄', 'Karlsruhe', 'KAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(917, 56, '卡塞尔', 'Kassel', 'KAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(918, 56, '开姆尼斯', 'Chemnitz', 'CHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(919, 56, '科布伦次', 'Koblenz', 'KOB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(920, 56, '科隆', 'Cologne', 'CGN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(921, 56, '莱比锡', 'Leipzig', 'LEJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(922, 56, '兰茨胡特', 'Landshut', 'LDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(923, 56, '吕讷堡', 'Luneburg', 'LBG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(924, 56, '马格德堡', 'Magdeburg', 'MAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(925, 56, '曼海姆', 'Mannheim', 'MHG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(926, 56, '美因兹', 'Mainz', 'MAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(927, 56, '明斯特', 'Muenster', 'MUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(928, 56, '慕尼黑', 'Munich', 'MUC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(929, 56, '纽伦堡', 'Nuremberg', 'NUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(930, 56, '什未林', 'Schwerin', 'SWH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(931, 56, '斯图加特', 'Stuttgart', 'STR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(932, 56, '特里尔', 'Trier', 'TRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(933, 56, '威斯巴登', 'Wiesbaden', 'WIB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(934, 56, '维尔茨堡', 'Wuerzburg', 'WUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(935, 57, '阿伊莱乌', 'Aileu', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(936, 57, '阿伊纳罗', 'Ainaro', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(937, 57, '埃尔梅拉', 'Ermera', 'ER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(938, 57, '安贝诺', 'Ambeno', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(939, 57, '包考', 'Baucau', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(940, 57, '博博纳罗', 'Bobonaro', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(941, 57, '帝力', 'Dili', 'DI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(942, 57, '科瓦利马', 'Kovalima', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(943, 57, '劳滕', 'Lautem', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(944, 57, '利基卡', 'Liquica', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(945, 57, '马纳图托', 'Manatuto', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(946, 57, '马努法伊', 'Manofahi', 'MF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(947, 57, '维克克', 'Viqueque', 'VI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(948, 58, '滨海区', 'Maritime', 'M', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(949, 58, '草原区', 'Savanes', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(950, 58, '高原区', 'Plateaux', 'P', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(951, 58, '卡拉区', 'Kara', 'K', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(952, 58, '中部区', 'Centre', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(953, 61, '阿巴坎', 'Abakan', 'ABA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(954, 61, '阿尔汉格尔斯克', 'Arkhangelsk', 'ARK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(955, 61, '阿金斯科耶', 'Aginskoye', 'AGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(956, 61, '阿纳德尔', 'Anadyr', 'DYR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(957, 61, '阿斯特拉罕', 'Astrakhan', 'AST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(958, 61, '埃利斯塔', 'Elista', 'ESL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(959, 61, '奥廖尔', 'Orel', 'ORL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(960, 61, '奥伦堡', 'Orenburg', 'ORE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(961, 61, '巴尔瑙尔', 'Barnaul', 'BAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(962, 61, '奔萨', 'Penza', 'PNZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(963, 61, '彼得罗巴甫洛夫斯克', 'Petropavlovsk-Kamchatskiy', 'PKC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(964, 61, '彼得罗扎沃茨克', 'Petrozavodsk', 'PES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(965, 61, '彼尔姆', 'Perm', 'PER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(966, 61, '比罗比詹', 'Birobidzan', 'BBZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(967, 61, '别尔哥罗德', 'Belgorod', 'BEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(968, 61, '伯力', 'Chabarovsk', 'COK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(969, 61, '布拉戈维申斯克', 'Blagoveshchensk', 'BQS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(970, 61, '布良斯克', 'Bryansk', 'BRY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(971, 61, '车里雅宾斯克', 'Chelyabinsk', 'CHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(972, 61, '赤塔', 'Chita', 'CHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(973, 61, '顿河畔罗斯托夫', 'Rostov-na-Donu', 'ROS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(974, 61, '鄂木斯克', 'Omsk', 'OMS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(975, 61, '伏尔加格勒', 'Volgograd', 'VOG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(976, 61, '弗拉基米尔', 'Vladimir', 'VMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(977, 61, '弗拉季高加索', 'Vladikavkaz', 'VLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(978, 61, '戈尔诺－阿尔泰斯克', 'Gorno-Altajsk', 'GOA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(979, 61, '格罗兹尼', 'Grozny', 'GRV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(980, 61, '海参崴', 'Vladivostok', 'VVO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(981, 61, '汉特－曼西斯克', 'Khanty-Mansiysk', 'KHM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(982, 61, '基洛夫', 'Kirov', 'KIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(983, 61, '加里宁格勒', 'Kaliningrad', 'KGD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(984, 61, '喀山', 'Kazan', 'KZN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(985, 61, '卡卢加', 'Kaluga', 'KLF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(986, 61, '科斯特罗马', 'Kostroma', 'KOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(987, 61, '克拉斯诺达尔', 'Krasnodar', 'KRR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(988, 61, '克拉斯诺亚尔斯克', 'Krasnojarsk', 'KYA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(989, 61, '克麦罗沃', 'Kemerovo', 'KEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(990, 61, '克孜勒', 'Kyzyl', 'KYZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(991, 61, '库德姆卡尔', 'Kudymkar', 'KUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(992, 61, '库尔干', 'Kurgan', 'KRO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(993, 61, '库尔斯克', 'Kursk', 'URS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(994, 61, '利佩茨克', 'Lipeck', 'LIP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(995, 61, '梁赞', 'Ryazan', 'RYA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(996, 61, '马哈奇卡拉', 'Makhachkala', 'MCX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(997, 61, '马加丹', 'Magadan', 'MAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(998, 61, '马加斯', 'Magas', 'IN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(999, 61, '迈科普', 'Maykop', 'MAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1000, 61, '摩尔曼斯克', 'Murmansk', 'MMK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1001, 61, '莫斯科', 'Moscow', 'MOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1002, 61, '纳尔奇克', 'Nalchik', 'NAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1003, 61, '纳里扬马尔', 'Naryan-Mar', 'NNM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1004, 61, '南萨哈林斯克', 'Juzno-Sachalinsk', 'JSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1005, 61, '诺夫哥罗德', 'Velikij Novgorod', 'VUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1006, 61, '帕拉纳', 'Palana', 'PAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1007, 61, '普斯科夫', 'Pskov', 'PSK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1008, 61, '切博克萨雷', 'Cheboksary', 'CSY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1009, 61, '切尔克斯克', 'Cherkessk', 'CKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1010, 61, '秋明', 'Tyumen', 'TYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1011, 61, '萨拉托夫', 'Saratov', 'SAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1012, 61, '萨兰斯克', 'Saransk', 'SKX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1013, 61, '萨列哈尔德', 'Salekhard', 'SLY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1014, 61, '萨马拉', 'Samara', 'SAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1015, 61, '瑟克特夫卡尔', 'Syktyvkar', 'SCW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1016, 61, '圣彼得堡', 'St. Peterburg', 'SPE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1017, 61, '斯摩棱斯克', 'Smolensk', 'LNX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1018, 61, '斯塔夫罗波尔', 'Stavropol', 'STA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1019, 61, '坦波夫', 'Tambov', 'TAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1020, 61, '特维尔', 'Tver', 'TVE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1021, 61, '图拉', 'Tula', 'TUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1022, 61, '托木斯克', 'Tomsk', 'TOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1023, 61, '沃罗涅什', 'Voronezh', 'VOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1024, 61, '沃洛格达', 'Vologda', 'VLG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1025, 61, '乌法', 'Ufa', 'UFA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1026, 61, '乌兰乌德', 'Ulan-Ude', 'UUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1027, 61, '乌里扬诺夫斯克', 'Uljanovsk', 'ULY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1028, 61, '乌斯季奥尔登斯基', 'Ust-Ordynsky', 'UOB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1029, 61, '下诺夫哥罗德', 'Niznij Novgorod', 'GOJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1030, 61, '新西伯利亚', 'Novosibirsk', 'NVS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1031, 61, '雅库茨克', 'Jakutsk', 'JAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1032, 61, '雅罗斯拉夫尔', 'Jaroslavl', 'JAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1033, 61, '叶卡捷林堡', 'Jekaterinburg', 'JEK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1034, 61, '伊尔库茨克', 'Irkutsk', 'IKT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1035, 61, '伊热夫斯克', 'Izhevsk', 'IJK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1036, 61, '伊万诺沃', 'Ivanovo', 'IVO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1037, 61, '约什卡尔奥拉', 'Yoshkar-Ola', 'YOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1038, 62, '阿苏艾', 'Azuay', 'A', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1039, 62, '埃尔奥罗', 'El Oro', 'O', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1040, 62, '埃斯梅拉尔达斯', 'Esmeraldas', 'E', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1041, 62, '玻利瓦尔', 'Bolivar', 'B', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1042, 62, '瓜亚斯', 'Guayas', 'G', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1043, 62, '加拉帕戈斯', 'Galapagos', 'W', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1044, 62, '卡尔奇', 'Carchi', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1045, 62, '卡尼亚尔', 'Canar', 'F', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1046, 62, '科托帕希', 'Cotopaxi', 'X', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1047, 62, '洛哈', 'Loja', 'L', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1048, 62, '洛斯里奥斯', 'Los Rios', 'R', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1049, 62, '马纳比', 'Manabi', 'M', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1050, 62, '莫罗纳－圣地亚哥', 'Morona-Santiago', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1051, 62, '纳波，奥雷利亚纳', 'Napo, Orellana', 'D', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1052, 62, '帕斯塔萨', 'Pastaza', 'Y', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1053, 62, '皮钦查', 'Pichincha', 'P', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1054, 62, '钦博拉索', 'Chimborazo', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1055, 62, '萨莫拉－钦奇佩', 'Zamora-Chinchipe', 'Z', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1056, 62, '苏昆毕奥斯', 'Sucumbios', 'U', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1057, 62, '通古拉瓦', 'Tungurahua', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1058, 62, '因巴布拉', 'Imbabura', 'I', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1059, 63, '安塞巴', 'Anseba', 'KE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1060, 63, '北红海', 'Semenawi Keyih Bahri', 'SK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1061, 63, '加什·巴尔卡', 'Gash Barka', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1062, 63, '南部', 'Debub', 'DE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1063, 63, '南红海', 'Debubawi Keyih Bahri', 'DK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1064, 63, '中部', 'Maekel', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1065, 64, '阿尔勒', 'Arles', 'ARL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1066, 64, '阿雅克修', 'Ajaccio', 'AJA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1067, 64, '艾克斯', 'Aix-en-Provence', 'QXB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1068, 64, '奥尔良', 'Orleans', 'ORR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1069, 64, '巴黎', 'Paris', 'PAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1070, 64, '贝桑松', 'Besancon', 'BSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1071, 64, '第戎', 'Dijon', 'DIJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1072, 64, '弗雷瑞斯', 'Frejus', 'FRJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1073, 64, '卡昂', 'Caen', 'CFR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1074, 64, '雷恩', 'Rennes', 'RNS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1075, 64, '里昂', 'Lyon', 'LIO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1076, 64, '里尔', 'Lille', 'LLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1077, 64, '利摩日', 'Limoges', 'LIG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1078, 64, '鲁昂', 'Rouen', 'URO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1079, 64, '马赛', 'Marseille', 'MRS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1080, 64, '梅斯', 'Metz', 'MZM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1081, 64, '蒙彼利埃', 'Montpellier', 'MPL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1082, 64, '南特', 'Nantes', 'NTE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1083, 64, '尼斯', 'Nice', 'NCE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1084, 64, '沙隆', 'Chalons-en-Champagne', 'CSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1085, 64, '图卢兹', 'Toulouse', 'TLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1086, 64, '瓦朗斯', 'Valence', 'VAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1087, 64, '亚眠', 'Amiens', 'AMI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1088, 70, '达沃', 'Davao', 'DOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1089, 70, '卡卢坎', 'Caloocan', 'CAO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1090, 70, '马尼拉', 'Manila', 'MNL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1091, 70, '宿务', 'Cebu', 'CEB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1092, 72, '埃斯波', 'Espoo', 'ESP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1093, 72, '奥卢', 'Oulu', 'OLU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1094, 72, '波里', 'Pori', 'POR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1095, 72, '博尔沃', 'Porvoo', 'PRV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1096, 72, '海门林纳', 'Hameenlinna', 'HMY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1097, 72, '赫尔辛基', 'Helsinki', 'HEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1098, 72, '卡亚尼', 'Kajaani', 'KAJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1099, 72, '科科拉', 'Kokkola', 'KOK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(1100, 72, '科特卡', 'Kotka', 'KTK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1101, 72, '库奥皮奥', 'Kuopio', 'KUO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1102, 72, '拉赫蒂', 'Lahti', 'LHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1103, 72, '拉彭兰塔', 'Lappeenranta', 'LPP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1104, 72, '罗瓦涅米', 'Rovaniemi', 'RVN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1105, 72, '玛丽港', 'Mariehamn', 'MHQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1106, 72, '米凯利', 'Mikkeli', 'MIK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1107, 72, '坦佩雷', 'Tampere', 'TMP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1108, 72, '图尔库', 'Turku', 'TKU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1109, 72, '瓦萨', 'Vaasa', 'VAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1110, 72, '万塔', 'Vantaa', 'VAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1111, 72, '约恩苏', 'Joensuu', 'JOE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1112, 73, '保尔', 'Paul', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1113, 73, '波多诺伏', 'Porto Novo', 'PN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1114, 73, '博阿维斯塔岛', 'Boa Vista', 'BV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1115, 73, '布拉瓦岛', 'Brava', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1116, 73, '大里贝拉', 'Ribeira Grande', 'RG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1117, 73, '福古岛', 'Fogo', 'FO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1118, 73, '马尤岛', 'Maio', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1119, 73, '莫斯特罗', 'Mosteiros', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1120, 73, '普拉亚', 'Praia', 'PR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1121, 73, '萨尔岛', 'Sal', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1122, 73, '圣安唐岛', 'Santo Antao', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1123, 73, '圣地亚哥岛', 'Santiago', 'IA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1124, 73, '圣多明戈', 'Sao Domingos', 'SD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1125, 73, '圣菲利普', 'Sao Filipe', 'SF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1126, 73, '圣卡塔琳娜', 'Santa Catarina', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1127, 73, '圣克鲁斯', 'Santa Cruz', 'CR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1128, 73, '圣米戈尔', 'Sao Miguel', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1129, 73, '圣尼古拉岛', 'Sao Nicolau', 'SN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1130, 73, '圣维森特岛', 'Sao Vicente', 'SV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1131, 73, '塔拉法尔', 'Tarrafal', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1132, 78, '阿劳卡', 'Arauca', 'ARA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1133, 78, '安提奥基亚', 'Antioquia', 'ANT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1134, 78, '北桑坦德', 'Norte de Santander', 'NDS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1135, 78, '波哥大首都区', 'Bogota', 'BDC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1136, 78, '博利瓦尔', 'Bolivar', 'BOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1137, 78, '博亚卡', 'Boyaca', 'BOY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1138, 78, '大西洋', 'Atlantico', 'ATL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1139, 78, '瓜维亚雷', 'Guaviare', 'GVR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1140, 78, '瓜希拉', 'La Guajira', 'GJR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1141, 78, '瓜伊尼亚', 'Guainia', 'GNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1142, 78, '金迪奥', 'Quindio', 'QUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1143, 78, '卡尔达斯', 'Caldas', 'CAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1144, 78, '卡克塔', 'Caqueta', 'CAQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1145, 78, '卡萨纳雷', 'Casanare', 'CAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1146, 78, '考卡', 'Cauca', 'CAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1147, 78, '考卡山谷', 'Valle del Cauca', 'VDC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1148, 78, '科尔多巴', 'Cordoba', 'COR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1149, 78, '昆迪纳马卡', 'Cundinamarca', 'CAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1150, 78, '利萨拉尔达', 'Risaralda', 'RIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1151, 78, '马格达雷那', 'Magdalena', 'MAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1152, 78, '梅塔', 'Meta', 'MET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1153, 78, '纳里尼奥', 'Narino', 'NAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1154, 78, '普图马约', 'Putumayo', 'PUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1155, 78, '乔科', 'Choco', 'CHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1156, 78, '塞萨尔', 'Cesar', 'CES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1157, 78, '桑坦德', 'Santander', 'SAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1158, 78, '圣安德烈斯-普罗维登西亚', 'San Andres y Providencia', 'SAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1159, 78, '苏克雷', 'Sucre', 'SUC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1160, 78, '托利马', 'Tolima', 'TOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1161, 78, '维查达', 'Vichada', 'VIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1162, 78, '沃佩斯', 'Vaupes', 'VAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1163, 78, '乌伊拉', 'Huila', 'HUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1164, 78, '亚马孙', 'Amazonas', 'AMZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1165, 79, '阿拉胡埃拉', 'Alajuela', 'A', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1166, 79, '埃雷迪亚', 'Heredia', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1167, 79, '瓜纳卡斯特', 'Guanacaste', 'G', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1168, 79, '卡塔戈', 'Cartago', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1169, 79, '利蒙', 'Limon', 'L', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1170, 79, '蓬塔雷纳斯', 'Puntarenas', 'P', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1171, 79, '圣何塞', 'San Jose', 'SJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1172, 83, '奥尔金', 'Holguin', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1173, 83, '比那尔德里奥', 'Pinar del Rio', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1174, 83, '比亚克拉拉', 'Villa Clara', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1175, 83, '格拉玛', 'Granma', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1176, 83, '关塔那摩', 'Guantanamo', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1177, 83, '哈瓦那', 'La Habana', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1178, 83, '哈瓦那城', 'Ciudad de la Habana', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1179, 83, '卡马圭', 'Camaguey', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1180, 83, '拉斯图纳斯', 'Las Tunas', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1181, 83, '马坦萨斯', 'Matanzas', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1182, 83, '马亚里', 'Mayari', 'MAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1183, 83, '曼萨尼罗', 'Manzanillo', 'MZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1184, 83, '青年岛特区', 'Isla de la Juventud', '99', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1185, 83, '圣地亚哥', 'Santiago de Cuba', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1186, 83, '圣斯皮里图斯', 'Sancti Spiritus', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1187, 83, '西恩富戈斯', 'Cienfuegos', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1188, 83, '谢戈德阿维拉', 'Ciego de Avila', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1189, 86, '埃塞奎博群岛-西德梅拉拉', 'Essequibo Islands-West Demerara', 'EW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1190, 86, '巴里马-瓦伊尼', 'Barima-Waini', 'BW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1191, 86, '波默伦-苏佩纳姆', 'Pomeroon-Supenaam', 'PM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1192, 86, '波塔罗-锡帕鲁尼', 'Potaro-Siparuni', 'PI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1193, 86, '德梅拉拉-马海卡', 'Demerara-Mahaica', 'DM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1194, 86, '东伯比斯-科兰太因', 'East Berbice-Corentyne', 'EC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1195, 86, '库尤尼-马扎鲁尼', 'Cuyuni-Mazaruni', 'CM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1196, 86, '马海卡-伯比斯', 'Mahaica-Berbice', 'MB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1197, 86, '上德梅拉拉-伯比斯', 'Upper Demerara-Berbice', 'UD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1198, 86, '上塔库图-上埃塞奎博', 'Upper Takutu-Upper Essequibo', 'UT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1199, 87, '阿尔卡累克', 'Arkalyk', 'AYK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1200, 87, '阿克莫拉', 'Aqmola', 'AKM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1201, 87, '阿克苏', 'Aksu', 'AKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1202, 87, '阿克托别', 'Aqtobe', 'AKT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1203, 87, '阿拉木图', 'Almaty', 'ALA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1204, 87, '阿雷斯', 'Arys', 'ARY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1205, 87, '阿斯塔纳市', 'Astana', 'AST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1206, 87, '阿特劳', 'Atyrau', 'ATY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1207, 87, '埃基巴斯图兹', 'Ekibastuz', 'EKB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1208, 87, '巴尔喀什', 'Balkhash', 'BXH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1209, 87, '巴甫洛达尔', 'Pavlodar', 'PAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1210, 87, '北哈萨克斯坦', 'Soltustik Qazaqstan', 'SEV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1211, 87, '东哈萨克斯坦', 'Shyghys Qazaqstan', 'VOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1212, 87, '济良诺夫斯克', 'Zyryanovsk', 'ZYR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1213, 87, '江布尔', 'Zhambyl', 'DMB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1214, 87, '杰兹卡兹甘', 'Zhezkazgan', 'DZH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1215, 87, '卡拉干达', 'Qaraghandy', 'KAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1216, 87, '卡拉扎尔', 'Karazhal', 'KZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1217, 87, '卡普恰盖', 'Kapchagay', 'KAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1218, 87, '科斯塔奈', 'Qostanay', 'KST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1219, 87, '克孜勒奥尔达', 'Qyzylorda', 'KZY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1220, 87, '肯套', 'Kentau', 'KEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1221, 87, '库尔恰托夫', 'Kurchatov', 'KUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1222, 87, '利萨科夫斯克', 'Lisakovsk', 'LKK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1223, 87, '列宁诺戈尔斯克', 'Leninogorsk', 'LEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1224, 87, '鲁德内', 'Rudny', 'RUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1225, 87, '曼格斯套', 'Mangghystau', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1226, 87, '南哈萨克斯坦', 'Ongtustik Qazaqstan', 'KGT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1227, 87, '萨兰', 'Saran', 'SAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1228, 87, '塞梅伊', 'Semey', 'SEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1229, 87, '沙赫京斯克', 'Shakhtinsk', 'SAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1230, 87, '斯捷普诺戈尔斯克', 'Stepnogorsk', 'STE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1231, 87, '铁克利', 'Tekeli', 'TEK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1232, 87, '铁米尔套', 'Temirtau', 'TEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1233, 87, '突厥斯坦', 'Turkestan', 'TUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1234, 87, '西哈萨克斯坦', 'Batys Qazaqstan', 'ZAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1235, 87, '扎纳奥津', 'Zhanaozen', 'ZHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1236, 90, '阿尔梅勒', 'Almere', 'AER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1237, 90, '阿默斯福特', 'Amersfoort', 'AME', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1238, 90, '阿姆斯特丹', 'Amsterdam', 'AMS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1239, 90, '阿纳姆', 'Arnhem', 'ARN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1240, 90, '阿珀尔多伦', 'Apeldoorn', 'APE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1241, 90, '阿森', 'Assen', 'ASS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1242, 90, '埃德', 'Ede', 'EDE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1243, 90, '埃门', 'Emmen', 'EMM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1244, 90, '埃因霍芬', 'Eindhoven', 'EIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1245, 90, '布雷达', 'Breda', 'BRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1246, 90, '蒂尔堡', 'Tilburg', 'TLB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1247, 90, '多德雷赫特', 'Dordrecht', 'DOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1248, 90, '恩斯赫德', 'Enschede', 'ENS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1249, 90, '格罗宁根', 'Groningen', 'GRQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1250, 90, '哈勒姆', 'Haarlem', 'HRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1251, 90, '海牙', 'Hague', 'HAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1252, 90, '霍夫多尔普', 'Hoofddorp', 'HFD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1253, 90, '莱顿', 'Leiden', 'LID', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1254, 90, '莱利斯塔德', 'Lelystad', 'LEY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1255, 90, '鹿特丹', 'Rotterdam', 'RTM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1256, 90, '吕伐登', 'Leeuwarden', 'LWR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1257, 90, '马斯特里赫特', 'Maastricht', 'MST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1258, 90, '米德尔堡', 'Middelburg', 'MDL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1259, 90, '奈梅亨', 'Nijmegen', 'NIJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1260, 90, '斯海尔托亨博思', '''s-Hertogenbosch', 'HTB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1261, 90, '乌得勒支', 'Utrecht', 'UTC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1262, 90, '兹沃勒', 'Zwolle', 'ZWO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1263, 90, '佐特尔梅', 'Zoetermeer', 'ZTM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1264, 93, '阿特兰蒂达', 'Atlantida', 'AT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1265, 93, '埃尔帕拉伊索', 'El Paraiso', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1266, 93, '奥科特佩克', 'Ocotepeque', 'OC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1267, 93, '奥兰乔', 'Olancho', 'OL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1268, 93, '弗朗西斯科-莫拉桑', 'Francisco Morazan', 'FM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1269, 93, '格拉西亚斯-阿迪奥斯', 'Gracias a Dios', 'GD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1270, 93, '海湾群岛', 'Islas de la Bahia', 'IB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1271, 93, '科尔特斯', 'Cortes', 'CR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1272, 93, '科隆', 'Colon', 'CL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1273, 93, '科马亚瓜', 'Comayagua', 'CM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1274, 93, '科潘', 'Copan', 'CP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1275, 93, '拉巴斯', 'La Paz', 'PZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1276, 93, '伦皮拉', 'Lempira', 'LE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1277, 93, '乔卢特卡', 'Choluteca', 'CH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1278, 93, '乔罗马', 'Choloma', 'CHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1279, 93, '山谷', 'Valle', 'VA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1280, 93, '圣巴巴拉', 'Santa Barbara', 'SB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1281, 93, '因蒂布卡', 'Intibuca', 'IN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1282, 93, '约罗', 'Yoro', 'YO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1283, 94, '菲尼克斯群岛', 'Phoenix Islands', 'PHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1284, 94, '吉尔伯特群岛', 'Gilberts Islands', 'GIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1285, 94, '莱恩群岛', 'Line Islands', 'LIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1286, 95, '阿里萨比赫区', 'Ali Sabih', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1287, 95, '奥博克区', 'Obock', 'O', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1288, 95, '迪基勒区', 'Dikhil', 'K', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1289, 95, '塔朱拉区', 'Tadjoura', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1290, 96, '奥什', 'Osh', 'O', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1291, 96, '巴特肯', 'Batken', 'B', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1292, 96, '比什凯克市', 'Bishkek', 'GB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1293, 96, '楚河', 'Chuy', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1294, 96, '贾拉拉巴德', 'Jalal-Abad', 'J', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1295, 96, '卡拉巴尔塔', 'Karabalta', 'KBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1296, 96, '卡拉库尔', 'Kara-Kol', 'KKO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1297, 96, '坎特', 'Kant', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1298, 96, '科克扬加克', 'Kok-Jangak', 'KJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1299, 96, '迈利赛', 'Mailuu-Suu', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1300, 96, '纳伦', 'Naryn', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1301, 96, '苏卢克图', 'Suluktu', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1302, 96, '塔拉斯', 'Talas', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1303, 96, '塔什库梅尔', 'Tash-Kumyr', 'TK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1304, 96, '乌兹根', 'Uzgen', 'UG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1305, 96, '伊塞克湖', 'Ysyk-Kol', 'Y', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1306, 97, '博凯', 'Boke', 'BOK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1307, 97, '恩泽雷科雷', 'Nzerekore', 'NZR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1308, 97, '法拉纳', 'Faranah', 'FRN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1309, 97, '金迪亚', 'Kindia', 'KND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1310, 97, '康康', 'Kankan', 'KNK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1311, 97, '科纳克里', 'Conakry', 'CNK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1312, 97, '拉贝', 'Labe', 'LAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1313, 97, '玛木', 'Mamou', 'MAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1314, 99, '阿伯茨福', 'Abbotsford', 'ABB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1315, 99, '埃德蒙顿', 'Edmonton', 'EDM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1316, 99, '奥沙瓦', 'Oshawa', 'OSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1317, 99, '巴里', 'Barrie', 'BAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1318, 99, '布列塔尼角', 'Cape Breton', 'CBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1319, 99, '多伦多', 'Toronto', 'TOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1320, 99, '弗雷德里顿', 'Fredericton', 'FRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1321, 99, '圭尔夫', 'Guelph', 'GLP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1322, 99, '哈利法克斯', 'Halifax', 'HAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1323, 99, '哈密尔顿', 'Hamilton', 'HAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1324, 99, '怀特霍斯', 'Whitehorse', 'YXY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1325, 99, '基劳纳', 'Kelowna', 'KWL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1326, 99, '基奇纳', 'Brampton', 'BRP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1327, 99, '金斯敦', 'Kingston', 'KGN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1328, 99, '卡里加里', 'Calgary', 'CAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1329, 99, '魁北克', 'Quebec', 'QUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1330, 99, '里贾纳', 'Regina', 'REG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1331, 99, '伦敦', 'London', 'LOD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1332, 99, '蒙特利尔', 'Montreal', 'MTR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1333, 99, '萨德伯里', 'Sudbury', 'SUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1334, 99, '萨斯卡通', 'Saskatoon', 'SAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1335, 99, '三河城', 'Trois-Rivieres', 'TRR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1336, 99, '桑德贝', 'Thunder Bay', 'THU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1337, 99, '舍布鲁克', 'Sherbrooke', 'SBE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1338, 99, '圣卡塔琳娜', 'St. Catharines', 'SCA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1339, 99, '圣约翰斯', 'Saint-John''s', 'SJB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1340, 99, '维多利亚', 'Victoria', 'VIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1341, 99, '温哥华', 'Vancouver', 'VAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1342, 99, '温尼伯', 'Winnipeg', 'WNP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1343, 99, '温莎', 'Windsor', 'WDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1344, 99, '渥太华', 'Ottawa', 'OTT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1345, 99, '夏洛特敦', 'Charlottetown', 'CHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1346, 99, '耶洛奈夫', 'Yellowknife', 'YZF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1347, 99, '伊魁特', 'Iqaluit', 'IQL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1348, 100, '阿散蒂', 'Ashanti', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1349, 100, '奥布阿西', 'Obuasi', 'OBU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1350, 100, '北部', 'Northern', 'NO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1351, 100, '布朗阿哈福', 'Brong Ahafo', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1352, 100, '大阿克拉', 'Greater Accra', 'GA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1353, 100, '东部', 'Eastern', 'EA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1354, 100, '上东部', 'Upper East', 'UE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1355, 100, '上西部', 'Upper West', 'UW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1356, 100, '沃尔特', 'Volta', 'VO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1357, 100, '西部', 'Western', 'WE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1358, 100, '中部', 'Central', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1359, 101, '奥果韦-洛洛', 'Ogooue-Lolo', 'OL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1360, 101, '奥果韦-伊温多', 'Ogooue-Ivindo', 'OI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1361, 101, '滨海奥果韦', 'Ogooue-Maritime', 'OM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1362, 101, '恩古涅', 'Ngounie', 'NG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1363, 101, '河口', 'Estuaire', 'ES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1364, 101, '尼扬加', 'Nyanga', 'NY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1365, 101, '上奥果韦', 'Haut-Ogooue', 'HO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1366, 101, '沃勒-恩特姆', 'Woleu-Ntem', 'WN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1367, 101, '中奥果韦', 'Moyen-Ogooue', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1368, 102, '奥多棉吉', 'Otdar Mean Chey', 'OC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1369, 102, '白马市', 'Krong Keb', 'KB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1370, 102, '柏威夏', 'Preah Vihear', 'PR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1371, 102, '拜林市', 'Krong Pailin', 'PL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1372, 102, '班迭棉吉', 'Banteay Mean Chey', 'BM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1373, 102, '磅清扬', 'Kampong Chhnang', 'KZC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1374, 102, '磅士卑', 'Kampong Spoe', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1375, 102, '磅同', 'Kampong Thum', 'KZK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1376, 102, '磅湛', 'Kampong Cham', 'KM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1377, 102, '波罗勉', 'Prey Veng', 'PG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1378, 102, '茶胶', 'Takev', 'TK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1379, 102, '柴桢', 'Svay Rieng', 'SVR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1380, 102, '干丹', 'Kandal', 'KL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1381, 102, '戈公', 'Kaoh Kong', 'KKZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1382, 102, '贡布', 'Kampot', 'KMT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1383, 102, '金边市', 'Phnum Penh', 'PNH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1384, 102, '桔井', 'Kracheh', 'KH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1385, 102, '腊塔纳基里', 'Rotanak Kiri', 'RBE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1386, 102, '马德望', 'Bat Dambang', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1387, 102, '蒙多基里', 'Mondol Kiri', 'MWV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1388, 102, '菩萨', 'Pouthĭsat', 'PO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1389, 102, '上丁', 'Stoeng Treng', 'TNX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1390, 102, '西哈努克市', 'Krong Preah', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1391, 102, '暹粒', 'Siem Reab', 'REP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1392, 103, '奥洛穆茨', 'Olomoucky', 'OL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1393, 103, '比尔森', 'Plzensky', 'PL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1394, 103, '布拉格直辖市', 'Prague', 'PR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1395, 103, '赫拉德茨-克拉洛韦', 'Kralovehradecky', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1396, 103, '卡罗维发利', 'Karlovarsky', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1397, 103, '利贝雷克', 'Liberecky', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1398, 103, '摩拉维亚-西里西亚', 'Moravskoslezsky', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1399, 103, '南摩拉维亚', 'Jihomoravsky', 'JC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1400, 103, '帕尔杜比采', 'Pardubicky', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1401, 103, '维索基纳', 'Vysocina', 'VY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1402, 103, '乌斯季', 'Ustecky', 'US', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1403, 103, '中捷克', 'Stredocesky', 'ST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1404, 103, '兹林', 'Zlinsky', 'ZL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1405, 104, '北马塔贝莱兰', 'Matabeleland North', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1406, 104, '布拉瓦约', 'Bulawayo', 'BU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1407, 104, '东马绍纳兰', 'Mashonaland East', 'ME', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1408, 104, '哈拉雷', 'Harare', 'HA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1409, 104, '马尼卡兰', 'Manicaland', 'ML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1410, 104, '马斯温戈', 'Masvingo', 'MV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1411, 104, '南马塔贝莱兰', 'Matabeleland South', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1412, 104, '西马绍纳兰', 'Mashonaland West', 'MW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1413, 104, '中部', 'Midlands', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1414, 104, '中马绍纳兰', 'Mashonaland Central', 'MC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1415, 105, '阿达马瓦', 'Adamaoua', 'ADA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1416, 105, '北部', 'Nord', 'NOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1417, 105, '北端', 'Extreme-Nord', 'EXN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1418, 105, '滨海', 'Littoral', 'LIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1419, 105, '东部', 'Est', 'EST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1420, 105, '南部', 'Sud', 'SUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1421, 105, '西北', 'Nord-Oueste', 'NOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1422, 105, '西部', 'Ouest', 'OUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1423, 105, '西南', 'Sud-Oueste', 'SOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1424, 105, '中央', 'Centre', 'CEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1425, 106, '北部', 'Madinat ach Shamal', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1426, 106, '多哈', 'Ad Dawhah', 'DW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1427, 106, '古韦里耶', 'Al Ghuwariyah', 'GW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1428, 106, '豪尔', 'Al Khawr', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1429, 106, '杰里扬拜特奈', 'Jariyan al Batnah', 'JB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1430, 106, '赖扬', 'Ar Rayyan', 'RN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1431, 106, '沃克拉', 'Al Wakrah', 'WK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1432, 106, '乌姆锡拉勒', 'Umm Salal', 'UL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1433, 106, '朱迈利耶', 'Al Jumaliyah', 'JM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1434, 110, '阿涅比', 'Agnebi', 'AG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1435, 110, '巴芬', 'Bafing', 'BF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1436, 110, '邦达马河谷', 'Vallee du Bandama', 'VB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1437, 110, '登盖莱', 'Denguele', 'DE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1438, 110, '恩济－科莫埃', 'Nzi-Comoe', 'NC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1439, 110, '弗罗马格尔', 'Fromager', 'FR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1440, 110, '湖泊', 'Lacs', 'LC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1441, 110, '马拉韦', 'Marahoue', 'MR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1442, 110, '南邦达马', 'Sud-Bandama', 'SB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1443, 110, '南科莫埃', 'Sud-Comoe', 'SC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1444, 110, '萨桑德拉', 'Haut-Sassandra', 'HT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1445, 110, '萨瓦纳', 'Savanes', 'SV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1446, 110, '山地', 'Montagnes', 'DH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1447, 110, '沃罗杜古', 'Worodougou', 'WR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1448, 110, '下萨桑德拉', 'Bas-Sassandra', 'BS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1449, 110, '泻湖', 'Lagunes', 'LG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1450, 110, '赞赞', 'Zanzan', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1451, 110, '中卡瓦利', 'Moyen-Cavally', 'MV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1452, 110, '中科莫埃', 'Moyen-Comoe', 'MC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1453, 112, '奥西耶克-巴拉尼亚', 'Osjecko-Baranjska', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1454, 112, '别洛瓦尔-比洛戈拉', 'Bjelovarsko-Bilogorska', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1455, 112, '滨海和山区', 'Primorsko-Goranska', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1456, 112, '波热加-斯拉沃尼亚', 'Pozega-Slavonia', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1457, 112, '布罗德-波萨维纳', 'Brodsko-Posavska', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1458, 112, '杜布罗夫斯克-内雷特瓦', 'Dubrovacko-Neretvanska', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1459, 112, '卡尔洛瓦茨', 'Karlovacka', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1460, 112, '科普里夫尼察-克里热夫齐', 'Koprivnicko-Krizevacka', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1461, 112, '克拉皮纳-扎戈列', 'Krapinsko-Zagorska', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1462, 112, '利卡-塞尼', 'Licko-Senjska', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1463, 112, '梅吉穆列', 'Medimurska', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1464, 112, '萨格勒布', 'Zagrebacka', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1465, 112, '萨格勒布市', 'Grad Zagreb', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1466, 112, '斯普利特-达尔马提亚', 'Splitsko-Dalmatinska', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1467, 112, '瓦拉日丁', 'Varazdinska', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1468, 112, '维罗维蒂察-波德拉维纳', 'Viroviticko-Podravska', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1469, 112, '武科瓦尔-斯里耶姆', 'Vukovarsko-Srijemska', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1470, 112, '希贝尼克-克宁', 'Sibensko-Kninska', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1471, 112, '锡萨克-莫斯拉维纳', 'Sisacko-Moslavacka', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1472, 112, '伊斯特拉', 'Istarska', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1473, 112, '扎达尔', 'Zadarska', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1474, 113, '埃尔格约-马拉奎特', 'Elgeyo-Marakwet', 'EMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1475, 113, '巴林戈', 'Baringo', 'BAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1476, 113, '邦戈马', 'Bungoma', 'BUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1477, 113, '博美特', 'Bomet', 'BOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1478, 113, '布希亚', 'Busia', 'BUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1479, 113, '恩布', 'Embu', 'EMB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1480, 113, '霍马湾', 'Homa Bay', 'HOB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1481, 113, '基安布', 'Kiambu', 'KIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1482, 113, '基里菲', 'Kilifi', 'KIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1483, 113, '基里尼亚加', 'Kirinyaga', 'KIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1484, 113, '基苏木', 'Kisumu', 'KIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1485, 113, '基图伊', 'Kitui', 'KIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1486, 113, '基西', 'Kisii', 'KII', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1487, 113, '加里萨', 'Garissa', 'GAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1488, 113, '卡卡梅加', 'Kakamega', 'KAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1489, 113, '卡耶亚多', 'Kajiado', 'KAJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1490, 113, '凯里乔', 'Kericho', 'KEY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1491, 113, '夸勒', 'Kwale', 'KWA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1492, 113, '拉木', 'Lamu', 'LAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1493, 113, '莱基皮亚', 'Laikipia', 'LAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1494, 113, '马查科斯', 'Machakos', 'MAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1495, 113, '马瓜尼', 'Makueni', 'MAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1496, 113, '马萨布布', 'Marsabit', 'RBT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1497, 113, '曼德拉', 'Mandera', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1498, 113, '梅鲁', 'Meru', 'MER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1499, 113, '蒙巴萨', 'Mombasa', 'MOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1500, 113, '米戈利', 'Migori', 'MIG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1501, 113, '穆兰卡', 'Muranga', 'MUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1502, 113, '纳库鲁', 'Nakuru', 'NUU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1503, 113, '纳罗克', 'Narok', 'NAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1504, 113, '南迪', 'Nandi', 'NAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1505, 113, '内罗毕', 'Nairobi', 'NA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1506, 113, '尼蒂', 'Nithi', 'NIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1507, 113, '尼亚米拉', 'Nyamira', 'NYM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1508, 113, '年达鲁阿', 'Nyandarua', 'NYN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1509, 113, '涅里', 'Nyeri', 'NYE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1510, 113, '桑布卢', 'Samburu', 'UAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1511, 113, '塔纳河', 'Tana River', 'TRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1512, 113, '泰塔塔维塔', 'Taita-Taveta', 'TTA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1513, 113, '特兰斯-恩佐亚', 'Trans-Nzoia', 'TNZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1514, 113, '图尔卡纳', 'Turkana', 'TUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1515, 113, '瓦吉尔', 'Wajir', 'WJR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1516, 113, '瓦辛基苏', 'Uasin Gishu', 'UGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1517, 113, '韦希加', 'Vihiga', 'VIH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1518, 113, '西波克特', 'West Pokot', 'WPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1519, 113, '夏亚', 'Siaya', 'SIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1520, 113, '伊希约洛', 'Isiolo', 'ISI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1521, 113, '中央', 'Central', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1522, 115, '阿卢克斯内', 'Aluksnes', 'ALU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1523, 115, '爱兹克劳克雷', 'Aizkraukles', 'AIZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1524, 115, '奥格雷', 'Ogres', 'OGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1525, 115, '巴尔维', 'Balvu', 'BAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1526, 115, '包斯卡', 'Bauskas', 'BAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1527, 115, '采西斯', 'Cesu', 'CES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1528, 115, '多贝莱', 'Dobeles', 'DOB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1529, 115, '古尔贝内', 'Gulbenes', 'GUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1530, 115, '杰卡布皮尔斯', 'Jekabpils', 'JEK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1531, 115, '克拉斯拉瓦', 'Kraslavas', 'KRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1532, 115, '库尔迪加', 'Kuldigas', 'KUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1533, 115, '雷泽克内', 'Rezeknes', 'RZR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1534, 115, '里加', 'Rigas', 'RGA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1535, 115, '利耶帕亚', 'Liepajas', 'LPK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1536, 115, '林巴济', 'Limbazu', 'LIM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1537, 115, '卢扎', 'Ludzas', 'LUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1538, 115, '马多纳', 'Madonas', 'MAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1539, 115, '普雷利', 'Preilu', 'PRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1540, 115, '萨尔杜斯', 'Saldus', 'SAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1541, 115, '塔尔西', 'Talsu', 'TAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1542, 115, '陶格夫皮尔斯', 'Daugavpils', 'DGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1543, 115, '图库马', 'Tukuma', 'TUK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1544, 115, '瓦尔加', 'Valkas', 'VLK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1545, 115, '瓦尔米耶拉', 'Valmieras', 'VLM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1546, 115, '文茨皮尔斯', 'Ventspils', 'VSL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1547, 115, '叶尔加瓦', 'Jelgavas', 'JGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1548, 116, '伯里亚', 'Berea', 'D', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1549, 116, '布塔布泰', 'Butha-Buthe', 'B', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1550, 116, '古廷', 'Quthing', 'G', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1551, 116, '加查斯内克', 'Qachas Nek', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1552, 116, '莱里贝', 'Leribe', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1553, 116, '马费滕', 'Mafeteng', 'E', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1554, 116, '马塞卢', 'Maseru', 'A', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1555, 116, '莫哈莱斯胡克', 'Mohales Hoek', 'F', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1556, 116, '莫霍特隆', 'Mokhotlong', 'J', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1557, 116, '塔巴采卡', 'Thaba-Tseka', 'K', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1558, 117, '阿速坡', 'Attapu', 'AT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1559, 117, '波里坎赛', 'Bolikhamxai', 'BL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1560, 117, '博乔', 'Bokeo', 'BK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1561, 117, '川圹', 'Xiangkhoang', 'XI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1562, 117, '丰沙里', 'Phongsali', 'PH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1563, 117, '甘蒙', 'Khammouan', 'KH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1564, 117, '华潘', 'Houaphan', 'HO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1565, 117, '琅勃拉邦', 'Louangphrabang', 'LP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1566, 117, '琅南塔', 'Louang Namtha', 'LM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1567, 117, '赛宋本行政特区', 'Xaisomboun', 'XN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1568, 117, '色贡', 'Xekong', 'XE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1569, 117, '沙拉湾', 'Saravan', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1570, 117, '沙湾拿吉', 'Savannakhet', 'SV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1571, 117, '沙耶武里', 'Xaignabouri', 'XA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1572, 117, '万象', 'Vientiane', 'VI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1573, 117, '乌多姆赛', 'Oudomxai', 'OU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1574, 117, '占巴塞', 'Champasak', 'CH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1575, 118, '北部', 'Ash-Shamal', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1576, 118, '贝卡', 'Al-Biqa', 'BI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1577, 118, '贝鲁特', 'Bayrut', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1578, 118, '黎巴嫩山', 'Jabal Lubnan', 'JL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1579, 118, '奈拜提耶市', 'An-Nabatiyah', 'NA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1580, 118, '南部', 'Al-Janub', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1581, 119, '巴波卢', 'Gbarpolu', 'GBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1582, 119, '邦', 'Bong', 'BG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1583, 119, '博波卢', 'Bopolu', 'BOP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1584, 119, '博米', 'Bomi', 'BM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1585, 119, '大巴萨', 'Grand Bassa', 'GB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1586, 119, '大吉德', 'Grand Gedeh', 'GG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1587, 119, '大角山', 'Grand Cape Mount', 'CM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1588, 119, '大克鲁', 'Grand Kru', 'GK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1589, 119, '菲什敦', 'Fish Town', 'FT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1590, 119, '吉河', 'River Gee', 'RG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1591, 119, '里弗塞斯', 'River Cess', 'RI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1592, 119, '洛法', 'Lofa', 'LO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1593, 119, '马吉比', 'Margibi', 'MG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1594, 119, '马里兰', 'Maryland', 'MY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1595, 119, '蒙特塞拉多', 'Montserrado', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1596, 119, '宁巴', 'Nimba', 'NI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1597, 119, '锡诺', 'Sinoe', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1598, 121, '阿利图斯', 'Alytus', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1599, 121, '考纳斯', 'Kaunas', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1600, 121, '克莱佩达', 'Klaipeda', 'KL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1601, 121, '马里扬泊列', 'Marijampole', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1602, 121, '帕涅韦日斯', 'Panevezys', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1603, 121, '陶拉格', 'Taurages', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1604, 121, '特尔希艾', 'Telsiu', 'TE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1605, 121, '维尔纽斯', 'Vilnius', 'VI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1606, 121, '乌田纳', 'Utenos', 'UT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1607, 121, '希奥利艾', 'Siauliai', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1608, 121, '亚克曼', 'Akmenes', 'AKM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1609, 124, '迪基希', 'Diekirch', 'DD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1610, 124, '格雷文马赫', 'Grevenmacher', 'GG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1611, 124, '卢森堡', 'Luxembourg', 'LL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1612, 125, '比温巴', 'Byumba', 'BY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1613, 125, '布塔雷', 'Butare', 'BU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1614, 125, '恩延扎', 'Nyanza', 'NY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1615, 125, '基本古', 'Kibungo', 'KG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1616, 125, '基布耶', 'Kibuye', 'KY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1617, 125, '基加利-恩加利', 'Kigali-Ngali', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1618, 125, '基加利市', 'Kigali-Ville', 'KV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1619, 125, '吉孔戈罗', 'Gikongoro', 'GK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1620, 125, '吉塞尼', 'Gisenyi', 'GS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1621, 125, '吉塔拉马', 'Gitarama', 'GT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1622, 125, '卡布加', 'Kabuga', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1623, 125, '卢瓦马加纳', 'Rwamagana', 'RW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1624, 125, '鲁汉戈', 'Ruhango', 'RH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1625, 125, '鲁亨盖里', 'Ruhengeri', 'RU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1626, 125, '尚古古', 'Cyangugu', 'CY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1627, 125, '乌姆塔拉', 'Umutara', 'UM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1628, 126, '阿尔巴尤利亚', 'Alba Iulia', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1629, 126, '阿拉德', 'Arad', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1630, 126, '奥拉迪亚', 'Oradea', 'OR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1631, 126, '巴克乌', 'Bacau', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(1632, 126, '巴亚马雷', 'Baia Mare', 'BM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1633, 126, '比斯特里察', 'Bistrita', 'BN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1634, 126, '博托沙尼', 'Botosani', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1635, 126, '布加勒斯特', 'Bucuresti', 'BC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1636, 126, '布拉索夫', 'Brasov', 'BS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1637, 126, '布勒伊拉', 'Braila', 'BL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1638, 126, '布泽乌', 'Buzau', 'BZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1639, 126, '德罗贝塔-塞维林堡', 'Drobeta-Turnu Severin', 'DT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1640, 126, '德瓦', 'Deva', 'DE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1641, 126, '蒂米什瓦拉', 'Timisoara', 'TI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1642, 126, '福克沙尼', 'Focsani', 'FO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1643, 126, '加拉茨', 'Galati', 'GL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1644, 126, '久尔久', 'Giurgiu', 'GG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1645, 126, '康斯坦察', 'Constanta', 'CT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1646, 126, '克拉约瓦', 'Craiova', 'DO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1647, 126, '克勒拉希', 'Calarasi', 'CR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1648, 126, '克卢日纳波卡', 'Cluj-Napoca', 'CN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1649, 126, '勒姆尼库沃尔恰', 'XRimnicu Vilcea', 'VI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1650, 126, '雷希察', 'Resita', 'RE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1651, 126, '梅尔库里亚丘克', 'Miercurea-Ciuc', 'MC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1652, 126, '皮特什蒂', 'Pitesti', 'PI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1653, 126, '皮亚特拉尼亚姆茨', 'Piatra Neamt', 'PN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1654, 126, '普洛耶什蒂', 'Ploiesti', 'PL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1655, 126, '萨图·马雷', 'Satu Mare', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1656, 126, '圣格奥尔基', 'Sfantu-Gheorghe', 'SG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1657, 126, '斯拉蒂纳', 'Slatina', 'ST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1658, 126, '斯洛博齐亚', 'Slobozia', 'SB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1659, 126, '苏恰瓦', 'Suceava', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1660, 126, '特尔戈维什泰', 'Targovişte', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1661, 126, '特尔古穆列什', 'Tirgu Mures', 'TM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1662, 126, '特尔古日乌', 'Tirgu-Jiu', 'TJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1663, 126, '图尔恰', 'Tulcea', 'TU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1664, 126, '瓦斯卢伊', 'Vaslui', 'VA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1665, 126, '锡比乌', 'Sibiu', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1666, 126, '雅西', 'Iasi', 'IS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1667, 126, '亚厉山德里亚', 'Alexandria', 'AD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1668, 126, '扎勒乌', 'Zalau', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1669, 127, '安齐拉纳纳', 'Antsiranana', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1670, 127, '菲亚纳兰楚阿', 'Fianarantsoa', 'FN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1671, 127, '马哈赞加', 'Mahajanga', 'MJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1672, 127, '塔那那利佛', 'Antananarivo', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1673, 127, '图阿马西拉', 'Toamasina', 'TM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1674, 127, '图利亚拉', 'Toliary', 'TL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1675, 128, '阿杜', 'Addu Atoll', 'ADD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1676, 128, '北阿里', 'North Ari Atoll', 'AAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1677, 128, '北蒂拉杜马蒂', 'North Thiladhunmathi', 'THD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1678, 128, '北马洛斯马杜卢', 'North Maalhosmadhulu', 'MAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1679, 128, '北米拉杜马杜卢', 'North Miladhunmadhulu', 'MLD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1680, 128, '北尼兰杜', 'North Nilandhe Atoll', 'NAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1681, 128, '北苏瓦迪瓦', 'North Huvadhu Atoll', 'HAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1682, 128, '法迪福卢', 'Faadhippolhu', 'FAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1683, 128, '费利杜', 'Felidhu Atoll', 'FEA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1684, 128, '福阿穆拉库', 'Foammulah', 'FMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1685, 128, '哈杜马蒂', 'Hadhdhunmathi', 'HDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1686, 128, '科卢马杜卢', 'Kolhumadulu', 'KLH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1687, 128, '马累', 'Male', 'MAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1688, 128, '马累岛', 'Male Atoll', 'MAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1689, 128, '穆拉库', 'Mulakatholhu', 'MUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1690, 128, '南阿里', 'South Ari Atoll', 'AAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1691, 128, '南蒂拉杜马蒂', 'South Thiladhunmathi', 'THU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1692, 128, '南马洛斯马杜卢', 'South Maalhosmadulu', 'MAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1693, 128, '南米拉杜马杜卢', 'South Miladhunmadhulu', 'MLU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1694, 128, '南尼兰杜', 'South Nilandhe Atoll', 'NAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1695, 128, '南苏瓦迪瓦', 'South Huvadhu Atoll', 'HAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1696, 130, '北部区', 'Northern', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1697, 130, '南部区', 'Southern', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1698, 130, '中央区', 'Central', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1699, 132, '巴马科首都区', 'Bamako', 'CD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1700, 132, '基达尔', 'Kidal', 'KD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1701, 132, '加奥', 'Gao', 'GA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1702, 132, '卡伊', 'Kayes', 'KY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1703, 132, '库利科罗', 'Koulikoro', 'KL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1704, 132, '莫普提', 'Mopti', 'MP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1705, 132, '塞古', 'Segou', 'SG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1706, 132, '通布图', 'Tombouctou', 'TB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1707, 132, '锡卡索', 'Sikasso', 'SK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1708, 139, '阿德拉尔', 'Adrar', 'AD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1709, 139, '阿萨巴', 'El-Acaba', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1710, 139, '卜拉克纳', 'Brakna', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1711, 139, '东胡德', 'Hodh el-Gharbi', 'HG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1712, 139, '戈尔戈勒', 'Gorgol', 'GO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1713, 139, '吉迪马卡', 'Guidimaka', 'GM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1714, 139, '努瓦迪布湾', 'Dakhlet Nouadhibou', 'DN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1715, 139, '努瓦克肖特特区', 'Nouakchott', 'NO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1716, 139, '塔甘特', 'Tagant', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1717, 139, '特拉扎', 'Trarza', 'TR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1718, 139, '提里斯-宰穆尔', 'Tiris Zemmour', 'TZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1719, 139, '西胡德', 'Hodh ech-Chargui', 'HC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1720, 139, '因希里', 'Inchiri', 'IN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1721, 141, '阿纳', 'Aana', 'AAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1722, 141, '阿图阿', 'Atua', 'ATU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1723, 141, '艾加伊勒泰', 'Aigaile Tai', 'AIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1724, 141, '法塞莱莱阿加', 'Faasaleleaga', 'FAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1725, 141, '加盖福毛加', 'Gagaifomauga', 'GFG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1726, 141, '加加埃毛加', 'Gagaemauga', 'GMG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1727, 141, '帕劳利', 'Palauli', 'PAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1728, 141, '萨图帕伊泰阿', 'Satupaitea', 'SAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1729, 141, '萨瓦伊岛', 'Savaii', 'SAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1730, 141, '图阿马萨加', 'Tuamasaga', 'TUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1731, 141, '瓦奥福诺蒂', 'Vaao Fonoti', 'VAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1732, 141, '韦西加诺', 'Vaisigano', 'VAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1733, 141, '乌波卢岛', 'Upolu', 'UPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1734, 143, '巴彦洪格尔', 'Bayanhongor', '69', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1735, 143, '巴彦乌勒盖', 'Bayan-Ulgiy', '71', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1736, 143, '布尔干', 'Bulgan', '67', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1737, 143, '达尔汗乌勒', 'Darhan-Uul', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1738, 143, '东方', 'Dornod', '61', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1739, 143, '东戈壁', 'Dornogovi', '63', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1740, 143, '鄂尔浑', 'Orhon', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1741, 143, '戈壁阿尔泰', 'Govi-Altay', '65', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1742, 143, '戈壁苏木贝尔', 'Govisumber', '64', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1743, 143, '后杭爱', 'Arhangay', '73', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1744, 143, '科布多', 'Hovd', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1745, 143, '肯特', 'Hentiy', '39', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1746, 143, '库苏古尔', 'Hovsgol', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1747, 143, '南戈壁', 'Umnogovi', 'UMN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1748, 143, '前杭爱', 'Uvorhangay', 'UVO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1749, 143, '色楞格', 'Selenge', '49', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1750, 143, '苏赫巴托尔', 'Suhbaatar', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1751, 143, '乌布苏', 'Uvs', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1752, 143, '乌兰巴托市', 'Ulaanbaatar hot', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1753, 143, '扎布汗', 'Dzavhan', '57', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1754, 143, '中戈壁', 'Dundgovi', '59', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1755, 143, '中央', 'Tov', '47', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1756, 145, '达卡', 'Dhaka', 'DAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1757, 145, '吉大港', 'Chittagong', 'CGP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1758, 145, '库尔纳', 'Khulna', 'KHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1759, 147, '阿雷基帕', 'Arequipa', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1760, 147, '阿普里马克', 'Apurimac', 'AP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1761, 147, '阿亚库乔', 'Ayacucho', 'AY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1762, 147, '安卡什', 'Ancash', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1763, 147, '胡利亚卡', 'Juliaca', 'JUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1764, 147, '胡宁', 'Junin', 'JU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1765, 147, '卡哈马卡', 'Cajamarca', 'CJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1766, 147, '卡亚俄', 'Callao', 'CL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1767, 147, '库斯科', 'Cusco', 'CU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1768, 147, '拉利伯塔德', 'La Libertad', 'LD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1769, 147, '兰巴耶克', 'Lambayeque', 'LY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1770, 147, '利马', 'Lima', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1771, 147, '洛雷托', 'Loreto', 'LO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1772, 147, '马德雷德迪奥斯', 'Madre de Dios', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1773, 147, '莫克瓜', 'Moquegua', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1774, 147, '帕斯科', 'Pasco', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1775, 147, '皮乌拉', 'Piura', 'PI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1776, 147, '普诺', 'Puno', 'PU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1777, 147, '钦博特', 'Chimbote', 'CHM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1778, 147, '钦查阿尔塔', 'Chincha Alta', 'CHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1779, 147, '圣马丁', 'San Martin', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1780, 147, '苏拉纳', 'Sullana', 'SUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1781, 147, '塔克纳', 'Tacna', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1782, 147, '通贝斯', 'Tumbes', 'TU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1783, 147, '瓦努科', 'Huanuco', 'HO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1784, 147, '万卡维利卡', 'Huancavelica', 'HV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1785, 147, '乌卡亚利', 'Ucayali', 'UC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1786, 147, '亚马孙', 'Amazonas', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1787, 147, '伊卡', 'Ica', 'IC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1788, 148, '勃固省', 'Bago', 'BG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1789, 148, '掸邦', 'Shan', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1790, 148, '德林达依省', 'Tanintharyi', 'TN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1791, 148, '克伦邦', 'Kayin', 'KN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1792, 148, '克钦邦', 'Kachin', 'KC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1793, 148, '克耶邦', 'Kayah', 'KH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1794, 148, '马圭省', 'Magway', 'MG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1795, 148, '曼德勒省', 'Mandalay', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1796, 148, '孟邦', 'Mon', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1797, 148, '钦邦', 'Chin', 'CH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1798, 148, '若开邦', 'Rakhine', 'RK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1799, 148, '实皆省', 'Sagaing', 'SG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1800, 148, '仰光省', 'Yangon', 'YG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1801, 148, '伊洛瓦底省', 'Ayeyarwady', 'AY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1802, 150, '丹吉尔', 'Tangier', 'TGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1803, 150, '得土安', 'Tetouan', 'TET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1804, 150, '非斯', 'Fes', 'FES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1805, 150, '卡萨布兰卡', 'Casablanca', 'CBL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1806, 150, '拉巴特', 'Rabat', 'RSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1807, 150, '马拉喀什', 'Marrakech', 'MRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1808, 150, '梅克内斯', 'Meknes', 'MKN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1809, 150, '乌季达', 'Oujda', 'OUJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1810, 150, '西撒哈拉', 'Western Sahara', 'WSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1811, 153, '阿瓜斯卡连斯特', 'Aguascalientes', 'AGU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1812, 153, '阿卡普尔科', 'Acapulco', 'ACA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1813, 153, '埃莫西约', 'Hermosillo', 'HMO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1814, 153, '埃佩切', 'Campeche', 'CAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1815, 153, '奥夫雷贡城', 'Obregon', 'OBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1816, 153, '奥里萨巴', 'Orizaba', 'ORI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1817, 153, '巴利城', 'Valles', 'VHM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1818, 153, '巴亚尔塔港', 'Puerto Vallarta', 'PVR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1819, 153, '比利亚埃尔莫萨', 'Villahermosa', 'VSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1820, 153, '波萨里卡', 'Poza Rica de Hidalgo', 'PRH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1821, 153, '蒂华纳', 'Tijuana', 'TIJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1822, 153, '杜兰戈', 'Durango', 'DUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1823, 153, '恩塞纳达', 'Ensenada', 'ESE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1824, 153, '瓜达拉哈拉', 'Guadalajara', 'GDL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1825, 153, '瓜纳华托', 'Guanajuato', 'GUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1826, 153, '哈拉帕', 'Jalapa', 'JAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1827, 153, '华雷斯', 'Juarez', 'JUZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1828, 153, '华雷斯港', 'Benito Juare', 'BJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1829, 153, '卡门', 'Carmen', 'CAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1830, 153, '科利马', 'Colima', 'COL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1831, 153, '克雷塔罗', 'Queretaro', 'QUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1832, 153, '库埃纳瓦卡', 'Cuernavaca', 'CVC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1833, 153, '库利阿坎', 'Culiacan', 'CUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1834, 153, '夸察夸拉克斯', 'Coatzacoalcos', 'COA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1835, 153, '拉巴斯', 'La Paz', 'LAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1836, 153, '莱昂', 'Leon', 'LEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1837, 153, '雷诺萨', 'Reynosa', 'REX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1838, 153, '洛斯莫奇斯', 'Los Mochis', 'LMM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1839, 153, '马萨特兰', 'Mazatlan', 'MZT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1840, 153, '马塔莫罗斯', 'Matamoros', 'MAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1841, 153, '梅里达', 'Merida', 'MID', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1842, 153, '蒙克洛瓦', 'Monclova', 'LOV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1843, 153, '蒙特雷', 'Monterrey', 'MTY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1844, 153, '莫雷利亚', 'Morelia', 'MLM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1845, 153, '墨西哥城', 'Mexico City', 'MEX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1846, 153, '墨西卡利', 'Mexicali', 'MXL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1847, 153, '诺加莱斯', 'Nogales', 'NOG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1848, 153, '帕丘卡', 'Pachuca', 'PAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1849, 153, '普埃布拉', 'Puebla', 'PUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1850, 153, '奇尔潘辛戈', 'Chilpancingo', 'CHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1851, 153, '奇瓦瓦', 'Chihuahua', 'CHH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1852, 153, '切图马尔', 'Cheturnal', 'CTM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1853, 153, '萨尔蒂约', 'Saltillo', 'SLW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1854, 153, '萨卡特卡斯', 'Zacatecas', 'ZAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1855, 153, '塞拉亚', 'Celaya', 'CLY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1856, 153, '圣路易斯波托亚', 'San Luis Potosi', 'SLP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1857, 153, '塔帕丘拉', 'Tapachula', 'TAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1858, 153, '坦皮科', 'Tampico', 'TAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1859, 153, '特拉斯卡拉', 'Tlaxcala', 'TLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1860, 153, '特皮克', 'Tepic', 'TPQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1861, 153, '特瓦坎', 'Tehuacan', 'TCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1862, 153, '图斯特拉-古铁雷斯', 'Tuxtla Gutierrez', 'TGZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1863, 153, '托雷翁', 'Torreon', 'TRC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1864, 153, '托卢卡', 'Toluca', 'TLC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1865, 153, '瓦哈卡', 'Oaxaca', 'OAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1866, 153, '维多利亚城', 'Victoria', 'VIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1867, 153, '韦拉克鲁斯', 'Veracruz', 'VER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1868, 153, '乌鲁阿潘', 'Uruapan', 'UPN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1869, 153, '新拉雷多', 'Nuevo Laredo', 'NLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1870, 153, '伊拉普阿托', 'Irapuato', 'IRP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1871, 154, '埃龙戈', 'Erongo', 'ER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1872, 154, '奥汉圭纳', 'Ohangwena', 'OW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1873, 154, '奥卡万戈', 'Okavango', 'KV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1874, 154, '奥马赫科', 'Omaheke', 'OK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1875, 154, '奥姆沙蒂', 'Omusati', 'OT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1876, 154, '奥乔宗蒂约巴', 'Otjozondjupa', 'OJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1877, 154, '奥沙纳', 'Oshana', 'ON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1878, 154, '奥希科托', 'Oshikoto', 'OO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1879, 154, '哈达普', 'Hardap', 'HA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1880, 154, '霍马斯', 'Khomas', 'KH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1881, 154, '卡拉斯', 'Karas', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1882, 154, '卡普里维', 'Caprivi', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1883, 154, '库内内', 'Kunene', 'KU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1884, 155, '阿平顿', 'Upington', 'UTN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1885, 155, '艾利弗山', 'Mount Ayliff', 'MAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1886, 155, '彼德马里茨堡', 'Pietermaritzburg', 'PZB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1887, 155, '彼德斯堡', 'Pietersburg', 'PTG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1888, 155, '比勒陀利亚', 'Pretoria', 'PRY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1889, 155, '比索', 'Bisho', 'BIY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1890, 155, '布雷达斯多普', 'Bredasdorp', 'BDD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1891, 155, '布隆方丹', 'Bloemfontein', 'BFN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1892, 155, '布隆克斯特斯普利特', 'Bronkhorstspruit', 'BHT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1893, 155, '德阿尔', 'De Aar', 'DAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1894, 155, '德班', 'Durban', 'DUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1895, 155, '邓迪', 'Dundee', 'DUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1896, 155, '东巴克利', 'Barkley East', 'BAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1897, 155, '东伦敦', 'East London', 'ELS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1898, 155, '弗雷堡', 'Vryburg', 'VRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1899, 155, '弗里尼欣', 'Vereeniging', 'VGG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1900, 155, '格罗布莱斯达尔', 'Groblersdal', 'GBD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1901, 155, '基雅尼', 'Giyani', 'GIY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1902, 155, '金伯利', 'Kimberley', 'KIM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1903, 155, '开普敦', 'Cape Town', 'CPT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1904, 155, '克莱克斯多普', 'Klerksdorp', 'KXE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1905, 155, '库鲁曼', 'Kuruman', 'KMH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1906, 155, '昆士敦', 'Queenstown', 'UTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1907, 155, '莱迪史密斯', 'Ladysmith', 'LAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1908, 155, '兰德方丹', 'Randfontein', 'RFT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1909, 155, '理查兹湾', 'Richards Bay', 'RCB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1910, 155, '利斯滕堡', 'Rustenburg', 'RSB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1911, 155, '米德尔堡', 'Middelburg', 'MDB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1912, 155, '姆库泽', 'Mkuze', 'MZQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1913, 155, '穆里斯堡', 'Moorreesburg', 'MOO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1914, 155, '内尔斯普雷特', 'Nelspruit', 'NLP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1915, 155, '尼尔斯特隆', 'Nylstroom', 'NYL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1916, 155, '纽卡斯尔', 'Newcastle', 'NCS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1917, 155, '乔治', 'George', 'GRJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1918, 155, '萨索尔堡', 'Sasolburg', 'SAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1919, 155, '瑟孔达', 'Secunda', 'ZEC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1920, 155, '特克索波', 'Ixopo', 'IXO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1921, 155, '特隆普斯堡', 'Trompsburg', 'TPB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1922, 155, '跳羚', 'Springbok', 'SBU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1923, 155, '图拉马哈谢', 'Thulamahashe', 'TLH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1924, 155, '托霍延杜', 'Thohoyandou', 'THY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1925, 155, '韦茨肖克', 'Witsieshoek', 'WSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1926, 155, '韦尔科姆', 'Welkom', 'WEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1927, 155, '乌伦迪', 'Ulundi', 'ULD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1928, 155, '乌姆塔塔', 'Umtata', 'UTT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1929, 155, '伍斯特', 'Worcester', 'WOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1930, 155, '西博福特', 'Beaufort West', 'BEW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1931, 155, '谢普斯通港', 'Port Shepstone', 'PSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1932, 155, '伊丽莎白港', 'Port Elizabeth', 'PLZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1933, 155, '约翰内斯堡', 'Johannesburg', 'JNB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1934, 159, '巴格马蒂', 'Bagmati', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1935, 159, '道拉吉里', 'Dhawalagiri', 'DH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1936, 159, '甘达基', 'Gandaki', 'GA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1937, 159, '戈西', 'Kosi', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1938, 159, '格尔纳利', 'Karnali', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1939, 159, '贾纳克布尔', 'Janakpur', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1940, 159, '拉布蒂', 'Rapti', 'RA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1941, 159, '蓝毗尼', 'Lumbini', 'LU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1942, 159, '马哈卡利', 'Mahakali', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1943, 159, '梅吉', 'Mechi', 'ME', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1944, 159, '纳拉亚尼', 'Narayani', 'NA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1945, 159, '佩里', 'Bheri', 'BH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1946, 159, '萨加玛塔', 'Sogarmatha', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1947, 159, '塞蒂', 'Seti', 'SE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1948, 160, '埃斯特利', 'Esteli', 'ES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1949, 160, '北大西洋', 'Atlantico Norte', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1950, 160, '博阿科', 'Boaco', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1951, 160, '格拉纳达', 'Granada', 'GR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1952, 160, '卡拉索', 'Carazo', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1953, 160, '莱昂', 'Leon', 'LE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1954, 160, '里瓦斯', 'Rivas', 'RV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1955, 160, '马德里斯', 'Madriz', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1956, 160, '马那瓜', 'Managua', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1957, 160, '马萨亚', 'Masaya', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1958, 160, '马塔加尔帕', 'Matagalpa', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1959, 160, '南大西洋', 'Atlantico Sur', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1960, 160, '奇南德加', 'Chinandega', 'CD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1961, 160, '琼塔莱斯', 'Chontales', 'CT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1962, 160, '圣胡安河', 'Rio San Juan', 'SJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1963, 160, '希诺特加', 'Jinotega', 'JI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1964, 160, '新塞哥维亚', 'Nueva Segovia', 'NS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1965, 161, '阿加德兹', 'Agadez', 'AJY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1966, 161, '迪法', 'Diffa', 'DIF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1967, 161, '蒂拉贝里', 'Tillaberi', 'TIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1968, 161, '多索', 'Dosso', 'DSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1969, 161, '津德尔', 'Zinder', 'ZND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1970, 161, '马拉迪', 'Maradi', 'MFQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1971, 161, '尼亚美市', 'Niamey C.U.', 'NIM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1972, 161, '塔瓦', 'Tahoua', 'THZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1973, 162, '阿比亚', 'Abuja', 'ABV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1974, 162, '奥博莫绍', 'Ogbomosho', 'OGB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1975, 162, '卡诺', 'Kano', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1976, 162, '拉各斯', 'Lagos', 'LOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1977, 162, '伊巴丹', 'Ibadan', 'IBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1978, 164, '阿克什胡斯', 'Akershus', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1979, 164, '奥普兰', 'Oppland', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1980, 164, '奥斯陆市', 'Oslo', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1981, 164, '北特伦德拉格', 'Nord-Trondelag', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1982, 164, '布斯克吕', 'Buskerud', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1983, 164, '东阿格德尔', 'Aust-Agder', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1984, 164, '东福尔', 'Ostfold', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1985, 164, '芬马克', 'Finnmark', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1986, 164, '海德马克', 'Hedmark', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1987, 164, '霍达兰', 'Hordaland', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1988, 164, '罗加兰', 'Rogaland', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1989, 164, '默勒－鲁姆斯达尔', 'More og Romsdal', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1990, 164, '南特伦德拉格', 'Sor-Trondelag', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1991, 164, '诺尔兰', 'Nordland', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1992, 164, '松恩－菲尤拉讷', 'Sogn og Fjordane', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1993, 164, '泰勒马克', 'Telemark', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1994, 164, '特罗姆斯', 'Troms', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1995, 164, '西阿格德尔', 'Vest-Agder', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1996, 164, '西福尔', 'Vestfold', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1997, 168, '滨海阿连特茹', 'Alentejo Litoral', 'ALL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1998, 168, '滨海皮尼亚尔', 'Pinhal Litoral', 'PLT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1999, 168, '波尔图', 'Porto', 'VDP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2000, 168, '杜罗', 'Douro', 'MDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2001, 168, '恩特拉杜罗伏日', 'Entre Douro e Vouga', 'EDV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2002, 168, '法鲁', 'Faro', 'FAO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2003, 168, '丰沙尔', 'Funchal', 'FUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2004, 168, '卡瓦多', 'Cavado', 'CAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2005, 168, '科瓦贝拉', 'Cova da Beira', 'CLB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2006, 168, '里斯本', 'Lisboa', 'LIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2007, 168, '利巴特茹', 'Leziria do Tejo', 'LTE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2008, 168, '梅地奥特茹', 'Medio Tejo', 'MTE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2009, 168, '米尼奥-利马', 'Minho-Lima', 'MLI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2010, 168, '内贝拉北', 'Beira Interior Norte', 'BIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2011, 168, '内贝拉南', 'Beira Interior Sul', 'BIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2012, 168, '内皮尼亚尔北', 'Pinhal Interior Norte', 'PIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2013, 168, '内皮尼亚尔南', 'Pinhal Interior Sul', 'PIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2014, 168, '蓬塔德尔加达', 'Ponta Delgada', 'PDL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2015, 168, '塞图巴尔半岛', 'Peninsula de Setubal', 'PSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2016, 168, '山后', 'Serra da Estrela', 'SES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2017, 168, '上阿连特茹', 'Alto Alentejo', 'AAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2018, 168, '上特拉斯山', 'Alto Tros-os-Montes', 'ATM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2019, 168, '塔梅加', 'Tamega', 'TAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2020, 168, '万福', 'Ave', 'AES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2021, 168, '西部', 'Oeste', 'OES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2022, 168, '下阿连特茹', 'Baixo Alentejo', 'BAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2023, 168, '下伏日', 'Baixo Vouga', 'BVO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2024, 168, '下蒙德古', 'Baixo Mondego', 'BMO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2025, 168, '中阿连特茹', 'Alentejo Central', 'ALC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2026, 170, '爱媛', 'Ehime', '38', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2027, 170, '爱知', 'Aichi', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2028, 170, '北海道', 'Hokkaido', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2029, 170, '兵库', 'Hyogo', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2030, 170, '冲绳', 'Okinawa', '47', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2031, 170, '茨城', 'Ibaraki', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2032, 170, '大阪', 'Osaka', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2033, 170, '大分', 'Oita', '44', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2034, 170, '岛根', 'Shimane', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2035, 170, '徳岛', 'Tokushima', '36', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2036, 170, '东京', 'Tokyo', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2037, 170, '福岛', 'Fukushima', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2038, 170, '福冈', 'Fukuoka', '40', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2039, 170, '福井', 'Fukui', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2040, 170, '富山', 'Toyama', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2041, 170, '冈山', 'Okayama', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2042, 170, '高知', 'Kochi', '39', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2043, 170, '宮城', 'Miyagi', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2044, 170, '宫崎', 'Miyazaki', '45', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2045, 170, '广岛', 'Hiroshima', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2046, 170, '和歌山', 'Wakayama', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2047, 170, '京都', 'Kyoto', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2048, 170, '静冈', 'Shizuoka', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2049, 170, '枥木', 'Tochigi', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2050, 170, '鹿儿岛', 'Kagoshima', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2051, 170, '奈良', 'Nara', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2052, 170, '鸟取', 'Tottori', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2053, 170, '岐阜', 'Gifu', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2054, 170, '埼玉', 'Saitama', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2055, 170, '千叶', 'Chiba', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2056, 170, '青森', 'Aomori', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2057, 170, '秋田', 'Akita', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2058, 170, '群马', 'Gunma', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2059, 170, '三重', 'Mie', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2060, 170, '山口', 'Yamaguchi', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2061, 170, '山梨', 'Yamanashi', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2062, 170, '山形', 'Yamagata', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2063, 170, '神奈川', 'Kanagawa', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2064, 170, '石川', 'Ishikawa', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2065, 170, '香川', 'Kagawa', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2066, 170, '新潟', 'Niigata', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2067, 170, '熊本', 'Kumamoto', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2068, 170, '岩手', 'Iwate', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2069, 170, '长崎', 'Nagasaki', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2070, 170, '长野', 'Nagano', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2071, 170, '滋贺', 'Shiga', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2072, 170, '佐贺', 'Saga', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2073, 171, '北博滕', 'Norrbottens', 'BD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2074, 171, '布莱金厄', 'Blekinge', 'K', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2075, 171, '达拉纳', 'Dalarnas', 'DLN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2076, 171, '东约特兰', 'Ustergotland', 'UGL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2077, 171, '厄勒布鲁', 'Orebro', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2078, 171, '哥得兰', 'Gotlands', 'I', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2079, 171, '哈兰', 'Hallands', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2080, 171, '卡尔马', 'Kalmar', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2081, 171, '克鲁努贝里', 'Kronobergs', 'G', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2082, 171, '南曼兰', 'Sodermanlands', 'D', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2083, 171, '斯德哥尔摩', 'Stockholms', 'AB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2084, 171, '斯科耐', 'Skane', 'M', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2085, 171, '韦姆兰', 'Varmlands', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2086, 171, '乌普萨拉', 'Uppsala', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2087, 171, '西博滕', 'Vasterbottens', 'AC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2088, 171, '西曼兰', 'Vastmanlands', 'U', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2089, 171, '西诺尔兰', 'Vasternorrlands', 'Y', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2090, 171, '西约特兰', 'Vastra Gotalands', 'O', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2091, 171, '延雪平', 'Jonkopings', 'F', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2092, 171, '耶夫勒堡', 'Gavleborgs', 'X', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2093, 171, '耶姆特兰', 'Jamtlands', 'Z', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2094, 172, '阿尔高', 'Aargau', 'AG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2095, 172, '巴塞尔城市', 'Basel－Sstadt', 'BS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2096, 172, '巴塞尔乡村', 'Basel Landschaft', 'BL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2097, 172, '伯尔尼', 'Bern', 'BE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2098, 172, '楚格', 'Zug', 'ZG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2099, 172, '弗里堡', 'Freiburg', 'FR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2100, 172, '格拉鲁斯', 'Glarus', 'GL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2101, 172, '格劳宾登', 'Graubünden', 'GR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2102, 172, '卢塞恩', 'Luzern', 'LU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2103, 172, '洛桑', 'Lausanne', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2104, 172, '纳沙泰尔', 'Neuchatel', 'NE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2105, 172, '内阿彭策尔', 'Appenzell Innerrhodn', 'AI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2106, 172, '日内瓦', 'Geneve', 'GE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2107, 172, '汝拉', 'Jura', 'JU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2108, 172, '沙夫豪森', 'Schaffhausen', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2109, 172, '上瓦尔登', 'Obwalden', 'OW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2110, 172, '圣加仑', 'St.Gallen', 'SG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2111, 172, '施维茨', 'Schwyz', 'SZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2112, 172, '苏黎世', 'Zurich', 'ZH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2113, 172, '索洛图恩', 'Solothurn', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2114, 172, '提契诺', 'Ticino', 'TI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2115, 172, '图尔高', 'Thurgau', 'TG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2116, 172, '瓦莱', 'Wallis', 'VS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2117, 172, '外阿彭策尔', 'Appenzell Ausserrhon', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2118, 172, '沃', 'Vaud', 'VD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2119, 172, '乌里', 'Uri', 'UR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2120, 172, '下瓦尔登', 'Nidwalden', 'NW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2121, 173, '阿波帕', 'Apopa', 'APO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2122, 173, '阿瓦查潘', 'Ahuachapan', 'AH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2123, 173, '滨海', 'Litoral', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2124, 173, '查拉特南戈', 'Chalatenango', 'CH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2125, 173, '德尔加多', 'Delgado', 'DE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2126, 173, '基埃-恩特姆', 'Kie-Ntem', 'KN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2127, 173, '卡瓦尼亚斯', 'Cabanas', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2128, 173, '库斯卡特兰', 'Cuscatlan', 'CU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2129, 173, '拉巴斯', 'La Paz', 'PZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2130, 173, '拉利伯塔德', 'La Libertad', 'LB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2131, 173, '拉乌尼翁', 'La Union', 'UN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2132, 173, '梅基卡诺斯', 'Mejicanos', 'MEJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2133, 173, '莫拉桑', 'Morazan', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2134, 173, '圣安娜', 'Santa Ana', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2135, 173, '圣米格尔', 'San Miguel', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2136, 173, '圣萨尔瓦多', 'San Salvador', 'SS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2137, 173, '圣维森特', 'San Vicente', 'SV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2138, 173, '松索纳特', 'Sonsonate', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2139, 173, '索亚潘戈', 'Soyapango', 'SOY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2140, 173, '韦莱-恩萨斯', 'Wele-Nzas', 'WN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2141, 173, '乌苏卢坦', 'Usulutan', 'US', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2142, 173, '伊洛潘戈', 'Ilopango', 'IL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2143, 173, '中南', 'Centro Sur', 'CS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2144, 175, '贝尔格莱德', 'Beograd', 'BEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2145, 175, '波德戈里察', 'Podgorica', 'POD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2146, 175, '克拉古涅瓦茨', 'Kragujevac', 'KGV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2147, 175, '尼什', 'Nis', 'INI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2148, 175, '诺维萨德', 'Novi Sad', 'NVS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2149, 175, '普里什蒂纳', 'Pristina', 'PRN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2150, 175, '苏博蒂察', 'Subotica', 'SUB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2151, 175, '泽蒙', 'Zemun', 'ZEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2152, 176, '北部', 'Northern', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2153, 176, '东部', 'Eastern', 'E', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2154, 176, '南部', 'Southern', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2155, 176, '西部区', 'Western', 'W', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2156, 177, '达喀尔', 'Dakar', 'DA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2157, 177, '法蒂克', 'Fatick', 'FA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2158, 177, '济金绍尔', 'Ziguinchor', 'ZI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2159, 177, '捷斯', 'Thies', 'TH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2160, 177, '久尔贝勒', 'Diourbel', 'DI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2161, 177, '考拉克', 'Kaolack', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2162, 177, '科尔达', 'Kolda', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2163, 177, '卢加', 'Louga', 'LO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2164, 177, '马塔姆', 'Matam', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2165, 177, '圣路易', 'Saint-Louis', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2166, 177, '坦巴昆达', 'Tambacounda', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(2167, 178, '法马古斯塔', 'Famagusta', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2168, 178, '凯里尼亚', 'Kyrenia', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2169, 178, '拉纳卡', 'Larnaca', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2170, 178, '利马索尔', 'Limassol', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2171, 178, '尼科西亚', 'Nicosia', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2172, 178, '帕福斯', 'Pafos', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2173, 180, '阿尔阿尔', 'Arar', 'ARA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2174, 180, '艾卜哈', 'Abha', 'AHB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2175, 180, '巴哈', 'Al Bahah', 'BH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2176, 180, '布赖代', 'Buraydah', 'BUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2177, 180, '达曼', 'Dammam', 'DAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2178, 180, '哈费尔巴廷', 'Hafar al-Batin', 'HBT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2179, 180, '哈伊勒', 'Hail', 'HL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2180, 180, '海米斯穆谢特', 'Khamis Mushayt', 'KMX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2181, 180, '海耶', 'Al-Kharj', 'AKH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2182, 180, '胡富夫', 'Al-Hufuf', 'HFF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2183, 180, '吉达', 'Jiddah', 'JED', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2184, 180, '吉赞', 'Jizan', 'JZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2185, 180, '利雅得', 'Riyad', 'RD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2186, 180, '麦地那', 'Medina', 'MED', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2187, 180, '麦加', 'Makkah', 'ML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2188, 180, '姆巴拉兹', 'Al-Mubarraz', 'MBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2189, 180, '纳季兰', 'Najran', 'NR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2190, 180, '塞卡卡', 'Sakaka', 'SAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2191, 180, '塔布克', 'Tabuk', 'TB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2192, 180, '塔伊夫', 'At Tarif', 'TAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2193, 180, '延布', 'Yanbu al-Bahr', 'YNB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2194, 180, '朱拜勒', 'Al-Jubayl', 'JBI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2195, 189, '阿努拉德普勒', 'Anuradhapura', 'ADP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2196, 189, '安帕赖', 'Ampara', 'AMP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2197, 189, '巴杜勒', 'Badulla', 'BAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2198, 189, '拜蒂克洛', 'Batticaloa', 'BTC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2199, 189, '波隆纳鲁沃', 'Polonnaruwa', 'POL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2200, 189, '汉班托特', 'Hambantota', 'HBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2201, 189, '基里诺奇', 'Kilinochchi', 'KIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2202, 189, '加勒', 'Galle', 'GAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2203, 189, '加姆珀哈', 'Gampaha', 'GAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2204, 189, '贾夫纳', 'Jaffna', 'JAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2205, 189, '卡卢特勒', 'Kalutara', 'KLT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2206, 189, '凯格勒', 'Kegalle', 'KEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2207, 189, '康提', 'Kandy', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2208, 189, '科伦坡', 'Colombo', 'CMB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2209, 189, '库鲁内格勒', 'Kurunegala', 'KUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2210, 189, '拉特纳普勒', 'Ratnapura', 'RAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2211, 189, '马纳尔', 'Mannar', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2212, 189, '马特莱', 'Matale', 'MAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2213, 189, '马特勒', 'Matara', 'MAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2214, 189, '莫讷勒格勒', 'Monaragala', 'MON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2215, 189, '穆莱蒂武', 'Mullathivu', 'MUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2216, 189, '努沃勒埃利耶', 'Nuwara Eliya', 'NUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2217, 189, '普塔勒姆', 'Puttalam', 'PUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2218, 189, '亭可马里', 'Trincomalee', 'TRR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2219, 189, '瓦武尼亚', 'Vavuniya', 'VAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2220, 190, '班斯卡-比斯特里察', 'Banskobystricky', 'BBY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2221, 190, '布拉迪斯拉发', 'Bratislavsky', 'BTS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2222, 190, '科希策', 'Koricky', 'KOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2223, 190, '尼特拉', 'Nitriansky', 'NRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2224, 190, '普雷绍夫', 'Prerovsky', 'POV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2225, 190, '日利纳', 'Rilinsky', 'RIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2226, 190, '特尔纳瓦', 'Trnavsky', 'TNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2227, 190, '特伦钦', 'Trenriansky', 'TRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2228, 191, '奥巴尔诺-克拉', 'Obalno-kraska', 'OKR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2229, 191, '奥斯雷德涅斯洛文', 'Osrednjeslovenska', 'OSR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2230, 191, '波德拉夫', 'Podravska', 'POD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2231, 191, '波穆尔', 'Pomurska', 'POM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2232, 191, '多雷尼', 'Dolenjska', 'DLJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2233, 191, '戈雷尼', 'Gorenjska', 'GSZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2234, 191, '戈里', 'Goriska', 'GSK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2235, 191, '科洛', 'Koroska', 'KOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2236, 191, '诺特拉尼', 'Notranjsko-kraska', 'NKR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2237, 191, '萨维尼', 'Savinjska', 'SAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2238, 191, '斯波德涅波萨夫', 'Spodnjeposavska', 'SPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2239, 191, '扎萨夫', 'Zasavska', 'ZAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2240, 194, '北部', 'Ash-Shamaliyah', 'ASH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2241, 194, '赤道', 'Al-Istiwaiyah', 'SIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2242, 194, '达尔富尔', 'Darfur', 'SDA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2243, 194, '东部', 'Ash-Sharqiyah', 'SHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2244, 194, '加扎勒河', 'Bahr al-Ghazal', 'SBG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2245, 194, '喀土穆', 'Al-Khartum', 'KRT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2246, 194, '科尔多凡', 'Kurdufan', 'GKU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2247, 194, '上尼罗', 'Aali an-Nil', 'ANB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2248, 194, '中部', 'Al Wasta', 'WDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2249, 195, '布罗科蓬多', 'Brokopondo', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2250, 195, '科罗尼', 'Coronie', 'CR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2251, 195, '科默韦讷', 'Commewijne', 'CM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2252, 195, '马罗韦讷', 'Marowijne', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2253, 195, '尼克里', 'Nickerie', 'NI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2254, 195, '帕拉', 'Para', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2255, 195, '帕拉马里博', 'Paramaribo', 'PM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2256, 195, '萨拉马卡', 'Saramacca', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2257, 195, '瓦尼卡', 'Wanica', 'WA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2258, 195, '西帕里韦尼', 'Sipaliwini', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2259, 196, '瓜达尔卡纳尔', 'Guadalcanal', 'GC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2260, 196, '霍尼亚拉', 'Honiara', 'HO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2261, 196, '拉纳尔和贝罗纳', 'Rennell and Bellona', 'RB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2262, 196, '马基拉', 'Makira', 'MK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2263, 196, '马莱塔', 'Malaita', 'ML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2264, 196, '乔伊索', 'Choiseul', 'CH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2265, 196, '泰莫图', 'Temotu', 'TM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2266, 196, '西部', 'Western', 'WE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2267, 196, '伊萨贝尔', 'Isabel', 'IS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2268, 196, '中部群岛', 'Central Islands', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2269, 198, '杜尚别', 'Dushanbe', 'DYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2270, 198, '霍罗格', 'Khorugh', 'KHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2271, 198, '卡尼巴达姆', 'Kanibadam', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2272, 198, '科法尔尼洪', 'Kofarnihon', 'KOF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2273, 198, '苦盏', 'Khujand', 'KHU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2274, 198, '库尔干-秋别', 'Kurgan-Tjube', 'KTJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2275, 198, '库洛布', 'Kulob', 'KLB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2276, 198, '洛贡', 'Rogun', 'RGU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2277, 198, '努雷克', 'Nurek', 'NUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2278, 198, '彭吉肯特', 'Pendzhikent', 'PJK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2279, 198, '萨班特', 'Sarband', 'SBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2280, 198, '塔博沙尔', 'Taboshar', 'TBS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2281, 198, '图尔孙扎德', 'Tursunzade', 'TSZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2282, 198, '乌拉秋别', 'Ura-Tjube', 'UTJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2283, 198, '伊斯法拉', 'Isfara', 'ISF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2284, 199, '安纳乍能', 'Amnat Charoen', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2285, 199, '巴蜀', 'Prachuap Khiri Khan', '77', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2286, 199, '巴吞他尼', 'Pathum Thani', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2287, 199, '巴真', 'Prachin Buri', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2288, 199, '北碧', 'Kanchanaburi', '71', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2289, 199, '北标', 'Saraburi', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2290, 199, '北大年', 'Pattani', '94', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2291, 199, '北揽', 'Samut Prakan', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2292, 199, '北榄坡', 'Nakhon Sawan', '60', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2293, 199, '北柳', 'Chachoengsao', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2294, 199, '碧差汶', 'Phetchabun', '76', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2295, 199, '博达伦', 'Phatthalung', '93', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2296, 199, '猜那', 'Chai Nat', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2297, 199, '猜也奔', 'Chaiyaphum', '36', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2298, 199, '程逸', 'Uttaradit', '53', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2299, 199, '春蓬', 'Chumphon', '86', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2300, 199, '春武里', 'Chon Buri', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2301, 199, '达', 'Tak', '63', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2302, 199, '达叻', 'Trat', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2303, 199, '大城', 'Phra Nakhon Si Ayutthaya', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2304, 199, '董里', 'Trang', '92', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2305, 199, '佛丕', 'Phetchaburi', '78', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2306, 199, '佛统', 'Nakhon Pathom', '73', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2307, 199, '甘烹碧', 'Kamphaeng Phet', '62', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2308, 199, '红统', 'Ang Thong', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2309, 199, '华富里', 'Lop Buri', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2310, 199, '加拉信', 'Kalasin', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2311, 199, '甲米', 'Krabi', '81', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2312, 199, '尖竹汶', 'Chanthaburi', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2313, 199, '孔敬', 'Khon Kaen', '40', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2314, 199, '拉农', 'Rayong', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2315, 199, '廊开', 'Nong Khai', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2316, 199, '廊莫那浦', 'Nong Bua Lamphu', '39', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2317, 199, '叻丕', 'Ratchaburi', '70', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2318, 199, '黎', 'Loei', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2319, 199, '黎逸', 'Roi Et', '45', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2320, 199, '龙仔厝', 'Samut Sakhon', '74', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2321, 199, '罗勇', 'Ranong', '85', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2322, 199, '洛坤', 'Nakhon Si Thammarat', '80', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2323, 199, '玛哈沙拉堪', 'Maha Sarakham', '44', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2324, 199, '曼谷', 'Bangkok', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2325, 199, '莫达汉', 'Mukdahan', '49', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2326, 199, '那空那育', 'Nakhon Nayok', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2327, 199, '那空帕农', 'Nakhon Phanom', '48', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2328, 199, '难', 'Nan', '55', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2329, 199, '南奔', 'Lamphun', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2330, 199, '暖武里', 'Nonthaburi', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2331, 199, '帕', 'Phrae', '54', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2332, 199, '帕尧', 'Phayao', '56', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2333, 199, '攀牙', 'Phangnga', '82', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2334, 199, '彭世洛', 'Phitsanulok', '65', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2335, 199, '披集', 'Phichit', '66', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2336, 199, '普吉', 'Phuket', '83', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2337, 199, '清莱', 'Chiang Rai', '57', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2338, 199, '清迈', 'Chiang Mai', '50', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2339, 199, '色军', 'Sakon Nakhon', '47', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2340, 199, '沙敦', 'Satun', '91', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2341, 199, '沙缴', 'Sa Kaeo', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2342, 199, '四色菊', 'Si sa ket', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2343, 199, '宋卡', 'Songkhla', '90', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2344, 199, '素可泰', 'Sukhothai', '64', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2345, 199, '素叻', 'Surat Thani', '84', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2346, 199, '素林', 'Surin', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2347, 199, '素攀武里', 'Suphan Buri', '72', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2348, 199, '陶公', 'Narathiwat', '96', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2349, 199, '乌隆', 'Udon Thani', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2350, 199, '乌泰他尼', 'Uthai Thani', '61', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2351, 199, '乌汶', 'Ubon Ratchathani', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2352, 199, '武里南', 'Buri Ram', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2353, 199, '信武里', 'Sing Buri', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2354, 199, '耶梭通', 'Yasothon', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2355, 199, '也拉', 'Yala', '95', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2356, 199, '夜丰颂', 'Mae Hong Son', '58', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2357, 199, '夜功', 'Samut Songkhram', '75', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2358, 200, '阿鲁沙', 'Arusha', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2359, 200, '奔巴北', 'Kaskazini Pemba', 'PN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2360, 200, '奔巴南', 'Kusini Pemba', 'PS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2361, 200, '滨海', 'Pwani', 'PW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2362, 200, '达累斯萨拉姆', 'Dar es Salaam', 'DS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2363, 200, '多多马', 'Dodoma', 'DO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2364, 200, '基戈马', 'Kigoma', 'KI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2365, 200, '卡盖拉', 'Kagera', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2366, 200, '林迪', 'Lindi', 'LN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2367, 200, '鲁夸', 'Rukwa', 'RK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2368, 200, '鲁伍马', 'Ruvuma', 'RV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2369, 200, '马腊', 'Mara', 'MR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2370, 200, '曼亚拉', 'Manyara', 'MY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2371, 200, '莫洛戈罗', 'Morogoro', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2372, 200, '姆贝亚', 'Mbeya', 'MB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2373, 200, '姆特瓦拉', 'Mtwara', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2374, 200, '姆万扎', 'Mwanza', 'MW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2375, 200, '乞力马扎罗', 'Kilimanjaro', 'KJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2376, 200, '桑给巴尔', 'Zanzibar', 'ZN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2377, 200, '桑给巴尔北', 'Kaskazini Unguja', 'UN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2378, 200, '桑给巴尔南', 'Kusini Unguja', 'US', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2379, 200, '桑给巴尔市和西', 'Mjini Magharibi', 'MM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2380, 200, '塔波拉', 'Tabora', 'TB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2381, 200, '坦噶', 'Tanga', 'TN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2382, 200, '辛吉达', 'Singida', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2383, 200, '欣延加', 'Shinyanga', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2384, 200, '伊林加', 'Iringa', 'IR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2385, 201, '埃瓦', 'Eua', 'E', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2386, 201, '哈派', 'Haapai', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2387, 201, '纽阿斯', 'Niuas', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2388, 201, '汤加塔布', 'Tongatapu', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2389, 201, '瓦瓦乌', 'Vavau', 'V', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2390, 205, '艾尔亚奈', 'Ariana', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2391, 205, '巴杰', 'Beja', 'BJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2392, 205, '本阿鲁斯', 'Ben Arous', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2393, 205, '比塞大', 'Bizerte', 'BI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2394, 205, '吉比利', 'Kebili', 'KB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2395, 205, '加贝斯', 'Gabes', 'GB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2396, 205, '加夫萨', 'Gafsa', 'GF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2397, 205, '坚杜拜', 'Jendouba', 'JE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2398, 205, '卡夫', 'Le Kef', 'LK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2399, 205, '卡塞林', 'Kasserine', 'KS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2400, 205, '凯鲁万', 'Kairouan', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2401, 205, '马赫迪耶', 'Mahdia', 'MH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2402, 205, '马努巴', 'Manouba', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2403, 205, '梅德宁', 'Medenine', 'ME', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2404, 205, '莫纳斯提尔', 'Monastir', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2405, 205, '纳布勒', 'Nabeul', 'NA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2406, 205, '斯法克斯', 'Sfax', 'SF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2407, 205, '苏塞', 'Sousse', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2408, 205, '泰塔温', 'Tataouine', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2409, 205, '突尼斯', 'Tunis', 'TU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2410, 205, '托泽尔', 'Tozeur', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2411, 205, '西迪布济德', 'Sidi Bouzid', 'SD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2412, 205, '锡勒亚奈', 'Siliana', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2413, 205, '宰格万', 'Zaghouan', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2414, 207, '阿达纳', 'Adana', 'ADA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2415, 207, '阿德亚曼', 'Adiyaman', 'ADI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2416, 207, '阿尔达罕', 'Ardahan', 'ARD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2417, 207, '阿尔特温', 'Artvin', 'ART', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2418, 207, '阿菲永', 'Afyon', 'AFY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2419, 207, '阿克萨赖', 'Aksaray', 'AKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2420, 207, '阿勒', 'Agri', 'AGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2421, 207, '阿马西亚', 'Amasya', 'AMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2422, 207, '埃迪尔内', 'Edirne', 'EDI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2423, 207, '埃尔津詹', 'Erzincan', 'EZC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2424, 207, '埃尔祖鲁姆', 'Erzurum', 'EZR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2425, 207, '埃拉泽', 'Elazig', 'ELA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2426, 207, '埃斯基谢希尔', 'Eskisehir', 'ESK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2427, 207, '艾登', 'Aydin', 'AYI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2428, 207, '安卡拉', 'Ankara', 'ANK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2429, 207, '安塔利亚', 'Antalya', 'ANT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2430, 207, '奥尔杜', 'Ordu', 'ORD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2431, 207, '巴尔腾', 'Bartin', 'BAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2432, 207, '巴勒克埃西尔', 'Balikesir', 'BAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2433, 207, '巴特曼', 'Batman', 'BAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2434, 207, '巴伊布尔特', 'Bayburt', 'BAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2435, 207, '比莱吉克', 'Bilecik', 'BIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2436, 207, '比特利斯', 'Bitlis', 'BIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2437, 207, '宾格尔', 'Bingol', 'BIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2438, 207, '博卢', 'Bolu', 'BOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2439, 207, '布尔杜尔', 'Burdur', 'BRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2440, 207, '布尔萨', 'Bursa', 'BRS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2441, 207, '昌克勒', 'Cankiri', 'CKR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2442, 207, '代尼兹利', 'Denizli', 'DEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2443, 207, '迪亚巴克尔', 'Diyarbakir', 'DIY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2444, 207, '凡', 'Van', 'VAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2445, 207, '哈卡里', 'Hakkari', 'HKR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2446, 207, '哈塔伊', 'Hatay', 'HTY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2447, 207, '基利斯', 'Kilis', 'KLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2448, 207, '吉雷松', 'Giresun', 'GIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2449, 207, '加济安泰普', 'Gaziantep', 'GAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2450, 207, '居米什哈内', 'Gumushane', 'GMS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2451, 207, '卡尔斯', 'Kars', 'KRS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2452, 207, '卡赫拉曼马拉什', 'Kahraman Maras', 'KAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2453, 207, '卡拉比克', 'Karabuk', 'KRB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2454, 207, '卡拉曼', 'Karaman', 'KRM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2455, 207, '卡斯塔莫努', 'Kastamonu', 'KAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2456, 207, '开塞利', 'Kayseri', 'KAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2457, 207, '科贾埃利', 'Kocaeli', 'KOC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2458, 207, '柯克拉雷利', 'Kirklareli', 'KLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2459, 207, '科尼亚', 'Konya', 'KON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2460, 207, '克尔谢希尔', 'Kirsehir', 'KRH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2461, 207, '克勒克卡莱', 'Kirikkale', 'KRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2462, 207, '拉飞', 'Urfa', 'URF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2463, 207, '里泽', 'Rize', 'RIZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2464, 207, '马尔丁', 'Mardin', 'MAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2465, 207, '马拉蒂亚', 'Malatya', 'MAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2466, 207, '马尼萨', 'Manisa', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2467, 207, '穆拉', 'Mugla', 'MUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2468, 207, '穆什', 'Mus', 'MUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2469, 207, '内夫谢希尔', 'Nevsehir', 'NEV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2470, 207, '尼代', 'Nigde', 'NIG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2471, 207, '恰纳卡莱', 'Canakkale', 'CKL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2472, 207, '乔鲁姆', 'Corum', 'COR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2473, 207, '屈塔希亚', 'Kutahya', 'KUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2474, 207, '萨卡里亚', 'Sakarya', 'SAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2475, 207, '萨姆松', 'Samsun', 'SAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2476, 207, '泰基尔达', 'Tekirdag', 'TEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2477, 207, '特拉布宗', 'Trabzon', 'TRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2478, 207, '通杰利', 'Tunceli', 'TUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2479, 207, '托卡特', 'Tokat', 'TOK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2480, 207, '乌萨克', 'Usak', 'USK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2481, 207, '锡尔纳克', 'Sirnak', 'SIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2482, 207, '锡尔特', 'Siirt', 'SII', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2483, 207, '锡诺普', 'Sinop', 'SIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2484, 207, '锡瓦斯', 'Sivas', 'SIV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2485, 207, '伊迪尔', 'Igdir', 'IGD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2486, 207, '伊切尔', 'Icel', 'ICE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2487, 207, '伊斯帕尔塔', 'Isparta', 'ISP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2488, 207, '伊斯坦布尔', 'Istanbul', 'IST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2489, 207, '伊兹密尔', 'Izmir', 'IZM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2490, 207, '约兹加特', 'Yozgat', 'YOZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2491, 207, '宗古尔达克', 'Zonguldak', 'ZON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2492, 208, '阿哈尔', 'Ahal', 'A', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2493, 208, '阿什哈巴德市', 'Ashgabat', 'ASB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2494, 208, '巴尔坎', 'Balkan', 'B', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2495, 208, '达沙古兹', 'Dashoguz', 'D', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2496, 208, '列巴普', 'Lebap', 'L', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2497, 208, '马雷', 'Mary', 'M', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2498, 208, '涅比特达格', 'Nebitdag', 'NEB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2499, 211, '马朗帕', 'Malampa', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2500, 211, '彭纳马', 'Penama', 'PE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2501, 211, '桑马', 'Sanma', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2502, 211, '塔菲阿', 'Tafea', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2503, 211, '托尔巴', 'Torba', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2504, 211, '谢法', 'Shefa', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2505, 212, '埃尔普罗格雷索', 'El Progreso', 'PR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2506, 212, '埃斯昆特拉', 'Escuintla', 'ES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2507, 212, '哈拉帕', 'Jalapa', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2508, 212, '胡蒂亚帕', 'Jutiapa', 'JU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2509, 212, '基切', 'Quiche', 'QC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2510, 212, '克萨尔特南戈', 'Quetzaltenango', 'QZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2511, 212, '雷塔卢莱乌', 'Retalhuleu', 'RE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2512, 212, '米克斯科', 'Mixco', 'MIX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2513, 212, '佩滕', 'Peten', 'PE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2514, 212, '奇基穆拉', 'Chiquimula', 'CQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2515, 212, '奇马尔特南戈', 'Chimaltenango', 'CM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2516, 212, '萨卡帕', 'Zacapa', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2517, 212, '萨卡特佩克斯', 'Sacatepequez', 'ST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2518, 212, '上韦拉帕斯', 'Alta Verapaz', 'AV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2519, 212, '圣罗莎', 'Santa Rosa', 'SR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2520, 212, '圣马科斯', 'San Marcos', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2521, 212, '苏奇特佩克斯', 'Suchitepequez', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2522, 212, '索洛拉', 'Solola', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2523, 212, '托托尼卡潘', 'Totonicapan', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2524, 212, '危地马拉', 'Guatemala', 'GU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2525, 212, '韦韦特南戈', 'Huehuetenango', 'HU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2526, 212, '下韦拉帕斯', 'Baja Verapaz', 'BV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2527, 212, '新城', 'Villa Nueva', 'VIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2528, 212, '伊萨瓦尔', 'Izabal', 'IZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2529, 215, '阿拉瓜', 'Aragua', 'D', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2530, 215, '阿马库罗三角洲', 'Delta Amacuro', 'Y', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2531, 215, '阿普雷', 'Apure', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2532, 215, '安索阿特吉', 'Anzoategui', 'B', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2533, 215, '巴里纳斯', 'Barinas', 'E', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2534, 215, '玻利瓦尔', 'Bolivar', 'F', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2535, 215, '波图格萨', 'Portuguesa', 'P', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2536, 215, '法尔孔', 'Falcon', 'I', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2537, 215, '瓜里科', 'Guarico', 'J', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2538, 215, '加拉加斯', 'Caracas', 'A', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2539, 215, '卡拉沃沃', 'Carabobo', 'G', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2540, 215, '科赫德斯', 'Cojedes', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2541, 215, '拉腊', 'Lara', 'K', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2542, 215, '联邦属地', 'Dependencias Federales', 'W', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2543, 215, '梅里达', 'Merida', 'L', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2544, 215, '米兰达', 'Miranda', 'M', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2545, 215, '莫纳加斯', 'Monagas', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2546, 215, '苏克雷', 'Sucre', 'R', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2547, 215, '苏利亚', 'Zulia', 'V', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2548, 215, '塔奇拉', 'Tachira', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2549, 215, '特鲁希略', 'Trujillo', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2550, 215, '新埃斯帕塔', 'Estado Nueva Esparta', 'O', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2551, 215, '亚拉奎', 'Yaracuy', 'U', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2552, 215, '亚马孙', 'Amazonas', 'Z', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2553, 217, '阿鲁阿', 'Arua', 'ARU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2554, 217, '阿帕克', 'Apac', 'APC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2555, 217, '阿朱马尼', 'Adjumani', 'ADJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2556, 217, '本迪布焦', 'Bundibugyo', 'BUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2557, 217, '布吉里', 'Bugiri', 'BUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2558, 217, '布西亚', 'Busia', 'BUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2559, 217, '布谢尼', 'Bushenyi', 'BSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2560, 217, '恩通加莫', 'Ntungamo', 'NTU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2561, 217, '古卢', 'Gulu', 'GUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2562, 217, '霍伊马', 'Hoima', 'HOI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2563, 217, '基巴莱', 'Kibaale', 'KBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2564, 217, '基博加', 'Kiboga', 'KIB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2565, 217, '基恩乔乔', 'Kyenjojo', 'KYE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2566, 217, '基索罗', 'Kisoro', 'KIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2567, 217, '基特古姆', 'Kitgum', 'KIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2568, 217, '金贾', 'Jinja', 'JIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2569, 217, '卡巴莱', 'Kabale', 'KBL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2570, 217, '卡巴罗莱', 'Kabarole', 'KAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2571, 217, '卡贝拉马伊多', 'Kaberamaido', 'KAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2572, 217, '卡兰加拉', 'Kalangala', 'KAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2573, 217, '卡姆文盖', 'Kamwenge', 'KAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2574, 217, '卡穆利', 'Kamuli', 'KML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2575, 217, '卡农古', 'Kanungu', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2576, 217, '卡普乔鲁瓦', 'Kapchorwa', 'KPC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2577, 217, '卡塞塞', 'Kasese', 'KAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2578, 217, '卡塔奎', 'Katakwi', 'KTK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2579, 217, '卡永加', 'Kayunga', 'KAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2580, 217, '坎帕拉', 'Kampala', 'KMP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2581, 217, '科蒂多', 'Kotido', 'KOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2582, 217, '库米', 'Kumi', 'KUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2583, 217, '拉卡伊', 'Rakai', 'RAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2584, 217, '利拉', 'Lira', 'LIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2585, 217, '卢韦罗', 'Luwero', 'LUW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2586, 217, '鲁昆吉里', 'Rukungiri', 'RUK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2587, 217, '马萨卡', 'Masaka', 'MAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2588, 217, '马辛迪', 'Masindi', 'MSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2589, 217, '马尤盖', 'Mayuge', 'MAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2590, 217, '莫罗托', 'Moroto', 'MRT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2591, 217, '莫约', 'Moyo', 'MOY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2592, 217, '姆巴拉拉', 'Mbarara', 'MBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2593, 217, '姆巴莱', 'Mbale', 'MBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2594, 217, '姆皮吉', 'Mpigi', 'MPI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2595, 217, '穆本德', 'Mubende', 'MUB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2596, 217, '穆科诺', 'Mukono', 'MUK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2597, 217, '纳卡皮里皮里特', 'Nakapiripirit', 'NAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2598, 217, '纳卡松戈拉', 'Nakasongola', 'NKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2599, 217, '内比', 'Nebbi', 'NEB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2600, 217, '帕德尔', 'Pader', 'PAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2601, 217, '帕利萨', 'Pallisa', 'PAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2602, 217, '森巴布莱', 'Sembabule', 'SEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2603, 217, '索罗提', 'Soroti', 'SOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2604, 217, '托罗罗', 'Tororo', 'TOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2605, 217, '瓦基索', 'Wakiso', 'WAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2606, 217, '锡龙科', 'Sironko', 'SIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2607, 217, '伊甘加', 'Iganga', 'IGA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2608, 217, '永贝', 'Yumbe', 'YUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2609, 218, '敖德萨', 'Odessa', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2610, 218, '波尔塔瓦', 'Poltava', '53', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2611, 218, '第聂伯罗波得罗夫斯克', 'Dnipropetrovsk', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2612, 218, '顿涅茨克', 'Donetsk', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2613, 218, '哈尔科夫', 'Kharkiv', '63', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2614, 218, '赫尔松州', 'Khersonsrka', '65', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2615, 218, '赫梅利尼茨基', 'Khmelnytsky', '68', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2616, 218, '基辅', 'Kyiv', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2617, 218, '基洛夫格勒', 'Kirovohrad', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2618, 218, '捷尔诺波尔', 'Ternopil', '61', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2619, 218, '克里米亚自治共和国', 'Respublika Krym', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2620, 218, '利沃夫', 'Lviv', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2621, 218, '卢甘斯克', 'Luhansk', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2622, 218, '罗夫诺', 'Rivne', '56', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2623, 218, '尼古拉耶夫', 'Mykolayiv', '48', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2624, 218, '切尔卡瑟', 'Cherkasy', '71', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2625, 218, '切尔尼戈夫', 'Chernihiv', '74', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2626, 218, '切尔诺夫策', 'Chernivtsi', '77', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2627, 218, '日托米尔', 'Zhytomyr', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2628, 218, '苏梅', 'Sumy', '59', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2629, 218, '外喀尔巴阡', 'Zakarpatska', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2630, 218, '文尼察', 'Vinnytsya', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2631, 218, '沃伦', 'Volyn', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2632, 218, '伊万－弗兰科夫州', 'Ivano-Frankivsk', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2633, 218, '扎波罗热', 'Zaporizhzhya', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2634, 219, '阿蒂加斯', 'Artigas', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2635, 219, '杜拉斯诺', 'Durazno', 'DU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2636, 219, '佛罗里达', 'Florida', 'FA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2637, 219, '弗洛雷斯', 'Flores', 'FS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2638, 219, '卡内洛内斯', 'Canelones', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2639, 219, '科洛尼亚', 'Colonia', 'CO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2640, 219, '拉瓦耶哈', 'Lavalleja', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2641, 219, '里韦拉', 'Rivera', 'RV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2642, 219, '罗恰', 'Rocha', 'RO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2643, 219, '马尔多纳多', 'Maldonado', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2644, 219, '蒙得维的亚', 'Montevideo', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2645, 219, '内格罗河', 'Rio Negro', 'RN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2646, 219, '派桑杜', 'Paysandu', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2647, 219, '萨尔托', 'Salto', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2648, 219, '塞罗拉尔戈', 'Cerro Largo', 'CL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2649, 219, '三十三人', 'Treinta y Tres', 'TT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2650, 219, '圣何塞', 'San Jose', 'SJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2651, 219, '索里亚诺', 'Soriano', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2652, 219, '塔夸伦博', 'Tacuarembo', 'TAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2653, 220, '安集延', 'Andijon', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2654, 220, '布哈拉', 'Buxoro', 'BU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2655, 220, '费尔干纳', 'Fargona', 'FA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2656, 220, '花拉子模', 'Xorazm', 'XO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2657, 220, '吉扎克', 'Jizzax', 'JI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2658, 220, '卡拉卡尔帕克斯坦共和国', 'Qoraqalpogiston', 'QR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2659, 220, '卡什卡达里亚', 'Qasqadaryo', 'QA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2660, 220, '纳曼干', 'Namangan', 'NG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2661, 220, '纳沃伊', 'Navoiy', 'NW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2662, 220, '撒马尔罕', 'Samarqand', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2663, 220, '苏尔汉河', 'Surxondaryo', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2664, 220, '塔什干', 'Toshkent', 'TK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2665, 220, '塔什干市', 'Toshkent Shahri', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2666, 220, '锡尔河', 'Sirdaryo', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2667, 221, '阿尔梅里亚', 'Almeria', 'LEI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2668, 221, '阿尔瓦塞特', 'Albacete', 'ALB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2669, 221, '阿拉瓦', 'Alava', 'ALA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2670, 221, '阿利坎特', 'Alicante', 'ALC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2671, 221, '阿斯图利亚斯', 'Asturias', 'AST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2672, 221, '阿维拉', 'Avila', 'AVI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2673, 221, '奥伦塞', 'Orense', 'ORE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2674, 221, '巴达霍斯', 'Badajoz', 'BJZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2675, 221, '巴利阿里', 'Baleares', 'BLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2676, 221, '巴利亚多利德', 'Valladolid', 'VLL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2677, 221, '巴伦西亚', 'Valencia', 'VLC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2678, 221, '巴塞罗那', 'Barcelona', 'BCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2679, 221, '比斯开', 'Vizcaya', 'VSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2680, 221, '布尔戈斯', 'Burgos', 'BUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2681, 221, '格拉纳达', 'Granada', 'GRX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2682, 221, '瓜达拉哈拉', 'Guadalajara', 'GUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2683, 221, '哈恩', 'Jaen', 'JAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2684, 221, '赫罗纳', 'Gerona', 'GRO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2685, 221, '吉普斯夸', 'Guipuzcoa', 'GUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2686, 221, '加的斯', 'Cadiz', 'CAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2687, 221, '卡塞雷斯', 'Caceres', 'CCS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2688, 221, '卡斯蒂利亚', 'Cludad Real', 'CIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2689, 221, '卡斯特利翁', 'Castellon', 'CAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2690, 221, '科尔多瓦', 'Cordoba', 'ODB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2691, 221, '昆卡', 'Cuenca', 'CUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2692, 221, '拉科鲁尼亚', 'La Coruna', 'LCG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2693, 221, '拉里奥哈', 'La Rioja', 'ARL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2694, 221, '拉斯帕尔马斯', 'Las Palmas', 'LPA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2695, 221, '莱昂', 'Leon', 'LEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2696, 221, '莱里达', 'Lleida', 'LLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2697, 221, '卢戈', 'Provincia de Lugo', 'LGO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2698, 221, '马德里', 'Madrid', 'MAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2699, 221, '马拉加', 'Malaga', 'AGP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2700, 221, '穆尔西亚', 'Murcia', 'MJV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2701, 221, '纳瓦拉', 'Navarra', 'NVV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2702, 221, '帕伦西亚', 'Palencia', 'PAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2703, 221, '蓬特韦德拉', 'Provincia de Pontevedra', 'PEV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2704, 221, '萨拉戈萨', 'Zaragoza', 'ZAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2705, 221, '萨拉曼卡', 'Salamanca', 'SLM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2706, 221, '萨莫拉', 'Zamora', 'ZMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2707, 221, '塞哥维亚', 'Segovia', 'SEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(2708, 221, '塞维利亚', 'Sevilla', 'SVQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2709, 221, '桑坦德', 'Santander', 'SDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2710, 221, '圣克鲁斯-德特内里费', 'Santa Cruz de Tenerife', 'SCT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2711, 221, '索里亚', 'Soria', 'SOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2712, 221, '塔拉戈纳', 'Tarragona', 'TAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2713, 221, '特鲁埃尔', 'Teruel', 'TER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2714, 221, '托莱多', 'Toledo', 'TOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2715, 221, '韦尔瓦', 'Huelva', 'HUV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2716, 221, '韦斯卡', 'Huesca', 'HUC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2717, 222, '比雷埃夫斯', 'Peiraievs', 'PRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2718, 222, '多德卡尼斯', 'Dodecanese', 'DO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2719, 222, '干尼亚', 'Chanion', 'CHQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2720, 222, '基克拉迪', 'Cyclades', 'CY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2721, 222, '拉西锡', 'Lasithiou', 'LST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2722, 222, '莱斯博斯', 'Lesbos', 'LES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2723, 222, '雷西姆农', 'Rethymnis', 'RET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2724, 222, '萨摩斯', 'Samos', 'SMI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2725, 222, '雅典', 'Athens', 'ATH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2726, 222, '伊拉克里翁', 'Irakleiou', 'HER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2727, 225, '奥克兰', 'Auckland', 'AUK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2728, 225, '北岸', 'North Shore', 'NSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2729, 225, '北帕默斯顿', 'Palmerston North', 'PMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2730, 225, '北远', 'Far North', 'FNR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2731, 225, '布莱尼姆', 'Blenheim', 'BHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2732, 225, '达尼丁', 'Dunedin', 'DUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2733, 225, '格雷茅斯', 'Greymouth', 'GMN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2734, 225, '哈密尔顿', 'Hamilton', 'HLZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2735, 225, '黑斯廷斯', 'Hastings', 'HAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2736, 225, '怀塔科拉', 'Waitakere', 'WAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2737, 225, '吉斯伯恩', 'Gisborne', 'GIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2738, 225, '凯帕拉', 'Kaipara', 'KAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2739, 225, '克赖斯特彻奇', 'Christchurch', 'CHC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2740, 225, '里士满', 'Richmond', 'RMD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2741, 225, '马努考', 'Manukau', 'MNK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2742, 225, '纳尔逊', 'Nelson', 'NSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2743, 225, '内皮尔', 'Napier', 'NPE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2744, 225, '斯特拉特福德', 'Stratford', 'STR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2745, 225, '陶马鲁努伊', 'Taumarunui', 'TAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2746, 225, '瓦卡塔尼', 'Whakatane', 'WHK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2747, 225, '旺阿雷', 'Whangarei', 'WRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2748, 225, '旺格努伊', 'Wanganui', 'WAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2749, 225, '新普利茅斯', 'New Plymouth', 'NPL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2750, 225, '因弗卡吉尔', 'Invercargill', 'IVC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2751, 226, '巴兰尼亚', 'Baranya', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2752, 226, '巴奇-基什孔', 'Bacs-Kiskun', 'BK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2753, 226, '包尔绍德-奥包乌伊-曾普伦', 'Borsod-Abauj-Zemplen', 'BZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2754, 226, '贝凯什', 'Bekes', 'BE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2755, 226, '布达佩斯', 'Budapest', 'BU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2756, 226, '费耶尔', 'Fejer', 'FE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2757, 226, '豪伊杜-比豪尔', 'Hajdu-Bihar', 'HB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2758, 226, '赫维什', 'Heves', 'HE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2759, 226, '加兹-纳杰孔-索尔诺克', 'Jasz-Nagykun-Szolnok', 'JN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2760, 226, '杰尔-莫松-肖普朗', 'Gyor-Moson-Sopron', 'GS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2761, 226, '科马罗姆', 'Komarom-Esztergom', 'KE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2762, 226, '诺格拉德', 'Nograd', 'NO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2763, 226, '佩斯', 'Pest', 'PE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2764, 226, '琼格拉德', 'Csongrad', 'CS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2765, 226, '绍莫吉', 'Somogy', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2766, 226, '索博尔奇-索特马尔-贝拉格', 'Szabolcs-Szatmar-Bereg', 'SZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2767, 226, '托尔瑙', 'Tolna', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2768, 226, '维斯普雷姆', 'Veszprem', 'VE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2769, 226, '沃什', 'Vas', 'VA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2770, 226, '佐洛', 'Zala', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2771, 227, '阿勒颇', 'Halab', 'HL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2772, 227, '大马士革', 'Rif Dimashq', 'RD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2773, 227, '大马士革市', 'Madinat Dimashq', 'DI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2774, 227, '代尔祖尔', 'Dayr az Zawr', 'DZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2775, 227, '德拉', 'Dara', 'DA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2776, 227, '哈马', 'Hamah', 'HM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2777, 227, '哈塞克', 'Al Hasakah', 'HA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2778, 227, '霍姆斯', 'Hims', 'HI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2779, 227, '加布', 'Al Ghab', 'GH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2780, 227, '卡米什利', 'Al-Qamishli', 'QA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2781, 227, '库奈特拉', 'Al Qunaytirah', 'QU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2782, 227, '拉卡', 'Ar Raqqah', 'RQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2783, 227, '拉塔基亚', 'Al Ladhiqiyah', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2784, 227, '苏韦达', 'As Suwayda', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2785, 227, '塔尔图斯', 'Tartus', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2786, 227, '伊德利卜', 'Idlib', 'ID', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2787, 228, '波特兰', 'Portland', 'POR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2788, 228, '汉诺威', 'Hanover', 'HAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2789, 228, '金斯敦', 'Kingston', 'KIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2790, 228, '克拉伦登', 'Clarendon', 'CLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2791, 228, '曼彻斯特', 'Manchester', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2792, 228, '圣安德鲁斯', 'St. Andrews', 'AND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2793, 228, '圣安娜', 'St. Ann', 'ANN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2794, 228, '圣凯瑟琳', 'St. Catherine', 'CAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2795, 228, '圣玛丽', 'St. Mary', 'MAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2796, 228, '圣托马斯', 'St. Thomas', 'THO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2797, 228, '圣伊丽莎白', 'St. Elizabeth', 'ELI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2798, 228, '圣詹姆斯', 'St. James', 'JAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2799, 228, '特里洛尼', 'Trelawny', 'TRL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2800, 228, '西摩兰', 'Westmoreland', 'WML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2801, 229, '阿尔马维尔', 'Armavir', 'ARM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2802, 229, '阿拉加措特恩', 'Aragacotn', 'AGT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2803, 229, '阿拉拉特', 'Ararat', 'ARA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2804, 229, '埃里温市', 'Yerevan', 'EVN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2805, 229, '格加尔库尼克', 'Gelarkunik', 'GEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2806, 229, '科泰克', 'Kotayk', 'KOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2807, 229, '洛里', 'Lorri', 'LOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2808, 229, '塔武什', 'Tavus', 'TAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2809, 229, '瓦约茨·佐尔', 'VayocJor', 'VAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2810, 229, '希拉克', 'Shirak', 'SHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2811, 229, '休尼克', 'Syunik', 'SYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2812, 230, '阿比扬', 'Abyan', 'AB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2813, 230, '阿姆兰', 'Amran Sana', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2814, 230, '贝达', 'Al-Bayda', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2815, 230, '达利', 'Ad-Dali', 'DA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2816, 230, '哈德拉毛', 'Hadramawt', 'HD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2817, 230, '哈杰', 'Hajjah', 'HJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2818, 230, '荷台达', 'Al-Hudaydah', 'HU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2819, 230, '焦夫', 'Al-Jawf', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2820, 230, '拉赫季', 'Lahij', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2821, 230, '马里卜', 'Marib', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2822, 230, '迈赫拉', 'Al-Mahrah', 'MR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2823, 230, '迈赫维特', 'Al-Mahwit', 'MW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2824, 230, '萨达', 'Sadah', 'SD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2825, 230, '萨那', 'Sana', 'SN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2826, 230, '赛文', 'Seiyun', 'GXF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2827, 230, '舍卜沃', 'Shabwah', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2828, 230, '塔伊兹', 'Taizz', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2829, 230, '希赫尔', 'Ash-Shihr', 'ASR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2830, 230, '亚丁', 'Adan', 'AD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2831, 230, '伊卜', 'Ibb', 'IB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2832, 230, '扎玛尔', 'Dhamar', 'DH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2833, 233, '阿什杜德', 'Ashdod', 'ASH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2834, 233, '贝尔谢巴', 'Beersheba', 'BEV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2835, 233, '贝特雁', 'Bat Yam', 'BAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2836, 233, '海法', 'Haifa', 'HFA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2837, 233, '霍隆', 'Holon', 'HOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2838, 233, '内坦亚', 'Netanya', 'NAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2839, 233, '特拉维夫', 'Tel Aviv-Yafo', 'TLV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2840, 233, '耶路撒冷', 'Jerusalem', 'J', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2841, 234, '阿斯蒂', 'Asti', 'AST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2842, 234, '阿斯科利皮切诺', 'Ascoli Piceno', 'ASP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2843, 234, '安科纳', 'Ancona', 'AOI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2844, 234, '奥尔比亚', 'Olbia-Tempio', 'OLB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2845, 234, '奥里斯塔诺', 'Oristano', 'QOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2846, 234, '奥斯塔', 'Aosta', 'AOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2847, 234, '巴勒莫', 'Palermo', 'PMO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2848, 234, '巴里', 'Bari', 'BRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2849, 234, '贝加莫', 'Bergamo', 'BGO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2850, 234, '贝内文托', 'Benevento', 'BEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2851, 234, '比萨', 'Pisa', 'PSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2852, 234, '波代诺内', 'Pordenone', 'PRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2853, 234, '波坦察', 'Potenza', 'QPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2854, 234, '博洛尼亚', 'Bologna', 'BLQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2855, 234, '布拉', 'Biella', 'BIE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2856, 234, '布雷西亚', 'Brescia', 'BRC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2857, 234, '布林迪西', 'Brindisi', 'BDS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2858, 234, '的里雅斯特', 'Trieste', 'TRS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2859, 234, '都灵', 'Turin', 'TRN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2860, 234, '费拉拉', 'Ferrara', 'FRR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2861, 234, '佛罗伦萨', 'Firenze', 'FLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2862, 234, '福贾', 'Foggia', 'FOG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2863, 234, '卡利亚里', 'Cagliari', 'CAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2864, 234, '卡塞塔', 'Caserta', 'CST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2865, 234, '卡塔尼亚', 'Catania', 'CTA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2866, 234, '卡坦扎罗', 'Catanzaro', 'QCZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2867, 234, '坎波巴索', 'Campobasso', 'COB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2868, 234, '科摩', 'Como', 'CIY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2869, 234, '科森扎', 'Cosenza', 'QCS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2870, 234, '克罗托内', 'Crotone', 'CRV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2871, 234, '库内奥', 'Cuneo', 'CUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2872, 234, '拉奎拉', 'L''Aquila', 'LAQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2873, 234, '拉斯佩齐亚', 'La Spezia', 'SPE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2874, 234, '莱科', 'Lecco', 'LCO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2875, 234, '莱切', 'Lecce', 'LCC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2876, 234, '雷焦艾米利亚', 'Reggio Emilia', 'RNE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2877, 234, '雷焦卡拉布里亚', 'Reggio Calabria', 'REG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2878, 234, '里窝那', 'Livorno', 'LIV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2879, 234, '罗马', 'Roma', 'ROM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2880, 234, '马萨', 'Massa-Carrara', 'MCR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2881, 234, '马泰拉', 'Matera', 'MTR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2882, 234, '蒙扎', 'Monza e Brianza', 'MZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2883, 234, '米兰', 'Milano', 'MIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2884, 234, '摩德纳', 'Modena', 'MOD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2885, 234, '墨西拿', 'Messina', 'MSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2886, 234, '那不勒斯', 'Naples', 'NAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2887, 234, '努奥罗', 'Nuoro', 'QNU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2888, 234, '诺瓦拉', 'Novara', 'NVR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2889, 234, '帕尔马', 'Parma', 'PMF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2890, 234, '帕维亚', 'Pavia', 'PAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2891, 234, '佩鲁贾', 'Perugia', 'PEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2892, 234, '热那亚', 'Genova', 'CAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2893, 234, '萨莱诺', 'Salerno', 'SAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2894, 234, '萨萨里', 'Sassari', 'QSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2895, 234, '萨沃纳', 'Savona', 'SVN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2896, 234, '塔兰托', 'Taranto', 'TAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2897, 234, '特拉帕尼', 'Trapani', 'TPS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2898, 234, '特伦托', 'Trento', 'TRT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2899, 234, '威尼斯', 'Venice', 'VCE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2900, 234, '韦尔切利', 'Vercelli', 'VRL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2901, 234, '维泰博', 'Viterbo', 'VIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2902, 234, '乌迪内', 'Udine', 'UDN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2903, 234, '锡拉库扎', 'Syracuse', 'SYR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2904, 234, '锡耶纳', 'Siena', 'SNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2905, 234, '亚历山德里亚', 'Alessandria', 'ALE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2906, 234, '伊塞尔尼亚', 'Isernia', 'ISE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2907, 235, '艾藻尔', 'Aizawl', 'AJL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2908, 235, '班加罗尔', 'Bangalore', 'BLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2909, 235, '本地治里', 'Pondicherry', 'PNY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2910, 235, '博帕尔', 'Bhopal', 'BHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2911, 235, '布巴内斯瓦尔', 'Bhubaneswar', 'BBI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2912, 235, '昌迪加尔', 'Chandigarh', 'IXC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2913, 235, '达曼', 'Daman', 'DAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2914, 235, '第乌', 'Diu', 'DIU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2915, 235, '甘托克', 'Gangtok', 'GTO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2916, 235, '哥印拜陀', 'Coimbatore', 'CJB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2917, 235, '加尔各答', 'Calcutta', 'CCU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2918, 235, '加里加尔', 'Karaikal', 'KRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2919, 235, '贾巴尔普尔', 'Jabalpur', 'JLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2920, 235, '贾朗达尔', 'Jalandhar', 'JUC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2921, 235, '焦特布尔', 'Jodhpur', 'JDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2922, 235, '金奈', 'Chennai', 'MAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2923, 235, '卡瓦拉蒂', 'Kavaratti', 'KVA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2924, 235, '科希马', 'Kohima', 'KOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2925, 235, '马埃', 'Mahe', 'MAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2926, 235, '马杜赖', 'Madurai', 'IXM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2927, 235, '森伯尔布尔', 'Sambalpur', 'SLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2928, 235, '特里凡得琅', 'Trivandrum', 'TRV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2929, 235, '乌代布尔', 'Udaipur', 'UDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2930, 235, '西隆', 'Shillong', 'SHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2931, 235, '锡尔萨瓦', 'Silvassa', 'SIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2932, 235, '新德里', 'New Delhi', 'ICD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2933, 235, '亚南', 'Yanam', 'SRV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2934, 235, '因帕尔', 'Imphal', 'IMF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2935, 235, '印多尔', 'Indore', 'IDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2936, 235, '斋普尔', 'Jaipur', 'JAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2937, 236, '巴厘', 'Bali', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2938, 236, '邦加－勿里洞群岛', 'Kepulauan Bangka Belitung', 'BB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2939, 236, '北苏拉威西', 'Sulawesi Utara', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2940, 236, '北苏门答腊', 'Sumatera Utara', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2941, 236, '大雅加达首都特区', 'Daerah Tingkat I Kalimantan Barat', 'KB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2942, 236, '东加里曼丹', 'Kalimantan Timur', 'KI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2943, 236, '东南苏拉威西', 'Sulawesi Tenggara', 'SG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2944, 236, '东努沙登加拉', 'Nusa Tenggara Timur', 'NT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2945, 236, '东爪哇', 'Java Timur', 'JI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2946, 236, '廖内', 'Riau', 'RI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2947, 236, '马鲁古', 'Maluku', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2948, 236, '明古鲁', 'Bengkulu', 'BE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2949, 236, '楠榜', 'Lampung', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2950, 236, '南加里曼丹', 'Kalimantan Selatan', 'KS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2951, 236, '南苏拉威西', 'Sulawesi Selatan', 'SN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2952, 236, '南苏门答腊', 'Sumatera Selatan', 'SS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2953, 236, '日惹特区', 'Daerah Istimewa Yogyakarta', 'YO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2954, 236, '万丹', 'Banten', 'BT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2955, 236, '西努沙登加拉', 'Nusa Tenggara Barat', 'NB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2956, 236, '西苏门答腊', 'Sumatera Barat', 'SR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2957, 236, '西爪哇', 'Java Barat', 'JB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2958, 236, '雅加达', 'Jakarta Raya', 'JK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2959, 236, '亚齐', 'Aceh', 'AC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2960, 236, '伊里安查亚', 'Irian Jaya', 'IJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2961, 236, '占碑', 'Jambi', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2962, 236, '中加里曼丹', 'Kalimantan Tengah', 'KT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2963, 236, '中苏拉威西', 'Sulawesi Tengah', 'ST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2964, 236, '中爪哇', 'Java Tengah', 'JT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2965, 239, '阿吉隆', 'Allun', 'AJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2966, 239, '安曼', 'Amman', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2967, 239, '拜勒加', 'Balqa', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2968, 239, '杰拉什', 'Jarash', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2969, 239, '卡拉克', 'Karak', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2970, 239, '鲁赛法', 'Rusayfah', 'RU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2971, 239, '马安', 'Maan', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2972, 239, '马德巴', 'Madaba', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2973, 239, '马夫拉克', 'Mafraq', 'MF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2974, 239, '塔菲拉', 'Tafiela', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2975, 239, '亚喀巴', 'Aqaba', 'AQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2976, 239, '伊尔比德', 'Irbid', 'IR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2977, 239, '扎尔卡', 'Zarqa', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2978, 240, '海防', 'Haiphong', 'HP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2979, 240, '河内', 'Hanoi', 'HI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2980, 240, '胡志明市', 'Ho Chi Minh City', 'HC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2981, 241, '北方', 'Northern', 'NO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2982, 241, '东方', 'Eastern', 'EA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2983, 241, '卢阿普拉', 'Luapula', 'LP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2984, 241, '卢萨卡', 'Lusaka', 'LK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2985, 241, '南方', 'Southern', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2986, 241, '铜带', 'Copperbelt', 'CB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2987, 241, '西北', 'North-Western', 'NW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2988, 241, '西方', 'Western', 'WE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2989, 241, '中央', 'Central', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2990, 245, '阿劳卡尼亚大区', 'Region de la Araucania', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2991, 245, '阿塔卡马大区', 'Region de Atacama', 'AT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2992, 245, '安托法加斯塔大区', 'Region de Antofagasta', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2993, 245, '比奥比奥大区', 'Region del Biobio', 'BI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2994, 245, '复活节岛', 'Libertador', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2995, 245, '湖大区', 'Region de los Lagos', 'LL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2996, 245, '科金博大区', 'Region de Coquimbo', 'CO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2997, 245, '马乌莱大区', 'Region del Maule', 'ML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2998, 245, '麦哲伦-智利南极大区', 'Magallanes y Antartica Chilena', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2999, 245, '圣地亚哥', 'Metropolitana de Santiago', 'RM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3000, 245, '塔拉帕卡大区', 'Region de Tarapaca', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3001, 245, '瓦尔帕莱索大区', 'Region de Valparaiso', 'VS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3002, 245, '伊瓦涅斯将军的艾森大区', 'Region de Alsen del General Carlos Ibanez del', 'AI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3003, 246, '巴明吉-班戈兰', 'Bamingui-Bangoran', 'BB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3004, 246, '班吉直辖市', 'Bangui', 'BGF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3005, 246, '宾博', 'Bimbo', 'BI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3006, 246, '凯莫', 'Kemo', 'KG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3007, 246, '洛巴伊', 'Lobaye', 'LB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3008, 246, '曼贝雷-卡代', 'Mambere-Kadei', 'HS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3009, 246, '姆博穆', 'Mbomou', 'MB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3010, 246, '纳纳-格里比齐', 'Nana-Gribizi', 'KB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3011, 246, '纳纳-曼贝雷', 'Nana-Mambere', 'NM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3012, 246, '桑加-姆巴埃雷', 'Sangha-Mbaere', 'SE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3013, 246, '上科托', 'Haute-Kotto', 'HK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3014, 246, '上姆博穆', 'Haut-Mbomou', 'HM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3015, 246, '瓦卡', 'Ouaka', 'UK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3016, 246, '瓦卡加', 'Vakaga', 'VK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3017, 246, '瓦姆', 'Ouham', 'AC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3018, 246, '瓦姆-彭代', 'Ouham-Pende', 'OP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3019, 246, '翁贝拉-姆波科', 'Ombella-Mpoko', 'MP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3020, 246, '下科托', 'Basse-Kotto', 'BK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3021, 247, '东城', 'Dongcheng', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3022, 247, '西城', 'Xicheng', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3023, 247, '朝阳', 'Chaoyang', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3024, 247, '丰台', 'Fengtai', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3025, 247, '石景山', 'Shijingshan', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3026, 247, '海淀', 'Haidian', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3027, 247, '门头沟', 'Mentougou', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3028, 247, '房山', 'Fangshan', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3029, 247, '通州', 'Tongzhou', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3030, 247, '顺义', 'Shunyi', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3031, 247, '昌平', 'Changping', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3032, 247, '大兴', 'Daxing', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3033, 247, '平谷', 'Pinggu', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3034, 247, '怀柔', 'Huairou', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3035, 247, '密云', 'Miyun', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3036, 247, '延庆', 'Yanqing', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3037, 248, '和平', 'Heping', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3038, 248, '河东', 'Hedong', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3039, 248, '河西', 'Hexi', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3040, 248, '南开', 'Nankai', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3041, 248, '河北', 'Hebei', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3042, 248, '红桥', 'Hongqiao', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3043, 248, '滨海新区', 'Binghaixinqu', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3044, 248, '东丽', 'Dongli', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3045, 248, '西青', 'Xiqing', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3046, 248, '津南', 'Jinnan', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3047, 248, '北辰', 'Beichen', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3048, 248, '宁河', 'Ninghe', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3049, 248, '武清', 'Wuqing', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3050, 248, '静海', 'Jinghai', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3051, 248, '宝坻', 'Baodi', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3052, 248, '蓟县', 'Jixian', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3053, 249, '石家庄', 'Shijiazhuang', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3054, 249, '唐山', 'Tangshan', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3055, 249, '秦皇岛', 'Qinhuangdao', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3056, 249, '邯郸', 'Handan', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3057, 249, '邢台', 'Xingtai', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3058, 249, '保定', 'Baoding', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3059, 249, '张家口', 'Zhangjiakou', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3060, 249, '承德', 'Chengde', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3061, 249, '沧州', 'Cangzhou', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3062, 249, '廊坊', 'Langfang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3063, 249, '衡水', 'Hengshui', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3064, 250, '太原', 'Taiyuan', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3065, 250, '大同', 'Datong', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3066, 250, '阳泉', 'Yangquan', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3067, 250, '长治', 'Changzhi', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3068, 250, '晋城', 'Jincheng', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3069, 250, '朔州', 'Shuozhou', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3070, 250, '晋中', 'Jinzhong', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3071, 250, '运城', 'Yuncheng', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3072, 250, '忻州', 'Xinzhou', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3073, 250, '临汾', 'Linfen', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3074, 250, '吕梁', 'luliang', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3075, 251, '呼和浩特', 'Hohhot', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3076, 251, '包头', 'Baotou', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3077, 251, '乌海', 'Wuhai', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3078, 251, '赤峰', 'Chifeng', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3079, 251, '通辽', 'Tongliao', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3080, 251, '鄂尔多斯', 'Ordos', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3081, 251, '呼伦贝尔', 'Hulun Buir', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3082, 251, '巴彦淖尔', 'Bayannur', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3083, 251, '乌兰察布', 'Ulan Qab', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3084, 251, '兴安', 'Xing''an', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3085, 251, '锡林郭勒', 'Xilin Gol', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3086, 251, '阿拉善', 'Alxa', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3087, 252, '沈阳', 'Shenyang', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3088, 252, '大连', 'Dalian', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3089, 252, '鞍山', 'Anshan', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3090, 252, '抚顺', 'Fushun', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3091, 252, '本溪', 'Benxi', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3092, 252, '丹东', 'Dandong', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3093, 252, '锦州', 'Jinzhou', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3094, 252, '营口', 'Yingkou', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3095, 252, '阜新', 'Fuxin', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3096, 252, '辽阳', 'Liaoyang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3097, 252, '盘锦', 'Panjin', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3098, 252, '铁岭', 'Tieling', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3099, 252, '朝阳', 'Chaoyang', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3100, 252, '葫芦岛', 'Huludao', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3101, 253, '长春', 'Changchun', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3102, 253, '吉林', 'Jilin', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3103, 253, '四平', 'Siping', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3104, 253, '辽源', 'Liaoyuan', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3105, 253, '通化', 'Tonghua', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3106, 253, '白山', 'Baishan', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3107, 253, '松原', 'Songyuan', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3108, 253, '白城', 'Baicheng', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3109, 253, '延边', 'Yanbian Korean Autonomous Prefecture', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3110, 254, '哈尔滨', 'Harbin', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3111, 254, '齐齐哈尔', 'Qiqihar', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3112, 254, '鸡西', 'Jixi', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3113, 254, '鹤岗', 'Hegang', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3114, 254, '双鸭山', 'Shuangyashan', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3115, 254, '大庆', 'Daqing', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3116, 254, '伊春', 'Yichun', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3117, 254, '佳木斯', 'Jiamusi', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3118, 254, '七台河', 'Qitaihe', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3119, 254, '牡丹江', 'Mudanjiang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3120, 254, '黑河', 'Heihe', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3121, 254, '绥化', 'Suihua', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3122, 254, '大兴安岭', 'Da Hinggan Ling', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3123, 255, '黄浦', 'Huangpu', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3124, 255, '卢湾', 'Luwan', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3125, 255, '徐汇', 'Xuhui', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3126, 255, '长宁', 'Changning', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3127, 255, '静安', 'Jing''an', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3128, 255, '普陀', 'Putuo', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3129, 255, '闸北', 'Zhabei', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3130, 255, '虹口', 'Hongkou', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3131, 255, '杨浦', 'Yangpu', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3132, 255, '闵行', 'Minhang', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3133, 255, '宝山', 'Baoshan', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3134, 255, '嘉定', 'Jiading', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3135, 255, '浦东新区', 'Pudong New Area', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3136, 255, '金山', 'Jinshan', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3137, 255, '松江', 'Songjiang', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3138, 255, '奉贤', 'Fengxian', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3139, 255, '青浦', 'Qingpu', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3140, 255, '崇明', 'Chongming', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3141, 256, '南京', 'Nanjing', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3142, 256, '无锡', 'Wuxi', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3143, 256, '徐州', 'Xuzhou', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3144, 256, '常州', 'Changzhou', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3145, 256, '苏州', 'Suzhou', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3146, 256, '南通', 'Nantong', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3147, 256, '连云港', 'Lianyungang', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3148, 256, '淮安', 'Huai''an', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3149, 256, '盐城', 'Yancheng', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3150, 256, '扬州', 'Yangzhou', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3151, 256, '镇江', 'Zhenjiang', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3152, 256, '泰州', 'Taizhou', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3153, 256, '宿迁', 'Suqian', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3154, 257, '杭州', 'Hangzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3155, 257, '宁波', 'Ningbo', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3156, 257, '温州', 'Wenzhou', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3157, 257, '嘉兴', 'Jiaxing', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3158, 257, '湖州', 'Huzhou', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3159, 257, '绍兴', 'Shaoxing', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3160, 257, '金华', 'Jinhua', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3161, 257, '衢州', 'Quzhou', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3162, 257, '舟山', 'Zhoushan', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3163, 257, '台州', 'Taizhou', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3164, 257, '丽水', 'Lishui', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3165, 258, '合肥', 'Hefei', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3166, 258, '芜湖', 'Wuhu', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3167, 258, '蚌埠', 'Bengbu', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3168, 258, '淮南', 'Huainan', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3169, 258, '马鞍山', 'Ma''anshan', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3170, 258, '淮北', 'Huaibei', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3171, 258, '铜陵', 'Tongling', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3172, 258, '安庆', 'Anqing', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3173, 258, '黄山', 'Huangshan', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3174, 258, '滁州', 'Chuzhou', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3175, 258, '阜阳', 'Fuyang', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3176, 258, '宿州', 'Suzhou', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3177, 258, '六安', 'Lu''an', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3178, 258, '亳州', 'Bozhou', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3179, 258, '池州', 'Chizhou', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3180, 258, '宣城', 'Xuancheng', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3181, 259, '福州', 'Fuzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3182, 259, '厦门', 'Xiamen', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3183, 259, '莆田', 'Putian', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3184, 259, '三明', 'Sanming', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3185, 259, '泉州', 'Quanzhou', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3186, 259, '漳州', 'Zhangzhou', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3187, 259, '南平', 'Nanping', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3188, 259, '龙岩', 'Longyan', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3189, 259, '宁德', 'Ningde', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3190, 260, '南昌', 'Nanchang', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3191, 260, '景德镇', 'Jingdezhen', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3192, 260, '萍乡', 'Pingxiang', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3193, 260, '九江', 'Jiujiang', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3194, 260, '新余', 'Xinyu', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3195, 260, '鹰潭', 'Yingtan', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3196, 260, '赣州', 'Ganzhou', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3197, 260, '吉安', 'Ji''an', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3198, 260, '宜春', 'Yichun', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3199, 260, '抚州', 'Fuzhou', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3200, 260, '上饶', 'Shangrao', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3201, 261, '济南', 'Jinan', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3202, 261, '青岛', 'Qingdao', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3203, 261, '淄博', 'Zibo', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3204, 261, '枣庄', 'Zaozhuang', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3205, 261, '东营', 'Dongying', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3206, 261, '烟台', 'Yantai', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3207, 261, '潍坊', 'Weifang', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3208, 261, '济宁', 'Jining', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3209, 261, '泰安', 'Tai''an', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3210, 261, '威海', 'Weihai', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3211, 261, '日照', 'Rizhao', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3212, 261, '莱芜', 'Laiwu', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3213, 261, '临沂', 'Linyi', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3214, 261, '德州', 'Dezhou', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3215, 261, '聊城', 'Liaocheng', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3216, 261, '滨州', 'Binzhou', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3217, 261, '菏泽', 'Heze', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3218, 262, '郑州', 'Zhengzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3219, 262, '开封', 'Kaifeng', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3220, 262, '洛阳', 'Luoyang', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3221, 262, '平顶山', 'Pingdingshan', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3222, 262, '安阳', 'Anyang', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3223, 262, '鹤壁', 'Hebi', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3224, 262, '新乡', 'Xinxiang', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3225, 262, '焦作', 'Jiaozuo', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3226, 262, '濮阳', 'Puyang', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3227, 262, '许昌', 'Xuchang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3228, 262, '漯河', 'Luohe', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3229, 262, '三门峡', 'Sanmenxia', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3230, 262, '南阳', 'Nanyang', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3231, 262, '商丘', 'Shangqiu', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3232, 262, '信阳', 'Xinyang', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3233, 262, '周口', 'Zhoukou', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3234, 262, '驻马店', 'Zhumadian', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3235, 262, '济源', 'Jiyuan', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3236, 263, '武汉', 'Wuhan', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3237, 263, '黄石', 'Huangshi', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3238, 263, '十堰', 'Shiyan', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3239, 263, '宜昌', 'Yichang', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3240, 263, '襄阳', 'Xiangyang', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3241, 263, '鄂州', 'Ezhou', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3242, 263, '荆门', 'Jingmen', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3243, 263, '孝感', 'Xiaogan', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3244, 263, '荆州', 'Jingzhou', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3245, 263, '黄冈', 'Huanggang', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3246, 263, '咸宁', 'Xianning', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3247, 263, '随州', 'Suizhou', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3248, 263, '恩施', 'Enshi Tujia-Miao Autonomous Prefecture', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3249, 263, '仙桃', 'Xiantao', '94', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3250, 263, '潜江', 'Qianjiang', '95', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3251, 263, '天门', 'Tianmen', '96', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3252, 263, '神农架', 'Shennongjia', 'A21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3253, 264, '长沙', 'Changsha', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3254, 264, '株洲', 'Zhuzhou', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3255, 264, '湘潭', 'Xiangtan', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3256, 264, '衡阳', 'Hengyang', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3257, 264, '邵阳', 'Shaoyang', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(3258, 264, '岳阳', 'Yueyang', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3259, 264, '常德', 'Changde', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3260, 264, '张家界', 'Zhangjiajie', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3261, 264, '益阳', 'Yiyang', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3262, 264, '郴州', 'Chenzhou', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3263, 264, '永州', 'Yongzhou', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3264, 264, '怀化', 'Huaihua', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3265, 264, '娄底', 'Loudi', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3266, 264, '湘西', 'Xiangxi Tujia-Miao Autonomous Prefecture', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3267, 265, '广州', 'Guangzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3268, 265, '韶关', 'Shaoguan', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3269, 265, '深圳', 'Shenzhen', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3270, 265, '珠海', 'Zhuhai', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3271, 265, '汕头', 'Shantou', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3272, 265, '佛山', 'Foshan', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3273, 265, '江门', 'Jiangmen', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3274, 265, '湛江', 'Zhanjiang', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3275, 265, '茂名', 'Maoming', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3276, 265, '肇庆', 'Zhaoqing', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3277, 265, '惠州', 'Huizhou', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3278, 265, '梅州', 'Meizhou', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3279, 265, '汕尾', 'Shanwei', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3280, 265, '河源', 'Heyuan', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3281, 265, '阳江', 'Yangjiang', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3282, 265, '清远', 'Qingyuan', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3283, 265, '东莞', 'Dongguan', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3284, 265, '中山', 'Zhongshan', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3285, 265, '潮州', 'Chaozhou', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3286, 265, '揭阳', 'Jieyang', '52', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3287, 265, '云浮', 'Yunfu', '53', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3288, 266, '南宁', 'Nanning', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3289, 266, '柳州', 'Liuzhou', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3290, 266, '桂林', 'Guilin', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3291, 266, '梧州', 'Wuzhou', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3292, 266, '北海', 'Beihai', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3293, 266, '防城港', 'Fangchenggang', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3294, 266, '钦州', 'Qinzhou', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3295, 266, '贵港', 'Guigang', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3296, 266, '玉林', 'Yulin', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3297, 266, '百色', 'Baise', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3298, 266, '贺州', 'Hezhou', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3299, 266, '河池', 'Hechi', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3300, 266, '来宾', 'Laibin', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3301, 266, '崇左', 'Chongzuo', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3302, 267, '海口', 'Haikou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3303, 267, '三亚', 'Sanya', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3304, 267, '三沙', 'Shansha', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3305, 267, '五指山', 'Wuzhishan', '91', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3306, 267, '琼海', 'Qionghai', '92', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3307, 267, '儋州', 'Danzhou', '93', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3308, 267, '文昌', 'Wenchang', '95', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3309, 267, '万宁', 'Wanning', '96', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3310, 267, '东方', 'Dongfang', '97', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3311, 267, '定安', 'Ding''an', 'A25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3312, 267, '屯昌', 'Tunchang', 'A26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3313, 267, '澄迈', 'Cengmai', 'A27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3314, 267, '临高', 'Lingao', 'A28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3315, 267, '白沙', 'Baisha Li Autonomous County', 'A30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3316, 267, '昌江', 'Jiang Li Autonomous County', 'A31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3317, 267, '乐东', 'Ledong Li Autonomous County', 'A33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3318, 267, '陵水', 'Lingshui Li Autonomous County', 'A34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3319, 267, '保亭', 'Baoting Li-Miao Autonomous County', 'A35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3320, 267, '琼中', 'Qiongzhong Li-Miao Autonomous County', 'A36', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3321, 268, '万州', 'Wanzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3322, 268, '涪陵', 'Fuling', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3323, 268, '渝中', 'Yuzhong', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3324, 268, '大渡口', 'Dadukou', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3325, 268, '江北', 'Jiangbei', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3326, 268, '沙坪坝', 'Shapingba', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3327, 268, '九龙坡', 'Jiulongpo', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3328, 268, '南岸', 'Nan''an', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3329, 268, '北碚', 'Beibei', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3330, 268, '两江新区', 'Kaixian', '85', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3331, 268, '万盛', 'Wansheng', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3332, 268, '双桥', 'Shuangqiao', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3333, 268, '渝北', 'Yubei', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3334, 268, '巴南', 'Ba''nan', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3335, 268, '长寿', 'Changshou', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3336, 268, '綦江', 'Qijiang', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3337, 268, '潼南', 'Tongnan', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3338, 268, '铜梁', 'Tongliang', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3339, 268, '大足', 'Dazu', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3340, 268, '荣昌', 'Rongchang', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3341, 268, '璧山', 'Bishan', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3342, 268, '梁平', 'Liangping', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3343, 268, '城口', 'Chengkou', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3344, 268, '丰都', 'Fengdu', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3345, 268, '垫江', 'Dianjiang', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3346, 268, '武隆', 'Wulong', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3347, 268, '忠县', 'Zhongxian', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3348, 268, '开县', 'Kaixian', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3349, 268, '云阳', 'Yunyang', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3350, 268, '奉节', 'Fengjie', '36', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3351, 268, '巫山', 'Wushan', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3352, 268, '巫溪', 'Wuxi', '38', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3353, 268, '黔江', 'Qianjiang', '39', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3354, 268, '石柱', 'Shizhu Tujia Autonomous Country', '40', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3355, 268, '秀山', 'Xiushan Tujia-Miao Autonomous Country', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3356, 268, '酉阳', 'Youyang Tujia-Miao Autonomous Country', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3357, 268, '彭水', 'Pengshui Miao-Tujia Autonomous Country', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3358, 268, '江津', 'Jiangjin', '81', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3359, 268, '合川', 'Hechuan', '82', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3360, 268, '永川', 'Yongchuan', '83', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3361, 268, '南川', 'Liangjiangxinqu', '84', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3362, 269, '成都', 'Chengdu', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3363, 269, '自贡', 'Zigong', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3364, 269, '攀枝花', 'Panzhihua', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3365, 269, '泸州', 'Luzhou', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3366, 269, '德阳', 'Deyang', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3367, 269, '绵阳', 'Mianyang', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3368, 269, '广元', 'Guangyuan', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3369, 269, '遂宁', 'Suining', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3370, 269, '内江', 'Neijiang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3371, 269, '乐山', 'Leshan', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3372, 269, '南充', 'Nanchong', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3373, 269, '眉山', 'Meishan', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3374, 269, '宜宾', 'Yibin', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3375, 269, '广安', 'Guang''an', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3376, 269, '达州', 'Dazhou', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3377, 269, '雅安', 'Ya''an', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3378, 269, '巴中', 'Bazhong', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3379, 269, '资阳', 'Ziyang', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3380, 269, '阿坝', 'Aba Tibetan-Qiang Autonomous Prefecture', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3381, 269, '甘孜', 'Garze Tibetan Autonomous Prefecture', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3382, 269, '凉山', 'Liangshan Yi Autonomous Prefecture', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3383, 270, '贵阳', 'Guiyang', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3384, 270, '六盘水', 'Liupanshui', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3385, 270, '遵义', 'Zunyi', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3386, 270, '安顺', 'Anshun', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3387, 270, '铜仁', 'Tongren', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3388, 270, '黔西南', 'Qianxinan Buyi-Miao Autonomous Prefecture', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3389, 270, '毕节', 'Bijie', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3390, 270, '黔东南', 'Qiandongnan Miao-Dong Autonomous Prefecture', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3391, 270, '黔南', 'Qiannan Buyi Autonomous Prefecture', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3392, 271, '昆明', 'Kunming', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3393, 271, '曲靖', 'Qujing', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3394, 271, '玉溪', 'Yuxi', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3395, 271, '保山', 'Baoshan', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3396, 271, '昭通', 'Zhaotong', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3397, 271, '丽江', 'Lijiang', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3398, 271, '普洱', 'Pu''er', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3399, 271, '临沧', 'Lincang', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3400, 271, '楚雄', 'Chuxiong Yi Autonomous Prefecture', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3401, 271, '红河', 'Honghe Hani-Yi Autonomous Prefecture', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3402, 271, '文山', 'Wenshan Zhuang-Miao Autonomous Prefecture', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3403, 271, '西双版纳', 'Xishuangbanna Dai Autonomous Prefecture', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3404, 271, '大理', 'Dali Bai Autonomous Prefecture', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3405, 271, '德宏', 'Dehong Dai-Jingpo Autonomous Prefecture', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3406, 271, '怒江', 'Nujiang Lisu Autonomous Prefecture', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3407, 271, '迪庆', 'Diqing Tibetan Autonomous Prefecture', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3408, 272, '拉萨', 'Lhasa', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3409, 272, '昌都', 'Qamdo', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3410, 272, '山南', 'Shannan', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3411, 272, '日喀则', 'Xigaze', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3412, 272, '那曲', 'Nagqu', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3413, 272, '阿里', 'Ngari', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3414, 272, '林芝', 'Nyingchi', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3415, 273, '西安', 'Xi''an', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3416, 273, '铜川', 'Tongchuan', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3417, 273, '宝鸡', 'Baoji', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3418, 273, '咸阳', 'Xianyang', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3419, 273, '渭南', 'Weinan', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3420, 273, '延安', 'Yan''an', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3421, 273, '汉中', 'Hanzhong', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3422, 273, '榆林', 'Yulin', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3423, 273, '安康', 'Ankang', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3424, 273, '商洛', 'Shangluo', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3425, 274, '兰州市', 'Lanzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3426, 274, '嘉峪关', 'Jinchang', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3427, 274, '金昌', 'Baiyin', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3428, 274, '白银', 'Tianshui', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3429, 274, '天水', 'Jiayuguan', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3430, 274, '武威', 'Wuwei', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3431, 274, '张掖', 'Zhangye', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3432, 274, '平凉', 'Pingliang', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3433, 274, '酒泉', 'Jiuquan', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3434, 274, '庆阳', 'Qingyang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3435, 274, '定西', 'Dingxi', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3436, 274, '陇南', 'Longnan', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3437, 274, '临夏', 'Linxia Hui Autonomous Prefecture', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3438, 274, '甘南', 'Gannan Tibetan Autonomous Prefecture', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3439, 275, '西宁', 'Xining', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3440, 275, '海东', 'Haidong', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3441, 275, '海北', 'Haibei Tibetan Autonomous Prefecture', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3442, 275, '黄南', 'Huangnan Tibetan Autonomous Prefecture', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3443, 275, '海南', 'Hainan Tibetan Autonomous Prefecture', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3444, 275, '果洛', 'Guoluo Tibetan Autonomous Prefecture', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3445, 275, '玉树', 'Yushu Tibetan Autonomous Prefecture', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3446, 275, '海西', 'Haixi Mongol-Tibetan Autonomous Prefecture', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3447, 276, '银川', 'Yinchuan', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3448, 276, '石嘴山', 'Shizuishan', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3449, 276, '吴忠', 'Wuzhong', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3450, 276, '固原', 'Guyuan', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3451, 276, '中卫', 'Zhongwei', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3452, 277, '乌鲁木齐', 'Urumqi', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3453, 277, '克拉玛依', 'Karamay', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3454, 277, '吐鲁番', 'Turpan', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3455, 277, '哈密', 'Hami', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3456, 277, '昌吉', 'Changji Hui Autonomous Prefecture', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3457, 277, '博尔塔拉', 'Bortala Mongol Autonomous Prefecture', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3458, 277, '巴音郭楞', 'Bayingolin Mongol Autonomous Prefecture', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3459, 277, '阿克苏', 'Aksu', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3460, 277, '克孜勒苏', 'Kizilsu Kirgiz Autonomous Prefecture', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3461, 277, '喀什', 'Kashi', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3462, 277, '和田', 'Hotan', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3463, 277, '伊犁', 'Ili Kazakh Autonomous Prefecture', '40', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3464, 277, '塔城', 'Tacheng', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3465, 277, '阿勒泰', 'Altay', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3466, 277, '石河子', 'Shihezi', '91', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3467, 277, '阿拉尔', 'Alar', '92', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3468, 277, '图木舒克', 'Tumsuk', '93', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3469, 277, '五家渠', 'Wujiaqu', '94', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3470, 277, '北屯', 'Beitun', '95', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3471, 278, '台北市', 'Taipei City', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3472, 278, '高雄市', 'Kaohsiung City', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3473, 278, '基隆市', 'Keelung City', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3474, 278, '台中市', 'Taichung City', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3475, 278, '台南市', 'Tainan City', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3476, 278, '新竹市', 'Hsinchu City', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3477, 278, '嘉义市', 'Chiayi City', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3478, 278, '台北县', 'Taipei County', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3479, 278, '宜兰县', 'Ilan County', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3480, 278, '桃园县', 'Taoyuan County', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3481, 278, '新竹县', 'Hsinchu County', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3482, 278, '苗栗县', 'Miaoli County', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3483, 278, '台中县', 'Taichung County', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3484, 278, '彰化县', 'Changhwa County', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3485, 278, '南投县', 'Nantou County', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3486, 278, '云林县', 'Yunnlin County', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3487, 278, '嘉义县', 'Chiayi County', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3488, 278, '台南县', 'Tainan County', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3489, 278, '高雄县', 'Kaohsiung County', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3490, 278, '屏东县', 'Pingtung County', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3491, 278, '台东县', 'Taitung County', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3492, 278, '花莲县', 'Hualian County', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3493, 278, '澎湖县', 'Penghu County', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3494, 279, '中西区', 'NaN', 'HCW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3495, 279, '东区', 'NaN', 'HEA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3496, 279, '九龙城区', 'NaN', 'KKC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3497, 279, '观塘区', 'NaN', 'KKT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3498, 279, '南区', 'NaN', 'HSO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3499, 279, '深水埗区', 'NaN', 'KSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3500, 279, '黄大仙区', 'NaN', 'KWT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3501, 279, '湾仔区', 'NaN', 'HWC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3502, 279, '油尖旺区', 'NaN', 'KYT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3503, 279, '离岛区', 'NaN', 'NIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3504, 279, '葵青区', 'NaN', 'NKT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3505, 279, '北区', 'NaN', 'NNO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3506, 279, '西贡区', 'NaN', 'NSK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3507, 279, '沙田区', 'NaN', 'NST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3508, 279, '屯门区', 'NaN', 'NTM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3509, 279, '大埔区', 'NaN', 'NTP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3510, 279, '荃湾区', 'NaN', 'NTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3511, 279, '元朗区', 'NaN', 'NYL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3512, 280, '花地玛堂区', 'NaN', 'OLF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3513, 280, '圣安多尼堂区', 'NaN', 'ANT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3514, 280, '大堂区', 'NaN', 'CAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3515, 280, '望德堂区', 'NaN', 'LAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3516, 280, '风顺堂区', 'NaN', 'LAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3517, 280, '氹仔', 'NaN', 'TPA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3518, 280, '路环', 'NaN', 'CLN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3519, 281, '北帕默斯顿', 'Palmerston', 'PAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3520, 281, '达尔文', 'Darwin', 'DRW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3521, 282, '堪培拉', 'Canberra', 'CBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3522, 283, '布里斯班', 'Brisbane', 'BNE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3523, 283, '黄金海岸', 'Gold Coast', 'OOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3524, 283, '凯恩斯', 'Cairns', 'CNS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3525, 283, '日光海岸', 'Caloundra', 'CUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3526, 283, '汤斯维尔', 'Townsville', 'TSV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3527, 283, '图文巴', 'Toowoomba', 'TWB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3528, 284, '阿德莱德', 'Adelaide', 'ADL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3529, 284, '奥古斯塔港', 'Port Augusta', 'PUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3530, 284, '甘比亚山', 'Mount Gambier', 'MGB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3531, 284, '怀阿拉', 'Whyalla', 'WAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3532, 284, '林肯港', 'Port Lincoln', 'PLO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3533, 284, '默里布里奇', 'Murray Bridge', 'MYB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3534, 284, '皮里港', 'Port Pirie', 'PPI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3535, 284, '维克托港', 'Victor Harbor', 'VHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3536, 285, '伯尼港', 'Burnie', 'BWT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3537, 285, '德文波特', 'Devonport', 'DPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3538, 285, '霍巴特', 'Hobart', 'HBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3539, 285, '朗塞斯顿', 'Launceston', 'LST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3540, 286, '吉朗', 'Geelong', 'GEX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3541, 286, '墨尔本', 'Melbourne', 'MEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3542, 287, '奥尔巴尼', 'Albany', 'ALH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3543, 287, '班伯里', 'Bunbury', 'BUY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3544, 287, '弗里曼特尔港', 'Fremantle', 'FRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3545, 287, '杰拉尔顿', 'Geraldton', 'GET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3546, 287, '卡尔古利', 'Kalgoorlie', 'KGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3547, 287, '曼哲拉', 'Mandurah', 'MDU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3548, 287, '珀斯', 'Perth', 'PER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3549, 288, '纽卡斯尔', 'Newcastle', 'NTL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3550, 288, '伍伦贡', 'Wollongong', 'WOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3551, 288, '悉尼', 'Sydney', 'HBS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3552, 289, '达城郡', 'Dalseong-gun', 'DSG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3553, 289, '大邱', 'Daegu', 'TAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3554, 289, '寿城区', 'Suseong-gu', 'SUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3555, 294, '春川市', 'Chuncheon', 'CHC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3556, 294, '东海市', 'Donghae', 'TGH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3557, 294, '高城郡', 'Goseong County', 'GSG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3558, 294, '横城郡', 'Hoengseong County', 'HSG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3559, 294, '洪川郡', 'Hongcheon County', 'HCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3560, 294, '华川郡', 'Hwacheon County', 'HCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3561, 294, '江陵市', 'Gangneung', 'KAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3562, 294, '旌善郡', 'Jeongseon County', 'JSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3563, 294, '麟蹄郡', 'Inje County', 'IJE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3564, 294, '宁越郡', 'Yeongwol County', 'YWL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3565, 294, '平昌郡', 'Pyeongchang County', 'POG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3566, 294, '三陟市', 'Samcheok', 'SUK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3567, 294, '束草市', 'Sokcho', 'SHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3568, 294, '太白市', 'Taebaek', 'TBK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3569, 294, '铁原郡', 'Cheorwon County', 'CWN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3570, 294, '襄阳郡', 'Yangyang County', 'YNY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3571, 294, '杨口郡', 'Yanggu County', 'YGU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3572, 294, '原州市', 'Wonju', 'WJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3573, 295, '安城市', 'Anseong', 'ASG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3574, 295, '安山市', 'Ansan', 'ASN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3575, 295, '安养市', 'Anyang', 'ANY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3576, 295, '抱川市', 'Pocheon', 'POC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3577, 295, '城南市', 'Seongnam', 'SEO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3578, 295, '东豆川市', 'Dongducheon', 'DDC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3579, 295, '富川市', 'Bucheon', 'BCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3580, 295, '高阳市', 'Goyang', 'GYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3581, 295, '光明市', 'Gwangmyeong', 'GMG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3582, 295, '广州市', 'Gwangju', 'KWU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3583, 295, '果川市', 'Gwacheon', 'GCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3584, 295, '河南市', 'Hanam', 'HNM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3585, 295, '华城市', 'Hwaseong', 'HCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3586, 295, '加平郡', 'Gapyeong County', 'GPG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3587, 295, '金浦市', 'Gimpo', 'GMP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3588, 295, '九里市', 'Guri', 'GRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3589, 295, '军浦市', 'Gunpo', 'GUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3590, 295, '骊州郡', 'Yeoju County', 'YJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3591, 295, '利川市', 'Icheon', 'ICE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3592, 295, '涟川郡', 'Yeoncheon County', 'YCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3593, 295, '龙仁市', 'Yongin', 'YNG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3594, 295, '南杨州市', 'Namyangju', 'NYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3595, 295, '平泽市', 'Pyeongtaek', 'PTK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3596, 295, '坡州市', 'Paju', 'PJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3597, 295, '始兴市', 'Siheung', 'SHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3598, 295, '水原市', 'Suwon', 'SUO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3599, 295, '乌山市', 'Osan', 'OSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3600, 295, '扬平郡', 'Yangpyeong County', 'YPG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3601, 295, '杨州市', 'Yangju', 'YYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3602, 295, '仪旺市', 'Uiwang', 'UWN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3603, 295, '议政府市', 'Uijeongbu', 'UIJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3604, 296, '安东市', 'Andong', 'ADG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3605, 296, '奉化郡', 'Bonghwa County', 'BHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3606, 296, '高灵郡', 'Goryeong County', 'GRG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3607, 296, '龟尾市', 'Gumi', 'KUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3608, 296, '金泉市', 'Gimcheon', 'KMC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3609, 296, '军威郡', 'Gunwi County', 'GWI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3610, 296, '醴泉郡', 'Yecheon County', 'YEC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3611, 296, '浦项市', 'Pohang', 'KPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3612, 296, '漆谷郡', 'Chilgok County', 'CGK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3613, 296, '淸道郡', 'Cheongdo County', 'CDO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3614, 296, '靑松郡', 'Cheongsong County', 'CSG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3615, 296, '庆山市', 'Gyeongsan', 'GYS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3616, 296, '庆州市', 'Gyeongju', 'GJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3617, 296, '荣州市', 'Yeongju', 'YEJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3618, 296, '尙州市', 'Sangju', 'SJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3619, 296, '蔚珍郡', 'Uljin County', 'UJN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3620, 296, '闻庆市', 'Mungyeong', 'MGG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3621, 296, '星州郡', 'Seongju County', 'SEJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3622, 296, '义城郡', 'Uiseong County', 'USG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3623, 296, '英阳郡', 'Yeongyang County', 'YYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3624, 296, '盈德郡', 'Yeongdeok County', 'YDK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3625, 296, '永川市', 'Yeongcheon', 'YCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3626, 296, '郁陵郡', 'Ulleung County', 'ULG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3627, 297, '昌宁郡', 'Changnyeong County', 'CNG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3628, 297, '昌原市', 'Changwon', 'CHW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3629, 297, '固城郡', 'Goseong County', 'GSO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3630, 297, '河东郡', 'Hadong County', 'HDG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3631, 297, '金海市', 'Gimhae', 'KMH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3632, 297, '晋州市', 'Jinju', 'HIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3633, 297, '居昌郡', 'Geochang County', 'GCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3634, 297, '巨济市', 'Geoje', 'KJE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3635, 297, '梁山市', 'Yangsan', 'YSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3636, 297, '马山市', 'Masan', 'MAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3637, 297, '密阳市', 'Miryang', 'MIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3638, 297, '南海郡', 'Namhae County', 'NHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3639, 297, '山淸郡', 'Sancheong County', 'SCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3640, 297, '泗川市', 'Sacheon', 'SAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3641, 297, '统营市', 'Tongyeong', 'TYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3642, 297, '陜川郡', 'Hapcheon County', 'HCE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3643, 297, '咸安郡', 'Haman County', 'HAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3644, 297, '咸阳郡', 'Hamyang County', 'HYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3645, 297, '宜宁郡', 'Uiryeong County', 'URG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3646, 297, '鎭海市', 'Jinhae', 'CHF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3647, 298, '淳昌郡', 'Sunchang County', 'SCG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3648, 298, '扶安郡', 'Buan County', 'PUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3649, 298, '高敞郡', 'Gochang County', 'GCG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3650, 298, '金堤市', 'Gimje', 'GJE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3651, 298, '井邑市', 'Jeongeup', 'JEO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3652, 298, '茂朱郡', 'Muju County', 'MJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3653, 298, '南原市', 'Namwon', 'NWN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3654, 298, '全州市', 'Jeonju', 'JNJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3655, 298, '群山市', 'Gunsan', 'KUV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3656, 298, '任实郡', 'Imsil County', 'ISL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3657, 298, '完州郡', 'Wanju County', 'WAJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3658, 298, '益山市', 'Iksan', 'IKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3659, 298, '长水郡', 'Jangsu County', 'JSU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3660, 298, '鎭安郡', 'Jinan County', 'JAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3661, 299, '宝城郡', 'Boseong County', 'BSG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3662, 299, '高兴郡', 'Goheung County', 'GHG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3663, 299, '谷城郡', 'Gokseong County', 'GSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3664, 299, '莞岛郡', 'Wando County', 'WND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3665, 299, '光阳市', 'Gwangyang', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3666, 299, '海南郡', 'Haenam County', 'HAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3667, 299, '和顺郡', 'Hwasun County', 'HSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3668, 299, '康津郡', 'Gangjin County', 'GJN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3669, 299, '丽水市', 'Yeosu', 'YOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3670, 299, '灵光郡', 'Yeonggwang County', 'YGG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3671, 299, '灵岩郡', 'Yeongam County', 'YAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3672, 299, '罗州市', 'Naju', 'NJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3673, 299, '木浦市', 'Mokpo', 'MOK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3674, 299, '求礼郡', 'Gurye County', 'GRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3675, 299, '顺天市', 'Suncheon', 'SYS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3676, 299, '潭阳郡', 'Damyang County', 'DYA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3677, 299, '务安郡', 'Muan County', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3678, 299, '咸平郡', 'Hampyeong County', 'HPG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3679, 299, '新安郡', 'Sinan County', 'SAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3680, 299, '长城郡', 'Jangseong County', 'JSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3681, 299, '长兴郡', 'Jangheung County', 'JHG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3682, 299, '珍岛郡', 'Jindo County', 'JDO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3683, 303, '报恩郡', 'Boeun County', 'BEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3684, 303, '曾坪郡', 'Jeungpyeong County', 'JYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3685, 303, '丹阳郡', 'Danyang County', 'DYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3686, 303, '堤川市', 'Jecheon', 'JCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3687, 303, '槐山郡', 'Goesan County', 'GSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3688, 303, '淸原郡', 'Cheongwon County', 'CWO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3689, 303, '淸州市', 'Cheongju', 'CJJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3690, 303, '沃川郡', 'Okcheon County', 'OCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3691, 303, '阴城郡', 'Eumseong County', 'ESG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3692, 303, '永同郡', 'Yeongdong County', 'YDG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3693, 303, '鎭川郡', 'Jincheon County', 'JCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3694, 303, '忠州市', 'Chungju', 'CHU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3695, 304, '保宁市', 'Boryeong', 'BOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3696, 304, '扶余郡', 'Buyeo County', 'BYO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3697, 304, '公州市', 'Gongju', 'GOJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3698, 304, '洪城郡', 'Hongseong County', 'HSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3699, 304, '鸡龙市', 'Gyeryong', 'GYE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3700, 304, '锦山郡', 'Geumsan County', 'GSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3701, 304, '礼山郡', 'Yesan County', 'YOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3702, 304, '论山市', 'Nonsan', 'NSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3703, 304, '青阳郡', 'Cheongyang County', 'CYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3704, 304, '瑞山市', 'Seosan', 'SSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3705, 304, '舒川郡', 'Seocheon County', 'SCE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3706, 304, '泰安郡', 'Taean County', 'TAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3707, 304, '唐津郡', 'Dangjin County', 'TJI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3708, 304, '天安市', 'Cheonan', 'CHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3709, 304, '牙山市', 'Asan', 'ASA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3710, 304, '燕岐郡', 'Yeongi County', 'YGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3711, 305, '北海', 'Butterworth', 'BWH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3712, 305, '槟城', 'George Town', 'PEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3713, 305, '大山脚', 'Bukit Mertajam', 'BMJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3714, 305, '高渊', 'Nibong Tebal', 'NTE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3715, 306, '加央', 'Kangar', 'KGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3716, 307, '甘马挽', 'Kemaman', 'KEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3717, 307, '瓜拉丁加奴', 'Kuala Terengganu', 'TGG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3718, 307, '龙运', 'Dungun', 'DGN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3719, 307, '马江', 'Marang', 'MAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3720, 307, '实兆', 'Setiu', 'SET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3721, 307, '乌鲁', 'Hulu', 'HUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3722, 307, '勿述', 'Besut', 'BES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3723, 308, '巴东得腊', 'Padang Terap', 'PGT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3724, 308, '笨筒', 'Pendang', 'PEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3725, 308, '浮罗交怡', 'Langkawi', 'LGK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3726, 308, '哥打士打', 'Kota Setar', 'KOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3727, 308, '古邦巴素', 'Kubang Pasu', 'KPA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3728, 308, '瓜拉姆达', 'Kuala Muda', 'KMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3729, 308, '华玲', 'Baling', 'BLZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3730, 308, '居林', 'Kulim', 'KLM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3731, 308, '万拉峇鲁', 'Bandar Baharu', 'BMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3732, 309, '巴西富地', 'Pasir Putih', 'PPU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3733, 309, '巴西马', 'Pasir Mas', 'PMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3734, 309, '丹那美拉', 'Tanah Merah', 'TMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3735, 309, '道北', 'Tumpat', 'TUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3736, 309, '登卓', 'Bachok', 'BAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3737, 309, '哥打巴鲁', 'Kota Bharu', 'KBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3738, 309, '瓜拉吉赖', 'Kuala Krai', 'KUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3739, 309, '话望生', 'Gua Musang', 'GMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3740, 309, '马樟', 'Machang', 'MAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3741, 309, '日里', 'Jeli', 'JEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3742, 310, '吉隆坡', 'Kuala Lumpur', 'KUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3743, 311, '马六甲市', 'Melaka', 'MEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3744, 311, '亚罗牙也', 'Alor Gajah', 'AOG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3745, 311, '野新', 'Jasin', 'JAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3746, 312, '纳闽', 'Labuan', 'LBU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3747, 312, '维多利亚', 'Victoria', 'VIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3748, 313, '百乐', 'Bera', 'BER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3749, 313, '北根', 'Pekan', 'PEK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3750, 313, '淡马鲁', 'Temerloh', 'TEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3751, 313, '而连突', 'Jerantut', 'JER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3752, 313, '关丹', 'Kuantan', 'KUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3753, 313, '金马仑高原', 'Cameron Highlands', 'CAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3754, 313, '劳勿', 'Raub', 'RAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3755, 313, '立卑', 'Kuala Lipis', 'KUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3756, 313, '马兰', 'Maran', 'MAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3757, 313, '文冬', 'Bentong', 'BEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3758, 313, '云冰', 'Rompin', 'TOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3759, 314, '安顺', 'Teluk Intan', 'TAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3760, 314, '丹绒马', 'Tanjung Malim', 'TAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3761, 314, '和丰', 'Sungai Siput', 'SSP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3762, 314, '紅土坎', 'Lumut', 'LUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3763, 314, '华都牙也', 'Batu Gajah', 'BGA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3764, 314, '江沙', 'Kuala Kangsar', 'KAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3765, 314, '太平', 'Taiping', 'TPG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3766, 314, '怡保', 'Ipoh', 'IPH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3767, 315, '笨珍', 'Pontian', 'POW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3768, 315, '丰盛港', 'Mersing', 'MEP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3769, 315, '哥打丁宜', 'Kota Tinggi', 'KTI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3770, 315, '居銮', 'Kluang', 'KLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3771, 315, '峇株巴辖', 'Batu Pahat', 'BAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3772, 315, '麻坡', 'Muar', 'MUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3773, 315, '昔加末', 'Segamat', 'SGM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3774, 315, '新山', 'Johor Bahru', 'JHB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3775, 316, '波德申', 'Port Dickson', 'PDI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3776, 316, '淡边', 'Tampin', 'TAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3777, 316, '芙蓉', 'Seremban', 'SRB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3778, 316, '瓜拉庇劳', 'Kuala Pilah', 'KPI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3779, 316, '林茂', 'Rembau', 'REM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3780, 316, '仁保', 'Jempol', 'JEP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3781, 316, '日叻务', 'Jelebu', 'JEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3782, 317, '吧巴', 'Papar', 'PAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3783, 317, '保佛', 'Beaufort', 'BEF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3784, 317, '比鲁兰', 'Beluran', 'BEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3785, 317, '必达士', 'Pitas', 'PIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3786, 317, '兵南邦', 'Penampang', 'PMP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3787, 317, '担布南', 'Tambunan', 'TAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3788, 317, '丹南', 'Tenom', 'TEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3789, 317, '斗湖', 'Tawau', 'TAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3790, 317, '斗亚兰', 'Tuaran', 'TUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3791, 317, '哥打基纳巴鲁', 'Kota Kinabalu', 'BKI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3792, 317, '哥打马鲁都', 'Kota Marudu', 'KMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3793, 317, '根地咬', 'Keningau', 'KEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3794, 317, '古达', 'Kudat', 'KUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3795, 317, '古打毛律', 'Kota Belud', 'KBD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3796, 317, '古纳', 'Kunak', 'KUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3797, 317, '瓜拉班尤', 'Kuala Penyu', 'KPU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3798, 317, '京那巴登岸', 'Kinabatangan', 'KBT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(3799, 317, '兰脑', 'Ranau', 'RNU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3800, 317, '拿笃', 'Lahad Datu', 'LDU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3801, 317, '纳巴湾', 'Nabawan', 'NAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3802, 317, '山打根', 'Sandakan', 'SDK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3803, 317, '西比陶', 'Sipitang', 'SPT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3804, 317, '仙本那', 'Semporna', 'SMM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3805, 318, '古晋', 'Kuching', 'KCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3806, 318, '加帛', 'Kapit', 'KPI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3807, 318, '林梦', 'Limbang', 'LMN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3808, 318, '美里', 'Miri', 'MYY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3809, 318, '民都鲁', 'Bintulu', 'BTU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3810, 318, '木胶', 'Mukah', 'MKM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3811, 318, '木中', 'Betong', 'BTG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3812, 318, '三马拉汉', 'Samarahan', 'SMH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3813, 318, '斯里阿曼', 'Sri Aman', 'SAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3814, 318, '泗里街', 'Sarikei', 'SAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3815, 318, '泗务', 'Sibu', 'SBW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3816, 319, '八打灵', 'Petaling', 'PJA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3817, 319, '鹅麦', 'Gombak', 'GOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3818, 319, '瓜拉冷岳', 'Kuala Langat', 'KLG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3819, 319, '瓜拉雪兰莪', 'Kuala Selangor', 'KSL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3820, 319, '沙白安南', 'Sabak Bernam', 'SBM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3821, 319, '乌鲁冷岳', 'Hulu Langat', 'HUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3822, 319, '乌鲁雪兰莪', 'Hulu Selangor', 'HUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3823, 319, '雪邦', 'Sepang', 'SEP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3824, 320, '费耶特维尔', 'Fayetteville', 'FYV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3825, 320, '史密斯堡', 'Fort Smith', 'FSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3826, 320, '小石城', 'Little Rock', 'LIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3827, 321, '伯明罕', 'Birmingham', 'BHM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3828, 321, '蒙哥马利', 'Montgomery', 'MGM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3829, 321, '莫比尔', 'Mobile', 'MOB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3830, 322, '安克雷奇', 'Anchorage', 'ANC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3831, 322, '费尔班克斯', 'Fairbanks', 'FAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3832, 322, '朱诺', 'Juneau', 'JNU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3833, 323, '爱达荷福尔斯', 'Idaho Falls', 'IDA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3834, 323, '波卡特洛', 'Pocatello', 'PIH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3835, 323, '博伊西', 'Boise', 'BOI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3836, 323, '布莱克富特', 'Blackfoot', 'BLK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3837, 323, '科达伦', 'Coeur d''Alene', 'COE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3838, 323, '刘易斯顿', 'Lewiston', 'LWS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3839, 323, '莫斯科', 'Moscow', 'MJL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3840, 323, '墨菲', 'Murphy', 'ZMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3841, 323, '楠帕', 'Nampa', 'NPA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3842, 323, '岂彻姆', 'Ketchum', 'QKM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3843, 323, '森瓦利', 'Sun Valley', 'SVY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3844, 323, '亚美利加瀑布城', 'American Falls', 'YAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3845, 324, '达文波特', 'Davenport', 'DVN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3846, 324, '得梅因', 'Des Moines', 'DSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3847, 324, '锡达拉皮兹', 'Cedar Rapids', 'CID', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3848, 325, '俾斯麦', 'Bismarck', 'BIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3849, 325, '大福克斯', 'Grand Forks', 'GFK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3850, 325, '法戈', 'Fargo', 'FAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3851, 325, '迈诺特', 'Minot', 'MOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3852, 326, '艾许维尔', 'Asheville', 'AEV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3853, 326, '杜罕', 'Durham', 'DHH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3854, 326, '格林斯伯勒', 'Greensboro', 'GBO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3855, 326, '教堂山', 'Chapel Hill', 'CHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3856, 326, '罗利', 'Raleigh', 'RAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3857, 326, '洛利杜罕都会区', 'Raleigh-Durham', 'RDU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3858, 326, '夏洛特', 'Charlotte', 'CRQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3859, 327, '阿伦敦', 'Allentown', 'AEW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3860, 327, '费城', 'Philadephia', 'PHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3861, 327, '匹兹堡', 'Pittsburgh', 'PIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3862, 328, '埃尔帕索', 'El Paso', 'ELP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3863, 328, '奥斯汀', 'Austin', 'AUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3864, 328, '达拉斯', 'Dallas', 'DAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3865, 328, '哥帕斯基斯蒂', 'Corpus Christi', 'CRP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3866, 328, '交维斯顿', 'Galveston', 'GLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3867, 328, '拉雷多', 'Laredo', 'LRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3868, 328, '麦亚伦', 'McAllen', 'TXC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3869, 328, '圣安东尼奥', 'San Antonio', 'SAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3870, 328, '休斯敦', 'Houston', 'HOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3871, 329, '代顿', 'Dayton', 'DYT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3872, 329, '哥伦布', 'Columbus', 'CZX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3873, 329, '克利夫兰', 'Cleveland', 'CLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3874, 329, '托莱多', 'Toledo', 'TOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3875, 329, '辛辛那提', 'Cincinnati', 'CVG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3876, 330, '俄克拉荷马城', 'Oklahoma City', 'OKC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3877, 330, '诺曼', 'Norman', 'OUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3878, 330, '塔尔萨', 'Tulsa', 'TUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3879, 331, '本德', 'Bend', 'BZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3880, 331, '波特兰', 'Portland', 'PDX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3881, 331, '达尔斯', 'The Dalles', 'DLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3882, 331, '达拉斯', 'Dallas', 'DAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3883, 331, '蒂拉穆克', 'Tillamook', 'TLM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3884, 331, '格兰茨帕斯', 'Grant''s Pass', 'XFX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3885, 331, '胡德里弗', 'Hood River', 'HDX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3886, 331, '火山口湖', 'Crater Lake', 'CTR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3887, 331, '科瓦利斯', 'Corvallis', 'YCV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3888, 331, '库斯贝', 'Coos Bay', 'COB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3889, 331, '梅德福', 'Medford', 'MFR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3890, 331, '塞勒姆', 'Salem', 'SLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3891, 331, '圣海伦斯', 'St Helens', 'STH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3892, 331, '斯普林菲尔德', 'Springfield', 'SPY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3893, 331, '尤金', 'Eugene', 'EUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3894, 332, '奥兰多', 'Orlando', 'ORL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3895, 332, '基韦斯特', 'Key West', 'EYW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3896, 332, '杰克逊维尔', 'Jacksonville', 'JAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3897, 332, '卡纳维尔角', 'Cape Canaveral', 'CPV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3898, 332, '罗德岱堡', 'Fort Lauderdale', 'FLL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3899, 332, '迈阿密', 'Miami', 'MIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3900, 332, '圣彼德斯堡市', 'St. Petersburg', 'PIE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3901, 332, '塔拉哈西', 'Tallahassee', 'TLH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3902, 332, '坦帕', 'Tampa', 'TPA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3903, 333, '伯灵顿', 'Burlington', 'BTV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3904, 333, '拉特兰', 'Rutland', 'RUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3905, 333, '南伯灵顿', 'South Burlington', 'ZBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3906, 334, '华盛顿哥伦比亚特区', 'Washington D.C.', 'WAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3907, 335, '斯波坎', 'Spokane', 'GEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3908, 335, '塔科马', 'Tacoma', 'TTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3909, 335, '西雅图', 'Seattle', 'SEA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3910, 336, '埃文斯顿', 'Evanston', 'EVD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3911, 336, '卡斯珀', 'Casper', 'CPR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3912, 336, '拉勒米', 'Laramie', 'LAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3913, 336, '罗克斯普林斯', 'Rock Springs', 'RKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3914, 336, '夏延', 'Cheyenne', 'CYS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3915, 336, '谢里登', 'Sheridan', 'SHR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3916, 337, '旧金山', 'San Francisco', 'SFO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3917, 337, '洛杉矶', 'Los Angeles', 'LAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3918, 337, '圣迭戈', 'San Diego', 'SAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3919, 337, '圣何塞', 'San Jose', 'SJC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3920, 338, '阿比林', 'Abilene', 'ABZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3921, 338, '奥弗兰公园', 'Overland Park', 'OVL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3922, 338, '哈钦森', 'Hutchinson', 'HCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3923, 338, '堪萨斯城', 'Kansas City', 'KCK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3924, 338, '莱文沃思', 'Leavenworth', 'XIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3925, 338, '劳伦斯', 'Lawrence', 'LWC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3926, 338, '曼哈顿', 'Manhattan', 'MHK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3927, 338, '托皮卡', 'Topeka', 'TOP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3928, 338, '威奇托', 'Wichita', 'ICT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3929, 339, '布里奇波特', 'Bridgeport', 'BDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3930, 339, '达里恩', 'Darien', 'DAQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3931, 339, '格林尼治', 'Greenwich', 'GRH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3932, 339, '哈特福德', 'Hartford', 'HFD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3933, 339, '米德尔顿', 'Middletown', 'XIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3934, 339, '纽黑文', 'New Haven', 'HVN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3935, 339, '韦斯特波特', 'Westport', 'WPT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3936, 339, '沃特伯里', 'Waterbury', 'WAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3937, 339, '新不列颠', 'New Britain', 'NWT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3938, 340, '阿斯彭', 'Aspen', 'ASE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3939, 340, '奥罗拉', 'Aurora', 'AUX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3940, 340, '博尔德', 'Boulder', 'WBU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3941, 340, '大章克申', 'Grand Junction', 'GJT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3942, 340, '丹佛', 'Denver', 'DEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3943, 340, '柯林斯堡', 'Fort Collins', 'FNL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3944, 340, '科罗拉多斯普林斯', 'Colorado Springs', 'COS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3945, 340, '韦尔', 'Vail', 'VAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3946, 341, '列克星敦', 'Lexington', 'LEX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3947, 341, '路易斯维尔', 'Louisville', 'LUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3948, 341, '欧文斯伯勒', 'Owensboro', 'OWB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3949, 342, '巴吞鲁日', 'Baton Rouge', 'BTR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3950, 342, '什里夫波特', 'Shreveport', 'SHV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3951, 342, '新奥尔良', 'New Orleans', 'MSY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3952, 343, '波塔基特', 'Pawtucket', 'PAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3953, 343, '克兰斯顿', 'Cranston', 'CQH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3954, 343, '纽波特', 'Newport', 'NPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3955, 343, '普罗维登斯', 'Providence', 'PVD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3956, 343, '韦斯特利', 'Westerly', 'WST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3957, 343, '文索基特', 'Woonsocket', 'SFN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3958, 343, '沃威克', 'Warwick', 'UZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3959, 344, '巴尔的摩', 'Balitmore', 'BAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3960, 344, '盖瑟斯堡', 'Gaithersburg', 'GAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3961, 344, '罗克维尔', 'Rockville', 'RKV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3962, 345, '波士顿', 'Boston', 'BZD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3963, 345, '斯普林菲尔德', 'Springfield', 'SFY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3964, 345, '伍斯特', 'Worcester', 'ORH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3965, 346, '比灵斯', 'Billings', 'BGS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3966, 346, '大瀑布村', 'Great Falls', 'GTF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3967, 346, '米苏拉', 'Missoula', 'MSO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3968, 347, '哥伦比亚', 'Columbia', 'COV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3969, 347, '杰佛逊市', 'Jefferson City', 'JEF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3970, 347, '堪萨斯城', 'Kansas City', 'MKC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3971, 347, '圣路易斯', 'Sanit Louis', 'STL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3972, 347, '斯普林菲尔德', 'Springfield', 'SGF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3973, 348, '比洛克西', 'Biloxi', 'BIX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3974, 348, '格尔夫波特', 'Gulfport', 'GPT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3975, 348, '格林维尔', 'Greenville', 'GLH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3976, 348, '哈蒂斯堡', 'Hattiesburg', 'HBG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3977, 348, '杰克逊', 'Jackson', 'JAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3978, 348, '默里迪恩', 'Meridian', 'MEI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3979, 348, '维克斯堡', 'Vicksburg', 'VKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3980, 349, '安娜堡', 'Ann Arbor', 'ARB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3981, 349, '巴特尔克里克', 'Battle Creek', 'BTL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3982, 349, '贝城', 'Bay City', 'BCY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3983, 349, '大急流城', 'Grand Rapids', 'GRR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3984, 349, '迪尔伯恩', 'Dearborn', 'DEO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3985, 349, '底特律', 'Detroit', 'DET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3986, 349, '弗林特', 'Flint', 'FNT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3987, 349, '怀恩多特', 'Wyandotte', 'WYD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3988, 349, '卡拉马袓', 'Kalamazoo', 'AZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3989, 349, '兰辛', 'Lansing', 'LAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3990, 349, '马斯基根', 'Muskegon', 'MKG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3991, 349, '庞菷亚克', 'Pontiac', 'PTK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3992, 349, '萨吉诺', 'Saginaw', 'SGM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3993, 349, '苏圣玛丽', 'Sault Ste Marie', 'SSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3994, 349, '沃伦', 'Warren', 'WAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3995, 349, '休伦港', 'Port Huron', 'PHN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3996, 350, '班戈', 'Bangor', 'BNQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3997, 350, '波特兰', 'Portland', 'POL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3998, 350, '刘易斯顿', 'Lewiston', 'QLW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3999, 351, '罗切斯特', 'Rochester', 'RST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4000, 351, '明尼阿波利斯', 'Minneapolis', 'MES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4001, 351, '圣保罗', 'Saint Paul', 'STP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4002, 352, '阿伯丁', 'Aberdeen', 'ABK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4003, 352, '拉皮德城', 'Rapid City', 'RAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4004, 352, '苏福尔斯', 'Sioux Falls', 'FSD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4005, 353, '北查尔斯顿', 'North Charleston', 'NTS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4006, 353, '查尔斯顿', 'Charleston', 'CHS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4007, 353, '哥伦比亚', 'Columbia', 'COV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4008, 354, '奥马哈', 'Omaha', 'OMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4009, 354, '贝尔维尤', 'Bellevue', 'XDE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4010, 354, '林肯', 'Lincoln', 'LNK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4011, 355, '埃尔科', 'Elko', 'EKO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4012, 355, '北拉斯维加斯', 'North Las Vegas', 'NVS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4013, 355, '弗吉尼亚城', 'Virginia City', 'VGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4014, 355, '亨德森', 'Henderson', 'HNZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4015, 355, '卡森城', 'Carson City', 'CSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4016, 355, '拉斯维加斯', 'Las Vegas', 'LAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4017, 355, '里诺', 'Reno', 'RNO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4018, 355, '斯帕克斯', 'Sparks', 'SPK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4019, 356, '布法罗', 'Buffalo', 'FFO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4020, 356, '罗切斯特', 'Rochester', 'ROC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4021, 356, '纽约市', 'New York', 'QEE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4022, 357, '多佛', 'Dover', 'DOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4023, 357, '纽瓦克', 'Newark', 'NWK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4024, 357, '威明顿', 'Wilmington', 'ILG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4025, 358, '布利斯托', 'Bristol', 'BSJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4026, 358, '查塔努加', 'Chattanooga', 'CHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4027, 358, '金斯波特', 'Kingsport', 'TRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4028, 358, '孟菲斯', 'Memphis', 'MEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4029, 358, '纳什维尔', 'Nashville', 'BNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4030, 358, '诺克斯维尔', 'Knoxville', 'TYS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4031, 358, '三城区', 'Tri-City Area', 'YTC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4032, 358, '士麦那', 'Smyrna', 'MQY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4033, 358, '斯普林希尔', 'Spring Hill', 'RGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4034, 358, '约翰逊城', 'Johnson City', 'JCY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4035, 359, '阿普尓顿', 'Appleton', 'ATW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4036, 359, '奥什科什', 'Oshkosh', 'OSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4037, 359, '格林贝', 'Green Bay', 'GBK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4038, 359, '基诺沙', 'Kenosha', 'ENW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4039, 359, '拉克罗斯', 'LaCrosse', 'LSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4040, 359, '拉辛', 'Racine', 'RAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4041, 359, '马尼托沃克', 'Manitowoc', 'MTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4042, 359, '迈迪逊', 'Madison', 'QMD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4043, 359, '密尔沃基', 'Milwaukee', 'MKE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4044, 359, '欧克莱尓', 'Eau Claire', 'EAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4045, 359, '沃索', 'Wausau', 'AUW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4046, 359, '希博伊根', 'Sheboygan', 'SBM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4047, 360, '弗吉尼亚比奇', 'Virginia Beach', 'VAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4048, 360, '诺福克', 'Norfolk', 'ORF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4049, 360, '切萨皮克', 'Chesapeake', 'HTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4050, 361, '查尔斯顿', 'Charleston', 'CRW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4051, 361, '亨廷顿', 'Huntington', 'HNU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4052, 361, '帕克斯堡', 'Parkersburg', 'PKB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4053, 362, '凯卢阿', 'Kailua', 'KHH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4054, 362, '檀香山', 'Honolulu', 'HNL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4055, 362, '希洛', 'Hilo', 'ITO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4056, 363, '康科德', 'Concord', 'CON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4057, 363, '曼彻斯特', 'Manchester', 'MHT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4058, 363, '纳舒厄', 'Nashua', 'ASH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4059, 364, '阿尔伯克基', 'Albuquerque', 'ABQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4060, 364, '拉斯克鲁塞斯', 'Las Cruces', 'LRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4061, 364, '罗斯韦尔', 'Roswell', 'ROW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4062, 364, '圣菲', 'Santa Fe', 'SAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4063, 365, '纽瓦克', 'Newark', 'NRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4064, 365, '帕特森', 'Paterson', 'PAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4065, 365, '泽西城', 'Jersey City', 'JEC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4066, 366, '凤凰城', 'Phoenix', 'PHX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4067, 366, '格兰代尔', 'Glendale', 'GDA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4068, 366, '梅萨', 'Mesa', 'MQA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4069, 366, '史卡兹代尔', 'Scottsdale', 'STZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4070, 366, '坦普', 'Tempe', 'TPE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4071, 366, '图森', 'Tucson', 'TUC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4072, 366, '优玛', 'Yuma', 'YUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4073, 367, '奥尔顿', 'Alton', 'ALN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4074, 367, '奥罗拉', 'Aurora', 'AUZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4075, 367, '布卢明顿', 'Bloomington', 'BLO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4076, 367, '丹维尓', 'Danville', 'DVI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4077, 367, '迪卡尔布', 'De Kalb', 'DEK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4078, 367, '迪凯持', 'Decatur', 'DEC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4079, 367, '东圣路易斯', 'East St Louis', 'ESL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4080, 367, '厄巴纳-香槟', 'Champaign-Urbana', 'CMI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4081, 367, '盖尔斯堡', 'Galesburg', 'GSU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4082, 367, '卡本代尔', 'Carbondale', 'MDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4083, 367, '罗克艾兰', 'Rock Island', 'RKI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4084, 367, '罗克福德', 'Rockford', 'RFD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4085, 367, '诺黙尔', 'Normal', 'NOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4086, 367, '皮奥里亚', 'Peoria', 'PLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4087, 367, '森特勒利亚', 'Centralia', 'CRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4088, 367, '斯普林菲尔德', 'Springfield', 'SPI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4089, 367, '沃其根', 'Waukegan', 'UGN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4090, 367, '芝加哥', 'Chicago', 'CHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4091, 368, '埃文斯维尔', 'Evansville', 'EVV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4092, 368, '韦恩堡', 'Fort Wayne', 'FWA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4093, 368, '印第安纳波利斯', 'Indianapolis', 'IND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4094, 369, '奥格登', 'Ogden', 'OGD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4095, 369, '雷登', 'Layton', 'LTJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4096, 369, '欧仁', 'Orem', 'OEU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4097, 369, '帕克城', 'Park City', 'PAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4098, 369, '普罗沃', 'Provo', 'PVU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4099, 369, '圣乔治', 'St.George', 'SGU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4100, 369, '西瓦利城', 'West Valley City', 'WVC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4101, 369, '盐湖城', 'Salt Lake City', 'SLC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4102, 370, '奥古斯塔', 'Augusta', 'AUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4103, 370, '哥伦布', 'Columbus', 'CZX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4104, 370, '梅肯', 'Macon', 'MCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4105, 370, '沙瓦纳', 'Savannah', 'SAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4106, 370, '亚特兰大', 'Atlanta', 'TAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4107, 371, '贝尔法斯特', 'Belfast', 'BFS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4108, 371, '德里', 'Derry', 'DRY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4109, 371, '利斯本', 'Lisburn', 'LSB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4110, 371, '纽里', 'Newry', 'NYM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4111, 372, '阿伯丁', 'Aberdeen', 'ABD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4112, 372, '爱丁堡', 'Edinburgh', 'EDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4113, 372, '丹迪', 'Dundee', 'DND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4114, 372, '格拉斯哥', 'Glasgow', 'GLG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4115, 372, '斯特灵', 'Stirling', 'STG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4116, 372, '因弗内斯', 'Inverness', 'INV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4117, 373, '班戈', 'Bangor', 'BAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4118, 373, '卡迪夫', 'Cardiff', 'CDF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4119, 373, '纽波特', 'Newport', 'NWP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4120, 373, '斯旺西', 'Swansea', 'SWA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4121, 374, '埃克塞特', 'Exeter', 'EXE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4122, 374, '巴斯', 'Bath', 'BAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4123, 374, '彼得伯勒', 'Peterborough', 'PTE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4124, 374, '伯明翰', 'Birmingham', 'BIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4125, 374, '布拉德福德', 'Bradford', 'BRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4126, 374, '布莱顿与赫福', 'Brighton & Hove', 'BNH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4127, 374, '布里斯托尔', 'Bristol', 'BST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4128, 374, '德比', 'Derby', 'DER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4129, 374, '德罕', 'Durham', 'DUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4130, 374, '格洛斯特', 'Gloucester', 'GLO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4131, 374, '赫尔河畔京斯敦', 'Kingston upon Hull', 'KUH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4132, 374, '赫里福德', 'Hereford', 'HAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4133, 374, '剑桥', 'Cambridge', 'CAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4134, 374, '卡莱尔', 'Carlisle', 'CAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4135, 374, '坎特伯雷', 'Canterbury', 'CNG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4136, 374, '考文垂', 'Coventry', 'COV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4137, 374, '兰开斯特', 'Lancaster', 'LAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4138, 374, '里彭', 'Ripon', 'RIP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4139, 374, '利奇菲尔德', 'Lichfield', 'LHF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4140, 374, '利物浦', 'Liverpool', 'LIV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4141, 374, '利茲', 'Leeds', 'LDS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4142, 374, '列斯特', 'Leicester', 'LCE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4143, 374, '林肯', 'Lincoln', 'LCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4144, 374, '伦敦', 'London', 'LND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4145, 374, '曼彻斯特', 'Manchester', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4146, 374, '南安普敦', 'Southampton', 'STH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4147, 374, '牛津', 'Oxford', 'OXF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4148, 374, '纽卡斯尔', 'Newcastle', 'NCL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4149, 374, '诺丁汉', 'Nottingham', 'NGM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4150, 374, '诺里奇', 'Norwich', 'NRW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4151, 374, '朴茨茅斯', 'Portsmouth', 'POR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4152, 374, '普雷斯顿', 'Preston', 'PRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4153, 374, '普利茅斯', 'Plymouth', 'PLY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4154, 374, '奇切斯特', 'Chichester', 'CST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4155, 374, '切斯特', 'Chester', 'CEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4156, 374, '桑德兰', 'Sunderland', 'SUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4157, 374, '圣阿本斯', 'Saint Albans', 'TBL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4158, 374, '索尔斯堡', 'Salisbury', 'SLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4159, 374, '索福特', 'Salford', 'SLF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4160, 374, '特鲁罗', 'Truro', 'TRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4161, 374, '特伦特河畔斯多克', 'Stoke-on-Trent', 'SOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4162, 374, '威尔斯', 'Wells', 'WLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4163, 374, '韦克菲尔德', 'Wakefield', 'WKF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4164, 374, '温彻斯特', 'Winchester', 'WNE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4165, 374, '伍尔弗汉普顿', 'Wolverhampton', 'WOV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4166, 374, '伍斯特', 'Worcester', 'WOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4167, 374, '谢菲尔德', 'Sheffield', 'SHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4168, 374, '伊利', 'Ely', 'ELY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4169, 374, '约克', 'York', 'YOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4171, 0, '中东', 'Middle East', 'AE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4172, 4171, '阿拉伯联合酋长国', 'UAE', 'AE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);


--
-- 表的结构 `qinggan_world_price`
--

DROP TABLE IF EXISTS `qinggan_world_price`;
CREATE TABLE IF NOT EXISTS `qinggan_world_price` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `region_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家ID（地区ID）',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000' COMMENT '价格',
  `vtype` varchar(10) NOT NULL COMMENT '类型，price价格，freight运费，excise消费税，tariff关税',
  PRIMARY KEY (`id`),
  KEY `region_id` (`region_id`,`tid`,`vtype`) USING BTREE
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='针对不同国家实现不同的价格' AUTO_INCREMENT=1 ;