﻿var SFUI =
{
	//后来实用中发现切换显示或隐藏的用处很少,还是直接设置为显示或隐藏比较有用
	show:function(node) {
		if(!node) return;
		var display ;
		//SPAN 之类的行间元素，使用 inline，其它块级元素使用 block
		var nodeName = node.tagName.toLowerCase();
		//alert(nodeName);
		if ('span' == nodeName) {
			display = 'inline';
		}
		else
		{
			display = 'block';
		}

		node.style.display = display ;
	},
	hide:function(node) {
		if(!node) return;
		node.style.display = 'none';
	},
	//后来实用中发现切换显示或隐藏的用处很少,还是直接设置为显示或隐藏比较有用
	showId:function(nodeId) {
		var node = document.getElementById(nodeId);
		this.show(node);
	},
	hideId:function(nodeId) {
		var node = document.getElementById(nodeId);
		this.hide(node);
	},
	//取页面元素相对窗口的绝对位置
	getAbsPoint : function (e)
	{
		var x = e.offsetLeft;
		var y = e.offsetTop;
		while(e = e.offsetParent)
		{
			x += e.offsetLeft;
			y += e.offsetTop;
		}
		return {'x': x, 'y': y};
	},
	//取元素的实际样式
	getRealStyle : function(node)
	{
		var RealStyle;
		if (node.currentStyle)                            /*先试 IE 的 简单API */
		{
			RealStyle = node.currentStyle;
		}
		else if (window.getComputedStyle)              /* 再试 W3C API */
		{
			RealStyle = window.getComputedStyle(node, null);
		}
		return RealStyle;
	},
	//上述 RealStyle 取得的值，有些不是数字，要再转为数值
	getStyleNum:function(value)
	{
		var num = parseInt(value);
		return ( num > 0) ? num : 0;
	},
	oldDocumentHeight:0,
	//取窗口内页面宽
	getWindowWidth:function()
	{
		return window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
	},
	//取窗口内页面高
	getWindowHeight:function()
	{
		return window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
	},
	getDocumentWidth:function() {
		return document.documentElement.scrollWidth || document.body.scrollWidth;
	},
	getDocumentHeight:function() {
		return document.documentElement.scrollHeight || document.body.scrollHeight;
	},
	setInput: function (itemid, val)
	{
		//	alert(itemid);
		var formitem = $id(itemid);
		if(!formitem) return;
		formitem.value = val;
		//如果输入格里有提示文字，就有提示的样式“inputHint”，设定了值
		//formitem.className='';
		//因为有了点击文档任何地主都会隐藏菜单，所以设定值时就不用再额外隐藏菜单了。
		//this.hide(event);
	},
	setA:function(itemid, val)
	{
		//		alert(itemid);
		if(!$id(itemid)) return;
		$id(itemid).innerHTML = val;
	},
	setInputA:function(itemid, val, hint)
	{
		this.setInput(itemid, val);
		this.setA(itemid+'_a', hint);
	},
	templateFetch:function (str, obj)
	{
		var retval = str;
		//其实是顺次对 str 执行正则表达式的替换
		for (i in obj)
		{
			var re = new RegExp('\\{'+i+'\\}', 'g');
			retval = retval.replace(re, obj[i]);
		}
		return retval;
	},
	drag:function(elementToDrag, event, container)
	{
		var startX = event.clientX, startY = event.clientY;
		var container = container || null;
		if(container) container = $id(container);

		var origX = elementToDrag.offsetLeft, origY = elementToDrag.offsetTop;

		var deltaX = startX - origX, deltaY = startY - origY;
		if (document.addEventListener) {  // DOM Level 2 event model
			document.addEventListener("mousemove", moveHandler, true);
			document.addEventListener("mouseup", upHandler, true);
		}
		else if (document.attachEvent) {  // IE 5+ Event Model
			elementToDrag.setCapture( );
			elementToDrag.attachEvent("onmousemove", moveHandler);
			elementToDrag.attachEvent("onmouseup", upHandler);
			// Treat loss of mouse capture as a mouseup event.
			elementToDrag.attachEvent("onlosecapture", upHandler);
		}
		else {  // IE 4 Event Model
			var oldmovehandler = document.onmousemove; // used by upHandler( )
			var olduphandler = document.onmouseup;
			document.onmousemove = moveHandler;
			document.onmouseup = upHandler;
		}

		if (event.stopPropagation) event.stopPropagation( );  // DOM Level 2
		else event.cancelBubble = true;                      // IE

		// Now prevent any default action.
		if (event.preventDefault) event.preventDefault( );   // DOM Level 2
		else event.returnValue = false;                     // IE

		function moveHandler(e) {
			if (!e) e = window.event;  
			var realStyle = SFUI.getRealStyle(elementToDrag);
			var dragWidth = elementToDrag.offsetWidth;
			var dragHeight = elementToDrag.offsetHeight;
			if(container)
			{
				var contWidth = container.offsetWidth;
				var contHeight = container.offsetHeight;
			}
			else
			{
				var contWidth = SFUI.getDocumentWidth();
				var contHeight = SFUI.oldDocumentHeight;
			}
			var leftMin = e.clientX - deltaX;
			var leftMax = contWidth - dragWidth;
			var dragLeft = (leftMin < 0 ) ? 0 : (leftMax < leftMin) ? leftMax : leftMin;

			var topMin = e.clientY - deltaY;
			var topMax = contHeight - dragHeight;

			var dragTop = (topMin < 0 ) ? 0 : (topMax < topMin) ? topMax : topMin;

			elementToDrag.style.left = dragLeft  + "px";
			elementToDrag.style.top = dragTop + "px";

			if (e.stopPropagation) e.stopPropagation( );  // DOM Level 2
			else e.cancelBubble = true;                  // IE
		}
		function upHandler(e) {
			if (!e) e = window.event;  // IE Event Model

			if (document.removeEventListener) {  // DOM event model
				document.removeEventListener("mouseup", upHandler, true);
				document.removeEventListener("mousemove", moveHandler, true);
			}
			else if (document.detachEvent) {  // IE 5+ Event Model
				elementToDrag.detachEvent("onlosecapture", upHandler);
				elementToDrag.detachEvent("onmouseup", upHandler);
				elementToDrag.detachEvent("onmousemove", moveHandler);
				elementToDrag.releaseCapture( );
			}
			else {  
				document.onmouseup = olduphandler;
				document.onmousemove = oldmovehandler;
			}

			if (e.stopPropagation) e.stopPropagation( );  // DOM Level 2
			else e.cancelBubble = true;                  // IE
		}
	},
	clearHint:function(formitem) {
		formitem.className = 'guestbook02';
		if (formitem.value == formitem.defaultValue) {
			formitem.value = '';
		}
	},
	toggleHint:function(formitem) {
		formitem.className = 'guestbook02';
		if ('' == formitem.value) {
			formitem.value = formitem.defaultValue;
			formitem.className = 'guestbook01';
		}
	},
	//同级几个 DIV 中显示当前一个，隐藏其它若干个
	showPeer:function(nodeId)
	{
		var pearThis = $id(nodeId);
		if(!pearThis) return;
		var peers = pearThis.parentNode.childNodes;
		for (var i = 0;i<peers.length;i++)
		{
			if ('div'==peers[i].nodeName.toLowerCase())
			{
				if (peers[i] == pearThis)
				{
					peers[i].style.display = 'block';
				}
				else if(peers[i].className == pearThis.className || peers[i].className == pearThis.className+' noshow'  || peers[i].className+' noshow' == pearThis.className)
				{
					peers[i].style.display = 'none';
				}
			}
		}
	}
};

var SFMapUI = {
	init:function() {
		var me = this;
		//me.menu = new Flyer('SFmenu');
		//me.submenu = new Flyer('SFsubmenu');
		//初始化高度
		SFMapUI.autoResize(false,true);
		//SFMapUI.clearAllOption();
		if (filePath.indexOf('zhuangshi') == -1 && filePath.indexOf('company') == -1)
		{
			me.newPurpose();
			me.newOpenyear('opentimesyear');
			me.newOpenyear('opentimeeyear');
			me.newOpenmonth('opentimesmonth');
			me.newOpenmonth('opentimeemonth');
			me.newSort();
		}
		me.newDistrict();
		//if($id('area').value || $id('district').value) $id('district_a').innerHTML = searchcondition.area || searchcondition.district;

		SFUtil.eventAdd(window, 'resize', function()
		{
			SFMapUI.autoResize();
		});

		//注册点击文档任何地方关闭菜单
		SFUtil.eventAdd(document, 'click', function(e)
		{
			var e = e || window.event;
			var eventSource = e.target || e.srcElement;
			var expt = $id('panel_moreoptions');
			var expt1 = $id('panel_keyword');
			if(expt1 && !SFUtil.containNode(expt1, eventSource) && !SFUtil.containNode($id('showsuggest'), eventSource) && !SFUtil.containNode($id('keyword'), eventSource)) expt1.style.display = 'none';
			if(!expt || SFUtil.containNode(expt, eventSource)) return;
			var yearMonth = ['panel_opentimesyear_a', 'panel_opentimeeyear_a', 'panel_opentimesmonth_a', 'panel_opentimeemonth_a'];
			for(var i=0; i<yearMonth.length; i++)
			{
				var ele = $id(yearMonth[i]);
				if(!ele) continue;
				else if(SFUtil.containNode(ele, eventSource)) return;
				else ele.style.display = 'none';
			}
			expt.style.display = 'none';
		});
		//悬停出菜单后关闭菜单，一个思路是给文档加 mouseover 事件，把发起菜单的元素 ID 记住，看鼠标 mouseover 的节点是否在菜单体 ID 里，在时维持，不在关闭。

		//由于拖层层时，文档高度会不断变大，在初始化时把文档原高度存在 SFUI 属性里
		SFUI.oldDocumentHeight = SFUI.getDocumentHeight();

		//没有商圈、环线、轨道时，把相应菜单隐藏掉
		//即使城市没有商圈，也有 Area 空数组
		/*if (!Area || 0 == Area.length) {
			SFUI.hideId('area_a');
		}*/
		//没有轨道和环线时，则根本没有这 2 个变量，所以要用 typeof 判断
		if ('undefined'==typeof(Railways) || filePath.indexOf('zhuangshi') > -1) {
			SFUI.hideId('subway_a');
		} else {
			me.config.leveledMenu.subway = {
				id:'subway',
				subId:'subwaystation',
				data:Railways,
				subData:railway_station,
				defaultVal:'价格不限',
				title:'选择价格'
			};
			me.newSubway();
			//if(searchcondition.subway) SFUI.setA('subway_a',searchcondition.subway);
		}

		if ('undefined'==typeof(mapcityround) || ''==mapcityround || filePath.indexOf('zhuangshi') > -1 || filePath.indexOf('company') > -1) {
			SFUI.hideId('round_a');
		} else {
			me.config.menu.round = {
				id:'round',
				data:mapcityround,
				defaultVal:'价格不限',
				title:'选择价格'
			};
			me.newRound();
			//if(searchcondition.round) SFUI.setA('round_a',searchcondition.round);
		}
	},
	newPurpose:function(purpose) {
		//alert('newPurpose');
		var itemTarget = document.getElementById('purposes_a');
		if(!itemTarget) return;
		//var purpose = purpose || '';
		if(!purpose && SFMap.firstLoad && searchcondition.purpose && $id('purposes').value)
		{
			currentPurpose = $id('purposes').value;
		}
		else
		{
			var currentPurpose = purpose || '不限,-1';
			$id('purposes').value = currentPurpose;
		}
		str = '类型：';
		if('' == currentPurpose || currentPurpose.indexOf('不限') == 0)
		{
			str += '<a  href="javascript:;" class="a">不限</a>  ';
		}
		else
		{
			str += '<a href="javascript:;" onclick="SFMapUI.newPurpose(\'不限,-1\');SFMap.autoView=true;SFMap.searchResult();return false;">不限</a>  ';
		}
		if(filePath.indexOf("company")==-1)
		{
			for(var i=0; i<Purposes.length; i++)
			{
				var itemThis = Purposes[i];
				if(currentPurpose.indexOf(itemThis.name) == 0)
				{
					str += '<a class="a" href="javascript:;">'+itemThis.name+'</a>  ';
				}
				else
				{
					str += '<a href="javascript:;" onclick="SFMapUI.newPurpose(\''+itemThis.name+','+itemThis.value+'\');SFMap.autoView=true;SFMap.searchResult();return false;">'+itemThis.name+'</a>  ';
				}
			}
			itemTarget.innerHTML = str;
			this.newPrice('');
		}
	},
	newPrice:function(price) {
		
	},
	 
	newOpenyear:function(id) {
		var p = $id('panel_moreoptions');
		if(!p) return;
		var panel = document.createElement('div');
		panel.id = 'panel_'+id+'_a';
		panel.className = 'paneltable';
		panel.style.width = '39px';

		var myDate = new Date();
		var yearStart = myDate.getFullYear();
		for(var i=0; i<8; i++)
		{
			var a = document.createElement('a');
			a.innerHTML = yearStart-i;
			a.onclick = function(){
				SFUI.setInputA(id,this.innerHTML,this.innerHTML);
				panel.style.display = 'none';
				p.style.display = 'block';
			};
			a.onmouseover = function(){this.id = 'hover';};
			a.onmouseout = function(){this.id = '';};
			panel.appendChild(a);
		}
		document.body.appendChild(panel);
	},
	newOpenmonth:function(id) {
		var p = $id('panel_moreoptions');
		if(!p) return;
		var panel = document.createElement('div');
		panel.id = 'panel_'+id+'_a';
		panel.className = 'paneltable';
		panel.style.width = '39px';

		for(var i=1; i<13; i++)
		{
			var a = document.createElement('a');
			a.innerHTML = (i<10) ? '0'+i : i;
			a.onclick = function(){
				SFUI.setInputA(id,this.innerHTML,this.innerHTML);
				panel.style.display = 'none';
				//p.style.display = 'block';
			};
			a.onmouseover = function(){this.id = 'hover';};
			a.onmouseout = function(){this.id = '';};
			panel.appendChild(a);
		}
		document.body.appendChild(panel);
	},
	clearOpentime:function() {
		var me = this;
		me.resetOpentime();
		//SFMap.searchResult();
	},
	resetOpentime:function() {
		SFUI.setInputA('opentimesyear','','');
		SFUI.setInputA('opentimesmonth','','');
		SFUI.setInputA('opentimeeyear','','');
		SFUI.setInputA('opentimeemonth','','');
		SFUI.setInput('opentime','');
		SFUI.setA('opentimetitle_a','开盘时间');
	},
	clearAllOption:function()
	{
		var me = this;
		var inputA = [{id:'district', hint:'选择区域'},{id:'area', hint:''}, {id:'round', hint:'选择环线'}, {id:'subway', hint:'选择价格'}];
		for(var i=0; i<inputA.length; i++)
		{
			var itemThis = inputA[i];
			SFUI.setInputA(itemThis.id, '',itemThis.hint);
		}
		me.resetOpentime();
		me.newPurpose();
	},
	//取得某年某月的最后一天
	getLastdayofMonth:function(year, month)
	{
		if(!year || !month) return;
		var day30 = ['04', '06', '09', '11'];
		if('02' == month)
		{
			if(0 == year % 4 && ((0 != year % 100) && (0 == year % 400)))
			{
				return '29';
			}
			else
			{
				return '28';
			}
		}
		for(var i=0; i<day30.length; i++)
		{
			if(month == day30[i]) return '30';
		}
		return '31';
	},
	searchOpentime:function(event) {
		var syear = $id('opentimesyear').value;
		var smonth = $id('opentimesmonth').value;
		var eyear = $id('opentimeeyear').value;
		var emonth = $id('opentimeemonth').value;

		var titlestr = "";

		var searchdate = "[";

		if(smonth != "" && syear == "")
		{
			alert("请选择开始年份");
			return false;
		}
		if(emonth != "" && eyear== "")
		{
			alert("请选择结束年份");
			return false;
		}
		if(syear >= eyear)
		{
			if(((parseInt(syear+smonth) > parseInt(eyear+emonth)) && (parseInt(eyear+emonth) != 0)))
			{
				alert("结束时间必须大于开始时间");
				return false;
			}
		}

		if(smonth != "")
		{

			titlestr += syear+"."+smonth.substring(0,2);
			searchdate += syear+smonth+"01";
		}
		else
		{
			if(syear != "")
			{
				titlestr += syear;
				searchdate += syear+"0101";
			}
			else
			{
				searchdate += "";
			}
		}
		searchdate += ",";
		titlestr += "-";

		if(emonth != "")
		{
			titlestr += eyear+"."+emonth.substring(0,2);
			searchdate += eyear+emonth+this.getLastdayofMonth(eyear,emonth);
		}
		else
		{
			if(eyear != "")
			{
				titlestr += eyear;
				searchdate += eyear+"1231";
			}
			else
			{
				searchdate += "";
			}
		}
		searchdate += "]";

		//this.hideFlyer(event, this.menu);
		SFUI.setInput('opentime',searchdate);
		if("-" != titlestr) SFUI.setA('opentimetitle_a',titlestr);
		//alert(searchdate);
		SFMap.searchResult();
	},
	newDistrict:function() {
		this.newLeveledMenu('district');
	},
	newSubway:function() {
		this.newLeveledMenu('subway');
	},
	newRound:function() {
		this.newMenu('round');
	},
	config:
	{
		leveledMenu: {
			district: {
				id:'district',
				subId:'area',
				data:Districts,
				subData:Area,
				defaultVal:'区域不限',
				title:'选择区域'
			}
		},
		menu: {
		}
	},
	clearOtherOpts:function(id)
	{
		var inputA = [{id:'district', hint:'选择区域'},{id:'area', hint:''}, {id:'round', hint:'选择环线'}, {id:'subway', hint:'选择价格'}];
		for(var i=0; i<inputA.length; i++)
		{
			var itemThis = inputA[i];
			if(id == itemThis.id || ('district' == id && 'area' == itemThis.id)) continue;
			SFUI.setInputA(itemThis.id, '',itemThis.hint);
		}
	},
	newMenu:function(mType, mWidth)
	{
		var me = this;
		var mWidth = mWidth || 92;
		if('undefined' == typeof me.config.menu[mType]) return;
		var menuData = me.config.menu[mType];

		//menu的外框样式，默认为不显示
		var panel = document.createElement('div');
		var sourceItem = $id(menuData.id+'_a');
		if(!sourceItem) return;
		var pos = SFUI.getAbsPoint(sourceItem);
		panel.id = 'panel_'+menuData.id+'_a';
		panel.className = 'paneltable';
		panel.style.top = (pos.y + 12) + 'px';
		panel.style.left = (pos.x - 1) + 'px';
		panel.style.width = mWidth+'px';

		var ddMouseEvent = function(sItem, flg){
			sItem.id = flg ? 'hover' : '';
		};
		var clickEvent = function(sItem) {
			var tagname = sItem.tagName.toLowerCase();
			var val = sItem.innerHTML;
			SFUI.hideId('panel_'+menuData.id+'_a');
			SFMapUI.clearOtherOpts(menuData.id);
			if(val == menuData.defaultVal)
			{
				SFUI.setA(menuData.id+'_a', menuData.title);
				SFUI.setInput(menuData.id, '');
				//SFMap.map.panTo(cityy,cityx);
				//SFMap.map.setZoom(mapsize);
				SFMap.map.setCenter(cityy,cityx,mapsize);
			}
			else
			{
				SFUI.setA(menuData.id+'_a', val);
				SFUI.setInput(menuData.id, val);
				SFMap.map.setViewAuto(true);
			}
			SFMap.searchResult();
		};
		var div = document.createElement('div');
		div.innerHTML = menuData.defaultVal;
		div.onclick = function(){clickEvent(this);};
		div.onmouseover = function(){ddMouseEvent(this,true);};
		div.onmouseout = function(){ddMouseEvent(this,false);};
		panel.appendChild(div);

		if(mType == 'round') {
			var datas = menuData.data.split(',');
		} else {
			var datas = menuData.data;
		}
		
		var dataLen = datas.length;
		for (var i=0; i<dataLen; i++)
		{
			div = document.createElement('div');
			div.innerHTML = datas[i];
			div.onclick = function(){clickEvent(this);};
			div.onmouseover = function(){ddMouseEvent(this,true);};
			div.onmouseout = function(){ddMouseEvent(this,false);};
			panel.appendChild(div);
		}
		panel.onmouseover = function(){this.style.display="block";};
		panel.onmouseout = function(){this.style.display="none";};
		document.body.appendChild(panel);
	},
	newLeveledMenu:function(mType,mWidth)
	{
		var mWidth = mWidth || 92;
		var me = this;
		if('undefined' == typeof me.config.leveledMenu[mType]) return;
		var menuData = me.config.leveledMenu[mType];

		//menu的外框样式，默认为不显示
		var panel = document.createElement('div');
		var sourceItem = $id(menuData.id+'_a');
		if(!sourceItem) return;
		var pos = SFUI.getAbsPoint(sourceItem);
		panel.id = 'panel_'+menuData.id+'_a';
		panel.className = 'paneltable';
		panel.style.width = mWidth+'px';

		//dl是最外层，每个dd是一组分级的menu
		//ol是一级menu，ul是二级menu
		var dl = document.createElement('dl');
		var dd = document.createElement('dd');
		//ol是一级menu，div是内容，本来用一层就足够了，但在IE下文字比较多时出现了小箭头错位的现象，所以分了两层
		var ol = document.createElement('ol');
		var div = document.createElement('div');
		div.innerHTML = menuData.defaultVal;

		var ddMouseEvent = function(sItem, flg){
			var display = 'none';
			var id = '';
			if(flg) {
				display = 'block';
				id = 'hover';
			}
			var childNodes = sItem.childNodes;
			var count = 0;
			var cTagname = '';
			for(var c=0; c<childNodes.length; c++)
			{
				if(count > 1) break;
				cTagname = childNodes[c].tagName.toLowerCase();
				if('ul' == cTagname)
				{
					childNodes[c].style.display = display;
					count += 1;
				}
				else if('ol' == cTagname)
				{
					childNodes[c].id = id;
					count += 1;
				}
			}
		};
		var clickEvent = function(sItem) {
			var tagname = sItem.tagName.toLowerCase();
			var val = sItem.innerHTML;
			SFMapUI.clearOtherOpts(menuData.id);
			SFUI.setA(menuData.id+'_a', val);
			var v1 = '';
			var v2 = '';
			if('div' == tagname)
			{
				SFUI.setInput(menuData.id, val);
				SFUI.setInput(menuData.subId, '');
				v1 = val;
				var childNodes = sItem.parentNode.parentNode.childNodes;
				var cTagname = '';
				for(var c=0; c<childNodes.length; c++)
				{
					cTagname = childNodes[c].tagName.toLowerCase();
					if('ul' == cTagname)
					{
						SFUI.hide(childNodes[c]);
						break;
					}
				}
			}
			else if('li' == tagname)
			{
				SFUI.setInput(menuData.subId, val);
				SFUI.hide(sItem.parentNode);
				v2 = val;
				var childNodes = sItem.parentNode.parentNode.childNodes;
				var cTagname = '';
				for(var c=0; c<childNodes.length; c++)
				{
					cTagname = childNodes[c].tagName.toLowerCase();
					if('ol' == cTagname)
					{
						v1 = childNodes[c].childNodes[0].innerHTML;
						SFUI.setInput(menuData.id, v1);
						break;
					}
				}
			}
			SFUI.hideId('panel_'+menuData.id+'_a');
			if('district' == menuData.id) SFMap.getCenter(v1, v2);
			//if('subway' == menuData.id) SFMap.drawSubWay(true);
		};
		div.onclick = function(){
			SFMapUI.clearOtherOpts(menuData.id);
			SFUI.setA(menuData.id+'_a',menuData.title);
			SFUI.setInput(menuData.id, '');
			SFUI.setInput(menuData.subId, '');
			SFUI.hideId('panel_'+menuData.id+'_a');
			if('district' == menuData.id) SFMap.getCenter('', '');
			//if('subway' == menuData.id) SFMap.drawSubWay(true);
		};
		ol.appendChild(div);
		dd.appendChild(ol);
		dd.onmouseover = function(){ddMouseEvent(this,true);};
		dd.onmouseout = function(){ddMouseEvent(this,false);};
		dl.appendChild(dd);

		var dataLen = menuData.data.length;
		for (var i=0; i<dataLen; i++)
		{
			var itemThis = menuData.data[i];
			dd = document.createElement('dd');
			ol = document.createElement('ol');
			div = document.createElement('div');
			div.innerHTML = (mType == 'subway') ? itemThis.value : itemThis.name;
			div.onclick = function(){clickEvent(this);};
			ol.appendChild(div);
			dd.appendChild(ol);
			var subDataArr = menuData.subData[itemThis.index];
			if(subDataArr)
			{
				var ul = document.createElement('ul');
				var topPx = (i+1)*20;
				ul.style.left = mWidth+'px';
				var subDataLen = subDataArr.length;
				if(subDataLen < 3) ul.style.width = mWidth*subDataLen +'px';
				var submenuLines = Math.ceil(subDataLen/3);
				if(submenuLines+i>dataLen && dataLen+1>submenuLines) topPx = (dataLen-submenuLines+1)*20;
				ul.style.top = (topPx-1)+'px';
				for(var j=0; j<subDataLen; j++)
				{
					ol.className = 'menur';
					var subData = (mType == 'district') ? subDataArr[j].split(',')[1] : subDataArr[j];
					var li = document.createElement('li');
					li.innerHTML = subData;
					li.onmouseover = function(){this.id='hover';};
					li.onmouseout = function(){this.id='';};
					li.onclick = function(){clickEvent(this);};
					ul.appendChild(li);
				}
				dd.appendChild(ul);
			}
			dd.onmouseover = function(){ddMouseEvent(this,true);};
			dd.onmouseout = function(){ddMouseEvent(this,false);};
			dl.appendChild(dd);
		}
		panel.appendChild(dl);
		panel.onmouseover = function(){this.style.display='block';};
		panel.onmouseout = function(){this.style.display='none';};
		document.body.appendChild(panel);
	},
	newSort:function () {
		var option = {
			'':'排序方式',
			'pa':'价格升序',
			'pd':'价格降序'
		};
		var panel = document.createElement('div');
		panel.id = 'panel_sort_a';
		panel.className = 'paneltable';
		panel.style.width = '62px';
		var str = '';
		for(var i in option)
		{
			var a = document.createElement('a');
			a.innerHTML = option[i];
			a.provalue = i;
			a.onclick = function(){
				SFUI.setInputA('sort',this.provalue,this.innerHTML);
				//SFMap.searchResult(0,false,1);
				SFMap.gotosearch();
				return false;
			};
			a.onmouseover = function() {this.id='hover';};
			a.onmouseout = function() {this.id='';};
			panel.appendChild(a);
		}
		panel.onmouseover = function() {this.style.display='block';};
		panel.onmouseout = function() {this.style.display='none';};
		document.body.appendChild(panel);
	},
	showTip:function(content, left, top) {
		var node = $id('maptip');
		content = $id('template_maptip').value;
		node.innerHTML = content;
		node.style.display = 'block';
		node.style.left = left+'px';
		node.style.top = top +'px';
	},
	suggest_selected:0,
	suggest_url: '/public/xml.aspx?action=ShowBuildKeyword',

	/*关键字提示方法
	参数：
	e		DOM 2 标准的事件对象。当函数有多个参数时，这个事件对象必须是全局变量，变更名固定为 event，且从文档最顶层调用函数的地方传递进来，所以得 onkeyup="SearchMenu.suggest(event, this, '/suggest/extend?action=tip&scope=news', {q:this.value});" 这样才能在 FF 里用。
	poper	发起元素
	args	参数值对，每个属性名是参数名，每个值是参数的值，如二手房的用 {city:$('form_2nd').City.value, q:this.value}，会转化成 city=表单form_2nd中City项的值&q=当前格的值
	*/
	newSuggest:function()
	{
		var panel = $id('panel_keyword');
		if(panel) return;
		panel = document.createElement('div');
		panel.id = 'panel_keyword';
		panel.className = 'paneltable';
		var sItem = $id('keyword');
		//alert($id('keyword').offsetWidth);
		panel.style.width = (sItem && sItem.offsetWidth-2>0)? (sItem.offsetWidth-2)+'px' : '285px';
		panel.style.borderTop = 'none';
		panel.innerHTML = '<span>输入中文/拼音/拼音首字母或用上下键选择</span>';
		panel.onmouseover = function(){this.style.display='block';};
		panel.onmouseout = function(){this.style.display='none';};
		document.body.appendChild(panel);
	},
	showSuggest:function()
	{
		var me = this;
		var panel = $id('panel_keyword');
		if(!panel)
		{
			me.newSuggest();
			panel = $id('panel_keyword');
		}
		SFMapUI.showMenu('keyword');
	},
	suggest: function(event, poper)
	{
		if(filePath=="/company/")
			this.suggest_url="/public/xml.aspx?action=ShowCompanyKeyword";
		if(filePath=="/360/")
			this.suggest_url="/public/xml.aspx?action=Show360Keyword";
		
		var event = event || window.event;
		var code = event.keyCode;
		var itemId = poper.id;
		var panel = $id('panel_keyword');
		var me = this;
		////回车，直接搜索
		if(!panel)
		{
			me.newSuggest();
			panel = $id('panel_keyword');
		}
		if(code == 13 || /^\s*$/.test(poper.value))
		{
			panel.style.display='none';
		}
		//按的不是方向键时取关键字提示。方向键是37:"left", 38:"up",	39:"right", 40:"down"
		else if ((code < 37) ||  (code > 40))
		{
			//每次生成新菜单时都把按键选中项的索引复原
			this.suggest_selected = 0;
			var method = 'post';
			//window.open(  this.suggest_url+"&cname="+searchcondition['cityname']+"&q="+escape(poper.value)  )
			var params = {'cname':searchcondition['cityname'], 'q':escape(poper.value), 'random':Math.random()};
			//终于明白了 IE 6 在 AJAX 的回调函数里不再能获取此前的事件，并且通过参数传递也不灵。所以此前设想只传递事件对象，而不再传递发起元素对象，现在看来不灵了，还得把发起元素对象也传递了。
			var onComplete = function(originalRequest) {
				var xmlObj = originalRequest.responseXML;
				var json = SFUtil.xml2json(xmlObj);
				var suggestwords = json.result.msg;
				//有提示数据时再显示菜单
				if (''!=suggestwords) {
					var arrWords = suggestwords.split(',');
					var str = '<span>输入中文/拼音/拼音首字母或用上下键选择</span>';
					panel.innerHTML = str;
					for (var i=0; i<arrWords.length; i++) {
						var a = document.createElement('a');
						a.innerHTML = arrWords[i];
						a.onclick = function(){
							$id(itemId).value = this.innerHTML;
							panel.style.display = 'none';
						}
						a.onmouseover = function(){this.className='suggest_selected';};
						a.onmouseout = function(){this.className='';};
						panel.appendChild(a);
					}
					//panel.onmouseover = function(){this.style.display='block';};
					//panel.onmouseout = function(){this.style.display='none';};
				}
				else{
					var str = '<span>输入中文/拼音/拼音首字母或用上下键选择</span>';
					panel.innerHTML = str;	
				}
				SFMapUI.showMenu('keyword');
				//没有数据时把已显示的菜单关闭掉。这里不能用 me.hideFlyer 或 menu.hide 方法，因为按键的节点还在动作发起节点，不会隐藏菜单，只能直接用 style
				/*else if(panel) {
					panel.style.display='none';
				}*/
			};
			
			var xhr = new SFXHR(this.suggest_url, method, params, onComplete);
		}
		//按的是方向键时控制菜单中选项
		else
		{
			if (panel && 'none'!=panel.style.display)
			{
				var nodes = $id('panel_keyword').childNodes;

				//提示出的关键字节点数，即共有几行
				var suggestNum = nodes.length;
				//关键字提示层的选中行要想能跟随按键变化，选中行数做成当前的局部变量不灵，每次按键都会重新回到局部变量的初始值，也得用个此函数范围外的变量，于是在 SearchWord 对象里再加个属性 suggest_selected 去记录，则选行的操作和城市菜单都一样了。
				if ((38 == code) || (40 == code))
				{
					//向上减行数
					if ((38 == code) && (2 < this.suggest_selected))
					{
						this.suggest_selected--;
					}
					//向下加行数
					if ((40 == code) && (this.suggest_selected < suggestNum))
					{
						this.suggest_selected += (0 == this.suggest_selected) ? 2 : 1;
					}
					//找 suggestsearch 节点内的所有 a 把它们的 class 都清空，把当前选中行的 class 设成 suggest_selected。
					for (i=1; i< suggestNum; i++)
					{
						//行数是从1数起的，而节点数组的是从0数起的
						nodes[i].className = (i == (this.suggest_selected-1)) ? 'suggest_selected':'';
					}
					//焦点在输入格里时，按回车键是肯定要提交表单的，如果人为阻止表单提交，还得另外恢复表单的提交，干脆在选择时直接更新输入格的值
					var itemselected = nodes[this.suggest_selected-1].childNodes;
					//二手房加了数目后，A 里统一多了一层 span，所以再向内找一层子节点
					//itemselected = itemselected[0].childNodes;
					SFUI.setInput('keyword',itemselected[0].data);
				}
			}
		}
	},
	toggleRight:function(flg) {
		//if($id('map_result_main').style.display == 'none')
		if(flg)
		{
			$id('map_result_main').style.display='block';
			$id('map_body_box').style.marginRight = '218px';
			SFUI.hideId('map_result_barimg_open');
			SFUI.showId('map_result_barimg_hide');
		}
		else
		{
			$id('map_result_main').style.display='none';
			$id('map_body_box').style.marginRight = '0px';
			SFUI.hideId('map_result_barimg_hide');
			SFUI.showId('map_result_barimg_open');
		}
		this.autoResize(true);
	},
	//页面高度自适应
	autoResize:function(init,fistload)
	{
		var init = init || false;
		var fistload = fistload || false;
		var MINHEIGHT = 500;	//浏览器允许的最小高度
		//var MINWIDTH = 900;	//浏览器允许的最小宽度
		var TOPHEIGHT = (filePath.indexOf('zhuangshi') > -1 || filePath.indexOf('company') > -1) ? 129 : 113;		//顶部通栏的高度 111 52+8+59(35)+10+24
		if($id('condition_bar') && $id('topmenu'))
		{
			var h = $id('condition_bar').offsetHeight+$id('topmenu').offsetHeight+40;
			TOPHEIGHT = (h > TOPHEIGHT && h < 200) ? h : TOPHEIGHT;
		}
		//var BOTTOMHEIGHT = 25;		//底部信息栏的高度 20
		var BOTTOMHEIGHT = 0;
		//var RESULTHEIGHT = 90;	//结果栏顶部和底部的和
		var FIXHEIGHT = 0;
		var UA = navigator.userAgent.toLowerCase();
		if(UA.indexOf('360se') > -1) FIXHEIGHT += 3;
		else if(UA.indexOf('firefox') > -1) FIXHEIGHT += 1;
		else if(UA.indexOf('msie 6') > -1) FIXHEIGHT += 0;
		else FIXHEIGHT += 2;
		var viewHeight = SFUI.getWindowHeight();
		if(viewHeight < MINHEIGHT){
			viewHeight = MINHEIGHT;
		}
		var contentHeight = viewHeight - TOPHEIGHT  - FIXHEIGHT - BOTTOMHEIGHT;
		var content1minus = contentHeight - 1;
		var obj_heights = {
			map_body_box:contentHeight,
			map_canvas:contentHeight,
			map_result_barimg_hide:content1minus,
			map_result_barimg_open:content1minus,
			listfav:contentHeight - 9,
			//tab_div0:contentHeight - 47,
			map_fav:contentHeight - 201,
			rightmenu1:contentHeight - 9,
			rightmenu2:contentHeight - 9,
			rightmenu4:contentHeight - 9,
			carsteplistmenu:contentHeight - 72
		};
		for (var id in obj_heights)
		{
			var ele = $id(id);
			if(ele)
			{
				ele.style.height = obj_heights[id]+'px';
			}
		}

		//9 20 28 36 resultPage 40 
		if($id('resultlist'))
		{
			var pageHeight = $id('resultpage') ? $id('resultpage').offsetHeight+20 : 40;
			var listHeight = contentHeight - 93 - pageHeight;
			$id('resultlist').style.height = (listHeight > 0) ? listHeight+'px' : '10px';
		}
		//resize的时候要调整驾车和周边框的位置
		var jczbList = ['jczbsearch', 'jczbresult', 'jczbsearchmin', 'jczbresultmin'];
		var container = $id('map_canvas');
		//if(fistload) SFUI.showId('jczbsearch');  delete by 2-24
		for(var i=0; i<jczbList.length; i++)
		{
			var tItem = $id(jczbList[i]);
			var tWidth = (tItem.offsetWidth > 0) ? tItem.offsetWidth : 234;
			var tHeight = tItem.offsetHeight;
			var cWidth = container.offsetWidth;
			var cHeight = container.offsetHeight;
			var isResult = (jczbList[i].indexOf('result') > -1);
			if(!tItem) continue;
			var topPx = tItem.style.top;
			var topNum = (topPx.length > 0) ? parseInt(topPx.substr(0,topPx.indexOf('px'))) : 0;
			var leftPx = tItem.style.left;
			var leftNum = (leftPx.length > 0) ? parseInt(leftPx.substr(0,leftPx.indexOf('px'))) : 0;
			//if(0 == topNum || topNum+tHeight > cHeight || init)
			//{
				try
				{
					tItem.style.top = isResult ? '69px' : '10px';
				}
				catch(e)
				{
					tItem.style.top = isResult ? '69' : '10';
				}
			//}
			//if(0 == leftNum || leftNum+tWidth+15 > cWidth || init)
			//{
				try
				{
					tItem.style.left = (cWidth-tWidth-15 > 0) ? (cWidth-tWidth-15)+'px' : '0px';
				}
				catch(e)
				{
					tItem.style.left = (cWidth-tWidth-15 > 0) ? (cWidth-tWidth-15) : '0';
				}
			//}
		}
	},
	showMoreOptions:function()
	{
		var panel = $id('panel_moreoptions');
		var handler = $id('price_a');
		if(panel)
		{
			var topPx = 65;
			var leftPx = 370;
			var s3w = 526;
			var pw = 540;
			panel.style.display = 'block';
			if(handler)
			{
				//handler.className = 'more_options_show';
				var pos = SFUI.getAbsPoint(handler);
				var hw = handler.offsetWidth;
				var hh = handler.offsetHeight;
				s3w = (hw-14 > 0) ? hw-14 : s3w;
				pw = (hw > 0) ? hw : pw;
				topPx = pos.y + hh - 5;
				leftPx = pos.x;
			}
			panel.style.top = topPx + 'px';
			panel.style.left = leftPx + 'px';
			panel.style.width = pw + 'px';
			if($id('panel_moreoptions_s3')) $id('panel_moreoptions_s3').style.width = s3w + 'px';
		}
	},
	hideMoreOptions:function()
	{
		var panel = $id('panel_moreoptions');
		if(!panel || 'none' == panel.style.display) return;
		var yearMonth = ['panel_opentimesyear_a', 'panel_opentimeeyear_a', 'panel_opentimesmonth_a', 'panel_opentimeemonth_a'];
		for(var i=0; i<yearMonth.length; i++)
		{
			var submenu = $id(yearMonth[i]);
			if(submenu && 'block' == submenu.style.display)
			{
				return;
			}
		}
		panel.style.display = 'none';
	},
	iKnow:function(cookiename)
	{
		SFUtil.setCookie(cookiename,'1','365');
		SFUI.hideId('fdtip');
	},
	showMenu:function(id)
	{
		//alert(!$id(id) || !$id('panel_'+id));
		if(!$id(id) || !$id('panel_'+id)) return;
		var sItem = $id(id);
		var tItem = $id('panel_'+id);
		var pos = SFUI.getAbsPoint(sItem);
		tItem.style.top = (pos.y+sItem.offsetHeight)+'px';
		
			tItem.style.left = (pos.x)+'px';
		var arr = ['opentimesyear_a','opentimeeyear_a','opentimesmonth_a','opentimeemonth_a'];
		if(0 == id.indexOf('opentime'))
		{
			for(var i=0; i<arr.length; i++) SFUI.hideId('panel_'+arr[i]);
		}
		//alert(tItem.innerHTML);
		SFUI.show(tItem);
	}
};