﻿(function($) {
    $.suggest = function(input, options) 
	{
		var lockdata=null;
        var $input = $(input).attr("autocomplete", "off");
        var $results;
        var timeout = false; // hold timeout ID for suggestion results to appear	
        var prevLength = 0; // last recorded length of $input.val()
		var oldclick=false;
		var prestr="";
        var cache = []; // cache MRU list
        var cacheSize = 0; // size of cache in chars (bytes?)
        if (!options.attachObject) options.attachObject = $(document.createElement("ul")).appendTo('body');
        $results = $(options.attachObject);
        $results.addClass(options.resultsClass);
        resetPosition();
        $(window).load(resetPosition) // just in case user is changing size of page while loading
        .resize(resetPosition);
        $input.blur(function() {
				setTimeout(function() { $results.hide() }, 200);
				var val=$("#txtSaleCommunityName").val();
				if(val.length==0){
					$("#txtSaleCommunityNameTip").removeClass();
					$('#txtSaleCommunityNameTip').addClass( 'onError' );
					return false;
				}
				else{
					$("#txtSaleCommunityName").css("border","1px solid #7F9DB9");
					$("#txtSaleCommunityNameTip").removeClass();
					$('#txtSaleCommunityNameTip').addClass( 'onCorrect' );
				}
        });
        
        try {
            $results.bgiframe();
        } catch(e) {}
        $input.keyup(processKey); //
        function resetPosition() {
            // requires jquery.dimension plugin
            var offset = $input.offset();
            $results.css({
                top: (offset.top + input.offsetHeight) + 'px',
                left: offset.left + 'px'
            });
        }
        function processKey(e) {
            if ((/27$|38$|40$/.test(e.keyCode) && $results.is(':visible')) || (/^13$|^9$/.test(e.keyCode) && getCurrentResult())) {
                if (e.preventDefault) e.preventDefault();
                if (e.stopPropagation) e.stopPropagation();
                e.cancelBubble = true;
                e.returnValue = false;
                switch (e.keyCode) 
				{
					case 38:
						// up
						prevResult();
						break;
					case 40:
						// down
						nextResult();
						break;
					case 13:
						// return
						selectCurrentResult();
						break;
					case 27:
						//	escape
						$results.hide();
						break;
                }
            } 
			else if ($input.val() != prestr) {
                if (timeout) clearTimeout(timeout);
                timeout = setTimeout(suggest, options.delay);
                prestr = $input.val();
            }
        }
        function suggest() {
            var q = $.trim($input.val());
            displayItems(q);
        }
        function displayItems(items) {
			if(items.length>0){
				$.ajax({
				  url: "/public/ajax.aspx?action=ShowHouseAgent&keyword="+escape(items),
				  cache: false,
				  success:function(data)
				  {
					if(data.length>0){
						lockdata= data;
					}
					else{
						lockdata="";	
					}
					ShowSelectData(0);
				  }
				});	
			}
			else{
				setTimeout(function() { $results.hide() }, 200);
			}
        }
		function ShowSelectData(ipage){
			oldclick=false;
			var html = '';
			if(lockdata.length>0){
				var str1= lockdata.split("§");
				for( var ii=0;ii<str1.length;ii++){
					var str2= str1[ii].split("±");
					html += '<li id="'+str2[2]+'"><font class=AntHover>'+str2[0]+'</font><span class=Ant1>'+str2[1]+'</span></li>';
				}
			}
			if (html == '') {
				$results.hide();
			}
			else 
			{
				suggest_tip = '<div class="gray ac_result_tip">小帖士：可以使用↑↓进行上下移动</div>';
				html = suggest_tip + '<ul>' + html + '</ul>';
				$results.html(html).show();
				$results.children('ul').children('li:first-child').addClass(options.selectClass);
				$results.children('ul').children('li').mouseover(function() {
					$results.children('ul').children('li').removeClass(options.selectClass);
					$(this).addClass(options.selectClass);
				}).click(function(e) {
					e.preventDefault();
					e.stopPropagation();
					selectCurrentResult();
					$results.hide();
				});
			}
		}
		function gotonextpage(ipage){
		}
        function getCurrentResult() {
            if (!$results.is(':visible')) return false;
            var $currentResult = $results.children('ul').children('li.' + options.selectClass);
            if (!$currentResult.length) $currentResult = false;
            return $currentResult;
        }
        function selectCurrentResult() {
            $currentResult = getCurrentResult();
            if ($currentResult) {
                $input.val($currentResult.children('font').html().replace(/<font>.+?<\/font>/i, ''));
                $("#txtSaleCommunityAddress").val($currentResult.children('span').html().replace(/<span>.+?<\/span>/i, ''));
                $_D("txtSaleCommunityAreaID").value= $currentResult.attr('id');
                if (options.onSelect) {
                    options.onSelect.apply($input[0]);
                }
            }
        }
		function selectResult(){
			$currentResult = getCurrentResult();
            if ($currentResult) {
                $input.val($currentResult.children('font').html().replace(/<font>.+?<\/font>/i, ''));
                $("#txtSaleCommunityAddress").val($currentResult.children('span').html().replace(/<span>.+?<\/span>/i, ''));
                $_D("txtSaleCommunityAreaID").value= $currentResult.attr('id');
                if (options.onSelect) {
                    options.onSelect.apply($input[0]);
                }
            }
		}
        function nextResult() {
            $currentResult = getCurrentResult();
            if ($currentResult) $currentResult.removeClass(options.selectClass).next().addClass(options.selectClass);
            else $results.children('ul').children('li:first-child').addClass(options.selectClass);
			selectResult();
        }
        function prevResult() {
            $currentResult = getCurrentResult();
            if ($currentResult) $currentResult.removeClass(options.selectClass).prev().addClass(options.selectClass);
            else $results.children('ul').children('li:last-child').addClass(options.selectClass);
			selectResult();
        }
    }
    $.fn.suggest = function(source, options) {
        options = options || {};
        options.delay = options.delay || 0;
        options.resultsClass = options.resultsClass || 'ac_results';
        options.selectClass = options.selectClass || 'ac_over';
        options.matchClass = options.matchClass || 'ac_match';
        options.minchars = options.minchars || 1;
        options.delimiter = options.delimiter || '\n';
        options.onSelect = options.onSelect || false;
        options.dataDelimiter = options.dataDelimiter || '\t';
        options.dataContainer = options.dataContainer || '#SuggestResult';
        options.attachObject = options.attachObject || null;
        this.each(function() {
            new $.suggest(this, options);
        });
        return this;
    };
})(jQuery);