<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=1"><xsl:call-template name="softlist1"/></xsl:when>
		<xsl:when test="/xml/@action=2"><xsl:call-template name="softlist2"/></xsl:when>
		<xsl:when test="/xml/@action=3"><xsl:call-template name="softlist3"/></xsl:when>
		<xsl:when test="/xml/@action=4"><xsl:call-template name="softlist4"/></xsl:when>
        <xsl:when test="/xml/@action=5"><xsl:call-template name="softlist5"/></xsl:when>
        <xsl:when test="/xml/@action=6"><xsl:call-template name="softlist6"/></xsl:when>
        <xsl:when test="/xml/@action=7"><xsl:call-template name="softlist7"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="softlist"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="softlist">
	<xsl:for-each select="xml/datalist/row">
		<li><xsl:if test="/xml/@showdate=1"><span class="globalDate"><xsl:value-of select="@softtime" disable-output-escaping="yes"/></span></xsl:if><xsl:if test="/xml/@showcate=1">[<a href="{@link2}"><xsl:value-of select="@classname"/></a>]</xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="softlist1">
	<xsl:for-each select="xml/datalist/row">
		<li><xsl:if test="/xml/@showdate=1"><span class="globalDate"><xsl:value-of select="@softtime" disable-output-escaping="yes"/></span></xsl:if><xsl:if test="/xml/@showcate=1">[<a href="{@link2}"><xsl:value-of select="@classname"/></a>]</xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="softlist2">
	<xsl:for-each select="xml/datalist/row">
		<li><xsl:if test="/xml/@showdate=1"><span class="globalDate"><xsl:value-of select="@softtime" disable-output-escaping="yes"/></span></xsl:if><xsl:if test="/xml/@showcate=1">[<a href="{@link2}"><xsl:value-of select="@classname"/></a>]</xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="softlist3">
	<xsl:for-each select="xml/datalist/row">
		<xsl:if test="/xml/@showdate=1"><span class="globalDate"><xsl:value-of select="@softtime" disable-output-escaping="yes"/></span></xsl:if><xsl:if test="/xml/@showcate=1">[<a href="{@link2}"><xsl:value-of select="@classname"/></a>]</xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>
</xsl:template>

<xsl:template name="softlist4">
	<xsl:for-each select="xml/datalist/row">
		<li>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}" class="wezCblack"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}" class="wezCblack"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose>
        <xsl:if test="/xml/@showdate=1"><span><xsl:value-of select="@softtime" disable-output-escaping="yes"/></span></xsl:if><xsl:if test="/xml/@showcate=1">[<a href="{@link2}"><xsl:value-of select="@classname"/></a>]</xsl:if>
        </li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="softlist5">
	<xsl:for-each select="xml/datalist/row">
		<li><div class="wezDl1"><em class="wezRed">{@i}</em><xsl:if test="/xml/@showdate=1"><span class="globalDate"><xsl:value-of select="@softtime" disable-output-escaping="yes"/></span></xsl:if><xsl:if test="/xml/@showcate=1">[<a href="{@link2}"><xsl:value-of select="@classname"/></a>]</xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}" class="wezEblack"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}" class="wezEblack"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></div></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="softlist6">
	<xsl:for-each select="xml/datalist/row">
		<li> <xsl:if test="/xml/@showdate=1"><span class="fr"><xsl:value-of select="@softtime" disable-output-escaping="yes"/></span></xsl:if><xsl:if test="/xml/@showcate=1"><a href="{@link2}" class="m_sname"><xsl:value-of select="@classname"/></a></xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}" ><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}" ><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose>
        </li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="softlist7">
	<xsl:for-each select="xml/datalist/row">
		<li class="hotsoft{@i}"><xsl:if test="/xml/@showcate=1"><a href="{@link2}" class="m_sname"><xsl:value-of select="@classname"/></a></xsl:if>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}" ><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}" ><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose>
        <xsl:if test="/xml/@showdate=1"><span class="fr"><xsl:value-of select="@softtime" disable-output-escaping="yes"/></span></xsl:if>
        </li>
	</xsl:for-each>
</xsl:template>
  
</xsl:stylesheet>