<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.net Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@action=1"><xsl:call-template name="toplist1"/></xsl:when>
		<xsl:when test="/xml/@action=2"><xsl:call-template name="toplist2"/></xsl:when>
        <xsl:when test="/xml/@action=3"><xsl:call-template name="toplist3"/></xsl:when>
        <xsl:when test="/xml/@action=4"><xsl:call-template name="toplist4"/></xsl:when>
		<xsl:otherwise><xsl:call-template name="toplist"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="toplist">
	<xsl:for-each select="xml/datalist/row">
		<li><xsl:choose>
			<xsl:when test="@i&gt;3"><span class="list-icon2"><xsl:value-of select="@i"/></span></xsl:when>
			<xsl:otherwise><span class="list-icon1"><xsl:value-of select="@i"/></span></xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="toplist1">
	<xsl:for-each select="xml/datalist/row">
		<li><span class="list-icon{@i}"><xsl:value-of select="@i"/></span>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="toplist2">
	<xsl:for-each select="xml/datalist/row">
		<li><span class="list-icon{@i}"><xsl:value-of select="@i"/></span>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="toplist3">
	<xsl:for-each select="xml/datalist/row">
		<li>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></xsl:otherwise>
		</xsl:choose></li>
	</xsl:for-each>
</xsl:template>

<xsl:template name="toplist4">
	<xsl:for-each select="xml/datalist/row">
		<li class="clear"><xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><a href="{@link}"><img src="{@imglink}" width="{/xml/@width}" height="{/xml/@height}" border="0" alt="{@title}" /></a></xsl:when>
			<xsl:otherwise><a href="{@link}" target="{/xml/@target}"><img src="{@imglink}" width="{/xml/@width}" height="{/xml/@height}" border="0" alt="{@title}" /></a></xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="string-length(/xml/@target)&lt;2"><p><strong><a href="{@link}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></strong></p></xsl:when>
			<xsl:otherwise><p><strong><a href="{@link}" target="{/xml/@target}" title="{@title}"><xsl:value-of select="@topic" disable-output-escaping="yes"/></a></strong></p></xsl:otherwise>
		</xsl:choose>
        <span><xsl:value-of select="@content" disable-output-escaping="yes"/></span>
        </li>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>