<?xml version="1.0" encoding="GB2312"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" omit-xml-declaration = "yes" indent="yes" version="4.0"/>
	<!--
	Copyright (C) 2007,2008 NewAsp.Net. All rights reserved.
	Written by newasp.cn Sunwin
	-->
<xsl:template match="/">
	<xsl:choose>
		<xsl:when test="/xml/@topicmode='1'">
			<xsl:call-template name="answerecords"/>
		</xsl:when>
		<xsl:when test="/xml/@topicmode='3'">
			<xsl:call-template name="sharerecords"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="askedrecords"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="listpage">
	<div class="mainPage">
		<i class="postCount"><b><xsl:value-of select="xml/@totalnumber" disable-output-escaping="yes"/></b>ҳΣ<b><xsl:value-of select="xml/@page" disable-output-escaping="yes"/></b>/<xsl:value-of select="xml/@pagecount" disable-output-escaping="yes"/>ҳ</i>
		<var class="morePage">
			<xsl:value-of select="$AskedPageList" disable-output-escaping="yes"/>
		</var>
	</div>
</xsl:template>
<xsl:template name="askedrecords">
<h2 class="listHead">
	<span class="headline1"><b>ûʼ¼</b></span> 
	<span class="headline2"><a href="{$installdir}usertopic.asp?userid={xml/@nowuserid}&amp;topicmode=1">ûش¼</a></span> 
	<span class="headline2"><a href="{$installdir}usertopic.asp?userid={xml/@nowuserid}&amp;topicmode=3">û¼</a></span> 
	<span class="headline3"><input type="checkbox" onchange="javascript:toggleLinkAttributes();" id="toggleLinks" /><label for="toggleLinks" title="Open in new window?"><strong>´</strong></label></span>
</h2>
<div id="userListZone">
<ul>
	<li class="headline"><span class="title">( <xsl:value-of select="xml/@totalnumber" disable-output-escaping="yes"/> )</span> <span class="cent">ش</span> <span class="state">״̬</span> <span class="time"></span></li>
	<xsl:if test="xml/topic/row">
		<xsl:for-each select="xml/topic/row">
			<li><xsl:if test="@reward &gt; 0"><span class="reward"><img src="{$installdir}images/icons/icon_10.gif" border="0"/> <xsl:value-of select="@reward" disable-output-escaping="yes"/></span></xsl:if>
			<span class="title">
			<a rel="external" href="{$installdir}question.asp?topicid={@topicid}">
			<xsl:choose>
				<xsl:when test="string-length(@title) &gt; 35 "><xsl:value-of select="concat(substring(@title,0,25),'....',substring(@title,(string-length(@title)- 10 ),string-length(@title)))" disable-output-escaping="yes"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="@title" disable-output-escaping="yes"/></xsl:otherwise>
			</xsl:choose>
			</a> </span> 
			<span class="cent"><xsl:value-of select="@postnum" disable-output-escaping="yes"/></span> 
			<span class="state"><img src="{$installdir}images/icons/icon_0{@topicmode}.gif" border="0"/></span> 
			<span class="time"><xsl:value-of select="@dateandtime" /></span></li>
		</xsl:for-each>
	</xsl:if>
</ul>
<xsl:call-template name="listpage"/>
</div>
</xsl:template>
<xsl:template name="answerecords">
<h2 class="listHead">
	<span class="headline2"><a href="{$installdir}usertopic.asp?userid={xml/@nowuserid}&amp;topicmode=0">ûʼ¼</a></span> 
	<span class="headline1"><b>ûش¼</b></span> 
	<span class="headline2"><a href="{$installdir}usertopic.asp?userid={xml/@nowuserid}&amp;topicmode=3">û¼</a></span> 
	<span class="headline3"><input type="checkbox" onchange="javascript:toggleLinkAttributes();" id="toggleLinks" /><label for="toggleLinks" title="Open in new window?"><strong>´</strong></label></span>
</h2>
<div id="userListZone">
<ul>
	<li class="headline"><span class="title">( <xsl:value-of select="xml/@totalnumber" disable-output-escaping="yes"/> )</span> <span class="asker"></span> <span class="state">״̬</span> <span class="time"></span></li>
	<xsl:if test="xml/topic/row">
		<xsl:for-each select="xml/topic/row">
			<li><span class="title">
			<a rel="external" href="{$installdir}question.asp?topicid={@topicid}">
			<xsl:choose>
				<xsl:when test="string-length(@title) &gt; 32 "><xsl:value-of select="concat(substring(@title,0,22),'....',substring(@title,(string-length(@title)- 10 ),string-length(@title)))" disable-output-escaping="yes"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="@title" disable-output-escaping="yes"/></xsl:otherwise>
			</xsl:choose>
			</a> </span>
			<span class="asker"><a rel="external" href="{$installdir}usertopic.asp?userid={@postuserid}"><xsl:value-of select="@postusername" disable-output-escaping="yes"/></a></span> 
			<span class="state">
			<xsl:choose>
				<xsl:when test="@answermode='1'"><img src="{$installdir}images/icons/icon_11.gif" border="0"/></xsl:when>
				<xsl:otherwise><img src="{$installdir}images/icons/icon_0{@topicmode}.gif" border="0"/></xsl:otherwise>
			</xsl:choose>
			</span> 
			<span class="time"><xsl:value-of select="@dateandtime" /></span></li>
		</xsl:for-each>
	</xsl:if>
</ul>
<xsl:call-template name="listpage"/>
</div>
</xsl:template>
<xsl:template name="sharerecords">
<h2 class="listHead">
	<span class="headline2"><a href="{$installdir}usertopic.asp?userid={xml/@nowuserid}&amp;topicmode=0">ûʼ¼</a></span> 
	<span class="headline2"><a href="{$installdir}usertopic.asp?userid={xml/@nowuserid}&amp;topicmode=1">ûش¼</a></span> 
	<span class="headline1"><b>û¼</b></span> 
	<span class="headline3"><input type="checkbox" onchange="javascript:toggleLinkAttributes();" id="toggleLinks" /><label for="toggleLinks" title="Open in new window?"><strong>´</strong></label></span>
</h2>
<div id="userListZone">
<ul>
	<li class="headline"><span class="title">( <xsl:value-of select="xml/@totalnumber" disable-output-escaping="yes"/> )</span> <span class="cent">ش</span> <span class="state">״̬</span> <span class="time"></span></li>
	<xsl:if test="xml/topic/row">
		<xsl:for-each select="xml/topic/row">
			<li><span class="title">
			<a rel="external" href="{$installdir}share.asp?topicid={@topicid}">
			<xsl:choose>
				<xsl:when test="string-length(@title) &gt; 35 "><xsl:value-of select="concat(substring(@title,0,25),'....',substring(@title,(string-length(@title)- 10 ),string-length(@title)))" disable-output-escaping="yes"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="@title" disable-output-escaping="yes"/></xsl:otherwise>
			</xsl:choose>
			</a> </span>
			<span class="cent"><xsl:value-of select="@postnum" disable-output-escaping="yes"/></span> 
			<span class="state"><img src="{$installdir}images/icons/icon_0{@topicmode}.gif" border="0"/></span> 
			<span class="time"><xsl:value-of select="@dateandtime" /></span></li>
		</xsl:for-each>
	</xsl:if>
</ul>
<xsl:call-template name="listpage"/>
</div>
</xsl:template>
</xsl:stylesheet>