﻿<%
Class Cms_Lib

    '构造函数开始

    Private Sub Class_Initialize()

    End Sub

    '=================================================================
    '函 数 名：GetNewsList
    '函数作用：装载文章列表
    '返 回 值：文章列表SQL
    '=================================================================

    Public Function GetNewsList(attr)
        Dim oSQL
        oSQL = GetPublicList("NewsList", attr)
        Set GetNewsList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetProList
    '函数作用：装载产品列表
    '=================================================================

    Public Function GetProList(attr)
        Dim oSQL
        oSQL = GetPublicList("ProList", attr)
        Set GetProList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetProList
    '函数作用：装载下载列表
    '=================================================================

    Public Function GetDownList(attr)
        Dim oSQL
        oSQL = GetPublicList("DownList", attr)
        Set GetDownList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetPublicList
    '函数作用：获取通用SQL语句
    '参　　数：
    '			cid					###	所属类别
    '			istop				###	条件是否置顶
    '			isbest				###	条件是否推荐
    '			ishot				###	条件是否热门
    '			num					###	显示条数
    '			start				###	从指定num数量的条数里开始
    '			ispic				###	是否只调用有图的
    '			order				###	排序方式，默认：更新时间
    '													1、点击量排序
    '													2、置顶+更新时间
    '													3、推荐+更新时间
    '													4、热门+更新时间
    '													5、置顶+点击量+更新时间
    '													6、置顶+点击量+更新时间
    '													7、热门+点击量+更新时间
    '			id					###	调用指定ID数据,多个以逗号隔开，如：22,98,118
    '返 回 值：SQL
    '=================================================================

    Public Function GetPublicList(ByVal TabName, ByVal attr)
        Dim oSQL, ClassId, DataClassId, DataIsTop, DataIsBest, DataIsHot
        Dim TempTopNum, ShowNum, IsPic, Id, OrderBy, StartNum
        ClassId = Cms.Tpl.attr(attr, "cid")
        DataIsTop = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "istop"))
        DataIsBest = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "isbest"))
        DataIsHot = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ishot"))
        IsPic = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ispic"))
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        TempTopNum = Easp.IIf(TempTopNum = 0, 10, TempTopNum)
        StartNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "start"))
        OrderBy = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "order"))
        Id = Cms.Tpl.attr(attr, "id")
        '==============================================================
        If StartNum > 0 Then
            ShowNum = TempTopNum + StartNum
        Else
            ShowNum = TempTopNum
        End If
        '==============================================================
        oSQL = "Select Top "& ShowNum &" * From ["& TablePrefix & TabName &"] Where 1 = 1 "
        '==============================================================
        If Not Easp.IsN(ClassId) Then
            oSQL = oSQL & " And ClassId In(" & ClassId & ") "
        End If
        If DataIsTop > 0 Then
            oSQL = oSQL & " And DataIsTop = 1 "
        End If
        If DataIsBest > 0 Then
            oSQL = oSQL & " And DataIsBest = 1 "
        End If
        If DataIsHot > 0 Then
            oSQL = oSQL & " And DataIsHot = 1 "
        End If
        If IsPic > 0 Then
            oSQL = oSQL & " And ImageUrl <> '' "
        End If
        If Not Easp.IsN(Id) Then
            oSQL = oSQL & " And Id in("& Id &") "
        End If
        Select Case OrderBy
            Case 1
                oSQL = oSQL & " Order By Hits Desc,UpTime Desc,Id Desc "
            Case 2
                oSQL = oSQL & " Order By DataIsTop Desc,UpTime Desc,Id Desc "
            Case 3
                oSQL = oSQL & " Order By DataIsBest Desc,UpTime Desc,Id Desc "
            Case 4
                oSQL = oSQL & " Order By DataIsHot Desc,UpTime Desc,Id Desc "
            Case 5
                oSQL = oSQL & " Order By DataIsTop Desc,Hits Desc,UpTime Desc,Id Desc "
            Case 6
                oSQL = oSQL & " Order By DataIsBest Desc,Hits Desc,UpTime Desc,Id Desc "
            Case 7
                oSQL = oSQL & " Order By DataIsHot Desc,Hits Desc,UpTime Desc,Id Desc "
            Case Else
                oSQL = oSQL & " Order By UpTime Desc,Id Desc "
        End Select
        '==============================================================
        GetPublicList = oSQL
    End Function

    '=================================================================
    '函 数 名：GetJobList
    '函数作用：装载人才招聘列表
    '参　　数：
    '			istop				###	条件是否置顶
    '			isbest				###	条件是否推荐
    '			ishot				###	条件是否热门
    '			num					###	显示条数
    '			start				###	从指定num数量的条数里开始
    '			order				###	排序方式，默认：更新时间
    '													1、置顶+更新时间
    '													2、推荐+更新时间
    '													3、热门+更新时间
    '			id					###	调用指定ID数据,多个以逗号隔开，如：22,98,118
    '返 回 值：人才招聘列表SQL
    '=================================================================

    Public Function GetJobList(attr)
        Dim oSQL, DataIsTop, DataIsBest, DataIsHot, OrderBy
        Dim TempTopNum, ShowNum, Id, StartNum
        DataIsTop = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "istop"))
        DataIsBest = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "isbest"))
        DataIsHot = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "ishot"))
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        TempTopNum = Easp.IIf(TempTopNum = 0, 10, TempTopNum)
        StartNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "start"))
        OrderBy = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "order"))
        Id = Cms.Tpl.attr(attr, "id")
        '==============================================================
        If StartNum > 0 Then
            ShowNum = TempTopNum + StartNum
        Else
            ShowNum = TempTopNum
        End If
        '==============================================================
        oSQL = "Select Top "& ShowNum &" * From ["& TablePrefix &"Job] Where 1 = 1  "
        '==============================================================
        If DataIsTop > 0 Then
            oSQL = oSQL & " And DataIsTop = 1 "
        End If
        If DataIsBest > 0 Then
            oSQL = oSQL & " And DataIsBest = 1 "
        End If
        If DataIsHot > 0 Then
            oSQL = oSQL & " And DataIsHot = 1 "
        End If
        If Not Easp.IsN(Id) Then
            oSQL = oSQL & " And Id in("& Id &") "
        End If
        Select Case OrderBy
            Case 1
                oSQL = oSQL & " Order By DataIsTop Desc,UpTime Desc,Id Desc "
            Case 2
                oSQL = oSQL & " Order By DataIsBest Desc,UpTime Desc,Id Desc "
            Case 3
                oSQL = oSQL & " Order By DataIsHot Desc,UpTime Desc,Id Desc "
            Case Else
                oSQL = oSQL & " Order By UpTime Desc,Id Desc "
        End Select
        '==============================================================
        Set GetJobList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetClassList
    '函数作用：装载分类列表
    '参　　数：
    '			cid					###	频道ID
    '			num					###	显示条数
    '			d					###	条件:只调用大类
    '			id					###	条件:指定分类ID
    '返 回 值：分类列表SQL
    '=================================================================

    Public Function GetClassList(attr)
        Dim oSQL, TempTopNum, Cid, IdVal, DeepPath
        Cid = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "cid"))
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        IdVal = Cms.Tpl.attr(attr, "id")
        DeepPath = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "d"))
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From "& TablePrefix &"Type Where IsShow = 1 "
        If Cid > 0 Then
            oSQL = oSQL & " And ChannelId = "& Cid &" "
        Else
            Exit Function
        End If
        If DeepPath = 1 Then
            oSQL = oSQL & " And DeepPath = 0 "
        End If
        If Not Easp.IsN(IdVal) Then
            oSQL = oSQL & " And id in("& IdVal &") "
        End If
        oSQL = oSQL & " Order By Px Asc,Id Desc "
        Set GetClassList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetNavList
    '函数作用：装载导航
    '参　　数：
    '			num					###	显示条数
    '			ispid				###	父类ID
    '			issub				###	是否只调用二级导航
    '返 回 值：导航SQL
    '=================================================================

    Public Function GetNavList(attr)
        Dim oSQL, TempTopNum, IsPid, IsSub
        '=============================================================
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        IsPid = Cms.Tpl.attr(attr, "ispid")
        IsSub = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "issub"))
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix &"Nav] Where IsChk = 1 "
        If Not Easp.IsN(IsPid) Then
            oSQL = oSQL & " And Pid in("& IsPid &") "
        End If
        If IsSub > 0 Then
            oSQL = oSQL & " And IsSub = 1 "
        End If
        oSQL = oSQL & " Order By Px Asc,id Desc "
        Set GetNavList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetLinkList
    '函数作用：装载友情连接
    '参　　数：
    '			num					###	显示条数
    '			t					###	条件
    '			islogo				### 是否只调用有LOGO
    '返 回 值：友情连接SQL
    '=================================================================

    Public Function GetLinkList(attr)
        Dim oSQL, TempTopNum, TypeId, IsLogo
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        TypeId = Cms.Tpl.attr(attr, "t")
        IsLogo = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "islogo"))
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix &"Links] Where 1 = 1 "
        If Not Easp.IsN(TypeId) And TypeId <> "0" Then
            oSQL = oSQL & " And TypeId in("& TypeId &") "
        End If
        If IsLogo > 0 Then
            oSQL = oSQL & " And Logo <> '' "
        End If
        oSQL = oSQL & " Order By Px Asc,id Desc  "
        Set GetLinkList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetHdpList
    '函数作用：装载幻灯片列表
    '参　　数：
    '			num					###	显示条数
    '			cid					###	所属类别
    '返 回 值：幻灯片SQL
    '=================================================================

    Public Function GetHdpList(attr)
        Dim oSQL, TempTopNum, ClassId
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        ClassId = Cms.Tpl.attr(attr, "cid")
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix &"Hdp] Where 1 = 1 "
        If Not Easp.IsN(ClassId) Then
            oSQL = oSQL & " And ClassId in("& ClassId &") "
        End If
        oSQL = oSQL & " Order By Px Asc,Id Desc  "
        Set GetHdpList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetAbout
    '函数作用：装载单页列表
    '参　　数：
    '			num					###	显示条数
    '			id					###	调用指定ID数据
    '返 回 值：单页SQL
    '=================================================================

    Public Function GetAbout(attr)
        Dim oSQL, TempTopNum, MaxTopNum, Id
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        Id = Cms.Tpl.attr(attr, "id")
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix &"About] Where 1 = 1 "
        If Not Easp.IsN(Id) Then
            oSQL = oSQL & " And Id in("& Id &") "
        End If
        oSQL = oSQL & " Order By Id Desc "
        Set GetAbout = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '函 数 名：GetBookList
    '函数作用：装载留言列表
    '参　　数：
    '			num					###	显示条数
    '			id					###	调用指定ID数据
    '返 回 值：留言列表SQL
    '=================================================================

    Public Function GetBookList(attr)
        Dim oSQL, TempTopNum, Id
        TempTopNum = CmsFun.ChkNumEric(Cms.Tpl.attr(attr, "num"))
        Id = Cms.Tpl.attr(attr, "id")
        '=============================================================
        oSQL = "Select "& Easp.IIf(TempTopNum = 0, "", "Top " & TempTopNum) &" * From ["& TablePrefix &"Book] Where 1 = 1 "
        If Not Easp.IsN(Id) Then
            oSQL = oSQL & " And Id in("& Id &") "
        End If
        oSQL = oSQL & " And IsChk = 1 "
        oSQL = oSQL & " Order By id Desc "
        Set GetBookList = Easp.db.GRS(oSQL)
    End Function

    '=================================================================
    '读取网站配置参数
    '=================================================================

    Public Function GetSiteConfig()
        Set GetSiteConfig = Easp.db.GR(TablePrefix & "Config", " id = 1 ", "")
    End Function

    '=================================================================
    ' 装载用户自定义标签
    '=================================================================


    Public Function GetUserLabel()
        Set GetUserLabel = Easp.db.GR(TablePrefix & "Label:title,Content", "", "")
    End Function

End Class
%>