﻿<%
'#################################################################################
'##	easp.molibupload.asp
'##	------------------------------------------------------------------------------
'##	Feature		:	EasyAsp MoLibUpload Plugin
'##	Version		:	v1.0
'##	Author		:	艾恩(http://dev.mo.cn)
'## Update      :   苏家戏子(939881475[at]qq.com)
'##	Update Date	:	2013/3/4 10:33
'##	Description	:	艾恩Asp无组件上传-MoLibUpload V1.0 For EasyAasp (Plugin)
'#################################################################################

Class EasyAsp_MoLibUpload
    Private Form, Fils, StreamT, mvarClsName, mvarClsDescription, mvarSavePath
    Private vCharSet, vMaxSize, vSingleSize, vErr, vVersion
    Private vTotalSize, vExe, vErrExe, vboundary, vLostTime, vFileCount, StreamOpened
    Private vMuti, vServerVersion, mvarDescription

    Public Property Let AllowMaxSize(ByVal Value)
        vMaxSize = Value
    End Property

    Public Property Let AllowMaxFileSize(ByVal Value)
        vSingleSize = Value
    End Property

    Public Property Let AllowFileTypes(ByVal Value)
        vExe = LCase(Value)
        vExe = Replace(vExe, "*.", "")
        vExe = Replace(vExe, ";", "|")
    End Property

    Public Property Let CharSet(ByVal Value)
        vCharSet = Value
    End Property

    Public Property Let SavePath(ByVal Value)
        mvarSavePath = Value
    End Property

    Public Property Get FileCount()
        FileCount = Fils.Count
    End Property

    Public Property Get Description()
        Description = mvarDescription
    End Property

    Public Property Get Version()
        Version = vVersion
    End Property

    Public Property Get TotalSize()
        TotalSize = vTotalSize
    End Property

    Public Property Get LostTime()
        LostTime = vLostTime
    End Property

    Private Sub Class_Initialize()
        Easp.Use "Fso"
        Dim T__
        Set Form = Server.CreateObject("Scripting.Dictionary")
        Set Fils = Server.CreateObject("Scripting.Dictionary")
        Set StreamT = Server.CreateObject("Adodb.stream")
        vVersion = "MoLibUpload V1.0"
        vMaxSize = -1
        vSingleSize = -1
        vErr = -1
        vExe = ""
        vTotalSize = 0
        vCharSet = Easp.CharSet
        StreamOpened = False
        vMuti = "_" & Getname() & "_"
        vServerVersion = 6.0
        T__ = LCase(Request.ServerVariables("SERVER_SOFTWARE"))
        T__ = Replace(T__, "microsoft-iis/", "")
        If IsNumeric(T__) Then vServerVersion = CDbl(T__)
        mvarClsName = "MoLibFileExtern_" + Getname()
        mvarClsDescription = "Class {ClsName}\nPublic ContentType,Size,UserSetName,Path,Position,FormName,TempFormName,NewName,FileName,LocalName,IsFile,Extend,Succeed,Exception\nEnd Class\nSet NewFile = new {ClsName}"
        mvarClsDescription = Replace(mvarClsDescription, "{ClsName}", mvarClsName)
        mvarClsDescription = Replace(mvarClsDescription, "\n", vbCrLf)
    End Sub

    Private Sub Class_Terminate()
        Dim f
        Form.RemoveAll()
        For Each f in Fils
            Set Fils(f) = Nothing
        Next
        Fils.RemoveAll()
        Set Form = Nothing
        Set Fils = Nothing
        If StreamOpened Then StreamT.Close()
        Set StreamT = Nothing
    End Sub

    Private Function ParseSizeLimit(byval SizeLimit)
        Dim unit, Val, multiplier, limit
        If Not IsNumeric(SizeLimit) Then
            multiplier = 1
            SizeLimit = ReplaceEx(LCase(SizeLimit), "\s", "")
            Val = replaceex(SizeLimit, "[^\d]+", "")
            If IsNumeric(Val) Then
                Val = CLng(Val)
                If Right(SizeLimit, 2) = "gb" Then multiplier = 1073741824
                If Right(SizeLimit, 2) = "mb" Then multiplier = 1048576
                If Right(SizeLimit, 2) = "kb" Then multiplier = 1024
                limit = Val * multiplier
            Else
                limit = -1
            End If
        Else
            limit = SizeLimit
        End If
        If limit< -1 Then limit = -1
        ParseSizeLimit = limit
    End Function

    Public Function GetData()
        GetData = False
        vMaxSize = ParseSizeLimit(vMaxSize)
        vSingleSize = ParseSizeLimit(vSingleSize)
        Dim time1
        time1 = Timer()
        Dim Val, Str, bcrlf, fpos, sSplit, slen, istart, ef
        Dim TotalBytes, tempdata, BytesRead, ChunkReadSize, PartSize, DataPart, formend, formhead, startpos, endpos
        Dim formname, FileName, fileExe, valueend, NewName, localname, type_1, contentType
        TotalBytes = Request.TotalBytes
        ef = False
        If checkEntryType = False Then ef = True
        mvarDescription = "错误无效的Enctypeor方法!"
        If vServerVersion >= 6 Then
            If Not ef Then
                If vMaxSize > 0 And TotalBytes > vMaxSize Then ef = True
                mvarDescription = "错误的文件超过了最大大小限制!"
            End If
        End If
        If ef Then Exit Function
        vTotalSize = 0
        StreamT.Type = 1
        StreamT.Mode = 3
        StreamT.Open
        StreamOpened = True
        BytesRead = 0
        ChunkReadSize = 1024 * 16
        Do While BytesRead < TotalBytes
            PartSize = ChunkReadSize
            If PartSize + BytesRead > TotalBytes Then PartSize = TotalBytes - BytesRead
            DataPart = Request.BinaryRead(PartSize)
            StreamT.Write DataPart
            BytesRead = BytesRead + PartSize
        Loop
        StreamT.Position = 0
        tempdata = StreamT.Read
        bcrlf = ChrB(13) & ChrB(10)
        fpos = InStrB(1, tempdata, bcrlf)
        sSplit = MidB(tempdata, 1, fpos - 1)
        slen = LenB(sSplit)
        istart = slen + 2
        Do
            formend = InStrB(istart, tempdata, bcrlf & bcrlf)
            formhead = MidB(tempdata, istart, formend - istart)
            Str = Bytes2Str(formhead)
            startpos = InStr(Str, "name=""") + 6
            endpos = InStr(startpos, Str, """")
            formname = LCase(Mid(Str, startpos, endpos - startpos))
            valueend = InStrB(formend + 3, tempdata, sSplit)
            If InStr(Str, "filename=""") > 0 Then
                formname = formname & vMuti & "0"
                startpos = InStr(Str, "filename=""") + 10
                endpos = InStr(startpos, Str, """")
                type_1 = InStr(endpos, LCase(Str), "content-type")
                contentType = Trim(Mid(Str, type_1 + 13))
                FileName = Mid(Str, startpos, endpos - startpos)
                If Trim(FileName) <> "" Then
                    FileName = Replace(FileName, "/", "\")
                    FileName = Replace(FileName, Chr(0), "")
                    LocalName = FileName
                    FileName = Mid(FileName, InStrRev(FileName, "\") + 1)
                    If InStr(FileName, ".")>0 Then
                        fileExe = Split(FileName, ".")(UBound(Split(FileName, ".")))
                    Else
                        fileExe = ""
                    End If
                    If vExe <> "" Then
                        If checkExe(fileExe) = True Then
                            mvarDescription = "错误无效的文件类型：(." & UCase(fileExe) & ")"
                            vErrExe = fileExe
                            tempdata = Empty
                            Exit Function
                        End If
                    End If
                    NewName = Getname()
                    NewName = NewName & "." & fileExe
                    vTotalSize = vTotalSize + valueend - formend - 6
                    If vSingleSize > 0 And (valueend - formend - 6) > vSingleSize Then
                        mvarDescription = "错误的文件超过了大小限制!"
                        tempdata = Empty
                        Exit Function
                    End If
                    If vMaxSize > 0 And vTotalSize > vMaxSize Then
                        mvarDescription = "错误的文件超过了最大大小限制!"
                        tempdata = Empty
                        Exit Function
                    End If
                    If Fils.Exists(formname) Then formname = GetNextFormName(formname)
                    Dim fileCls
                    Set fileCls = NewFile()
                    fileCls.ContentType = contentType
                    fileCls.Size = (valueend - formend - 6)
                    fileCls.Position = (formend + 3)
                    fileCls.FormName = Mid(formname, InStr(formname, vMuti) -1)
                    fileCls.TempFormName = formname
                    fileCls.NewName = NewName
                    fileCls.FileName = FileName
                    fileCls.LocalName = FileName
                    fileCls.IsFile = True
                    fileCls.Extend = Split(NewName, ".")(UBound(Split(NewName, ".")))
                    Fils.Add formname, fileCls
                End If
            Else
                Val = MidB(tempdata, formend + 4, valueend - formend - 6)
                If Form.Exists(formname) Then
                    Form(formname) = Form(formname) & "," & Bytes2Str(Val)
                Else
                    Form.Add formname, Bytes2Str(Val)
                End If
            End If
            istart = valueend + 2 + slen
        Loop Until (istart + 2) >= LenB(tempdata)
        tempdata = Empty
        vLostTime = FormatNumber((Timer - time1) * 1000, 2)
        GetData = True
    End Function

    Private Function CheckExe(ByVal ex)
        Dim notIn
        notIn = True
        If vExe = "*" Then
            notIn = False
        ElseIf InStr(1, vExe, "|") > 0 Then
            Dim tempExe
            tempExe = Split(vExe, "|")
            Dim I
            I = 0
            For I = 0 To UBound(tempExe)
                If LCase(ex) = tempExe(I) Then
                    notIn = False
                    Exit For
                End If
            Next
        Else
            If vExe = LCase(ex) Then
                notIn = False
            End If
        End If
        checkExe = notIn
    End Function

    Public Function GetSize(ByVal Size)
        If Size < 1024 Then
            GetSize = FormatNumber(Size, 2) & "B"
        ElseIf Size >= 1024 And Size < 1048576 Then
            GetSize = FormatNumber(Size / 1024, 2) & "KB"
        ElseIf Size >= 1048576 Then
            GetSize = FormatNumber((Size / 1024) / 1024, 2) & "MB"
        End If
    End Function

    Private Function Bytes2Str(ByVal byt)
        If LenB(byt) = 0 Then
            Bytes2Str = ""
            Exit Function
        End If
        Dim mystream, bstr
        Set mystream = Server.CreateObject("ADODB.Stream")
        mystream.Type = 2
        mystream.Mode = 3
        mystream.Open
        mystream.WriteText byt
        mystream.Position = 0
        mystream.CharSet = vCharSet
        mystream.Position = 2
        bstr = mystream.ReadText()
        mystream.Close
        Set mystream = Nothing
        Bytes2Str = bstr
    End Function

    Private Function Getname()
        Dim y, m, d, h, mm, S, r
        Randomize
        y = Year(Now)
        m = Right("0" & Month(Now), 2)
        d = Right("0" & Day(Now), 2)
        h = Right("0" & Hour(Now), 2)
        mm = Right("0" & Minute(Now), 2)
        S = Right("0" & Second(Now), 2)
        r = CInt(Rnd() * 10000)
        r = Right("0000" & r, 4)
        Getname = y & m & d & h & mm & S & r
    End Function

    Private Function checkEntryType()
        Dim Ct, ctArray, bArray, RequestMethod
        RequestMethod = Trim(LCase(Request.ServerVariables("REQUEST_METHOD")))
        If (RequestMethod = "" Or RequestMethod <> "post") Then
            checkEntryType = False
            Exit Function
        End If
        Ct = LCase(Request.ServerVariables("HTTP_CONTENT_TYPE"))
        ctArray = Split(Ct, ";")
        If UBound(ctarray) >= 0 Then
            If Trim(ctArray(0)) = "multipart/form-data" Then
                checkEntryType = True
                vboundary = Split(Ct, "boundary=")(1)
            Else
                checkEntryType = False
            End If
        Else
            checkEntryType = False
        End If
    End Function

    Public Function Post(ByVal formname)
        If Trim(formname) = "-1" Then
            Set Post = Form
        Else
            If Form.Exists(LCase(formname)) Then
                Post = Form(LCase(formname))
            Else
                Post = ""
            End If
        End If
    End Function

    Public Default Function Files(ByVal formname)
        If Trim(formname) = "-1" Then
            Set Files = Fils
        Else
            Dim vname
            vname = LCase(formname) & vMuti & "0"
            If InStr(formname, vMuti) > 0 Then vname = formname
            If Fils.Exists(vname) Then
                Set Files = Fils(vname)
            Else
                Set Files = NewFile()
                Files.IsFile = False
            End If
        End If
    End Function

    Public Function Search(ByVal formname)
        If formname = "*" Or formname = "-1" Then
            Set Search = Fils
            Exit Function
        End If
        Dim TempFormName
        TempFormName = formname & vMuti
        Dim FileCollection
        Set FileCollection = Server.CreateObject("Scripting.Dictionary")
        Dim v
        For Each v In Fils
            If LCase(Left(v, Len(TempFormName))) = LCase(TempFormName) Then
                FileCollection.Add v, Fils(v)
            End If
        Next
        Set Search = FileCollection
    End Function

    Public Function QuickSave(ByVal formname)
        Dim FC, SucceedCount, File
        SucceedCount = 0
        Set FC = Search(formname)
        For Each File In FC
            If Save(File, 0, True).Succeed Then SucceedCount = SucceedCount + 1
        Next
        QuickSave = SucceedCount
    End Function

    Public Function Save(Byref Name, byval tOption, byval OverWrite)
        Dim File
        If Not IsObject(Name) Then
            Set File = Files(Name)
            If Not File.IsFile Then
                File.Succeed = False
                File.Exception = "错误文件找不到!"
                Set Save = File
                Exit Function
            End If
            On Error Resume Next
            Err.Clear
        Else
            Set File = Name
        End If
        If Not File.IsFile Then
            File.Succeed = False
            File.Exception = "错误文件找不到!"
            Set Save = File
            Exit Function
        End If
        Dim IsP, Path
        IsP = (InStr(mvarSavePath, ":") = 2)
        If Not IsP Then Path = Server.MapPath(mvarSavePath)
        Path = Replace(Path, "/", "\")
        If Mid(Path, Len(Path) - 1) <> "\" Then Path = Path + "\"
        CreateFolder Path
        File.Path = Path
        If tOption = 1 Then
            Path = Path & File.LocalName
            File.FileName = File.LocalName
        Else
            If tOption = -1 And File.UserSetName <> "" Then
                Path = Path & File.UserSetName & "." & File.Extend
                File.FileName = File.UserSetName & "." & File.Extend
            Else
                Path = Path & File.NewName
                File.FileName = File.NewName
            End If
        End If
        If Not OverWrite Then
            Path = GetFilePath(File)
        End If
        Dim tmpStrm
        Set tmpStrm = Server.CreateObject("ADODB.Stream")
        tmpStrm.Mode = 3
        tmpStrm.Type = 1
        tmpStrm.Open
        StreamT.Position = File.Position
        StreamT.copyto tmpStrm, File.Size
        tmpStrm.SaveToFile Path, 2
        tmpStrm.Close
        Set tmpStrm = Nothing
        If Not Err Then
            File.Succeed = True
        Else
            Err.Clear()
            File.Succeed = False
            File.Exception = Err.Description
        End If
        Set Save = File
    End Function

    Public Function GetBinary(byval Name)
        Dim File
        Set File = Files(Name)
        If Not File.IsFile Then
            GetBinary = chrb(0)
            Exit Function
        End If
        StreamT.Position = File.Position
        GetBinary = StreamT.Read(File.Size)
    End Function

    Private Function GetNextFormName(byval formname)
        Dim formStart, currentIndex
        formStart = Left(formname, InStr(formname, vMuti) + Len(vMuti) -1)
        currentIndex = Mid(formname, InStr(formname, vMuti) + Len(vMuti))
        currentIndex = CInt(currentIndex)
        Do While Fils.Exists(formname)
            currentIndex = currentIndex + 1
            formname = formStart & currentIndex
        Loop
        GetNextFormName = formname
    End Function

    Private Function ReplaceEx(sourcestr, regString, Str)
        If IsNull(sourcestr) Then sourcestr = ""
        Dim re
        Set re = New RegExp
        re.IgnoreCase = True
        re.Global = True
        re.Pattern = "" & regString & ""
        Str = re.Replace(sourcestr, Str)
        Set re = Nothing
        ReplaceEx = Str
    End Function

    Private Function CreateFolder(ByVal folderPath)
        Easp.Fso.CreateFolder folderPath
    End Function

    Private Function GetFilePath(Byref File)
        Dim oFSO, Fname , FNameL , i
        i = 0
        Set oFSO = Server.CreateObject(Easp.FsoName())
        Fname = File.Path & File.FileName
        FNameL = Mid(File.FileName, 1, InStr(File.FileName, ".") - 1)
        Do While oFSO.FileExists(Fname)
            Fname = File.Path & FNameL & "(" & i & ")." & File.Extend
            File.FileName = FNameL & "(" & i & ")." & File.Extend
            i = i + 1
        Loop
        Set oFSO = Nothing
        GetFilePath = Fname
    End Function

    Private Function NewFile()
        Execute mvarClsDescription
    End Function

End Class
%>