<%
'޸ԷASPбҳ
Class ListPager
	Private m_DbType, m_Connection, m_Table, m_PrimaryKey, m_Fields, m_CommandText
	Private m_Cache, m_Expires, m_RecordCount, m_PageSize, m_PageCount, m_CurrentPage
	Private m_Where, m_WhereAND, m_Orders(1,4), m_OrdUbound, m_QueryString
	Private m_Order, m_OrderASC, m_OrderDESC, m_PreFields, m_PreRecordCount
Public Property Get Version
		Version = "Fonshen ASP ListPager"
	End Property
Public Property Let DbType(strDbType)
		m_DbType = UCase(DbType)
	End Property
Public Property Let Connection(objConnection)
		Set m_Connection = objConnection
	End Property
Public Property Let Table(strTable)
		m_Table = strTable
	End Property
Public Property Let PrimaryKey(strPrimaryKey)
		m_PrimaryKey = Lcase(strPrimaryKey)
	End Property
Public Property Let Fields(strFields)
		m_Fields = strFields
	End Property
Public Property Let Cache(intCache)
		m_Cache = intCache
	End Property
Public Property Let RecordCount(intRecordCount)
		m_RecordCount = intRecordCount
	End Property
	Public Property Get RecordCount
		RecordCount = m_RecordCount
	End Property
Public Property Let PageSize(intPageSize)
		m_PageSize = intPageSize
	End Property
	Public Property Get PageSize
		PageSize = m_PageSize
	End Property
Public Property Get PageCount
		PageCount = m_PageCount
	End Property
Public Property Get CurrentPage
		CurrentPage = m_CurrentPage
	End Property
Public Property Get QueryString
		QueryString = m_QueryString
	End Property
Public Property Get CommandText
		CommandText = m_CommandText
	End Property
Public Sub AddWhere(strWhere)
		if m_Where = "" then
			m_Where = "(" & strWhere & ")"
		else
			m_Where = m_Where & " AND (" & strWhere & ")"
		end if
	End Sub
	Public Sub AddOrder(strField,strOrder)
		m_OrdUbound = m_OrdUbound + 1
		if m_OrdUbound>Ubound(m_Orders,2) then ReDim m_Orders(1,2*m_OrdUbound-1)
		m_Orders(0,m_OrdUbound) = Lcase(Trim(strField))
		m_Orders(1,m_OrdUbound) = Ucase(Trim(strOrder))
	End Sub
Private Function ToLong(str,defautValue)
		if IsNumeric(str) then
			ToLong = Clng(str)
		else
			ToLong = defautValue
		end if
	End Function
Private Sub Class_Initialize
		m_OrdUbound = -1
		m_Cache = 0
		m_RecordCount = -1
		m_PageSize = 20
	End Sub
	Private Sub Class_Terminate
	End Sub
Private Sub Init_Where()
		if m_Where = "" then
			m_WhereAND = " WHERE "
		else
			m_Where = " WHERE " & m_Where
			m_WhereAND = m_Where & " AND "
		end if
	End Sub
	Private Sub Init_Order()
		Dim isNotStrongOrder : isNotStrongOrder = True
		m_PreFields = m_PrimaryKey
		for i=0 to m_OrdUbound
			if m_Orders(1,i) = "DESC" then
				m_OrderASC = m_OrderASC & m_Orders(0,i) & " DESC"
				m_OrderDESC= m_OrderDESC & m_Orders(0,i)& " ASC"
			else
				m_OrderASC = m_OrderASC & m_Orders(0,i) & " ASC"
				m_OrderDESC= m_OrderDESC & m_Orders(0,i)& " DESC"
			end if
			m_Order = m_OrderASC
			if m_Orders(0,i) = m_PrimaryKey then
				isNotStrongOrder = False
				Exit for
			else
				m_OrderASC = m_OrderASC & ","
				m_OrderDESC= m_OrderDESC& ","
				m_PreFields= m_PreFields& "," & m_Orders(0,i)
			end if
		next
		if isNotStrongOrder then
			m_OrderASC = m_OrderASC & m_PrimaryKey & " ASC"
			m_OrderDESC= m_OrderDESC& m_PrimaryKey & " DESC"
		end if
		if m_Order <> "" then m_Order = " ORDER BY " & m_Order
		m_OrderASC = " ORDER BY " & m_OrderASC
		m_OrderDESC= " ORDER BY " & m_OrderDESC
	End Sub
	Private Sub Init_RecordCount()
		Dim Item, QueryStringName : QueryStringName = "page"
		for each Item in Request.QueryString
			if StrComp(Item, QueryStringName, 1)<>0 then
				m_QueryString = m_QueryString & Item & "=" & Server.URLEncode(Request.QueryString(Item)) & "&"
			end if
		next
Dim queryArray : queryArray = Split(Request.QueryString(QueryStringName), ",")
		Dim intNow : intNow = DateDiff("n", DateSerial(2000, 1, 1), Now)
		m_Expires = intNow
		m_CurrentPage = 1
		select case Ubound(queryArray)
		case 0
			m_CurrentPage = ToLong(queryArray(0), 1)
		case 2
			m_CurrentPage = ToLong(queryArray(2), 1)
			m_Expires = ToLong(queryArray(0), m_Expires)
		end select
if m_RecordCount < 0 and m_Cache > 0 then
			if m_Expires > intNow then
				m_RecordCount = ToLong(queryArray(1), -1)
				if m_RecordCount = -1 then m_Expires = intNow + m_Cache
			else
				m_Expires = intNow + m_Cache
			end if
		else
			m_Expires = intNow
		end if
if m_RecordCount = -1 then
			m_RecordCount = m_Connection.Execute("SELECT COUNT(" & m_PrimaryKey & ") FROM " & m_Table & m_Where)(0)
		end if
if m_Expires = intNow then
			m_QueryString = m_QueryString & QueryStringName & "="
		else
			m_QueryString = m_QueryString & QueryStringName & "=" & m_Expires & "," & m_RecordCount & ","
		end if
	End Sub
	Private Sub Init_CurrentPage()
		Dim i : i = m_RecordCount mod m_PageSize
		if i = 0 then
			m_PageCount = m_RecordCount/m_PageSize
		else
			m_PageCount = (m_RecordCount - i)/m_PageSize + 1
		end if
		if m_CurrentPage<1 then m_CurrentPage = 1
		if m_CurrentPage>m_PageCount then m_CurrentPage = m_PageCount
m_PreRecordCount = m_CurrentPage * m_PageSize
	End Sub
	Private Sub Init_DbType()
		select case m_DbType
			case "ACCESS","MSSQL","MYSQL","ORACLE","PGSQL"
			case else
				select case (m_Connection.Provider)
					case "MSDASQL.1","SQLOLEDB.1","SQLOLEDB" : m_DbType = "MSSQL"
					case "MSDAORA.1","OraOLEDB.Oracle" : m_DbType = "ORACLE"
					case "Microsoft.Jet.OLEDB.4.0" : m_DbType = "ACCESS"
				end select
		end select
	End Sub
Public Sub Init()
		Call Init_Where()
		Call Init_Order()
		Call Init_RecordCount()
		Call Init_CurrentPage()
		Call Init_DbType()
	End Sub
Public Function GetRows()
			GetRows = AbsolutePositionGetRows()	 
	End Function
Private Function PosPageOneGetRows()
		m_CommandText = "SELECT TOP " & m_PageSize & " "&m_Fields & " FROM " & m_Table & m_Where & m_OrderASC
		PosPageOneGetRows = m_Connection.Execute(m_CommandText).GetRows()
	End Function
Private Function NegPageOneGetRows()
		m_CommandText = "SELECT " & m_Fields & " FROM (" &_
				"SELECT TOP " & (m_RecordCount-(m_PageCount-1)*m_PageSize) &" "& m_Fields & " FROM " & m_Table & m_Where & m_OrderDESC&_
				") AS derivedtbl_1" & m_OrderASC
		NegPageOneGetRows = m_Connection.Execute(m_CommandText).GetRows()
	End Function
Private Function PosPKCutGetRows(oper, func)
		m_CommandText = "SELECT TOP " & m_PageSize & " "&m_Fields & " FROM " & m_Table & m_WhereAND &_
				m_PrimaryKey & oper & "(SELECT " & func & "(" & m_PrimaryKey & ") FROM (" &_
				"SELECT TOP " & (m_PreRecordCount - m_PageSize) & " " & m_PrimaryKey & " FROM " & m_Table & m_Where & m_OrderASC &_
				") AS derivedtbl_1)" & m_OrderASC
		PosPKCutGetRows = m_Connection.Execute(m_CommandText).GetRows()
	End Function
Private Function NegPKCutGetRows(oper, func)
		m_CommandText = "SELECT " & m_Fields & " FROM ("&_
				"SELECT TOP " & m_PageSize & " "& m_Fields & " FROM " & m_Table & m_WhereAND &_
				m_PrimaryKey & oper & "(SELECT " & func & "(" & m_PrimaryKey & ") FROM (" &_
				"SELECT TOP " & (m_RecordCount - m_PreRecordCount) & " " & m_PrimaryKey & " FROM " & m_Table & m_Where & m_OrderDESC &_
				") AS derivedtbl_1)" & m_OrderDESC &_
				") AS derivedtbl_2" & m_OrderASC
		NegPKCutGetRows = m_Connection.Execute(m_CommandText).GetRows()
	End Function
Private Function PosTopNegTopGetRows()
		m_CommandText = "SELECT " & m_Fields & " FROM " & m_Table & " WHERE " & m_PrimaryKey & " IN(" &_
			  	"SELECT TOP " & m_PageSize & " " & m_PrimaryKey & " FROM (" &_
				"SELECT TOP " & m_PreRecordCount & " " & m_PreFields & " FROM " & m_Table & m_Where & m_OrderASC &_
				") A " & m_OrderDESC & ")" & m_OrderASC
		PosTopNegTopGetRows = m_Connection.Execute(m_CommandText).GetRows()
	End Function
Private Function NegTopPosTopGetRows()
		m_CommandText = "SELECT " & m_Fields & " FROM " & m_Table & " WHERE " & m_PrimaryKey & " IN(" &_
				"SELECT TOP " & m_PageSize & " " & m_PrimaryKey & " FROM (" &_
				"SELECT TOP " &(m_RecordCount + m_PageSize - m_PreRecordCount) & " " & m_PreFields & " FROM " & m_Table & m_Where & m_OrderDESC &_
				") A " & m_OrderASC & ")" & m_OrderASC
		NegTopPosTopGetRows = m_Connection.Execute(m_CommandText).GetRows()
	End Function
Private Function LimitGetRows()
		m_CommandText = "SELECT " & m_Fields & " FROM " & m_Table & m_Where & m_OrderASC & " LIMIT " & (m_PreRecordCount -m_PageSize) & "," & m_PageSize
		LimitGetRows = m_Connection.Execute(m_CommandText).GetRows()
	End Function
Private Function AbsolutePositionGetRows()
		Dim rs
		Set rs = Server.CreateObject ("Adodb.RecordSet")
		m_CommandText = "SELECT TOP " & m_PreRecordCount & " " & m_Fields & " FROM " & m_Table & m_Where & m_Order
		rs.Open m_CommandText,m_Connection,1,1,&H0001
		rs.AbsolutePosition = m_PreRecordCount - m_PageSize + 1
		AbsolutePositionGetRows = rs.GetRows(m_PageSize)
		rs.close()
		Set rs = nothing
	End Function
Private Function PosTopNotInGetRows()
		m_CommandText = "SELECT " & m_Fields & " FROM " & m_Table & " WHERE " & m_PrimaryKey & " IN(" &_
				"SELECT TOP " & m_PageSize & " " & m_PrimaryKey & " FROM " & m_Table & m_WhereAND & m_PrimaryKey & " NOT IN(" &_
				"SELECT TOP " &(m_PreRecordCount - m_PageSize) & " " & m_PrimaryKey & " FROM " & m_Table & m_Where & m_OrderASC &_
				")" & m_OrderASC & ")" & m_OrderASC
		PosTopNotInGetRows = m_Connection.Execute(m_CommandText).GetRows()
	End Function
Private Function NegTopNotInGetRows()
		m_CommandText = "SELECT " & m_Fields & " FROM " & m_Table & " WHERE " & m_PrimaryKey & " IN(" &_
				"SELECT TOP " & m_PageSize & " " & m_PrimaryKey & " FROM " & m_Table & m_WhereAND & m_PrimaryKey & " NOT IN(" &_
				"SELECT TOP " &(m_RecordCount - m_PreRecordCount) & " " & m_PrimaryKey & " FROM " & m_Table & m_Where & m_OrderDESC &_
				")" & m_OrderDESC & ")" & m_OrderASC
		NegTopNotInGetRows = m_Connection.Execute(m_CommandText).GetRows()
	End Function
Public Sub DrawPaging(intPages,strClass,arrText,reWrite)
		Dim chrSep : if strClass="" then chrSep = " "
		if IsNull(arrText) then arrText = Array("Total:<a>","</a> Page:<span>","</span> ","go")
		with Response			
			.Write(VBCrlf&Chr(9)&"<div id="""&strClass&""">"&VBCrlf&Chr(9)&Chr(9))
			.Write("<span>"&arrText(0) & m_RecordCount & arrText(1) & m_PageSize & arrText(2) &"</span>")
			'.Write("<span>"& m_CurrentPage &"/"& m_PageCount&"</span>")
			Dim dblPages : dblPages = intPages*2
			Dim intFrom : intFrom = m_CurrentPage - intPages
			if intFrom < 1 then intFrom = 1
			Dim intTo : intTo = intFrom + dblPages
			if intTo > m_PageCount then
				intTo = m_PageCount
				if m_PageCount > dblPages then
					intFrom = intTo - dblPages
				else
					intFrom = 1
				end if
			end if
			if intFrom > 1 then
			if reWrite="" then
				.Write("<a href=""?"&m_QueryString&"1"">1</a>"&chrSep)
				.Write("<a href=""?"&m_QueryString&(m_CurrentPage-1)&""">&lt;</a>"&chrSep)
			else
				.Write("<a href="""&reWrite&"1.html"">1</a>"&chrSep)
				.Write("<a href="""&reWrite&(m_CurrentPage-1)&".html"">&lt;</a>"&chrSep)			
			end if	
			end if
			for i = intFrom to intTo
				if i = m_CurrentPage then
					.Write("<span>"&i&"</span>"&chrSep)
				else
					if reWrite="" then
						.Write("<a href=""?"&m_QueryString&i&""">"&i&"</a>"&chrSep)
					else
						.Write("<a href="""&reWrite&i&".html"">"&i&"</a>"&chrSep)			
					end if
				end if
			next
			if intTo < m_PageCount then
				if reWrite="" then
					.Write("<a href=""?"&m_QueryString&(m_CurrentPage+1)&""">&gt;</a>"&chrSep)
					.Write("<a href=""?"&m_QueryString&m_PageCount&""">"&m_PageCount&"</a>"&chrSep)
				else
					.Write("<a href="""&reWrite&(m_CurrentPage+1)&".html"">&gt;</a>"&chrSep)
					.Write("<a href="""&reWrite&m_PageCount&".html"">"&m_PageCount&"</a>"&chrSep)
				end if
			end if
			.Write(VBCrlf&Chr(9)&"</div>")
		End With
	End Sub
End Class
%>