<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>7</title>
<meta http-equiv="imagetoolbar" content="no">
<style type="text/css">
	html {
		overflow: hidden;
	}
	body {
		position: absolute;
		margin: 0px;
		padding: 0px;
		background: #000000;
		width: 100%;
		height: 100%;
	}
	#center {
		position: absolute;
		left: 50%;
		top:  50%;
	}
	#slider {
	position: absolute;
	width: 820px;
	height: 333px;
	left: -430px;
	top: -186px;
	overflow: hidden;
	background: #000;
	border: 20px solid #000;
	background-color: #414141;
	}
	#slider .slide {
		position: absolute;
		top: 0px;
		height: 333px;
		width: 500px;
		background: #000;
		overflow: hidden;
		border-left: #000 solid 1px;
		cursor: default;
	}
	#slider .title   {
		color: #F80;
		font-weight: bold;
		font-size: 1.2em;
		margin-right: 1.5em;
		text-decoration: none;
	}
	#slider .backgroundText {
		position: absolute;
		width: 100%;
		height: 100%;
		top: 100%;
		background: #000;
		filter: alpha(opacity=40);
		opacity: 0.4;
	}
	#slider .text {
		position: absolute;
		top: 1%;
		top: 100%;
		color: #FFF;
		font-family: verdana, arial, Helvetica, sans-serif;
		font-size: 0.9em;
		text-align: justify;
		width: 470px;
		left: 10px;
	}
	#slider .diapo {
		position: absolute;
		filter: alpha(opacity=100);
		opacity: 1;
		visibility: hidden;
	}
</style>
<script type="text/javascript">
/* ==== slider nameSpace ==== */
var slider = function() {
	/* ==== private methods ==== */
	function getElementsByClass(object, tag, className) {
		var o = object.getElementsByTagName(tag);
		for ( var i = 0, n = o.length, ret = []; i < n; i++) {
			if (o[i].className == className) ret.push(o[i]);
		}
		if (ret.length == 1) ret = ret[0];
		return ret;
	}
	function setOpacity (obj,o) {
		if (obj.filters) obj.filters.alpha.opacity = Math.round(o);
		else obj.style.opacity = o / 100;
	}
	/* ==== Slider Constructor ==== */
	function Slider(oCont, speed, iW, iH, oP) {
		this.slides = [];
		this.over   = false;
		this.S      = this.S0 = speed;
		this.iW     = iW;
		this.iH     = iH;
		this.oP     = oP;
		this.oc     = document.getElementById(oCont);
		this.frm    = getElementsByClass(this.oc, 'div', 'slide');
		this.NF     = this.frm.length;
		this.resize();
		for (var i = 0; i < this.NF; i++) {
			this.slides[i] = new Slide(this, i);
		}
		this.oc.parent = this;
		this.view      = this.slides[0];
		this.Z         = this.mx;
		/* ==== on mouse out event ==== */
		this.oc.onmouseout = function () {
			this.parent.mouseout();
			return false;
		}
	}
	Slider.prototype = {
		/* ==== animation loop ==== */
		run : function () {
			this.Z += this.over ? (this.mn - this.Z) * .5 : (this.mx - this.Z) * .5;
			this.view.calc();
			var i = this.NF;
			while (i--) this.slides[i].move();
		},
		/* ==== resize  ==== */
		resize : function () {
			this.wh = this.oc.clientWidth;
			this.ht = this.oc.clientHeight;
			this.wr = this.wh * this.iW;
			this.r  = this.ht / this.wr;
			this.mx = this.wh / this.NF;
			this.mn = (this.wh * (1 - this.iW)) / (this.NF - 1);
		},
		/* ==== rest  ==== */
		mouseout : function () {
			this.over      = false;
			setOpacity(this.view.img, this.oP);
		}
	}
	/* ==== Slide Constructor ==== */
	Slide = function (parent, N) {
		this.parent = parent;
		this.N      = N;
		this.x0     = this.x1 = N * parent.mx;
		this.v      = 0;
		this.loaded = false;
		this.cpt    = 0;
		this.start  = new Date();
		this.obj    = parent.frm[N];
		this.txt    = getElementsByClass(this.obj, 'div', 'text');
		this.img    = getElementsByClass(this.obj, 'img', 'diapo');
		this.bkg    = document.createElement('div');
		this.bkg.className = 'backgroundText';
		this.obj.insertBefore(this.bkg, this.txt);
		if (N == 0) this.obj.style.borderLeft = 'none';
		this.obj.style.left = Math.floor(this.x0) + 'px';
		setOpacity(this.img, parent.oP);
		/* ==== mouse events ==== */
		this.obj.parent = this;
		this.obj.onmouseover = function() {
			this.parent.over();
			return false;
		}
	}
	Slide.prototype = {
		/* ==== target positions ==== */
		calc : function() {
			var that = this.parent;
			// left slides
			for (var i = 0; i <= this.N; i++) {
				that.slides[i].x1 = i * that.Z;
			}
			// right slides
			for (var i = this.N + 1; i < that.NF; i++) {
				that.slides[i].x1 = that.wh - (that.NF - i) * that.Z;
			}
		},
		/* ==== HTML animation : move slides ==== */
		move : function() {
			var that = this.parent;
			var s = (this.x1 - this.x0) / that.S;
			/* ==== lateral slide ==== */
			if (this.N && Math.abs(s) > .5) {
				this.obj.style.left = Math.floor(this.x0 += s) + 'px';
			}
			/* ==== vertical text ==== */
			var v = (this.N < that.NF - 1) ? that.slides[this.N + 1].x0 - this.x0 : that.wh - this.x0;
			if (Math.abs(v - this.v) > .5) {
				this.bkg.style.top = this.txt.style.top = Math.floor(2 + that.ht - (v - that.Z) * that.iH * that.r) + 'px';
				this.v = v;
				this.cpt++;
			} else {
				if (!this.pro) {
					/* ==== adjust speed ==== */
					this.pro = true;
					var tps = new Date() - this.start;
					if(this.cpt > 1) {
						that.S = Math.max(2, (28 / (tps / this.cpt)) * that.S0);
					}
				}
			}
			if (!this.loaded) {
				if (this.img.complete) {
					this.img.style.visibility = 'visible';
					this.loaded = true;
				}
			}
		},
		/* ==== light ==== */
		over : function () {
			this.parent.resize();
			this.parent.over = true;
			setOpacity(this.parent.view.img, this.parent.oP);
			this.parent.view = this;
			this.start = new Date();
			this.cpt = 0;
			this.pro = false;
			this.calc();
			setOpacity(this.img, 100);
		}
	}
	/* ==== public method - script initialization ==== */
	return {
		init : function() {
			// create instances of sliders here
			// parameters : HTMLcontainer name, speed (2 fast - 20 slow), Horizontal ratio, vertical text ratio, opacity
			this.s1 = new Slider("slider", 12, 1.84/3, 1/3.2, 70);
			setInterval("slider.s1.run();", 16);
		}
	}
}();

</script>
</head>

<body>
<div id="center"> 
  <div id="slider"> 
    <div class="slide"> <img class="diapo" src="anli/01.jpg" alt="һƷǽ"> 
      <div class="text"> <span class="title">ͼƬ</span> ͼƬ˵</div>
    </div>
    <div class="slide"> <img class="diapo" src="anli/02.jpg" alt="һƷǽ"> 
      <div class="text"> <span class="title">ͼƬ</span> ͼƬ˵</div>
    </div>
    <div class="slide"> <img class="diapo" src="anli/03.jpg" alt="һƷǽ"> 
      <div class="text"> <span class="title">ͼƬ</span> ͼƬ˵</div>
    </div>
    <div class="slide"> <img class="diapo" src="anli/04.jpg" alt="һƷǽ"> 
      <div class="text"> <span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
    <div class="slide"> <img class="diapo" src="anli/05.jpg" alt="һƷǽ"> 
      <div class="text"> <span class="title">ͼƬ</span> ͼƬ˵</div>
    </div>
    <div class="slide"> <img class="diapo" src="anli/06.jpg" alt="һƷǽ"> 
      <div class="text"> <span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
    <div class="slide"> <img class="diapo" src="anli/07.jpg" alt="һƷǽ"> 
      <div class="text"> <span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
    <div class="slide"> <img class="diapo" src="anli/08.jpg" alt="һƷǽ"> 
      <div class="text"> <span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
    <div class="slide"> <img class="diapo" src="anli/09.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
    <div class="slide"> <img class="diapo" src="anli/10.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/11.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/12.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/13.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/14.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/15.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/16.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/17.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/18.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/19.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/20.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/21.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/22.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
<div class="slide"> <img class="diapo" src="anli/23.jpg" alt="һƷǽ"> 
      <div class="text"><span class="title">ͼƬ</span>ͼƬ˵</div>
    </div>
  </div>
</div>
<script type="text/javascript">
/* ==== start script ==== */
slider.init();
</script>
</body>
</html>