<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" encoding="utf-8"/>

<xsl:template match="/gbook">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<title><xsl:value-of select="info/user"/>'s Guestbook</title>
<meta name="author" content="" />
<meta name="copyright" content="" />
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="css.css" type="text/css" rel="stylesheet"/>
<script type="text/javascript" src="js.js"></script>
</head>
<body>
	<div id="bodymain">
	<xsl:apply-templates select="info"/>
	<xsl:apply-templates select="messages"/>
	<div class="msg_block">
		<div class="msg_header"><xsl:value-of select="info/actiontitle"/><a name="writenew" /></div>
		<div class="msg_content post_new">
			<form id="msgform" method="post" action="?action={info/action}" onsubmit="return CheckForm();">
			<xsl:if test="info/actiontitle!='回复'">大名: <input type="text" size="40" maxlength="30" name="user" id="name"><xsl:if test="info/actiontitle='Edit the message'"><xsl:attribute name="value"><xsl:value-of select="messages/message/username"/></xsl:attribute></xsl:if></input><br />
			主页: <input type="text" size="40" maxlength="100" name="homepage" id="homepage"><xsl:if test="info/actiontitle='Edit the message'"><xsl:attribute name="value"><xsl:value-of select="messages/message/homepage"/></xsl:attribute></xsl:if></input><br /></xsl:if>
			<xsl:if test="info/validatecode='1'">Code: <input title="Validate Code" type="text" maxlength="4" size="5" name="validatecode" id="validatecode" /> <img align="top" src="validatecode.asp" alt="validate code" /><br /></xsl:if>
			内容:<br />
			<textarea name="content" id="msgcontent" rows="6" cols="64" title="这里输入你想说的话..."><xsl:if test="info/actiontitle='回复'"><xsl:value-of select="messages/message/reply"/></xsl:if><xsl:if test="info/actiontitle='Edit the message'"><xsl:value-of select="messages/message/content"/></xsl:if></textarea><br />
			<input title="提交" class="input_button" type="submit" value="提交" accesskey="s" id="msgsubmit"/> | <input title="清空" class="input_button" type="reset" accesskey="r" value="清空"/> | <input title="返回" accesskey="b" class="input_button" type="button" value="返回" onclick="history.go(-1);"/>
			</form>
		</div>
	</div>
	<div id="foot">Copyright @ 2010 <a title="泡客 / Seven's Home" target="_blank" href="http://pcook.com.cn/"><B>Pcook</B></a>.com.cn . All Rights Reserved</div>
	</div>
</body>
</html>
</xsl:template>

<xsl:template match="info">
	<div id="header"><h1><a href=""><xsl:value-of select="user"/>'s Guestbook</a></h1></div>
	<div id="navbar">
		<span class="nav_left">
			<xsl:if test="pagenow>1"><a title="go to first page" href="?page=1">首页</a></xsl:if><xsl:if test="pagenow&lt;=1">首页</xsl:if> |
			<xsl:if test="pagenow>1"><a title="go to prevous page" href="?page={pageprev}">前页</a></xsl:if><xsl:if test="pagenow&lt;=1">前页</xsl:if> |
			<xsl:if test="pagenow&lt;pagetotal"><a title="go to next page" href="?page={pagenext}">后页</a></xsl:if><xsl:if test="pagenow>=pagetotal">后页</xsl:if> |
			<xsl:if test="pagenow&lt;pagetotal"><a title="go to last page" href="?page={pagetotal}">尾页</a></xsl:if><xsl:if test="pagenow>=pagetotal">尾页</xsl:if> |
			条数: <xsl:value-of select="msgtotal"/> |
			页码: <xsl:value-of select='pagenow'/>/<xsl:value-of select='pagetotal'/>
		</span>
		<span class="nav_right">
			<a href="#writenew" title="写留言" accesskey="w">写留言</a> | <form name="admin_login" method="post">
			<xsl:choose>
				<xsl:when test="logined='NO'">
					<xsl:attribute name="action">?action=login</xsl:attribute><input size="12" maxlength="10" type="password" name="admin_pass"/> <input title="login to manage messages" class="input_button" type="submit" value="登录"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="action">?action=logout</xsl:attribute><input title="logout" class="input_button" type="submit" value="退出"/>
				</xsl:otherwise>
			</xsl:choose>
			</form>
		</span>
	</div>
</xsl:template>

<xsl:template match="messages">
	<xsl:for-each select="message">
	<div class="msg_block">
		<div class="msg_header">
			<span class="msg_header_title"><strong><a target="_blank" href="{homepage}" title="visit his/her homepage"><xsl:value-of select="username" /></a></strong> 发表于 <xsl:value-of select="time"/></span>
			<span class="msg_header_right">
				<xsl:if test="id!=''">[ <a title="回复" href="?action=reply&amp;id={id}">回复</a> | <a title="编辑" href="?action=edit&amp;id={id}">编辑</a> | <strong><a title="删除" href="?action=del&amp;id={id}">删除</a></strong> ]</xsl:if>
			</span>
		</div>
		<div class="msg_content">
		<xsl:for-each select="content/p">
			<p><xsl:value-of select="."/></p>
		</xsl:for-each>
		</div>
		<xsl:if test="reply!=''"><div class="msg_content msg_reply">
		<p><strong style="background-color:#F7FDFF;">回复</strong> 于 <xsl:value-of select="replytime"/>:</p>
		<xsl:for-each select="reply/p">
			<p><xsl:value-of select="."/></p>
		</xsl:for-each>
		</div></xsl:if>
	</div>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
