<%
'********************************************************************************
'函数名：GetImageExifInfo
'功  能：获取基本的Exif信息
'参  数：PicURL 文件路径，相对路径
'返  回：用|分隔的字符串
'********************************************************************************
Function GetImageExifInfo(PicURL)
    Dim TempStr, TempSplit
    Dim ExifInfo

    set ExifInfo = new Cls_Exif
    On Error Resume Next
    ExifInfo.ImageFile = Server.MapPath(PicURL)
    If Err<>0 Then
        Err.Clear
        On Error Goto 0
        Set ExifInfo = Nothing
        GetImageExifInfo = ""
        Exit Function
    Else
         On Error Goto 0
    End if
    if ExifInfo.hasExifInfo() and ExifInfo.GetExifByName("Camera Make")<>"" then
        TempStr = ExifInfo.GetExifByName("Camera Make")
        GetImageExifInfo = ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("Camera Model")
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("Date Time Original")
        If Left(TempStr, 4) = "0000" Then
            TempStr = ExifInfo.GetExifByName("Date Time Digitized")
        End If
        If Left(TempStr, 4) = "0000" Then
            TempStr = ExifInfo.GetExifByName("Date Time")
        End If
        If Left(TempStr, 4) = "0000" Then
            TempStr = ""
        End If
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("Exif Image Width")
        TempSplit = ExifInfo.GetExifByName("Exif Image Height")
        if TempStr <> "" and TempSplit<>"" then
            TempStr = TempStr & " * " & TempSplit
        else
            TempStr = ""
        end if
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("Software")
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("ISO Speed Ratings")
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("FStop")
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("Exposure Time")
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("Flash")
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("Exposure Bias Value")
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("Focal Length")
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
        TempStr = ExifInfo.GetExifByName("Metering Mode")
        GetImageExifInfo = GetImageExifInfo & "|" & ExifItem(TempStr)
    else
        GetImageExifInfo = ""
    end if
    Set ExifInfo = Nothing
End Function

Function GetAllExifInfo(PicURL)
    set ExifInfo = new Cls_Exif
    On Error Resume Next
    ExifInfo.ImageFile = Server.MapPath(PicURL)
    GetAllExifInfo=ExifInfo.ExifAllInfo()
    Set ExifInfo = Nothing
End Function

Function GetHexInfo(PicURL)
    set ExifInfo = new Cls_Exif
    On Error Resume Next
    ExifInfo.ImageFile = Server.MapPath(picURL)
    GetHexInfo=ExifInfo.ExifAllInfo2()
    Set ExifInfo = Nothing
End Function

Function ExifItem(ItemValue)
    if ItemValue <> "" then
        ExifItem = ExifItem & Server.HtmlEnCode(ItemValue)
    else
        ExifItem = ExifItem & "未知"
    end if
End Function

'********************************************************************************
'函数名：ISO8601
'功  能：转换时间格式
'参  数：时间
'返  回：
'********************************************************************************
Function ISO8601(DateTime)
    Dim DateMonth, DateDay, DateHour, DateMinute, DateWeek, DateSecond

    DateTime = DateAdd("h", -8, DateTime)
    DateMonth = Month(DateTime)
    DateDay = Day(DateTime)
    DateHour = Hour(DateTime)
    DateMinute = Minute(DateTime)
    DateWeek = Weekday(DateTime)
    DateSecond = Second(DateTime)
    If Len(DateMonth)<2 Then DateMonth = "0"&DateMonth
    If Len(DateDay)<2 Then DateDay = "0"&DateDay
    If Len(DateMinute)<2 Then DateMinute = "0"&DateMinute
    If Len(DateHour)<2 Then DateHour = "0"&DateHour
    If Len(DateSecond)<2 Then DateSecond = "0"&DateSecond
    ISO8601 = Year(DateTime)&"-"&DateMonth&"-"&DateDay&"T"&DateHour&":"&DateMinute&":"&DateSecond&"Z"
End Function

'********************************************************************************
'函数名：RemoveHTML
'功  能：过滤HTML
'参  数：HTML字符串
'返  回：
'********************************************************************************
Function RemoveHTML(strHTML)
Dim objRegExp, Match, Matches
Set objRegExp = New Regexp
objRegExp.IgnoreCase = True
objRegExp.Global = True
'取闭合的<>
objRegExp.Pattern = "<.+?>"
'进行匹配
Set Matches = objRegExp.Execute(strHTML)
' 遍历匹配集合，并替换掉匹配的项目
For Each Match in Matches
strHtml=Replace(strHTML,Match.Value,"")
Next
RemoveHTML=strHTML
Set objRegExp = Nothing
End Function

'*********************************************************
'函数名：WP_Totoro_chkComment
'功   能：调用totoro检查评论spam
'参   数：
'返   回：
'*********************************************************
Function WP_Totoro_chkComment()

	Call Totoro_checkBadWord(Request.Form("name") & Request.Form("content"))

	If Totoro_SV>=TOTORO_SV_THRESHOLD Then

		Dim strKey
		strKey=Request.QueryString("key")

		Call Totoro_ExitError("您的评论因被怀疑为 SPAM 而提交失败，请勿再次提交。")
	End If

End Function

'*********************************************************
'函数名：SaveCommentList
'功   能：生成最新评论
'参   数：
'返   回：
'*********************************************************
Function SaveCommentList()
    Dim rscomment, sqlcomment
    Set rscomment = Server.CreateObject("ADODB.RecordSet")
    sqlcomment = "select top 10 * from comment order by id desc"
    rscomment.Open sqlcomment, Conn, 1, 1
    Do While Not rscomment.EOF
        content = rscomment("content")
        If Len(content)>14 Then content = Left(content, 14)&"..."
        GetCommentList = GetCommentList&"<li><a href='"& WP_SUB_DOMAIN &"display.asp?id="&rscomment("desktop")&"'>"&content&"</a></li>"&Chr(13)&Chr(10)
        rscomment.movenext
    Loop
    rscomment.Close
    Set rscomment = Nothing
    
    Call SaveToFile(BlogPath & "include/windsphoto_comment.asp", GetCommentList(), "utf-8", TRUE)

End Function
%>