<?xml version="1.0" encoding="utf-8"?>
<!--
Author: xujiwei
Website: http://www.xujiwei.cn
E-mail: vipxjw@163.com
Copyright (c) 2006, All Right Reserved
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" encoding="utf-8"/>

<xsl:template match="/gbook">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<title><xsl:value-of select="info/user"/>'s guestbook</title>
<meta name="author" content="HotHeart,热血心肠,vipxjw@163.com" />
<meta name="copyright" content="www.xujiwei.cn,HotHeart,版权所有" />
<meta name="keywords" content="asp,asm,os,web,ajax,javascript,xml,vb,osdev" />
<meta name="description" content="Simple,Natural,Actual." />
<link href="gbook.css" type="text/css" rel="stylesheet"/>
<script type="text/javascript" src="gbook.js"></script>
</head>
<body>
	<div id="bodymain">
	<xsl:apply-templates select="info"/>
	<xsl:apply-templates select="messages"/>
	<div class="msg_block">
		<div class="msg_header"><xsl:value-of select="info/actiontitle"/><a name="writenew" /></div>
		<div class="msg_content post_new">
			<form id="msgform" method="post" action="gbook.asp?action={info/action}" onsubmit="return CheckForm();">
			<xsl:if test="info/actiontitle!='Reply the message'">Name: <input title="your name or nickname here" type="text" size="40" maxlength="30" name="user" id="name"><xsl:if test="info/actiontitle='Edit the message'"><xsl:attribute name="value"><xsl:value-of select="messages/message/username"/></xsl:attribute></xsl:if></input><br />
			Home: <input title="your homepage here" type="text" size="40" maxlength="100" name="homepage" id="homepage"><xsl:if test="info/actiontitle='Edit the message'"><xsl:attribute name="value"><xsl:value-of select="messages/message/homepage"/></xsl:attribute></xsl:if></input><br /></xsl:if>
			<xsl:if test="info/validatecode='1'">Code: <input title="Validate Code" type="text" maxlength="4" size="5" name="validatecode" id="validatecode" /> <img align="top" src="validatecode.asp" alt="validate code" /><br /></xsl:if>
			Content:<br />
			<textarea name="content" id="msgcontent" rows="6" cols="64" title="what you want to say here"><xsl:if test="info/actiontitle='Reply the message'"><xsl:value-of select="messages/message/reply"/></xsl:if><xsl:if test="info/actiontitle='Edit the message'"><xsl:value-of select="messages/message/content"/></xsl:if></textarea><br />
			<input title="submit your message" class="input_button" type="submit" value="Submit(S)" accesskey="s" id="msgsubmit"/> | <input title="clear your input" class="input_button" type="reset" accesskey="r" value="Reset(R)"/> | <input title="back to first page" accesskey="b" class="input_button" type="button" value="Back(B)" onclick="history.go(-1);"/>
			</form>
		</div>
	</div>
	<div id="foot">Powered by <a title="HotBook's website" target="_blank" href="http://www.xujiwei.cn/blog/">HotBook v1.0</a>, Copyright &#169; 2006, <a title="HotHeart's Blog" target="_blank" href="http://www.xujiwei.cn/blog/">HotHeart</a>, All Rights Reserved</div>
	</div>
</body>
</html>
</xsl:template>

<xsl:template match="info">
	<div id="header"><h1><a href="gbook.asp"><xsl:value-of select="user"/>'s guestbook</a></h1></div>
	<div id="navbar">
		<span class="nav_left">
			<a title="visit host's homepage" href="{home}">Home</a> |
			<xsl:if test="pagenow>1"><a title="go to first page" href="gbook.asp?page=1">First</a></xsl:if><xsl:if test="pagenow&lt;=1">First</xsl:if> |
			<xsl:if test="pagenow>1"><a title="go to prevous page" href="gbook.asp?page={pageprev}">Prev</a></xsl:if><xsl:if test="pagenow&lt;=1">Prev</xsl:if> |
			<xsl:if test="pagenow&lt;pagetotal"><a title="go to next page" href="gbook.asp?page={pagenext}">Next</a></xsl:if><xsl:if test="pagenow>=pagetotal">Next</xsl:if> |
			<xsl:if test="pagenow&lt;pagetotal"><a title="go to last page" href="gbook.asp?page={pagetotal}">Last</a></xsl:if><xsl:if test="pagenow>=pagetotal">Last</xsl:if> |
			Total: <xsl:value-of select="msgtotal"/> |
			Page: <xsl:value-of select='pagenow'/>/<xsl:value-of select='pagetotal'/>
		</span>
		<span class="nav_right">
			<a href="#writenew" title="write a new message" accesskey="w">Write</a> | <form name="admin_login" method="post">
			<xsl:choose>
				<xsl:when test="logined='NO'">
					<xsl:attribute name="action">gbook.asp?action=login</xsl:attribute><input size="12" maxlength="10" type="password" name="admin_pass"/> <input title="login to manage messages" class="input_button" type="submit" value="login"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="action">gbook.asp?action=logout</xsl:attribute><input title="logout" class="input_button" type="submit" value="logout"/>
				</xsl:otherwise>
			</xsl:choose>
			</form>
		</span>
	</div>
</xsl:template>

<xsl:template match="messages">
	<xsl:for-each select="message">
	<div class="msg_block">
		<div class="msg_header">
			<span class="msg_header_title"><strong><a target="_blank" href="{homepage}" title="visit his/her homepage"><xsl:value-of select="username" /></a></strong> post at <xsl:value-of select="time"/></span>
			<span class="msg_header_right">
				<xsl:if test="id!=''">[ <a title="reply this message" href="gbook.asp?action=reply&amp;id={id}">Reply</a> | <a title="edit this message" href="gbook.asp?action=edit&amp;id={id}">Edit</a> | <strong><a title="delete this message" href="gbook.asp?action=del&amp;id={id}">X</a></strong> ]</xsl:if>
			</span>
		</div>
		<div class="msg_content">
		<xsl:for-each select="content/p">
			<p><xsl:value-of select="."/></p>
		</xsl:for-each>
		</div>
		<xsl:if test="reply!=''"><div class="msg_content msg_reply">
		<p><strong style="background-color:#F7FDFF;">Reply</strong> at <xsl:value-of select="replytime"/>:</p>
		<xsl:for-each select="reply/p">
			<p><xsl:value-of select="."/></p>
		</xsl:for-each>
		</div></xsl:if>
	</div>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
