﻿using System;

namespace BLL
{
    /// <summary>
    /// app 的摘要说明
    /// </summary>
    public class App
    {
        public App()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }

        #region 计算页数

        /// <summary>
        /// 计算页数
        /// </summary>
        /// <param name="RecordCount">记录数</param>
        /// <param name="PageSize">页大小</param>
        /// <returns>页数</returns>
        public int GetPageCount(int RecordCount, int PageSize)
        {
            int count;
            if (RecordCount % PageSize == 0)
                count = RecordCount / PageSize;
            else
                count = RecordCount / PageSize + 1;
            return count;
        }

        #endregion

        #region 页索引异常处理

        /// <summary>
        /// 页索引异常处理
        /// </summary>
        /// <param name="PageIndex">页索引</param>
        /// <param name="PageCount">总页数</param>
        /// <returns></returns>
        public int GetPageIndex(int PageIndex, int PageCount)
        {
            if (PageIndex < 1)
                PageIndex = 1;
            else if (PageIndex > PageCount)
                PageIndex = PageCount;
            return PageIndex;
        }

        #endregion

        #region 格式化参数

        /// <summary>
        /// 格式化参数
        /// </summary>
        /// <param name="z">原始文字</param>
        /// <param name="leng">格式化长度</param>
        /// <returns>经格式化文字</returns>
        public string formatz(string z, int leng)
        {
            if (z.Length > leng)
                z = z.Substring(0, leng);
            z = z.PadLeft(leng, ' ');

            z = z.Replace("<", "&lt;");
            //z = z.Replace("&", "&nbsp;&nbsp;");
            z = z.Replace(Convert.ToChar(13).ToString(), " ");
            z = z.Replace("<br>", " ");

            return z + "&nbsp...";
        }

        #endregion

        #region 限定数据行数

        /// <summary>
        /// 限定数据行数
        /// </summary>
        /// <param name="rowscount">记录总行数</param>
        /// <returns>经过判断的记录行数</returns>
        public int LimitRows(int rowscount)
        {
            int rc;
            if (rowscount < 100)
                rc = rowscount;
            else rc = 100;
            return rc;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="rowscount">物理数据库实际存在的记录数</param>
        /// <param name="limitrows">根据要求限定的记录数</param>
        /// <returns>经过判断的记录行数</returns>
        public int LimitRows(int rowscount, int limitrows)
        {
            int rc;
            if (rowscount < limitrows)
                rc = rowscount;
            else rc = limitrows;
            return rc;
        }

        #endregion



    }
}
