﻿using System;
using System.Data;
using System.Configuration;


namespace BLL
{
    /// <summary>
    ///Bll 的摘要说明
    /// </summary>
    public class DbConn
    {
        #region 构造函数,根据要求改变数据库连接

        string Dbconn = null;
        
        /// <summary>
        /// 构造函数
        /// 根据要求改变数据库连接
        /// </summary>
        /// <param name="cmdText">Webconfig－>connectionStrings</param>
        public DbConn(string cmdText)
        {
            //Model.DBModel mod = new Model.DBModel();
            Dbconn = ConfigurationManager.ConnectionStrings[cmdText].ConnectionString;
        }

        #endregion

        #region 根据条件获取指定结果集的数据

        /// <summary>
        /// 根据条件获取指定结果集的数据
        /// </summary>
        /// <param name="strSql">表查询语句</param>
        /// <returns></returns>
        public DataSet GetDataSet(string cmdText)
        {
            DAL.SqlHelper she = new DAL.SqlHelper(Dbconn);
            DataSet dt = she.ExecuteDataSet(cmdText);
            return dt;
        }

        #endregion

        #region 根据条件获取指定表的数据

        /// <summary>
        /// 根据条件获取指定表的数据
        /// </summary>
        /// <param name="strSql">表查询语句</param>
        /// <returns></returns>
        public DataTable GetDataTable(string cmdText)
        {
            DAL.SqlHelper she = new DAL.SqlHelper(Dbconn);
            DataTable dt = she.ExecuteDataSet(cmdText).Tables[0];
            return dt;
        }

        #endregion

        #region 获取某表中的总记录数

        /// <summary>
        /// 获取某表中的总记录数
        /// </summary>
        /// <param name="cmdText">sql语句</param>
        /// <returns></returns>
        public  int GetRecordCount(string cmdText)
        {
            DAL.SqlHelper she = new DAL.SqlHelper(Dbconn);
            return Convert.ToInt32(she.ExecuteScalar(cmdText));
        }

        #endregion

        #region 更新某一字段的值

        /// <summary>
        /// 更新某表中某一字段的值
        /// </summary>
        /// <param name="cmdText">sql语句</param>
        public void UpdateAfield(string cmdText)
        {
            DAL.SqlHelper she = new DAL.SqlHelper(Dbconn);
            she.ExecuteNonQuery(cmdText);
        }

        #endregion

        #region 获取指定表中指定字段的最大值

        /// <summary>
        /// 获取指定表中指定字段的最大值
        /// </summary>
        /// <param name="tableName">表名称</param>
        /// <param name="field">字段</param>
        /// <returns>Return Type:Int</returns>
        public int GetMaxID(string cmdText)
        {
            //string s = cmdText;
            //int i = Convert.ToInt32(DAL.SqlHelper.ExecuteScalar(s) == DBNull.Value ? "0" : DAL.SqlHelper.ExecuteScalar(s));
            //return i;
            DAL.SqlHelper she = new DAL.SqlHelper(Dbconn);
            object maxid = she.ExecuteScalar(cmdText);
            if (maxid == DBNull.Value)
                maxid = "0";
            else
                maxid = maxid;
            int i = Convert.ToInt32(maxid);
            return i;
        }

        #endregion

        #region 根据ID 获取一行数据

        /// <summary>
        /// 根据主键Id,获取一行数据
        /// </summary>
        /// <param name="tableName">表名</param>
        /// <param name="keyName">主键名称</param>
        /// <param name="value">值</param>
        /// <param name="msg">返回信息</param>
        /// <returns></returns>
        public DataRow GetADataRow(string cmdText, out string msg)
        {
            try
            {
                DAL.SqlHelper she = new DAL.SqlHelper(Dbconn);
                DataTable dt = she.ExecuteDataSet(cmdText).Tables[0];
                if (dt.Rows.Count > 0)
                {
                    msg = "OK";
                    return dt.Rows[0];
                }
                else
                {
                    msg = "";
                    return null;
                }
            }
            catch (Exception ex)
            {
                msg = ex.Message;
                return null;
            }
        }

        #endregion
    }
}
