﻿using System;

namespace BLL
{  
    /// <summary>
    ///DbSql 的摘要说明
    /// </summary>
    public class DbSql
    {
        public DbSql()
        {
            //
            //TODO: 在此处添加构造函数逻辑
            //
        }

        #region 总记录数SQL

        /// <summary>
        /// 总记录数SQL
        /// </summary>
        /// <param name="mod">表名,条件(可选)</param>
        /// <returns></returns>
        public string countSql(Model.DBModel mod)
        {
            string s = "";
            if (mod.FilterCondition == "")
                s = "select count(*) from {0}";
            else
                s = "select count(*) from {0} where {1}";
            s = string.Format(s,mod.TableName,mod.FilterCondition);//表名,条件
            return s;
        }

        #endregion

        #region 分页sql
        /// <summary>
        /// 分页SQL
        /// </summary>
        /// <param name="mod">表名,主键,筛选条件,不带where,页大小,页索引,排序字段,排序方式 1为 DESC, 0为 ASC,查找的字段,总记录数</param>
        /// <param name="Table_Name">表名</param>
        /// <param name="Sign_Record">主键</param>
        /// <param name="Filter_Condition">筛选条件,不带where</param>
        /// <param name="Page_Size">页大小</param>
        /// <param name="Page_Index">页索引</param>
        /// <param name="TaxisField">排序字段</param>
        /// <param name="Taxis_Sign">排序方式 1为 DESC, 0为 ASC</param>
        /// <param name="Find_RecordList">查找的字段</param>
        /// <param name="Record_Count">总记录数</param>
        /// <returns>分页SQL语句</returns>
        public string makeSql(Model.DBModel mod)
        {
            int Start_Number;
            int End_Number;
            int TopN_Number;
            string @sSQL = "";

            if (mod.FindRecordList == "")
                mod.FindRecordList = "*";
            Start_Number = (mod.PageIndex - 1) * mod.PageSize;
            if (Start_Number <= 0)
                Start_Number = 0;
            End_Number = Start_Number + mod.PageSize;
            if (End_Number > mod.RecordCount)
                End_Number = mod.RecordCount;
            TopN_Number = End_Number - Start_Number;
            if (TopN_Number <= 0)
                TopN_Number = 0;

            if (mod.TaxisField == "")
               mod.TaxisField = mod.SignRecord;

            if (mod.TaxisSign == 0)
            {

                @sSQL += " SELECT {0} FROM {1} WHERE {2} in ";
                @sSQL += " ( SELECT TOP {3} {2} FROM {1}  WHERE {2} in ";
                if (mod.FilterCondition == "")
                    @sSQL += " ( SELECT TOP {4} {2} FROM {1} ORDER BY {5} ) ";
                else
                    @sSQL += " ( SELECT TOP {4} {2} FROM {1} WHERE {6} ORDER BY {5} ) ";
                @sSQL += " ORDER BY {5} DESC ) ORDER BY {5} ";
                @sSQL = string.Format(@sSQL,mod.FindRecordList,mod.TableName,mod.SignRecord, TopN_Number, End_Number,mod.TaxisField,mod.FilterCondition);//有改动，待验证,现在条件只用一次，没有用3次

            }
            else
            {
                @sSQL += " SELECT {0} FROM {1} WHERE {2} in ";
                @sSQL += " (SELECT TOP {3} {2} FROM {1}  WHERE {2} in ";
                if (mod.FilterCondition == "")
                    @sSQL += " (SELECT TOP {4} {2} FROM {1} ORDER BY {5} DESC ) ";
                else
                    @sSQL += " ( SELECT TOP {4} {2} FROM {1} WHERE {6} ORDER BY {5} DESC ) ";
                @sSQL += " ORDER BY {5} ) ORDER BY {5} DESC ";
                @sSQL = string.Format(@sSQL, mod.FindRecordList, mod.TableName, mod.SignRecord, TopN_Number, End_Number, mod.TaxisField, mod.FilterCondition);//有改动，待验证,现在条件只用一次，没有用3次
            }
            return @sSQL;
        }

        #endregion

        #region 根据条件获取指定表中的数据

        /// <summary>
        /// 根据条件获取指定表中的数据
        /// </summary>
        /// <param name="tablename">表名</param>
        /// <param name="where">条件</param>
        /// <returns></returns>
        public string getTable(string tablename, string where)
        {
            string s = "select * from " + tablename;
            if (where != "")
                s += " where " + where;
            return s;
        }

        #endregion

        #region 更新某一字段的值

        /// <summary>
        /// 更新某表中某一字段的值
        /// </summary>
        /// <param name="tablename">表名</param>
        /// <param name="fieldName">更新的字段名</param>
        /// <param name="fieldValue">更新的字段的值</param>
        /// <param name="identityFieldName">标识字段的名称</param>
        /// <param name="identityValue">标识字段的值</param>
        public string updateSql(string tablename, string fieldName, string fieldValue, string identityFieldName, string identityValue)
        {
            string s = "Update {0} set {1}='{2}' where {3}='{4}'";
            s = string.Format(s, tablename, fieldName, fieldValue, identityFieldName, identityValue);
            return s;
        }

        #endregion

        #region 获取指定表中指定字段的最大值
        /// <summary>
        /// 获取指定表中指定字段的最大值
        /// </summary>
        /// <param name="tableName">表名称</param>
        /// <param name="field">字段</param>
        /// <returns>Return Type:String</returns>
        public string maxidSql(string tableName, string field)
        {
            string s = "select Max({0}) from {1}";
            s = string.Format(s, field, tableName);
            return s;
        }
        #endregion

        #region 根据ID 获取一行数据

        /// <summary>
        /// 根据主键Id,获取一行数据
        /// </summary>
        /// <param name="tableName">表名</param>
        /// <param name="keyName">主键名称</param>
        /// <param name="value">值</param>
        /// <param name="msg">返回信息</param>
        /// <returns></returns>
        public string dataRowSql(string tableName, string keyName, string value)
        {
                string s = "select * from {0} where {1}='{2}'";
                s = string.Format(s, tableName, keyName, value);
                return s;
        }

        #endregion

       
    }
}