﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

public partial class Northwind : System.Web.UI.Page
{
    // ViewState 维护当前页索引

    public int PageIndex
    {
        get
        {
            object o = ViewState["PageIndex"];
            return ((o == null) ? 0 : (int)o);
        }
        set { ViewState["PageIndex"] = value; }
    }

    //上一页入口

    public void PrevPrevPage(object sender, EventArgs e)
    {
        PageIndex--;
        pageConn();
    }
    //下一页入口

    public void NextPrevPage(object sender, EventArgs e)
    {
        PageIndex++;
        pageConn();
    }
    //跳转到第几页
    public void JumpToPage(object sender, EventArgs e)
    {
        try
        {
            PageIndex = int.Parse(txtCurrentPageIndex.Text);
        }
        catch
        {
            txtCurrentPageIndex.Text = PageIndex.ToString();
            return;
        }
        pageConn();
    }

    //页面连接
    public void pageConn()
    {      
        Model.DBModel mod = new Model.DBModel();//实例化模型
        BLL.App app = new BLL.App();//实例化方法类
        BLL.DbSql dbsql = new BLL.DbSql();//实例化数据库连接语句生成业务
        BLL.DbConn dbconn = new BLL.DbConn("Northwinddb");//实例化数据库连接操作业务

        //修改这里,先修改上面实例化数据库连接操作业务
        mod.PageSize = 15;//页大小
        mod.TopNum = 500;//取记录条数的限定范围,int.MaxValue为最大值
        mod.TableName = "Orders";//表名
        mod.SignRecord = "OrderID";//主键
        mod.FilterCondition = "";//查询条件
        mod.TaxisField = "OrderID";//排序字段
        mod.TaxisSign = 1;//排序方式 1为 DESC, 0为 ASC
        mod.FindRecordList = " TOP {0} *";//目标字段
        if (mod.TopNum == int.MaxValue)
            mod.FindRecordList = string.Format(mod.FindRecordList, " 100 PERCENT ");
        else
            mod.FindRecordList = string.Format(mod.FindRecordList, mod.TopNum.ToString());

        mod.Countsql = dbsql.countSql(mod);//统计记录SQL
        mod.RecordCount = dbconn.GetRecordCount(mod.Countsql);//执行统计页码SQL,得到总记录大小
        if (mod.RecordCount > mod.TopNum)
            mod.RecordCount = app.LimitRows(mod.RecordCount, mod.TopNum);
        mod.PageCount = app.GetPageCount(mod.RecordCount, mod.PageSize);//计算页码
        if ((PageIndex < 1) || (PageIndex > mod.PageCount))
            PageIndex = app.GetPageIndex(PageIndex, mod.PageCount);//页索引异常处理
        mod.PageIndex = PageIndex;//页索引

        mod.Sql = dbsql.makeSql(mod);//生成SQL
        DataTable dt = dbconn.GetDataTable(mod.Sql);//执行SQL

        grid1.DataSource = dt;
        grid1.DataBind();

        txtCurrentPageIndex.Text = PageIndex.ToString();
        lblPageCount.Text = mod.PageCount.ToString();

    }

    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            PageIndex = 1;//初始化页索引为1
            pageConn();
        }

    }
}
