<%@LANGUAGE="JAVASCRIPT" CODEPAGE="65001"%>
<% Response.Charset="utf-8"; %>
<% Session.CodePage=65001; %>
<script language="VBScript" runat="server">
Function getIP()
Dim ip, sip
    sip = Request.ServerVariables("HTTP_X_FORWARDED_FOR")
If sip = "" OR InStr(sip, "unknown") > 0 Then
    ip = Request.ServerVariables("REMOTE_ADDR")
ElseIf InStr(sip, ",") > 0 Then
    ip = Mid(sip, 1, InStr(sip, ",")-1)
ElseIf InStr(sip, ";") > 0 Then
    ip = Mid(sip, 1, InStr(sip, ";")-1)
Else
    ip = sip
End If
getIP = Trim(Mid(ip, 1, 30))
End Function

Function BinaryToString(Binary)
  Dim cl1, cl2, cl3, pl1, pl2, pl3
  Dim L
  cl1 = 1
  cl2 = 1
  cl3 = 1
  L = LenB(Binary)

  Do While cl1<=L
    pl3 = pl3 & Chr(AscB(MidB(Binary,cl1,1)))
    cl1 = cl1 + 1
    cl3 = cl3 + 1
    If cl3>300 Then
      pl2 = pl2 & pl3
      pl3 = ""
      cl3 = 1
      cl2 = cl2 + 1
      If cl2>200 Then
        pl1 = pl1 & pl2
        pl2 = ""
        cl2 = 1
      End If
    End If
  Loop
  BinaryToString = pl1 & pl2 & pl3
End Function
</script>


<%
Array.prototype.______array = '______array';
var JSON = {
    stringify: function (arg) {
        var c, i, l, s = '', v;

        switch (typeof arg) {
        case 'object':
            if (arg) {
                if (arg.______array == '______array') {
                    for (i = 0; i < arg.length; ++i) {
                        v = this.stringify(arg[i]);
                        if (s) {
                            s += ',';
                        }
                        s += v;
                    }
                    return '[' + s + ']';
		} else if (typeof arg.toJsonString != 'undefined') {
		    return arg.toJsonString();
                } else if (typeof arg.toString != 'undefined') {
                    for (i in arg) {
                        v = arg[i];
                        if (typeof v != 'undefined' && typeof v != 'function') {
                            v = this.stringify(v);
                            if (s) {
                                s += ',';
                            }
                            s += this.stringify(i) + ':' + v;
                        }
                    }
                    return '{' + s + '}';
                }
            }
            return 'null';
        case 'number':
            return isFinite(arg) ? String(arg) : 'null';
        case 'string':
            l = arg.length;
            s = '"';
            for (i = 0; i < l; i += 1) {
                c = arg.charAt(i);
                if (c >= ' ') {
                    if (c == '\\' || c == '"') {
                        s += '\\';
                    }
                    s += c;
                } else {
                    switch (c) {
                        case '\b':
                            s += '\\b';
                            break;
                        case '\f':
                            s += '\\f';
                            break;
                        case '\n':
                            s += '\\n';
                            break;
                        case '\r':
                            s += '\\r';
                            break;
                        case '\t':
                            s += '\\t';
                            break;
                        default:
                            c = c.charCodeAt();
                            s += '\\u00' + Math.floor(c / 16).toString(16) +
                                (c % 16).toString(16);
                    }
                }
            }
            return s + '"';
        case 'boolean':
            return String(arg);
        default:
            return 'null';
        }
    },
    parse: function (text, ctors) {
        var at = 0;
        var ch = ' ';

        function error(m) {
            throw {
                name: 'JSONError',
                message: m,
                at: at - 1,
                text: text
            };
        }

        function next() {
            ch = text.charAt(at);
            at += 1;
            return ch;
        }

        function white() {
            while (ch != '' && ch <= ' ') {
                next();
            }
        }

        function str() {
            var i, s = '', t, u;

            if (ch == '"') {
outer:          while (next()) {
                    if (ch == '"') {
                        next();
                        return s;
                    } else if (ch == '\\') {
                        switch (next()) {
                        case 'b':
                            s += '\b';
                            break;
                        case 'f':
                            s += '\f';
                            break;
                        case 'n':
                            s += '\n';
                            break;
                        case 'r':
                            s += '\r';
                            break;
                        case 't':
                            s += '\t';
                            break;
                        case 'u':
                            u = 0;
                            for (i = 0; i < 4; i += 1) {
                                t = parseInt(next(), 16);
                                if (!isFinite(t)) {
                                    break outer;
                                }
                                u = u * 16 + t;
                            }
                            s += String.fromCharCode(u);
                            break;
                        default:
                            s += ch;
                        }
                    } else {
                        s += ch;
                    }
                }
            }
            error("Bad string");
        }

        function arr() {
            var a = [];

            if (ch == '[') {
                next();
                white();
                if (ch == ']') {
                    next();
                    return a;
                }
                while (ch) {
                    a.push(val());
                    white();
                    if (ch == ']') {
                        next();
                        return a;
                    } else if (ch != ',') {
                        break;
                    }
                    next();
                    white();
                }
            }
            error("Bad array");
        }

        function obj() {
            var k, o = {};

            if (ch == '{') {
                next();
                white();
                if (ch == '}') {
                    next();
                    return o;
                }
                while (ch) {
                    k = str();
                    white();
                    if (ch != ':') {
                        break;
                    }
                    next();
                    o[k] = val();
                    white();
                    if (ch == '}') {
                        next();
                        return o;
                    } else if (ch != ',') {
                        break;
                    }
                    next();
                    white();
                }
            }
            error("Bad object");
        }

        function num() {
            var n = '', v;
            if (ch == '-') {
                n = '-';
                next();
            }
            while (ch >= '0' && ch <= '9') {
                n += ch;
                next();
            }
            if (ch == '.') {
                n += '.';
                while (next() && ch >= '0' && ch <= '9') {
                    n += ch;
                }
            }
            if (ch == 'e' || ch == 'E') {
                n += 'e';
                next();
                if (ch == '-' || ch == '+') {
                    n += ch;
                    next();
                }
                while (ch >= '0' && ch <= '9') {
                    n += ch;
                    next();
                }
            }
            v = +n;
            if (!isFinite(v)) {
                error("Bad number");
            } else {
                return v;
            }
        }

        function word() {
            switch (ch) {
                case 't':
                    if (next() == 'r' && next() == 'u' && next() == 'e') {
                        next();
                        return true;
                    }
                    break;
                case 'f':
                    if (next() == 'a' && next() == 'l' && next() == 's' &&
                            next() == 'e') {
                        next();
                        return false;
                    }
                    break;
                case 'n':
                    if (next() == 'u' && next() == 'l' && next() == 'l') {
                        next();
                        return null;
                    }
                    break;
            }
            error("Syntax error");
        }

	function ctor() {
	    var name = '';
	    if (ch == '@') {
		next();
		while (ch == '.' || (ch.toUpperCase() >= 'A' &&
				     ch.toUpperCase() <= 'Z')) {
		    name += ch;
		    next();
		}
		var arg = val();
		if (name in ctors) {
		    return ctors[name](arg);
		} else {
		    error("Unknown ctor " + name);
		}
	    }
	    error("Bad ctor");
	}

        function val() {
            white();
            switch (ch) {
	        case '@':
		    return ctor();
                case '{':
                    return obj();
                case '[':
                    return arr();
                case '"':
                    return str();
                case '-':
                    return num();
                default:
                    return ch >= '0' && ch <= '9' ? num() : word();
            }
        }
        return val();
    }
};


var RPC = {
    htmlEn: function(ss){
        var s=ss;
        s = s.replace(/\&/g, '&amp;');
        s = s.replace(/\</g, '&lt;');
        s = s.replace(/\>/g, '&gt;');
        s = s.replace(/\"/g, '&quot;');
        return s;
    },
    getPara: function(s, k){
        var a = s.match(new RegExp('([&|\?|#]|\\b)('+ k +'=)([^&]*)([&]|\\b)'));
        var ret;
        if(a!=null){
            ret = decodeURIComponent(a[3]);
        }else{ret = '({})';}
        return ret;
    },
    padZeros : function (s, w) {
        if(!w){w=2;}
        for (var n = w - s.length; n > 0; n--) {
            s = '0' + s;
        }
        return s;
    },
    timeStamp: function(bL) {
        var d = new Date();
        var ret = d.getFullYear() + "-" + RPC.padZeros(d.getMonth()) + "-" + RPC.padZeros(d.getDate());
        if(bL){
            ret += " " + RPC.padZeros(d.getHours()) + ":" + RPC.padZeros(d.getMinutes()) + ":" + RPC.padZeros(d.getSeconds());
        }
        return ret;
    },
    iniData : function () {
          return { index: 0, data: [] };
    },
    handler : function (params) {
        var d, ret = "";
        var action = params.action;
        var arg = params.arg;
        var index = params.index;
        if(!action){action='get'; arg={};}
        if(!index){index=-1;}

        try{
            Application.Lock();
            var schat_index = Application("schat_index");

            // if get and no data to udpate, ignore it
            if( !(action=="get" && index == schat_index) ){
                 //get global cache data
                 if(g_appMode){
                    if(Application('schat_data')){
                        d = JSON.parse(Application('schat_data'));
                    }
                 }else{
                    d = JSONDB.load(g_curDb);
                 }
                 if (!d) {
                    d = RPC.iniData();
                 }

                //handle action
                 switch (action) {
                 case "say": {
                       var _t=arg.who;
                       if(!_t || _t==""){
                            arg.who = g_realip;
                       }
                       Application("schat_index") = ++d.index;

                       d.data.push([
                            d.index,
                            RPC.htmlEn(arg.who.substring(0,64)),
                            g_realip,
                            RPC.htmlEn(arg.words.substring(0,256)),
                            RPC.timeStamp(true)
                        ]);

                        // bake to file
                        if(d.index % g_count === 0 ){
                            JSONDB.SaveByDay(d);
                        }

                        // keep the count
                        while(d.data.length > g_count){
                            d.data.shift();
                        }

                        // save global cache data
                        if(g_appMode){
                            Application("schat_data")=JSON.stringify(d);
                        }else{
                            JSONDB.save(g_curDb, d);
                        }

                   }
                   //RESUME
                   case "get": {
                       var i, result = [], entry;
                       for (i = d.data.length - 1; i >= 0; i--) {
                           entry = d.data[i];
                           if(entry[0] <= index){
                               break;
                           }
                           result.unshift(entry);
                       }
                       ret = {index: d.index, updates: result};
                       break;
                   }
                   case "hlist":{
                        ret = JSONDB.getFileList('.');
                        break;
                   }
                   case "history":{
                        var fn=arg.fn?arg.fn:"";
                        var db = JSONDB.load(fn);
                        if (db) {
                            ret = {index: db.index, updates: db.data};
                        }
                        break;
                   }
                }
            }
         }catch(e){}finally{
             Application.UnLock();
         }
         return ret;
     },
    exceptionToJson: function (e) {
        var result;
        if ((typeof e == typeof {}) && ("name" in e) && (e.name == "RPCServerException")) {
            result = e;
        } else if ((typeof e == typeof {}) && ("message" in e)) {
            result = { message: e.message, name: e.name };
        } else {
            result = { message: e.toString(), name: null };
        }
        return {toJsonString: function () {
            return "@exception " + JSON.stringify(result);
        }};
    }
};

var JSONDB = {
    fs: Server.CreateObject("Scripting.FileSystemObject"),
    load: function (relpath) {
        var ret, f, path = Server.MapPath(relpath);;
        try{
            f = JSONDB.fs.OpenTextFile(path, 1);
            ret = JSON.parse(f.ReadAll());
        }catch(e){
            ret = undefined;
        }finally{
            try{
                if(f){
                    f.Close();
                    delete f;
                }
            }catch(e){}
        }
        return ret;
    },
    save: function (relpath, data) {
        var ret,f,path = Server.MapPath(relpath);
        try{
            f = JSONDB.fs.CreateTextFile(path);
            f.WriteLine(JSON.stringify(data));
            ret=true;
        }catch(e){
            ret=false;
        }finally{
            try{
                if(f){
                    f.Close();
                    delete f;
                }
            }catch(e){}
        }
        return ret;
    },
    SaveByDay:function(d){
        var pth = g_dbfilePreTag + RPC.timeStamp();
        try{
            var bak = JSONDB.load(pth);
            if(!bak){
                bak = RPC.iniData();
            }
            bak.index = d.index;
            var bakD=bak.data, dbD = d.data;
            for(var i=0, l=dbD.length; i<l ;i++){
                bakD.push(dbD[i]);
            }
            JSONDB.save(pth, bak);
        }catch(e){}
    },
    getFileList: function (relpath){
          var strPath = Server.MapPath(relpath);
          var folder = JSONDB.fs.GetFolder(strPath);
          var ret = [];
          var files = new Enumerator(folder.files);
          for(var i=0; !files.atEnd(); files.moveNext()){
            if(files.item().Name.indexOf(g_dbfilePreTag)==0){
                ret.push([files.item().Name, files.item().Size]);
            }
            i++;
          }
          delete files;
          delete folder;
          return ret;
    }
};

%>

<%/*shell code*/%>
<script language="VBScript" runat="server">
    Dim g_reqData, g_realip, g_dbfilePreTag, g_curDb, g_count, g_appMode
    g_reqData = BinaryToString(Request.BinaryRead(Request.TotalBytes))
    g_realip = getIP
    g_dbfilePreTag="chat_"
    g_curDb="chat"
    g_count = 20
    g_appMode = false
</script>
<%
    try {
        var params = JSON.parse(RPC.getPara(g_reqData,"para"));
        Response.Write(JSON.stringify(RPC.handler(params)));
    }catch(e){
        Response.Write(JSON.stringify(RPC.exceptionToJson(e)));
    }
%>